/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.SysConstant;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;

public class PriceService {
    public static List getBatchMatPrices(Context ctx, PriceCondition[] conditions) {
        ArrayList result = new ArrayList();
        Map group = PriceService.groupBySaleOrg(conditions);
        Set entry = group.entrySet();
        Iterator it = entry.iterator();
        while (it.hasNext()) {
            String saleOrgId = (String)it.next().getKey();
            PriceCondition[] groupCondtions = ((List)group.get(saleOrgId)).toArray(new PriceCondition[((List)group.get(saleOrgId)).size()]);
            List priceList = PriceService.getPrices(ctx, groupCondtions, saleOrgId);
            PriceService.populateResult(priceList, groupCondtions, result);
        }
        return result;
    }

    public static BigDecimal getEachMatPrice(Context ctx, PriceCondition condition, String matID) {
        BigDecimal price = SysConstant.BIGZERO;
        List result = PriceService.getMatPrices(ctx, condition);
        if (result.size() > 0) {
            price = PriceService.getPriceByMaterialId(result, matID);
        }
        return price;
    }

    private static List getMatPrices(Context ctx, PriceCondition condition) {
        List result = new ArrayList();
        String saleOrgId = null;
        if (condition.getSaleOrg() != null && condition.getSaleOrg().getId() != null) {
            saleOrgId = condition.getSaleOrg().getId().toString();
            PriceCondition[] pc = new PriceCondition[]{condition};
            result = PriceService.getPrices(ctx, pc, saleOrgId);
        }
        return result;
    }

    private static BigDecimal getPriceByMaterialId(List priceList, String matID) {
        BigDecimal price = SysConstant.BIGZERO;
        if (priceList.size() == 0) {
            return price;
        }
        SalePriceTO salePriceDTO = PriceService.findPriceDTO(priceList, matID);
        if (salePriceDTO != null) {
            price = salePriceDTO.price;
        }
        price = price == null ? SysConstant.BIGZERO : price;
        return price;
    }

    private static SalePriceTO findPriceDTO(List priceList, String matID) {
        for (int i = 0; i < priceList.size(); ++i) {
            MatPriceTO mp = (MatPriceTO)priceList.get(i);
            for (int j = 0; j < mp.prices.length; ++j) {
                SalePriceTO salePriceDTO = mp.prices[j];
                if (!matID.equals(salePriceDTO.material)) continue;
                PriceService.setPriceByDiscount(salePriceDTO);
                return salePriceDTO;
            }
        }
        return null;
    }

    private static Map groupBySaleOrg(PriceCondition[] conditions) {
        HashMap m = new HashMap();
        String saleOrgId = null;
        for (int i = 0; i < conditions.length; ++i) {
            PriceCondition condition = conditions[i];
            saleOrgId = condition.getSaleOrg().getId().toString();
            if (m.get(saleOrgId) == null) {
                ArrayList<PriceCondition> l = new ArrayList<PriceCondition>();
                l.add(condition);
                m.put(saleOrgId, l);
                continue;
            }
            ((List)m.get(saleOrgId)).add(condition);
        }
        return m;
    }

    private static void populateResult(List priceList, PriceCondition[] conditions, List result) {
        for (int i = 0; i < conditions.length; ++i) {
            PriceCondition condition = conditions[i];
            String matId = condition.getMaterialInfo().getId().toString();
            String saleOrgId = condition.getSaleOrg().getId().toString();
            String orgLongNumber = condition.getSaleOrg().getLongNumber();
            for (int j = 0; j < priceList.size(); ++j) {
                SalePriceTO salePriceDTO = PriceService.findChannelPriceDTO((MatPriceTO)priceList.get(j), matId, orgLongNumber, saleOrgId);
                if (salePriceDTO == null) continue;
                PriceService.setPriceByDiscount(salePriceDTO);
                result.add(salePriceDTO);
            }
        }
    }

    private static void setPriceByDiscount(SalePriceTO salePriceDTO) {
        if (salePriceDTO != null && salePriceDTO.price != null) {
            DiscountModeEnum discountMode = DiscountModeEnum.getEnum((int)(salePriceDTO.discountMode == null ? -1 : salePriceDTO.discountMode));
            BigDecimal discount = salePriceDTO.discountValue == null ? new BigDecimal("0.00") : salePriceDTO.discountValue;
            salePriceDTO.price = PriceService.calcDiscountPrice(discountMode, salePriceDTO.price, discount);
        }
    }

    private static BigDecimal calcDiscountPrice(DiscountModeEnum mode, BigDecimal price, BigDecimal discount) {
        if (mode == null) {
            return price;
        }
        BigDecimal discountPrice = new BigDecimal("0.00");
        BigDecimal Hundred = new BigDecimal("100.0");
        if (mode.equals((Object)DiscountModeEnum.PERCENT)) {
            discountPrice = price.multiply(discount).divide(Hundred, 2, 6);
            discountPrice = price.subtract(discountPrice);
        } else {
            discountPrice = price.subtract(discount);
        }
        return discountPrice;
    }

    private static SalePriceTO findChannelPriceDTO(MatPriceTO mp, String matId, String orglongNumber, String orgId) {
        SalePriceTO salePriceDTO = null;
        for (int i = 0; i < mp.prices.length; ++i) {
            salePriceDTO = mp.prices[i];
            if (null != (salePriceDTO = PriceService.findPriceDTO(salePriceDTO, matId, orglongNumber, orgId))) break;
        }
        return salePriceDTO;
    }

    public static BigDecimal findPrice(List priceList, String matID, String orgLongNumber, String saleOrgUnitID) {
        BigDecimal price = SysConstant.BIGZERO;
        SalePriceTO salePriceDTO = null;
        for (int i = 0; i < priceList.size(); ++i) {
            if (priceList.get(i) == null || (salePriceDTO = PriceService.findPriceDTO((SalePriceTO)priceList.get(i), matID, orgLongNumber, saleOrgUnitID)) == null) continue;
            price = salePriceDTO.price;
        }
        price = price == null ? SysConstant.BIGZERO : price;
        return price;
    }

    public static SalePriceTO findPriceDTO(SalePriceTO salePriceDTO, String matId, String orglongNumber, String orgId) {
        if ("basePrice".equals(salePriceDTO.priceType) ? matId.equals(salePriceDTO.material) && orgId != null && salePriceDTO.saleOrgUniID.equals(orgId) : ("pricePolicy".equals(salePriceDTO.priceType) ? orglongNumber.contains(salePriceDTO.orgLongNumber) && matId.equals(salePriceDTO.material) : "materialSaleInfo".equals(salePriceDTO.priceType) && orgId.equals(salePriceDTO.saleOrgUniID) && matId.equals(salePriceDTO.material))) {
            return salePriceDTO;
        }
        return null;
    }

    private static List getPrices(Context ctx, PriceCondition[] conditions, String saleOrgId) {
        ArrayList result = new ArrayList();
        try {
            IPriceProvider priceStrategy = null;
            priceStrategy = ctx == null ? PriceProviderFactory.getRemoteInstance() : PriceProviderFactory.getLocalInstance((Context)ctx);
            Method m = MethodUtils.getAccessibleMethod(IPriceProvider.class, (String)"getPrices", PriceCondition[].class);
            if (m != null) {
                List[] datas = priceStrategy.getPrices(conditions);
                PriceService.polulateData(Arrays.asList(datas), result, saleOrgId);
            } else {
                List datas = priceStrategy.batchCalculatPrice(conditions);
                PriceService.polulateData(datas, result, saleOrgId);
            }
        }
        catch (BOSException e) {
            System.out.println(e.getMessage());
            return result;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return result;
        }
        return result;
    }

    private static void polulateData(List datas, List result, String saleOrgId) {
        for (int i = 0; i < datas.size(); ++i) {
            List data = (List)datas.get(i);
            if (data == null) continue;
            MatPriceTO mp = new MatPriceTO(data.size());
            for (int j = 0; j < data.size(); ++j) {
                SalePriceTO sp = (SalePriceTO)data.get(j);
                if (sp.saleOrgUniID == null) {
                    sp.saleOrgUniID = saleOrgId;
                }
                if (sp.price == null) {
                    sp.price = SysConstant.BIGZERO;
                }
                mp.matId = sp.material;
                mp.prices[j] = sp;
            }
            result.add(mp);
        }
    }

    public static class MatPriceTO {
        public String matId;
        public SalePriceTO[] prices;

        public MatPriceTO(int priceTypeNumber) {
            this.prices = new SalePriceTO[priceTypeNumber];
        }
    }
}

