/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.arap.api.IArApBillHeadInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBack2LogisitcsFeeSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AP2LFWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true};
        IArApBillHeadInfo otherBillInfo = (IArApBillHeadInfo)destBillInfo;
        if (otherBillInfo == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("'").append(otherBillInfo.getId().toString()).append("'");
        String billId = sql.toString();
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, billId);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_PO_Audit", WriteBack2LogisitcsFeeSQLHelper.createAP2LFWriteSQL(bizAction, billId, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_PO_UnAduit", WriteBack2LogisitcsFeeSQLHelper.createAP2LFWriteSQL(bizAction, billId, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(billId, isWriteCore, tablename);
            }
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_PO_Audit", WriteBack2LogisitcsFeeSQLHelper.createAP2LFWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_PO_UnAduit", WriteBack2LogisitcsFeeSQLHelper.createAP2LFWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(idList, isWriteCore, tablename);
            }
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
        super.doHandle(ctx, bizAction, billId, ids);
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.AP2LFWriteBackHandler");
        String CR_TEMP = WriteBack2LogisitcsFeeSQLHelper.getAP2LFTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBack2LogisitcsFeeSQLHelper.getAP2LFInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBack2LogisitcsFeeSQLHelper.createLFWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBack2LogisitcsFeeSQLHelper.verifyLFWriteBack(rs);
    }
}

