/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AR2CIWriteBackHandler
extends AbstractWriteBackHandler {
    @Override
    protected boolean directlyInDB() {
        return true;
    }

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null) {
            return;
        }
        ChannelInWarehsBillInfo channelInWarehsBillInfo = (ChannelInWarehsBillInfo)destBillInfo;
        String id = channelInWarehsBillInfo.getId().toString();
        PreparedStatement ps = null;
        if (bizAction == BizActionEnum.AUDIT) {
            ps = this.createPreparedStatement("WB_CI_Audit", WriteBackSQLHelper.createAR2CIWriteSQLDialect(bizAction, ctx));
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            ps = this.createPreparedStatement("WB_CI_UnAduit", WriteBackSQLHelper.createAR2CIWriteSQLDialect(bizAction, ctx));
        }
        this.executeUpdate(ps, new Object[]{id});
        if (bizAction == BizActionEnum.AUDIT) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = "AR2CI_KSQL_0";
            tablename = KsqlUtil.createTempTable(ctx, WriteBackSQLHelper.getAR2CITempTableSQL(tablename));
            String WB_TEMP = WriteBackSQLHelper.getAR2CIInsertTempSQL(bizAction, idList, tablename);
            PreparedStatement pstmt = this.createPreparedStatement("WB_CI_TEMP", WB_TEMP);
            this.executeUpdate(pstmt, null);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_CI_Audit", WriteBackSQLHelper.createAR2CIWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_CI_UnAduit", WriteBackSQLHelper.createAR2CIWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                // empty if block
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        finally {
            if (tablename != null) {
                KsqlUtil.releaseTempTable(ctx, tablename);
            }
        }
    }

    private void verify(String idList, boolean[] isWriteCore, String tablename, boolean isArQtyGtSoSysParam) throws SCMBillException, SQLException {
    }
}

