/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBack2RoadCostBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AR2RCWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_AR_Audit", WriteBack2RoadCostBillSQLHelper.createAR2RCWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_AR_UnAduit", WriteBack2RoadCostBillSQLHelper.createAR2RCWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(idList, isWriteCore, tablename);
            }
            boolean isWriteBack2SaleOrder = false;
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                String coreBosType;
                BOSObjectType coreBosTypeObj;
                BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
                if (coreBosTypeObj == null || !(coreBosType = coreBosTypeObj.toString()).equals("C48A423A")) continue;
                isWriteBack2SaleOrder = true;
                break;
            }
            if (isWriteBack2SaleOrder) {
                tablename = this.createTempTable4Saleorder(ctx, idList);
                ps = null;
                if (bizAction == BizActionEnum.AUDIT) {
                    ps = this.createPreparedStatement("WB_SO", WriteBackSQLHelper.createAR2SOWriteSQL(bizAction, idList, tablename));
                } else if (bizAction == BizActionEnum.UNAUDIT) {
                    ps = this.createPreparedStatement("WB_SO_UnAduit", WriteBackSQLHelper.createAR2SOWriteSQL(bizAction, idList, tablename));
                }
                this.executeUpdate(ps, null);
                if (bizAction == BizActionEnum.AUDIT) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("company.id"));
                    BillBaseInfo otherBillInfo = (BillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(billId[0]), (SelectorItemCollection)sic);
                    boolean isArQtyGtSoSysParam = WriteBackSQLHelper.getArQtyGtSoSysParam(ctx, otherBillInfo.getCompany());
                    this.verifySaleOrder(idList, isWriteCore, tablename, isArQtyGtSoSysParam);
                }
            }
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.AR2RCWriteBackHandler");
        String CR_TEMP = WriteBack2RoadCostBillSQLHelper.getAR2RCTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBack2RoadCostBillSQLHelper.getAR2RCInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBack2RoadCostBillSQLHelper.createRCWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBack2RoadCostBillSQLHelper.verifyRCWriteBack(rs);
    }

    private String createTempTable4Saleorder(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.AR2SOWriteBackHandler");
        String CR_TEMP = WriteBackSQLHelper.getAR2SOTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBackSQLHelper.getAR2SOInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP_SO", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    private void verifySaleOrder(String idList, boolean[] isWriteCore, String tablename, boolean isArQtyGtSoSysParam) throws SCMBillException, SQLException {
        if (!isArQtyGtSoSysParam) {
            String VERIFY = WriteBackSQLHelper.createARWriteBackVerifySQL(idList, isWriteCore, tablename, isArQtyGtSoSysParam, false);
            PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
            IRowSet rs = this.executeQuery(ps, null);
            WriteBackSQLHelper.verifyARWriteBack(rs);
        }
    }
}

