/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractWriteBackHandler
implements IWriteBackHandler {
    Connection con = null;
    Map psMap = null;

    @Override
    public void handle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException {
        if (SCMServerUtils.isHasBizFlowValue((Context)ctx, (IObjectValue)destBillInfo)) {
            return;
        }
        if (this.directlyInDB()) {
            try {
                this.initConnection(ctx);
                this.doHandle(ctx, bizAction, destBillInfo);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    private void initConnection(Context ctx) throws SQLException {
        if (this.con == null) {
            this.con = EJBFactory.getConnection((Context)ctx);
            this.psMap = new HashMap();
        }
    }

    private void cleanup() {
        Iterator iter = this.psMap.keySet().iterator();
        while (iter.hasNext()) {
            SQLUtils.cleanup((Statement)((PreparedStatement)this.psMap.get(iter.next())));
        }
        SQLUtils.cleanup((Connection)this.con);
    }

    protected void doHandle(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
    }

    protected boolean directlyInDB() {
        return false;
    }

    protected final IRowSet executeQuery(PreparedStatement ps, Object[] params) throws SQLException {
        if (ps == null) {
            return null;
        }
        ResultSet rs = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        rs = ps.executeQuery();
        JdbcRowSet rowset = new JdbcRowSet();
        rowset.populate(rs);
        return rowset;
    }

    protected final PreparedStatement createPreparedStatement(String key, String sql) throws SQLException {
        if (this.psMap.containsKey(key)) {
            return (PreparedStatement)this.psMap.get(key);
        }
        PreparedStatement ps = this.con.prepareStatement(sql);
        this.psMap.put(key, ps);
        return ps;
    }

    protected final PreparedStatement getPreparedStatement(String key) throws SQLException {
        return (PreparedStatement)this.psMap.get(key);
    }

    protected final void executeUpdate(PreparedStatement ps, Object[] params) throws SQLException {
        if (ps == null) {
            return;
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        ps.execute();
        if (ps != null) {
            ps.close();
        }
    }

    @Override
    public void handle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException {
        if (billId.length == 0) {
            return;
        }
        ICoreBillBase iCoreBill = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)BOSUuid.read((String)billId[0]).getType().toString()));
        CoreBaseCollection objColl = iCoreBill.getCollection("select * where id in (" + SCMServerUtils.parseArraytoString((String[])billId) + ")");
        if (objColl == null || objColl.size() == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            if (SCMServerUtils.isHasBizFlowValue((Context)ctx, (IObjectValue)objColl.getObject(i))) continue;
            idList.add(objColl.getObject(i).get("id").toString());
        }
        if (idList.size() == 0) {
            return;
        }
        String[] billIds = new String[idList.size()];
        int size2 = idList.size();
        for (int i = 0; i < size2; ++i) {
            billIds[i] = idList.get(i).toString();
        }
        if (this.directlyInDB()) {
            try {
                this.initConnection(ctx);
                this.doHandle(ctx, bizAction, billIds, ids);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.cleanup();
            }
        }
    }

    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
    }
}

