/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBackFromCarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class CB2TOWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, false, false, false, true};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_CB_Audit", WriteBackFromCarryBillSQLHelper.createCB2TOWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_CB_UnAduit", WriteBackFromCarryBillSQLHelper.createCB2TOWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(ctx, idList, isWriteCore, tablename);
            }
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.CB2TOWriteBackHandler");
        String CR_TEMP = WriteBackFromCarryBillSQLHelper.getCB2TOTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBackFromCarryBillSQLHelper.getCB2TOInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBackFromCarryBillSQLHelper.createCBWriteBackVerifySQL(ctx, idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBackFromCarryBillSQLHelper.verifyCBWriteBack(rs);
    }
}

