/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.util.WriteBack2CarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class LF2CBWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, false, false, true, false, false};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_LF_Audit", WriteBack2CarryBillSQLHelper.createLF2CBWriteSQL(bizAction, idList, tablename));
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_LF_UnAduit", WriteBack2CarryBillSQLHelper.createLF2CBWriteSQL(bizAction, idList, tablename));
            }
            this.executeUpdate(ps, null);
            if (bizAction == BizActionEnum.AUDIT) {
                this.verify(ctx, idList, isWriteCore, tablename);
            }
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.LF2CBWriteBackHandler");
        String CR_TEMP = WriteBack2CarryBillSQLHelper.getLF2CBTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBack2CarryBillSQLHelper.getLF2CBInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws EASBizException, SQLException, BOSException {
        String VERIFY = WriteBack2CarryBillSQLHelper.createCBWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        String notCheckSql = this.getNotCheckSql(ctx, idList, isWriteCore, tablename);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY + notCheckSql);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBack2CarryBillSQLHelper.verifyCBWriteBack(ctx, rs);
    }

    private String getNotCheckSql(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[3]) {
            Set<String> notCheckTranportOrgUnits;
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)this.getSelectTranportOrgUnitSql(idList));
            ArrayList<String> tanportOrgUnitList = new ArrayList<String>();
            while (iRowSet.next()) {
                tanportOrgUnitList.add(iRowSet.getString("tranportOrgUnitId"));
            }
            int orgSize = tanportOrgUnitList.size();
            if (orgSize > 0 && (notCheckTranportOrgUnits = this.getNotNeedCheckOrg(ctx, "CARRY007", tanportOrgUnitList)).size() > 0) {
                String[] notCheckOrgUnitIdArray = notCheckTranportOrgUnits.toArray(new String[0]);
                StringBuffer notCheckOrgSql = new StringBuffer();
                int size = notCheckOrgUnitIdArray.length;
                for (int i = 0; i < size; ++i) {
                    notCheckOrgSql.append("'").append(notCheckOrgUnitIdArray[i]).append("'");
                    if (i == size - 1) continue;
                    notCheckOrgSql.append(",");
                }
                sql.append(" AND src.FTranportOrgUnitId NOT IN (").append(notCheckOrgSql).append(")");
            }
        }
        return sql.toString();
    }

    private Set<String> getNotNeedCheckOrg(Context ctx, String paramNumber, ArrayList<String> tanportOrgUnitList) throws BOSException, EASBizException {
        int orgSize = tanportOrgUnitList.size();
        ArrayList<String> paramNumbers = new ArrayList<String>(orgSize);
        for (int i = 0; i < orgSize; ++i) {
            paramNumbers.add(paramNumber);
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        ArrayList params = iParamControl.getParamHashMapBatch(paramNumbers, tanportOrgUnitList);
        HashSet<String> notCheckTranportOrgUnits = new HashSet<String>();
        for (ParamSimpleInfo paramSimpleInfo : params) {
            if (!"1".equals(paramSimpleInfo.getParamValue()) && !"true".equals(paramSimpleInfo.getParamValue())) continue;
            notCheckTranportOrgUnits.add(paramSimpleInfo.getOrgUnitPK().toString());
        }
        return notCheckTranportOrgUnits;
    }

    private String getSelectTranportOrgUnitSql(String idList) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT src.FTranportOrgUnitId as tranportOrgUnitId ");
        sql.append("FROM T_DT_CarryBillFeeEntry srcEntry ");
        sql.append("INNER JOIN T_DT_CarryBill src ON src.FID = srcEntry.FParentID ");
        sql.append("INNER JOIN T_DT_LogisticsFeeEntry destEntry ON destEntry.FSourceBillEntryId = srcEntry.FID ");
        sql.append("INNER JOIN T_DT_LogisticsFee dest ON dest.FID = destEntry.FParentID ");
        sql.append("WHERE dest.FID IN (");
        sql.append(idList);
        sql.append(") ");
        sql.append("AND ABS(srcEntry.FFeeQty)-ABS(srcEntry.FBalancedQty) < 0 GROUP BY src.FTranportOrgUnitId");
        return sql.toString();
    }
}

