/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBack2CarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PI2CBWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{false, true, false, false, false, false};
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            String coreBosType;
            BOSObjectType coreBosTypeObj;
            BOSObjectType bOSObjectType = coreBosTypeObj = ids[i][1] == null ? null : BOSUuid.read((String)ids[i][1]).getType();
            if (coreBosTypeObj == null || (coreBosType = coreBosTypeObj.toString()).equals("3171BFAD") || !coreBosType.equals("5C2A1F0C")) continue;
            isWriteCore[1] = false;
            isWriteCore[5] = true;
            break;
        }
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            String sql = null;
            if (isWriteCore[1]) {
                sql = WriteBack2CarryBillSQLHelper.createPI2CBWriteSQL(bizAction, idList, tablename);
            } else if (isWriteCore[5]) {
                sql = WriteBack2CarryBillSQLHelper.createPI2CBWriteSQL2(bizAction, idList, tablename);
            }
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_PI_Audit", sql);
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_PI_UnAduit", sql);
            }
            this.executeUpdate(ps, null);
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.PI2CBWriteBackHandler");
        String CR_TEMP = WriteBack2CarryBillSQLHelper.getPI2CBTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBack2CarryBillSQLHelper.getPI2CBInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBack2CarryBillSQLHelper.createCBWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBack2CarryBillSQLHelper.verifyCBWriteBack(ctx, rs);
    }
}

