/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.AbstractWriteBackHandler;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.WriteBack2CarryBillSQLHelper;
import com.kingdee.eas.scm.common.util.WriteBackSQLHelper;
import com.kingdee.eas.scm.im.dt.CarryBillFactory;
import com.kingdee.eas.scm.im.dt.CarryBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class SI2CBWriteBackHandler
extends AbstractWriteBackHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, String[] billId, String[][] ids) throws EASBizException, BOSException, SQLException {
        boolean[] isWriteCore = new boolean[]{true, false, false, false, false, false};
        String idList = WriteBackSQLHelper.getKeyIdList(billId);
        String tablename = null;
        CarryBillInfo info = null;
        String sourceBillId = ids[0][0];
        if (sourceBillId != null && (info = CarryBillFactory.getLocalInstance((Context)ctx).getCarryBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId), this.getSelectors())) != null && 4 == info.getDistributionType().getValue()) {
            isWriteCore = new boolean[]{false, false, false, false, false, false, false, false, false, true};
        }
        try {
            tablename = this.createTempTable(ctx, idList);
            PreparedStatement ps = null;
            String sql = null;
            if (isWriteCore[0]) {
                sql = WriteBack2CarryBillSQLHelper.createSI2CBWriteSQL(bizAction, idList, tablename);
            } else if (isWriteCore[9]) {
                sql = WriteBack2CarryBillSQLHelper.createSI2CBWriteSQL2(bizAction, idList, tablename);
            }
            if (bizAction == BizActionEnum.AUDIT) {
                ps = this.createPreparedStatement("WB_SI_Audit", sql);
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                ps = this.createPreparedStatement("WB_SI_UnAduit", sql);
            }
            this.executeUpdate(ps, null);
            this.writeBackPostRequisition(ctx, billId[0], bizAction);
        }
        finally {
            if (tablename != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(tablename);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String createTempTable(Context ctx, String idList) throws SQLException, BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.common.SI2CBWriteBackHandler");
        String CR_TEMP = WriteBack2CarryBillSQLHelper.getSI2CBTempTableSQL(tablename);
        iTableManager.createTempTable(CR_TEMP);
        String WB_TEMP = WriteBack2CarryBillSQLHelper.getSI2CBInsertTempSQL(idList, tablename);
        PreparedStatement ps = this.createPreparedStatement("WB_TEMP", WB_TEMP);
        this.executeUpdate(ps, null);
        return tablename;
    }

    @Override
    protected boolean directlyInDB() {
        return true;
    }

    private void verify(Context ctx, String idList, boolean[] isWriteCore, String tablename) throws SCMBillException, SQLException {
        String VERIFY = WriteBack2CarryBillSQLHelper.createCBWriteBackVerifySQL(idList, isWriteCore, tablename, false);
        PreparedStatement ps = this.createPreparedStatement("VERIFY", VERIFY);
        IRowSet rs = this.executeQuery(ps, null);
        WriteBack2CarryBillSQLHelper.verifyCBWriteBack(ctx, rs);
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("distributionType"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPostRequisition(Context ctx, String billid, BizActionEnum bizAction) throws EASBizException, BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String sign = "";
        if (bizAction == BizActionEnum.AUDIT) {
            sign = "+";
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sign = "-";
        }
        sql.append("UPDATE T_SD_PostRequisitionEntry AS T1 SET(FShippedQty,FSHIPPEDBASEQTY)=(");
        sql.append(" SELECT (isnull(T1.FSHIPPEDQTY,0)").append(sign).append("entry.fsumQty )  as fpostQty,");
        sql.append(" ( isnull(T1.FSHIPPEDBASEQTY,0)").append(sign).append("entry.fsumBaseQty) as fpostBaseQty from ( ");
        sql.append(" SELECT sum(CASE WHEN poentry.FUnitID=salentry.FUnitID then salentry.FQTY  ELSE ROUND(salentry.fBaseQty/mm.FBaseConvsRate,");
        sql.append(" mm.FQtyPrecision) END ) as fsumQty, sum( salentry.fBaseQty ) as fsumBaseQty,carentry.FSOURCEBILLENTRYID  as csourceid ");
        sql.append(" FROM T_IM_SALEISSUEENTRY salentry ");
        sql.append(" INNER JOIN T_DT_CARRYBILLENTRY carentry on salentry.FSOURCEBILLENTRYID = carentry.fid   ");
        sql.append(" INNER JOIN T_SD_POSTREQUISITIONENTRY  poentry on carentry.FSOURCEBILLENTRYID  = poentry.fid ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mm ON mm.FMaterialID=poentry.FMaterialID AND mm.FMeasureUnitID=poentry.FUnitID   ");
        sql.append(" where salentry.FPARENTID = '").append(billid).append("' group by carentry.FSOURCEBILLENTRYID ");
        sql.append(" ) as entry");
        sql.append(" where T1.fid = entry.csourceid )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select prentry.FPARENTID as FID from T_IM_SALEISSUEENTRY saleentry");
        sql.append(" inner join T_DT_CARRYBILLENTRY carrayentry on carrayentry.FID = saleentry.FSOURCEBILLENTRYID");
        sql.append(" inner join T_SD_POSTREQUISITIONENTRY prentry on prentry.FID = carrayentry.FSOURCEBILLENTRYID");
        sql.append(" where saleentry.FPARENTID = '").append(billid).append("' group by prentry.FPARENTID");
        ArrayList<String[]> entryParamsList = new ArrayList<String[]>();
        ArrayList<String[]> billParamsList = new ArrayList<String[]>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() > 0) {
            try {
                while (rs.next()) {
                    String[] ids = new String[]{rs.getString("FID")};
                    entryParamsList.add(ids);
                    String[] billParamIds = new String[]{rs.getString("FID"), rs.getString("FID")};
                    billParamsList.add(billParamIds);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            sql.setLength(0);
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" UPDATE T_SD_POSTREQUISITIONENTRY  SET FBASESTATUS = 7 ");
                sql.append(" where FPARENTID = ? and (FSHIPPEDQTY >= FQTY) ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" UPDATE T_SD_POSTREQUISITIONENTRY  SET FBASESTATUS = 4 ");
                sql.append(" where FPARENTID = ? and (FSHIPPEDQTY < FQTY) ");
            }
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), entryParamsList);
            sql.setLength(0);
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" UPDATE T_SD_POSTREQUISITION SET FBASESTATUS = 7 ");
                sql.append(" WHERE  NOT EXISTS ( select 1 from T_SD_POSTREQUISITIONENTRY ");
                sql.append(" where FBASESTATUS <>7 and FPARENTID = ?)");
                sql.append("  and fid = ?");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" UPDATE T_SD_POSTREQUISITION SET FBASESTATUS = 4 ");
                sql.append(" WHERE EXISTS ( select 1 from T_SD_POSTREQUISITIONENTRY ");
                sql.append(" where FBASESTATUS = 4 and FPARENTID = ?)");
                sql.append("  and fid = ?");
            }
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), billParamsList);
        }
    }
}

