/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.AuditActionProxy;
import com.kingdee.eas.scm.common.action.ConfirmActionProxy;
import com.kingdee.eas.scm.common.action.GeneralActionProxy;
import com.kingdee.eas.scm.common.action.MoveActionProxy;
import com.kingdee.eas.scm.common.action.ReasonActionProxy;
import com.kingdee.eas.scm.common.action.SubmitActionProxy;
import com.kingdee.eas.scm.common.action.UnAuditActionProxy;
import java.util.HashSet;

public class ActionProxyFactory {
    private static final HashSet<BatchActionEnum> reasonActionSet = new HashSet(3);
    public static final HashSet<BatchActionEnum> moveActionSet;

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action) throws IllegalArgumentException {
        String clzName = action.getClass().getName();
        if (clzName.endsWith("Action")) {
            return ActionProxyFactory.createActionProxy(bizAction, action, clzName.substring(0, clzName.length() - 6));
        }
        throw new IllegalArgumentException("The action name is not ends with 'Acton', please provide action method. ");
    }

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action, String actionMethod) {
        if (bizAction.equals((Object)BatchActionEnum.DELETE)) {
            return new ConfirmActionProxy(action, actionMethod, bizAction);
        }
        if (bizAction.equals((Object)BatchActionEnum.AUDIT)) {
            return new AuditActionProxy(action, actionMethod, bizAction);
        }
        if (bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            return new SubmitActionProxy(action, actionMethod, bizAction);
        }
        if (reasonActionSet.contains(bizAction)) {
            return new ReasonActionProxy(action, actionMethod, bizAction);
        }
        if (bizAction.equals((Object)BatchActionEnum.UNAUDIT)) {
            return new UnAuditActionProxy(action, actionMethod, bizAction);
        }
        return new GeneralActionProxy(action, actionMethod, bizAction);
    }

    public static ActionProxy createActionProxy(BatchActionEnum bizAction, ItemAction action, String actionMethod, ContextTypeEnum contextType) {
        if (contextType.equals((Object)ContextTypeEnum.INMAINTAINING) && (bizAction.equals((Object)BatchActionEnum.SUBMIT) || bizAction.equals((Object)BatchActionEnum.SAVE))) {
            return new SubmitActionProxy(action, actionMethod, bizAction);
        }
        if (moveActionSet.contains(bizAction)) {
            return new MoveActionProxy(action, actionMethod, bizAction);
        }
        return ActionProxyFactory.createActionProxy(bizAction, action, actionMethod);
    }

    static {
        reasonActionSet.add(BatchActionEnum.CLOSE);
        reasonActionSet.add(BatchActionEnum.FREEZE);
        reasonActionSet.add(BatchActionEnum.CANCEL);
        moveActionSet = new HashSet(4);
        moveActionSet.add(BatchActionEnum.FIRST);
        moveActionSet.add(BatchActionEnum.PREVIOUS);
        moveActionSet.add(BatchActionEnum.NEXT);
        moveActionSet.add(BatchActionEnum.LAST);
    }
}

