/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.workflow.biz.trans.BillApproveResultInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.action.AllInWFException;
import com.kingdee.eas.scm.common.action.JobActionProxy;
import java.util.List;

public class AuditActionProxy
extends JobActionProxy {
    private static final long serialVersionUID = 1L;
    private boolean multiApproved = false;

    public AuditActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        super(action, actionMethod, bizAction);
    }

    @Override
    protected int resolveResult(BatchSelectionEntries selectionEntry, BatchExecuteResult executeResult, List lockList) throws Exception {
        if (this.multiApproved) {
            this.getActionManager().getTableSelectionHelper().refresh(this.getBizAction(), selectionEntry, 1);
            return 1;
        }
        return super.resolveResult(selectionEntry, executeResult, lockList);
    }

    @Override
    protected boolean beforeAction() {
        this.multiApproved = false;
        return super.beforeAction();
    }

    @Override
    protected void handleBatchException(EASBizException e, String[] toDoArray) throws Exception {
        if (e instanceof AllInWFException) {
            String action;
            MetaDataPK uiObjPK;
            this.multiApproved = true;
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
            BillApproveResultInfo resultInfo = enactmentService.getBillApproveResultInfo(toDoArray, (IMetaDataPK)(uiObjPK = new MetaDataPK(MultiApproveUI.class.getName())), action = "ActionSubmit", userID);
            if (resultInfo.getAssignmentInfoMap() == null || resultInfo.getAssignmentInfoMap().size() <= 0) {
                throw new SCMBillException(SCMBillException.BILLINWF, e);
            }
            MultiApproveUtil.multiapproveBills((CoreUIObject)((CoreUIObject)this.uiObj), (String)userID, (String[])toDoArray);
        } else {
            super.handleBatchException(e, toDoArray);
        }
    }

    @Override
    protected int resolveResult(BatchSelectionEntries selectionEntry, BatchExecuteResult executeResult) throws Exception {
        if (this.multiApproved) {
            this.getActionManager().getTableSelectionHelper().refresh(this.getBizAction(), selectionEntry, 1);
            return 1;
        }
        return super.resolveResult(selectionEntry, executeResult);
    }
}

