/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.List;
import java.util.Map;

public class BatchResultResolver {
    private static final String EmptyString = "";
    private static BatchResultResolver render;
    private static final String TAB = "\t";
    private static final String CR = "\n";
    private static final String NO_RESULT = "";
    private static final String SUCCESS_HEAD_MSG = "SUCCESS_HEAD_MSG";
    private static final String SUCCESS_ENTRY_MSG = "SUCCESS_ENTRY_MSG";
    private static final String ERROR_HEAD_MSG = "ERROR_HEAD_MSG";
    private static final String ERROR_ENTRY_MSG = "ERROR_ENTRY_MSG";
    private static final String HEAD_TITLE;
    private static final String ENTRY_TITLE;

    private BatchResultResolver() {
    }

    public static BatchResultResolver getInstance() {
        return render;
    }

    public int resolveResult(ActionProxy actionProxy, BatchExecuteResult executeResult, BatchSelectionEntries selectionEntry, List todoList) {
        int countSuccess = this.processResults(executeResult, selectionEntry.getEntries(), todoList, actionProxy.getLevel());
        BatchActionResults batchResults = null;
        if (executeResult != null) {
            batchResults = (BatchActionResults)executeResult.getBatchResult();
        }
        if (batchResults != null && batchResults.isCanIgnore()) {
            countSuccess = this.showConfirm(actionProxy, countSuccess, selectionEntry, batchResults);
        } else {
            this.showResult(actionProxy, countSuccess, selectionEntry.getEntries());
        }
        return countSuccess;
    }

    private int showConfirm(ActionProxy actionProxy, int countSuccess, BatchSelectionEntries selectionEntry, BatchActionResults batchResults) {
        StringBuffer sb = new StringBuffer();
        sb.append(actionProxy.getLevel().equals((Object)ActionLevelEnum.HEAD) ? this.getHeadResult(selectionEntry.getEntries(), false) : this.getEntryResult(selectionEntry.getEntries(), false)).append(ResourceUtils.getMessage("com.kingdee.eas.scm.common.ActionResource", "CONFIRM_CONTINUE")).append(actionProxy.getValue("ShortDescription"));
        int answer = MsgBox.showConfirm2((Component)((Component)actionProxy.getUIObject()), (String)sb.toString());
        if (answer == 0) {
            List entries = selectionEntry.getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                BatchSelectionEntry entry = (BatchSelectionEntry)entries.get(i);
                ActionResultEnum actionResult = entry.getResult();
                if (ActionResultEnum.ERROR.equals((Object)actionResult)) {
                    entry.setActionResult(new ActionResult(null, ""));
                    continue;
                }
                entries.remove(entry);
            }
            return actionProxy.reDoActionPerformed(selectionEntry, batchResults);
        }
        return countSuccess;
    }

    private void showResult(ActionProxy actionProxy, int countSuccess, List selectionEntry) {
        int total = selectionEntry.size();
        if (countSuccess == total) {
            this.showSuccessMsg(actionProxy, total);
        } else {
            String result;
            String string = result = actionProxy.getLevel().equals((Object)ActionLevelEnum.HEAD) ? this.getHeadResult(selectionEntry, true) : this.getEntryResult(selectionEntry, true);
            if (result.trim().equals("")) {
                return;
            }
            MsgBox.showDetailAndOK(null, (String)this.getErrorMsg(total, total - countSuccess, actionProxy), (String)result, (int)8188);
        }
        List<EASBizException> list = actionProxy.getBatchActionExceptionList();
        StringBuffer msg = new StringBuffer(250);
        if (list != null && list.size() > 0) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EASBizException e = list.get(i);
                msg.append(e.getMessage() + CR);
            }
            String title = EASResource.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"AUTORESERVATION_WARNNING");
            MsgBox.showDetailAndOK(null, (String)title, (String)msg.toString(), (int)2);
        }
    }

    public int resolveResult(ActionProxy actionProxy, List selectionEntry) {
        int countSuccess = this.getSuccessCount(selectionEntry);
        this.showResult(actionProxy, countSuccess, selectionEntry);
        return countSuccess;
    }

    private int getSuccessCount(List selectionEntry) {
        int countSuccess = 0;
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (!entry.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
            ++countSuccess;
        }
        return countSuccess;
    }

    private String getErrorMsg(int total, int error, ActionProxy actionProxy) {
        return ResourceUtils.getMessageInOrder("com.kingdee.eas.scm.common.ActionResource", actionProxy.getLevel().equals((Object)ActionLevelEnum.HEAD) ? ERROR_HEAD_MSG : ERROR_ENTRY_MSG, new String[]{String.valueOf(total), String.valueOf(error), (String)actionProxy.getValue("ShortDescription")});
    }

    private void showSuccessMsg(ActionProxy actionProxy, int total) {
        if (actionProxy.getUIObject() instanceof CoreUI) {
            CoreUI uiObj = (CoreUI)actionProxy.getUIObject();
            uiObj.setMessageText(this.getSuccessMsg(actionProxy, total));
        }
    }

    private String getSuccessMsg(ActionProxy actionProxy, int total) {
        return ResourceUtils.getMessageInOrder("com.kingdee.eas.scm.common.ActionResource", actionProxy.getLevel().equals((Object)ActionLevelEnum.HEAD) ? SUCCESS_HEAD_MSG : SUCCESS_ENTRY_MSG, new String[]{String.valueOf(total), (String)actionProxy.getValue("ShortDescription")});
    }

    private int processResults(BatchExecuteResult executeResult, List selectionEntry, List todoList, ActionLevelEnum actionLevel) {
        if (executeResult == null || executeResult.getExceptions() == null || executeResult.getExceptions().length == 0) {
            return 0;
        }
        if (executeResult.getBatchResult() != null && !(executeResult.getBatchResult() instanceof BatchActionResults)) {
            throw new UnsupportedOperationException("The result of batch method must be BatchActionResults instance.");
        }
        BatchActionResults batchResults = (BatchActionResults)executeResult.getBatchResult();
        if (batchResults == null) {
            batchResults = BatchActionResults.populateActionResults((Object[])todoList.toArray());
        }
        Throwable[] exceptions = executeResult.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            if (!(exceptions[i] instanceof BOSException) || exceptions[i].getCause() == null || !(exceptions[i].getCause() instanceof EASBizException)) continue;
            executeResult.setException(i, exceptions[i].getCause());
        }
        int countSuccess = BatchActionUtil.resolveActionResults((BatchActionResults)batchResults, (BatchExecuteResult)executeResult, (List)selectionEntry, (List)todoList, (ActionLevelEnum)actionLevel);
        if (batchResults.getResponse() != null) {
            ActionCache.put((Map)batchResults.getResponse().getResponse());
        }
        return countSuccess;
    }

    private String getHeadResult(List selectionEntry, boolean isShowHeader) {
        StringBuffer sb = new StringBuffer();
        boolean isError = false;
        if (isShowHeader) {
            sb.append(HEAD_TITLE).append(CR);
        }
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (entry.getResult() == null || !entry.getResult().equals((Object)ActionResultEnum.ERROR)) continue;
            sb.append(entry.getNumber()).append(TAB).append(entry.getResultMsg()).append(CR);
            isError = true;
        }
        return isError ? sb.toString() : "";
    }

    private String getEntryResult(List selectionEntry, boolean isShowHeader) {
        StringBuffer sb = new StringBuffer();
        boolean isError = false;
        if (isShowHeader) {
            sb.append(ENTRY_TITLE).append(CR);
        }
        int size = selectionEntry.size();
        for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
            BatchSelectionEntry entry = (BatchSelectionEntry)selectionEntry.get(idxOfEntry);
            if (entry == null || !entry.getResult().equals((Object)ActionResultEnum.ERROR)) continue;
            sb.append(entry.getNumber()).append(TAB).append(TAB).append(entry.getSeq()).append(TAB).append(entry.getResultMsg()).append(CR);
            isError = true;
        }
        return isError ? sb.toString() : "";
    }

    static {
        HEAD_TITLE = ResourceUtils.getMessageInOrder("com.kingdee.eas.scm.common.ActionResource", "HEAD_TITLE", new String[]{TAB});
        ENTRY_TITLE = ResourceUtils.getMessage("com.kingdee.eas.scm.common.ActionResource", "ENTRY_TITLE", new String[]{TAB});
        render = new BatchResultResolver();
    }
}

