/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.BatchExecuteParams;
import com.kingdee.eas.scm.common.action.MonitorObject;
import com.kingdee.eas.scm.common.action.SCMJobMonitor;
import com.kingdee.eas.scm.common.action.SCMProgressDialog;
import com.kingdee.eas.scm.common.action.SCMProgressDialogFactory;
import com.kingdee.eas.scm.common.action.SCMThreadPool;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.framework.util.SCMMDUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobActionProxy
extends ActionProxy {
    private static final long serialVersionUID = 5157428415860924524L;
    private static Logger logger = Logger.getLogger(JobActionProxy.class);
    private static final String SCMBILL_ACTION_JOBNUMBER = "SCMBillActionJob";
    private IBizCtrl iBizInterface;
    private ICreateJobFacade iCreateJobfacade;
    private boolean isUseMultithreading = false;

    public JobActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        super(action, actionMethod, bizAction);
    }

    public JobActionProxy(ItemAction action, String actionMethod, ActionLevelEnum level, BatchActionEnum bizAction) {
        super(action, actionMethod, level, bizAction);
    }

    @Override
    protected int doAction(Context mainContext, BatchSelectionEntries selectionEntry) {
        if (!this.isNeedSubmitToJob(selectionEntry)) {
            return super.doAction(mainContext, selectionEntry);
        }
        try {
            if (this.doActionPerformed(selectionEntry) && selectionEntry.getToDoIdList().size() > 0) {
                this.submitJob();
            }
        }
        catch (Exception e) {
            this.action.getUIObject().handUIException((Throwable)e);
        }
        return 0;
    }

    protected boolean isNeedSubmitToJob(BatchSelectionEntries selectionEntry) {
        if (!this.isSupportJob()) {
            return false;
        }
        if (!this.isJobActionLevel()) {
            return false;
        }
        boolean isOverThreshold = SCMUtil.isEntryCountOverThreshold(selectionEntry.size());
        return isOverThreshold && !this.isInWorkflow();
    }

    private boolean isInWorkflow() {
        boolean isInWf = false;
        try {
            if (BatchActionEnum.AUDIT.equals((Object)this.getBizAction())) {
                isInWf = SCMClientUtils.checkAllBizObjInWfProcess(this.getSelectionEntry().getToDoIdArray());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Judge whether bill in workflow error: " + e.getMessage()));
        }
        return isInWf;
    }

    protected boolean isJobActionLevel() {
        return ActionLevelEnum.HEAD.equals((Object)this.getLevel());
    }

    protected boolean isSupportJob() {
        return true;
    }

    protected SCMJobMonitor submitJob() throws Exception {
        if (this.iCreateJobfacade == null) {
            this.iCreateJobfacade = CreateJobFacadeFactory.getRemoteInstance();
        }
        if (this.iBizInterface == null) {
            this.iBizInterface = this.getBizInterface(this.getMainContext());
        }
        BatchSelectionEntries selectEntries = this.getSelectionEntry();
        SCMJobMonitor monitor = this.buildSCMJobMonitor();
        monitor.setTotalCount(selectEntries.size());
        SCMThreadPool.addMonitor(monitor);
        new Thread(new SubmitWorker(monitor)).start();
        return monitor;
    }

    private void submitJob(String actionAlias, BatchSelectionEntries entries, SCMJobMonitor monitor, int index) {
        JobConfig jobCfg = this.createJobConfig(actionAlias, entries, index);
        JobParam jobParam = this.createJobParam(entries, index);
        BatchSelectionEntry entry = entries.get(index);
        if (jobParam == null) {
            entry.setResult(ActionResultEnum.ERROR);
            entry.setResultMsg(SCMUtil.getActionResource("NULLPARAM"));
            monitor.addExceptionMonitorObject(this.getMonitorObject(entry), entry.getResultMsg());
            return;
        }
        try {
            String jobInstExtId;
            Map jobMap = this.iCreateJobfacade.executeJob(jobParam, jobCfg);
            if (null != jobMap && null != (jobInstExtId = (String)jobMap.get("jobInstExtId"))) {
                monitor.addMonitorObject(jobInstExtId, this.getMonitorObject(entry));
            }
            entry.setResult(ActionResultEnum.SUCCESS);
        }
        catch (Exception e) {
            entry.setResult(ActionResultEnum.ERROR);
            entry.setResultMsg(e.getMessage());
            monitor.addExceptionMonitorObject(this.getMonitorObject(entry), e.getCause().getMessage());
        }
    }

    private SCMJobMonitor buildSCMJobMonitor() {
        String title = this.getUIObject().getUITitle() + "-->" + this.getValue("ShortDescription");
        this.initIsUseMultithreading();
        boolean isSingle = this.getSelectionEntry().getToDoIdList().size() == 1;
        SCMProgressDialog dialog = SCMProgressDialogFactory.getProgressDialog(this.getUIObject(), title, !this.isUseMultithreading && isSingle, true);
        SCMJobMonitor scmJobMonitor = new SCMJobMonitor(title, dialog, this);
        scmJobMonitor.setUseMultithreading(this.isUseMultithreading);
        return scmJobMonitor;
    }

    private void initIsUseMultithreading() {
        int toDoParamSize = this.getSelectionEntry().getToDoIdList().size();
        try {
            String value = ParamManager.getParamValue(null, null, (String)"SCMOperaThreadNum");
            int threadNum = 4;
            try {
                threadNum = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e.getMessage());
            }
            int useMultithreadingBillNumber = 5000;
            try {
                useMultithreadingBillNumber = Integer.parseInt(ParamManager.getParamValue(null, null, (String)"SCMMultithreadingOperaBillNumber"));
            }
            catch (NumberFormatException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            this.isUseMultithreading = this.getSelectionEntry().isHead() && toDoParamSize > threadNum && Boolean.parseBoolean(ParamManager.getParamValue(null, null, (String)"SCMOperaIsUseMultithreading")) && toDoParamSize >= useMultithreadingBillNumber;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private MonitorObject getMonitorObject(BatchSelectionEntry entry) {
        MonitorObject result = new MonitorObject();
        result.setId(entry.getId());
        result.setName(entry.getNumber());
        result.setNumber(entry.getNumber());
        return result;
    }

    public boolean checkBillExistJob(String billId) throws EASBizException, BOSException {
        return this.iCreateJobfacade.checkDuplicateTask(billId);
    }

    public JobConfig createJobConfig(String bizAction, BatchSelectionEntries entries, int index) {
        JobConfig jobCfg = new JobConfig();
        String title = this.buildTitle(bizAction, entries, index);
        jobCfg.setTitle(title);
        jobCfg.setNumber(SCMBILL_ACTION_JOBNUMBER);
        StringBuffer taskType = new StringBuffer(SCMBILL_ACTION_JOBNUMBER);
        taskType.append("_");
        if (this.isUseMultithreading) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                taskType.append(entries.get(i).getId()).append(",");
            }
        } else {
            taskType.append(entries.get(index).getId()).append(",");
        }
        jobCfg.setTaskType(taskType.substring(0, Math.min(taskType.length() - 1, 100)));
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        return jobCfg;
    }

    private String buildTitle(String bizAction, BatchSelectionEntries entries, int index) {
        StringBuffer titleDetail = new StringBuffer();
        String titlePrefix = this.getBillTypeName(entries.get(0)) + "\uff1a\u3010";
        String titleSuffix = "\u3011" + bizAction;
        BatchSelectionEntry entry = entries.get(index);
        if (this.isUseMultithreading) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                titleDetail.append(entry.getNumber()).append(",");
            }
        } else {
            titleDetail.append(entry.getNumber()).append(",");
        }
        String titleDetailStr = titleDetail.substring(0, Math.min(200 - titlePrefix.length() - titleSuffix.length() - 8, titleDetail.length() - 1));
        titleDetail.setLength(0);
        titleDetail.append(titlePrefix);
        titleDetail.append(titleDetailStr);
        titleDetail.append(titleSuffix);
        return titleDetail.toString();
    }

    protected String getBillTypeName(BatchSelectionEntry entry) {
        String bosType = BOSUuid.read((String)entry.getId()).getType().toString();
        EntityObjectInfo entityInfo = SCMMDUtil.getEntityByBosType((String)bosType);
        return entityInfo.getAlias();
    }

    protected String getBOSType() {
        BatchSelectionEntries selectionEntry = this.getSelectionEntry();
        if (selectionEntry.size() > 0) {
            return BOSUuid.read((String)selectionEntry.get(0).getId()).getType().toString();
        }
        return "";
    }

    private JobParam createJobParam(BatchSelectionEntries entries, int index) {
        BatchSelectionEntries tempBatchEntries = new BatchSelectionEntries(this.getLevel());
        BatchSelectionEntry entry = entries.get(index);
        tempBatchEntries.add(entry);
        BatchExecuteParams batchParams = this.initBatchExecuteParams(this.iBizInterface, this.isUseMultithreading ? entries : tempBatchEntries);
        if (batchParams == null) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("BatchParams", batchParams);
        HashSet<String> orgUnitSet = new HashSet<String>();
        ArrayList<String> numberList = new ArrayList<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            orgUnitSet.add(entry.getOrgId());
            numberList.add(entry.getNumber());
        }
        params.put("OrgUnitIDSet", orgUnitSet);
        params.put("numberList", numberList);
        params.put("isUseMultithreading", Boolean.valueOf(this.isUseMultithreading));
        return new JobParam(params);
    }

    private class SubmitWorker
    implements Runnable {
        SCMJobMonitor monitor;

        SubmitWorker(SCMJobMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void run() {
            int i;
            String actionAilas = (String)JobActionProxy.this.getValue("ShortDescription");
            BatchSelectionEntry entry = null;
            BatchSelectionEntries selectEnties = JobActionProxy.this.getSelectionEntry();
            int size = selectEnties.size();
            for (i = 0; i < size; ++i) {
                entry = selectEnties.get(i);
                if (entry.getResult() == null || !entry.getResult().equals((Object)ActionResultEnum.ERROR)) continue;
                selectEnties.getEntries().remove(i);
                --i;
                --size;
            }
            if (this.monitor.isUseMultithreading()) {
                JobActionProxy.this.submitJob(actionAilas, selectEnties, this.monitor, 0);
            } else {
                size = selectEnties.size();
                for (i = 0; i < size; ++i) {
                    JobActionProxy.this.submitJob(actionAilas, selectEnties, this.monitor, i);
                }
            }
            this.monitor.setFinishedSubmit(true);
        }
    }
}

