/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.job.JobStateEnum;
import com.kingdee.eas.base.job.client.JobProcessInstanceListUI;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.basedata.common.perf.JobInstExtCollection;
import com.kingdee.eas.basedata.common.perf.JobInstExtInfo;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.client.ctrl.WinMsgManager;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.ISCMProgressDialog;
import com.kingdee.eas.scm.common.action.MonitorObject;
import com.kingdee.eas.scm.common.action.SCMJobStateInfo;
import com.kingdee.eas.scm.common.action.SCMProgressDialogFactory;
import com.kingdee.eas.scm.common.action.SCMThreadPool;
import com.kingdee.eas.scm.common.action.SingleJobProgressDialog;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMJobMonitor {
    private static final Logger logger = Logger.getLogger(SCMJobMonitor.class);
    private static final int refreshInterval = 2000;
    private static final String TAB = "\t";
    private static final String CR = "\n";
    private Map<String, SCMJobStateInfo> jobStateMap;
    private Map<String, MonitorObject> runningMap;
    private SwingWorker refreshThread;
    private SwingWorker dialogWorker;
    private String title;
    private volatile boolean isFinished;
    private volatile boolean isFinishedSubmit;
    private ISCMProgressDialog dialog;
    private ActionProxy action;
    private int totalCount;
    private String detailMessage = "";
    private boolean isUseMultithreading = false;

    public SCMJobMonitor(String title, Object ui) {
        this(title, ui, true);
    }

    public SCMJobMonitor(String title, Object ui, boolean isSingleWork) {
        this(title, null);
        this.dialog = SCMProgressDialogFactory.getProgressDialog(ui, title, isSingleWork, false);
    }

    public SCMJobMonitor(String title, ISCMProgressDialog dialog) {
        this(title, dialog, null);
    }

    public SCMJobMonitor(String title, ISCMProgressDialog dialog, ActionProxy action) {
        this.title = title;
        this.dialog = dialog;
        this.action = action;
        this.totalCount = 0;
        this.jobStateMap = Collections.synchronizedMap(new HashMap());
        this.runningMap = Collections.synchronizedMap(new HashMap());
        this.isFinished = false;
        this.isFinishedSubmit = false;
        this.refreshThread = this.getRefreshWorker();
        this.dialogWorker = this.getDialogWorker();
    }

    public void start() {
        this.dialogWorker.start();
        this.refreshThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorObject(String jobId, MonitorObject object) {
        Map<String, MonitorObject> map = this.runningMap;
        synchronized (map) {
            this.runningMap.put(jobId, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionMonitorObject(MonitorObject object, String exception) {
        SCMJobStateInfo info = new SCMJobStateInfo();
        info.setObjectId(object.getId());
        info.setObjectName(object.getName());
        info.setProgress(100);
        info.setJobState(JobStateEnum.FAILED);
        info.setException(exception);
        Map<String, SCMJobStateInfo> map = this.jobStateMap;
        synchronized (map) {
            this.jobStateMap.put(object.getId(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorObject(MonitorObject object, String exception) {
        SCMJobStateInfo info = new SCMJobStateInfo();
        info.setObjectId(object.getId());
        info.setObjectName(object.getName());
        info.setProgress(100);
        info.setJobState(JobStateEnum.COMPLETE);
        info.setException(null);
        Map<String, SCMJobStateInfo> map = this.jobStateMap;
        synchronized (map) {
            this.jobStateMap.put(object.getId(), info);
        }
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setFinishedSubmit(boolean isFinishedSubmit) {
        this.isFinishedSubmit = isFinishedSubmit;
    }

    protected void afterJobFinished() {
        SCMThreadPool.destroyMonitor(this);
        if (this.dialogWorker.isIsFinished()) {
            this.showMessageDialog();
        } else {
            int countSuccess = this.getSuccessCount();
            if (countSuccess == this.jobStateMap.size()) {
                ((KDDialog)this.dialog).dispose();
            } else if (this.jobStateMap.size() == 1 && this.dialog instanceof SingleJobProgressDialog) {
                Iterator<SCMJobStateInfo> it = this.jobStateMap.values().iterator();
                ((SingleJobProgressDialog)this.dialog).showErrorMessage(it.next().getException());
            }
            this.refreshUI(countSuccess);
        }
    }

    private void showMessageDialog() {
        String hint = this.title;
        int countSuccess = this.getSuccessCount();
        hint = countSuccess == 0 ? hint + SCMUtil.getActionResource("EXECUTEERROR") : (countSuccess < this.jobStateMap.size() ? hint + SCMUtil.getActionResource("EXECUTEPARTERROR") : hint + SCMUtil.getActionResource("EXECUTESUCCESS"));
        MonitorInfo info = new MonitorInfo(hint, null, this.getShowMessageWorker(), null, false);
        WinMsgManager.newWinMsg((String)EASResource.getString((String)"com.kingdee.eas.basedata.common.perf.PERFAutoGenerateResource", (String)"19_JobMonitorManager"), (String)hint, (MonitorInfo)info);
    }

    protected void afterDialogClosed() {
        this.refreshUI(this.getSuccessCount());
    }

    private void refreshUI(int countSuccess) {
        if (this.action != null && countSuccess > 0) {
            ActionProxy.ActionData data = new ActionProxy.ActionData();
            data.countSuccess = countSuccess;
            this.action.refresh(data);
        }
    }

    private int getSuccessCount() {
        int completeCount = 0;
        for (SCMJobStateInfo entry : this.jobStateMap.values()) {
            if (!JobStateEnum.COMPLETE.equals((Object)entry.getJobState())) continue;
            ++completeCount;
        }
        return completeCount;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isDialogClosed() {
        return this.dialogWorker.isIsFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshProgress() throws BOSException {
        if (this.runningMap.isEmpty()) {
            this.isFinished = true;
            this.updateDialog();
            return;
        }
        this.isFinished = false;
        int count = 0;
        int totalCount = this.runningMap.size();
        int batchCount = totalCount / 200 + 1;
        String[] ids = new String[totalCount];
        Map<String, MonitorObject> map = this.runningMap;
        synchronized (map) {
            Iterator<String> it = this.runningMap.keySet().iterator();
            while (it.hasNext() && count < totalCount) {
                ids[count++] = it.next();
            }
        }
        for (int i = 1; i <= batchCount; ++i) {
            int start = (i - 1) * 200;
            int end = Math.min(totalCount, i * 200) - 1;
            this.singleBatchRefresh(ids, start, end);
        }
    }

    private final void singleBatchRefresh(String[] ids, int start, int end) throws BOSException {
        int length = end - start + 1;
        String[] batchIds = new String[length];
        System.arraycopy(ids, start, batchIds, 0, length);
        JobInstExtCollection jobInstCol = JobInstStatusFacadeFactory.getRemoteInstance().queryJobInstStatus(batchIds);
        if (null == jobInstCol || jobInstCol.size() == 0) {
            return;
        }
        int size = jobInstCol.size();
        for (int i = 0; i < size; ++i) {
            JobInstExtInfo jobInfo = jobInstCol.get(i);
            String jobId = jobInfo.getId().toString();
            SCMJobStateInfo scmStateInfo = new SCMJobStateInfo();
            scmStateInfo.setJobId(jobId);
            scmStateInfo.setJobState(jobInfo.getState());
            scmStateInfo.setProgress(jobInfo.getProgress());
            scmStateInfo.setProgressDetail(jobInfo.getProgressDetail());
            MonitorObject object = this.runningMap.get(jobId);
            if (object != null) {
                scmStateInfo.setObjectId(object.getId());
                scmStateInfo.setObjectName(object.getName());
            }
            if (JobStateEnum.FAILED.equals((Object)jobInfo.getState())) {
                scmStateInfo.setException(this.getErrorMessage(jobInfo.getJobInstId()));
            }
            if (JobStateEnum.COMPLETE.equals((Object)jobInfo.getState()) || JobStateEnum.FAILED.equals((Object)jobInfo.getState()) || JobStateEnum.ABORTED.equals((Object)jobInfo.getState())) {
                this.runningMap.remove(jobId);
            }
            this.jobStateMap.put(jobId, scmStateInfo);
        }
        this.updateDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDialog() {
        if (this.dialog == null) {
            return;
        }
        int progress = 0;
        Map<String, SCMJobStateInfo> map = this.jobStateMap;
        synchronized (map) {
            Iterator<SCMJobStateInfo> it = this.jobStateMap.values().iterator();
            if (this.jobStateMap.size() == 1) {
                SCMJobStateInfo entry = it.next();
                progress = entry.getProgress();
                this.detailMessage = entry.getProgressDetail();
                if (JobStateEnum.COMPLETE.equals((Object)entry.getJobState()) || JobStateEnum.FAILED.equals((Object)entry.getJobState()) || JobStateEnum.ABORTED.equals((Object)entry.getJobState())) {
                    this.detailMessage = !this.isUseMultithreading ? entry.getJobState().getAlias() : SCMUtil.getActionResource("USE_MULTITHREAD_TO_JOB");
                }
            } else {
                StringBuffer detail = new StringBuffer();
                detail.append(SCMUtil.getActionResource("BILLNUMBER")).append(TAB).append(SCMUtil.getActionResource("EXECUTE_STATUS")).append(CR);
                if (!this.isUseMultithreading) {
                    while (it.hasNext()) {
                        SCMJobStateInfo entry = it.next();
                        detail.append(entry.getObjectName()).append(TAB);
                        progress += entry.getProgress();
                        if (JobStateEnum.COMPLETE.equals((Object)entry.getJobState())) {
                            detail.append(entry.getJobState().getAlias()).append(CR);
                            continue;
                        }
                        if (JobStateEnum.FAILED.equals((Object)entry.getJobState())) {
                            detail.append(entry.getJobState().getAlias()).append(" \uff1a").append(entry.getException()).append(CR);
                            continue;
                        }
                        if (JobStateEnum.ABORTED.equals((Object)entry.getJobState())) {
                            detail.append(entry.getJobState().getAlias()).append(CR);
                            continue;
                        }
                        detail.append(entry.getProgress()).append("%  ").append(entry.getProgressDetail()).append(CR);
                    }
                } else {
                    detail.append(SCMUtil.getActionResource("USE_MULTITHREAD_TO_JOB"));
                }
                progress /= this.totalCount == 0 ? this.jobStateMap.size() : this.totalCount;
                this.detailMessage = detail.toString();
            }
        }
        this.dialog.updateProgress(progress, this.detailMessage);
    }

    private String getErrorMessage(String jobInstId) {
        String result = "";
        if (jobInstId == null || jobInstId.length() == 0) {
            return SCMUtil.getActionResource("CANNOTGETEXCEPTION");
        }
        try {
            String msg = JobUtils.getJobServiceFacade().getJobException(jobInstId);
            int start = msg.indexOf(":");
            int end = msg.indexOf("Stack trace");
            result = msg.substring(start + 1, end - 1);
        }
        catch (BOSException e) {
            result = SCMUtil.getActionResource("GETEXCEPTIONERROR");
        }
        return result;
    }

    private SwingWorker getRefreshWorker() {
        SwingWorker refreshWorker = new SwingWorker(){

            public Object construct() {
                while (!SCMJobMonitor.this.isFinished || !SCMJobMonitor.this.isFinishedSubmit) {
                    try {
                        Thread.sleep(2000L);
                        SCMJobMonitor.this.refreshProgress();
                    }
                    catch (BOSException e) {
                        logger.error((Object)("update progress error\uff1a " + e.getMessage()));
                        if (SCMJobMonitor.this.dialog != null) {
                            SCMJobMonitor.this.dialog.updateProgress(100, SCMUtil.getActionResource("GETPROGRESSERROR"));
                        }
                        SCMJobMonitor.this.isFinished = true;
                        SCMJobMonitor.this.isFinishedSubmit = true;
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)("RefreshStatusWorker InterruptedException: " + e.getMessage()));
                    }
                }
                return null;
            }

            public void finished() {
                SCMJobMonitor.this.dialog.updateProgress(100, SCMJobMonitor.this.detailMessage);
                SCMJobMonitor.this.afterJobFinished();
            }
        };
        return refreshWorker;
    }

    private SwingWorker getDialogWorker() {
        SwingWorker dialogWorker = new SwingWorker(){

            public Object construct() {
                if (SCMJobMonitor.this.dialog == null) {
                    throw new NullPointerException("progressDialog is not initial!");
                }
                ((KDDialog)SCMJobMonitor.this.dialog).show();
                return null;
            }

            public void finished() {
                SCMJobMonitor.this.afterDialogClosed();
            }
        };
        return dialogWorker;
    }

    private SwingWorker getShowMessageWorker() {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return null;
            }

            public void finishedLater() {
                IUIObject[] arrayUI = UIFrameUtil.findUIObject((String)JobProcessInstanceListUI.class.getName());
                if (arrayUI != null && arrayUI.length > 0) {
                    JobProcessInstanceListUI jobListUI = (JobProcessInstanceListUI)arrayUI[0];
                    try {
                        jobListUI.refreshList();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    jobListUI.getUIWindow().show();
                } else {
                    UIContext uiContext = new UIContext((Object)this);
                    try {
                        IUIWindow listUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(JobProcessInstanceListUI.class.getName(), (Map)uiContext);
                        listUI.show();
                    }
                    catch (UIException uIException) {
                        // empty catch block
                    }
                }
            }
        };
        return worker;
    }

    public boolean isUseMultithreading() {
        return this.isUseMultithreading;
    }

    public void setUseMultithreading(boolean useMultithreading) {
        this.isUseMultithreading = useMultithreading;
    }
}

