/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.metadata.bot.exception.NotSupportedException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.scm.common.action.MultiJobProgressDialog;
import com.kingdee.eas.scm.common.action.SCMProgressDialog;
import com.kingdee.eas.scm.common.action.SingleJobProgressDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class SCMProgressDialogFactory {
    public static SCMProgressDialog getProgressDialog(Object ui, String title, boolean isSingle, boolean isShowProgress) {
        SCMProgressDialog dialog = null;
        if (ui == null) {
            dialog = SCMProgressDialogFactory.createProgressDialog((Frame)null, isSingle);
        } else if (ui != null && ui instanceof CoreUIObject) {
            CoreUIObject curUIObject = (CoreUIObject)ui;
            Window win = SwingUtilities.getWindowAncestor((Component)curUIObject);
            if (win instanceof Frame) {
                dialog = SCMProgressDialogFactory.createProgressDialog((Frame)win, isSingle);
            } else if (win instanceof Dialog) {
                dialog = SCMProgressDialogFactory.createProgressDialog((Dialog)win, isSingle);
            }
            if (dialog == null) {
                dialog = SCMProgressDialogFactory.createProgressDialog((Frame)null, isSingle);
            }
        } else if (ui != null && ui instanceof Frame) {
            dialog = SCMProgressDialogFactory.createProgressDialog((Frame)ui, isSingle);
        } else {
            throw new NotSupportedException("Not support ui type, please check!");
        }
        dialog.setTitle(title);
        dialog.setIsShowProgress(isShowProgress);
        return dialog;
    }

    private static SCMProgressDialog createProgressDialog(Frame owner, boolean isSingle) {
        if (isSingle) {
            return new SingleJobProgressDialog(owner);
        }
        return new MultiJobProgressDialog(owner);
    }

    private static SCMProgressDialog createProgressDialog(Dialog owner, boolean isSingle) {
        if (isSingle) {
            return new SingleJobProgressDialog(owner);
        }
        return new MultiJobProgressDialog(owner);
    }
}

