/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.scm.common.action.AbstractTableSelectionHelper;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class TableSelectionHelper
extends AbstractTableSelectionHelper {
    static Logger logger = Logger.getLogger(TableSelectionHelper.class);
    private String idColName;
    private String orgIdColName;
    private String numberColName;
    private IMetaDataPK mainQueryPK;
    private CoreBillListUI uiObj;

    public void setTableProperty(CoreBillListUI uiObj, IMetaDataPK mainQueryPK, KDTable table, String idColName, String entryIdColName, String numberColName, String entrySeqColName, String orgIdColName) {
        this.uiObj = uiObj;
        this.mainQueryPK = mainQueryPK;
        this.tblMain = table;
        this.idColName = idColName;
        this.entryIdColName = entryIdColName;
        this.numberColName = numberColName;
        this.entrySeqColName = entrySeqColName;
        this.orgIdColName = orgIdColName;
    }

    @Override
    protected BatchSelectionEntry getSelectionEntry(IRow row, ActionLevelEnum actionLevel) throws BOSException {
        BatchSelectionEntry entry = new BatchSelectionEntry();
        entry.setId((String)this.getCellValue(row.getCell(this.idColName)));
        entry.setNumber((String)this.getCellValue(row.getCell(this.numberColName)));
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            String entryId = (String)this.getCellValue(row.getCell(this.entryIdColName));
            if (entryId == null) {
                return null;
            }
            entry.setEntryId(entryId);
            entry.setSeq(((Integer)this.getCellValue(row.getCell(this.entrySeqColName))).intValue());
        }
        entry.setRowNum(row.getRowIndex());
        entry.setOrgId((String)this.getCellValue(row.getCell(this.orgIdColName)));
        return entry;
    }

    @Override
    protected BatchSelectionEntries getSelectedAllIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        EntityViewInfo viewInfo = (EntityViewInfo)this.uiObj.getMainQuery().clone();
        return this.getDataFromDB(mainOrgContext, actionLevel, selectRows, viewInfo);
    }

    private void setDefaultSort(EntityViewInfo view, ActionLevelEnum actionLevel) {
        String seqPropName = this.uiObj.getEntriesName() + ".seq";
        if (view.getSorter() != null && view.getSorter().size() > 0) {
            SorterItemCollection sorters = view.getSorter();
            boolean hasNumberSorter = false;
            boolean hasSeqSorter = false;
            int size = sorters.size();
            for (int i = 0; i < size; ++i) {
                if (sorters.get(i).getPropertyName().equals("number")) {
                    hasNumberSorter = true;
                    continue;
                }
                if (!sorters.get(i).getPropertyName().equals(seqPropName)) continue;
                hasSeqSorter = true;
            }
            if (!hasNumberSorter) {
                SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
                aSorterItemInfo.setSortType(SortType.DESCEND);
                view.getSorter().add(aSorterItemInfo);
            }
            if (actionLevel.equals((Object)ActionLevelEnum.ENTRY) && !hasSeqSorter) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo(seqPropName);
                bSorterItemInfo.setSortType(SortType.ASCEND);
                view.getSorter().add(bSorterItemInfo);
            }
        } else {
            SorterItemInfo aSorterItemInfo = new SorterItemInfo("number");
            aSorterItemInfo.setSortType(SortType.DESCEND);
            view.getSorter().add(aSorterItemInfo);
            if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
                SorterItemInfo bSorterItemInfo = new SorterItemInfo(seqPropName);
                bSorterItemInfo.setSortType(SortType.ASCEND);
                view.getSorter().add(bSorterItemInfo);
            }
        }
    }

    public TableSelectionHelper(CoreBillListUI uiObj) {
        this.uiObj = uiObj;
    }

    @Override
    public void refresh(BatchActionEnum bizAction, BatchSelectionEntries selectionEntries, int countSuccess) throws Exception {
        if (countSuccess == 0) {
            return;
        }
        int curIndex = 0;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            curIndex = selectBlock.getTop();
        }
        this.uiObj.refreshList();
        this.tblMain.getSelectManager().select(curIndex, 0);
        this.tblMain.getLayoutManager().scrollRowToShow(curIndex);
    }

    protected void selectFirstRow() {
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    public IObjectPK getOrgPK(ItemAction action) {
        if (this.tblMain == null) {
            return null;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object keyValue;
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.orgIdColName);
            if (cell == null) {
                MsgBox.showError((String)"TableSelectionHelper: the main orgunit column name is not right.");
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return new ObjectStringPK(keyValue.toString());
            }
        }
        return null;
    }

    protected IObjectPK getEntryId() {
        ObjectUuidPK entryId = null;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            IRow row = this.tblMain.getRow(selectRows[0]);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell(this.entryIdColName);
            Object keyValue = cell.getValue();
            if (keyValue != null) {
                entryId = new ObjectUuidPK(keyValue.toString());
            }
        }
        return entryId;
    }

    public String getOrgIdColName() {
        return this.orgIdColName;
    }

    public KDTable getTblMain() {
        return this.tblMain;
    }

    @Override
    protected BatchSelectionEntries getSelectedMultiIDs(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, selectRows.length);
        HashSet<Object> keySet = new HashSet<Object>();
        for (int i = 0; i < selectRows.length; ++i) {
            BatchSelectionEntry entry;
            IRow row = this.tblMain.getRow(selectRows[i]);
            if (actionLevel.equals((Object)ActionLevelEnum.HEAD)) {
                Object id = this.getCellValue(row.getCell(this.idColName));
                if (keySet.contains(id)) continue;
                keySet.add(id);
            }
            if ((entry = this.getSelectionEntry(row, actionLevel)) == null) continue;
            results.add(entry);
        }
        return results;
    }

    private BatchSelectionEntries getDataFromDB(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows, EntityViewInfo viewInfo) throws BOSException {
        this.setDefaultSort(viewInfo, actionLevel);
        boolean isHead = actionLevel.equals((Object)ActionLevelEnum.HEAD);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo(this.idColName));
        selectors.add(new SelectorItemInfo(this.numberColName));
        if (actionLevel.equals((Object)ActionLevelEnum.ENTRY)) {
            selectors.add(new SelectorItemInfo(this.entryIdColName));
            selectors.add(new SelectorItemInfo(this.entrySeqColName));
        }
        selectors.add(new SelectorItemInfo(this.orgIdColName));
        viewInfo.setSelector(selectors);
        viewInfo.setAppendSelectors(false);
        IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)this.mainQueryPK, (Context)mainOrgContext);
        queryExecutor.setObjectView(viewInfo);
        queryExecutor.option().isAutoIgnoreDuplicatedRow = isHead;
        queryExecutor.option().isIgnorePermissionCheck = false;
        IRowSet rs = queryExecutor.executeQuery();
        HashSet<String> keySet = new HashSet<String>();
        if (rs != null && rs.size() > 0) {
            try {
                int size = rs.size();
                BatchSelectionEntries results = new BatchSelectionEntries(actionLevel, size);
                while (rs.next()) {
                    String id = rs.getString(1);
                    if (isHead) {
                        if (keySet.contains(id)) continue;
                        keySet.add(id);
                        results.add(new BatchSelectionEntry(id, rs.getString(2), rs.getString(3)));
                        continue;
                    }
                    results.add(new BatchSelectionEntry(id, rs.getString(3), rs.getString(2), rs.getInt(4), rs.getString(5)));
                }
                return results;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("getSelectedAllIDs(): The results of fetchDatasByFields not match Id and OrgId.");
            }
        }
        return null;
    }

    @Override
    protected BatchSelectionEntries getSelectedMultiIDs4SwitchView(Context mainOrgContext, ActionLevelEnum actionLevel, int[] selectRows) throws BOSException {
        HashSet<String> keySet = new HashSet<String>();
        IRow row = null;
        int len = selectRows.length;
        for (int i = 0; i < len; ++i) {
            row = this.tblMain.getRow(selectRows[i]);
            Object id = this.getCellValue(row.getCell(this.idColName));
            if (id == null || StringUtil.isEmpty((String)id.toString())) continue;
            keySet.add(id.toString());
        }
        EntityViewInfo viewInfo = (EntityViewInfo)this.uiObj.getMainQuery().clone();
        FilterInfo filterInfo = viewInfo.getFilter();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", keySet, CompareType.INCLUDE));
        String maskString = filterInfo.getMaskString();
        if (!StringUtil.isEmpty((String)maskString)) {
            StringBuilder newMaskString = new StringBuilder();
            int size = filterInfo.getFilterItems().size();
            newMaskString.append("(").append(maskString).append(") and #").append(size - 1);
            filterInfo.setMaskString(newMaskString.toString());
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.setRemoveEntry(false);
        return this.getDataFromDB(mainOrgContext, actionLevel, selectRows, viewInfo);
    }

    @Override
    public int getSelectedEntrySize(Context mainOrgContext, ActionLevelEnum actionLevel) throws BOSException {
        int size = 0;
        if (ActionLevelEnum.ENTRY.equals((Object)actionLevel)) {
            int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            size = selectRows.length;
        } else {
            size = this.getEntrySizeFromDB(mainOrgContext);
        }
        return size;
    }

    protected int getEntrySizeFromDB(Context mainOrgContext) throws BOSException {
        BatchSelectionEntries entries = this.getSelectedIDs(mainOrgContext, ActionLevelEnum.HEAD);
        HashSet<String> idSet = new HashSet<String>(entries.size());
        for (int i = 0; i < entries.size(); ++i) {
            idSet.add(entries.get(i).getId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("id");
        BOSObjectType type = null;
        IObjectPK entryId = this.getEntryId();
        if (entryId == null) {
            return 0;
        }
        type = ((ObjectUuidPK)entryId).getObjectType();
        IObjectCollection coll = DynamicObjectFactory.getRemoteInstance().getCollection(type, view);
        return coll.size();
    }
}

