/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.calculate.AbstractAlgorithm;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;

public class SaleOrderAlgorithm
extends AbstractAlgorithm {
    private SaleOrderInfo info;
    private Context ctx;

    public SaleOrderAlgorithm(SaleOrderInfo info, Context ctx) throws BOSException, EASBizException {
        this.info = info;
        this.ctx = ctx;
        this.initPrecision();
    }

    @Override
    protected void initPrecision() throws BOSException, EASBizException {
        SaleOrgUnitInfo saleOrg = null;
        saleOrg = this.info.getSaleOrgUnit();
        if (saleOrg == null) {
            saleOrg = (SaleOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.ctx, (OrgType)OrgType.Sale);
        }
        CompanyOrgUnitInfo companyOrg = null;
        companyOrg = null;
        if (saleOrg != null) {
            companyOrg = this.getCompany(this.ctx, saleOrg);
        } else if (this.info.getEntries().get(0).getCompanyOrgUnit() != null) {
            companyOrg = this.info.getEntries().get(0).getCompanyOrgUnit();
        }
        if (companyOrg == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{SaleUtil.getUIResource((String)"ORDER_FIELD_COMPANYORGUNIT")});
        }
        String oql = "SELECT *, baseCurrency.precision WHERE id ='" + companyOrg.getId().toString() + "'";
        companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo(oql);
        this.setLocalAmountPrecision(companyOrg.getBaseCurrency().getPrecision());
        if (this.info.getCurrency() != null) {
            CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)this.ctx).getValue("SELECT id, precision WHERE id = '" + this.info.getCurrency().getId().toString() + "'");
            this.info.setCurrency(currency);
            this.setAmountPrecision(this.info.getCurrency().getPrecision());
        }
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, SaleOrgUnitInfo saleOrgUnit) throws BOSException, EASBizException {
        if (saleOrgUnit == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(saleOrgUnit.getId().toString(), 2, 1);
        if (companyOrg == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(saleOrgUnit.getId().toString(), 2, 1);
            companyOrg = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (companyOrg != null) {
            String oql = "SELECT *, baseCurrency.precision WHERE id ='" + companyOrg.getId().toString() + "'";
            companyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        }
        return companyOrg;
    }

    @Override
    public BigDecimal getAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getAmount());
    }

    @Override
    public MeasureUnitInfo getAssistUnit(int i) {
        return this.info.getEntries().get(i).getAssistUnit();
    }

    @Override
    public BigDecimal getBaseQty(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getBaseQty());
    }

    @Override
    public ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    public BigDecimal getDiscountAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getDiscountAmount());
    }

    @Override
    public BigDecimal getExchangeRate() {
        return this.nullToZero(this.info.getExchangeRate());
    }

    @Override
    public MaterialInfo getMaterial(int i) {
        return this.info.getEntries().get(i).getMaterial();
    }

    @Override
    public BigDecimal getPrice(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getPrice());
    }

    @Override
    public int getPricePrecision(int i) {
        return this.info.getEntries().get(i).getMaterial().getPricePrecision();
    }

    @Override
    public BigDecimal getQty(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getQty());
    }

    @Override
    public BigDecimal getTax(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTax());
    }

    @Override
    public BigDecimal getTaxAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxAmount());
    }

    @Override
    public BigDecimal getTaxPrice(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxPrice());
    }

    @Override
    public BigDecimal getTaxRate(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxRate());
    }

    @Override
    public MeasureUnitInfo getUnit(int i) {
        return this.info.getEntries().get(i).getUnit();
    }

    @Override
    public boolean isInTax() {
        return this.info.isIsInTax();
    }

    @Override
    public void setActualPrice(BigDecimal price, int i) {
        this.info.getEntries().get(i).setActualPrice(price);
    }

    @Override
    public void setActualTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntries().get(i).setActualTaxPrice(taxPrice);
    }

    @Override
    public void setAmount(BigDecimal bigzero, int i) {
        this.info.getEntries().get(i).setAmount(bigzero);
    }

    @Override
    public void setAssistQty(BigDecimal assistQty, int i) {
        this.info.getEntries().get(i).setAssistQty(assistQty);
    }

    @Override
    public void setBaseQty(BigDecimal baseQty, int i) {
        this.info.getEntries().get(i).setBaseQty(baseQty);
    }

    @Override
    public void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.info.getEntries().get(i).setDiscountAmount(discountAmount);
    }

    @Override
    public void setLocalAmount(BigDecimal localAmount, int i) {
        this.info.getEntries().get(i).setLocalAmount(localAmount);
    }

    @Override
    public void setLocalTax(BigDecimal setScale, int i) {
        this.info.getEntries().get(i).setLocalTax(setScale);
    }

    @Override
    public void setLocalTaxAmount(BigDecimal setScale, int i) {
        this.info.getEntries().get(i).setLocalTaxAmount(setScale);
    }

    @Override
    public void setPrice(BigDecimal price, int i) {
        this.info.getEntries().get(i).setPrice(price);
    }

    @Override
    public void setTax(BigDecimal tax, int i) {
        this.info.getEntries().get(i).setTax(tax);
    }

    @Override
    public void setTaxAmount(BigDecimal taxAmount, int i) {
        this.info.getEntries().get(i).setTaxAmount(taxAmount);
    }

    @Override
    public void setTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntries().get(i).setTaxPrice(taxPrice);
    }

    @Override
    public void setTotalAmount(BigDecimal totalAmount) {
        this.info.setTotalAmount(totalAmount);
    }

    @Override
    public void setTotalTax(BigDecimal totalTax) {
        this.info.setTotalTax(totalTax);
    }

    @Override
    public void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setTotalTaxAmount(totalTaxAmount);
    }

    @Override
    public int getEntrySize() {
        return this.info.getEntries().size();
    }

    @Override
    public BigDecimal getLocalAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalAmount());
    }

    public BigDecimal getLocalTax(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalTax());
    }

    @Override
    public BigDecimal getLocalTaxAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalTaxAmount());
    }

    @Override
    public BigDecimal getDiscountRate(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getDiscount());
    }

    @Override
    public void setTotalLocalAmount(BigDecimal totalAmount) {
        this.info.setLocalTotalAmount(totalAmount);
    }

    @Override
    public void setTotalLocalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setLocalTotalTaxAmount(totalTaxAmount);
    }

    @Override
    public boolean isPriceInTax() {
        return this.info.isIsInTax();
    }
}

