/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.client.AbstractBTPRelationNavUI;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.scm.cal.WriteOffCreateTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupCollection;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.common.CCRelationBillFacadeFactory;
import com.kingdee.eas.scm.common.ICCRelationBillFacade;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CCRelationNavUI
extends AbstractBTPRelationNavUI {
    private String billInfoID = null;
    private Vector BOSTypeVector = new Vector();
    private ListUI curentBillListUI = null;
    private static final String RESXFILENAME = "com.kingdee.eas.base.btp.btpResource";

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.KDBtNext.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.KDBtPrev.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
    }

    private void runActionView(ListUI billListUI) throws Exception {
        ActionEvent e = new ActionEvent(this.btnView, 0, "View");
        billListUI.actionView_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initTP() throws Exception {
        Map btpNavCtx;
        int step;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        int entriesNum = 0;
        IObjectCollection selectedEntries = (IObjectCollection)this.getUIContext().get("selectedEntries");
        if (selectedEntries != null) {
            entriesNum = selectedEntries.size();
        }
        if (this.getUIContext().get("findType").equals(new Integer(0))) {
            filter.getFilterItems().add(new FilterItemInfo("fbillid", (Object)this.billInfoID, CompareType.EQUALS));
            markString.append("#0 ");
            step = 2;
            if (this.getUIContext().get("BTPNAVCTX") != null && (btpNavCtx = (Map)this.getUIContext().get("BTPNAVCTX")).get("NAVBOSTYPE") != null) {
                String srcBosType = btpNavCtx.get("NAVBOSTYPE").toString();
                filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType));
                markString.append(" and #1");
                ++step;
            }
            if (entriesNum > 0) {
                markString.append(" and (");
                filter.getFilterItems().add(new FilterItemInfo("relationEntries.destEntryID", null));
                markString.append("#" + step + " or ");
                filter.getFilterItems().add(new FilterItemInfo("relationEntries.destEntryID", (Object)this.billInfoID, CompareType.EQUALS));
                markString.append("#" + ++step + " or ");
                ++step;
                for (int i = 0; i < entriesNum; ++i) {
                    filter.getFilterItems().add(new FilterItemInfo("relationEntries.destEntryID", (Object)((CoreBillEntryBaseInfo)selectedEntries.getObject(i)).getId().toString(), CompareType.EQUALS));
                    if (i == entriesNum - 1) {
                        markString.append("#" + (i + step) + " ");
                        markString.append(")");
                        continue;
                    }
                    markString.append("#" + (i + step) + " or  ");
                }
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fbillid", (Object)this.billInfoID, CompareType.EQUALS));
            markString.append("#0 ");
            step = 2;
            if (this.getUIContext().get("BTPNAVCTX") != null && (btpNavCtx = (Map)this.getUIContext().get("BTPNAVCTX")).get("NAVBOSTYPE") != null) {
                String destBosType = btpNavCtx.get("NAVBOSTYPE").toString();
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBosType));
                markString.append(" and #").append(step);
                ++step;
            }
        }
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        Vector<String> srcBillIDs = new Vector<String>();
        ICCRelationBillFacade iccr = CCRelationBillFacadeFactory.getRemoteInstance();
        IRowSet rs = iccr.getRelationBill(viewInfo);
        if (rs != null) {
            while (rs.next()) {
                srcBillIDs.add(rs.getString("fbillid"));
            }
        }
        if (srcBillIDs.size() < 1) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        HashMap billTypes = this.getRelatedBillType(srcBillIDs);
        this.refreshTP2(billTypes, (Map)this.getUIContext().get("BTPNAVCTX"));
    }

    private void initUI() throws Exception {
        this.initTP();
    }

    public void onLoad() throws Exception {
        this.tpRelatedBills.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDTabbedPane tabpane = (KDTabbedPane)e.getSource();
                if (tabpane.getSelectedComponent() instanceof ListUI) {
                    CCRelationNavUI.this.curentBillListUI = (ListUI)tabpane.getSelectedComponent();
                } else {
                    CCRelationNavUI.this.curentBillListUI = null;
                }
            }
        });
        this.actionAttachment.setEnabled(false);
        this.actionAttachment.setVisible(false);
        this.billInfoID = (String)this.getUIContext().get("billInfoID");
        this.initUI();
        this.actionViewPrev.setEnabled(false);
        this.actionViewNext.setEnabled(false);
    }

    protected void KDBtPrev_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectedBillID();
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)this.billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        Vector<String> srcBillIDs = new Vector<String>();
        if (relations == null || relations.size() == 0) {
            throw new BTPException(BTPException.SRCBILLTYPENULL);
        }
        for (int i = 0; i < relations.size(); ++i) {
            srcBillIDs.add(relations.get(i).getSrcObjectID());
        }
        HashMap billTypes = this.getRelatedBillType(srcBillIDs);
        this.refreshTP(billTypes, (Map)this.getUIContext().get("BTPNAVCTX"));
    }

    private String getTableColumnFieldNameByPropName(String propName, String BOSType) throws Exception {
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        String billClassName = iBTPManager.getClassNameByBOSType(BOSType);
        String[] billClassNameArray = StringUtils.split((String)billClassName, (String)".");
        billClassName = billClassNameArray[billClassNameArray.length - 1];
        if (StringUtils.split((String)propName, (String)".").length == 1) {
            boolean isOwner = iBTPManager.isPropOwner(BOSType, propName);
            propName = !isOwner ? propName + ".id" : billClassName + "." + propName;
        }
        String tableColumnName = iBTPManager.getTableColumnFieldNameByPropName(BOSType, propName);
        return tableColumnName;
    }

    private void initQueryInfoFilter(ListUI billListUI, Vector billInfos) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        maskString.append("(");
        for (int i = 0; i < billInfos.size(); ++i) {
            if (i != 0) {
                maskString.append(" or ");
            }
            maskString.append("#" + i);
            String BOSType = BOSUuid.read((String)billInfos.get(i).toString()).getType().toString();
            filter.getFilterItems().add(new FilterItemInfo(this.getTableColumnFieldNameByPropName("id", BOSType), (Object)((String)billInfos.get(i)), CompareType.EQUALS));
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filter);
        billListUI.setDataObject((IObjectValue)entityViewInfo);
        billListUI.getMainTable().getStyleAttributes().setLocked(true);
    }

    private void refreshTP2(HashMap hashMap, Map uiContext) throws Exception {
        int compnentNum;
        for (int i = compnentNum = this.tpRelatedBills.getTabCount(); i > 0; --i) {
            Component obj = this.tpRelatedBills.getComponentAt(i - 1);
            if (obj != null && obj instanceof ListUI) {
                ((ListUI)obj).destroyWindow();
            }
            this.tpRelatedBills.remove(i - 1);
        }
        this.BOSTypeVector = new Vector();
        int tabNumbers = 0;
        Map map = CCRelationBillFacadeFactory.getRemoteInstance().processRelationBill(hashMap);
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            WriteOffGroupCollection writeOffGroupCollection;
            Object viewInfo;
            if (!entry.getKey().toString().startsWith("B84FB1E2") || !((viewInfo = entry.getValue()) instanceof EntityViewInfo) || (writeOffGroupCollection = WriteOffGroupFactory.getRemoteInstance().getWriteOffGroupCollection((EntityViewInfo)viewInfo)) == null || writeOffGroupCollection.size() <= 0) continue;
            boolean hasAuthoried = true;
            for (int i = 0; i < writeOffGroupCollection.size(); ++i) {
                WriteOffCreateTypeEnum createType = writeOffGroupCollection.get(i).getCreateType();
                if (createType == WriteOffCreateTypeEnum.AUTO_WRITEOFF || createType == WriteOffCreateTypeEnum.MANUAL_WRITEOFF) {
                    hasAuthoried = SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(writeOffGroupCollection.get(i).getCompanyOrgUnit().getId().toString()), "StockWriteOffReportView");
                } else if (createType == WriteOffCreateTypeEnum.DEV_AUTO_WRITEOFF || createType == WriteOffCreateTypeEnum.DEV_MANUAL_WRITEOFF_A || createType == WriteOffCreateTypeEnum.DEV_MANUAL_WRITEOFF_B || createType == WriteOffCreateTypeEnum.DEV_MANUAL_WRITEOFF_C || createType == WriteOffCreateTypeEnum.DEV_MANUAL_WRITEOFF_D || createType == WriteOffCreateTypeEnum.DEV_MANUAL_WRITEOFF_E) {
                    hasAuthoried = SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(writeOffGroupCollection.get(i).getCompanyOrgUnit().getId().toString()), "DevolveWriteOffReportView");
                } else if (createType == WriteOffCreateTypeEnum.SAL_AUTO_WRITEOFF || createType == WriteOffCreateTypeEnum.SAL_MANUAL_WRITEOFF) {
                    hasAuthoried = SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(writeOffGroupCollection.get(i).getCompanyOrgUnit().getId().toString()), "SaleWriteOffReportView");
                } else if (createType == WriteOffCreateTypeEnum.INCOME_AUTO_WRITEOFF || createType == WriteOffCreateTypeEnum.INCOME_MANUAL_WRITEOFF) {
                    hasAuthoried = SCMGroupClientUtils.isAuthoriedForOrg((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), (IObjectPK)new ObjectStringPK(writeOffGroupCollection.get(i).getCompanyOrgUnit().getId().toString()), "IncomeWriteOffReportView");
                }
                if (hasAuthoried) continue;
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)"NO_WRITEOFF_VIEW_PERMISSION"));
                SysUtil.abort();
            }
        }
        for (String str : map.keySet()) {
            StringTokenizer st = new StringTokenizer(str, "#");
            String[] temp = new String[3];
            int i = 0;
            while (st.hasMoreTokens()) {
                temp[i++] = st.nextToken();
            }
            String key = temp[0];
            String displayString = temp[1];
            String listUIName = temp[2];
            if (listUIName != null && listUIName.trim().length() > 0) {
                HashMap uiCtx = new HashMap();
                uiCtx.put("OwnerWindow", this.getUIContext().get("OwnerWindow"));
                uiCtx.put("BOTPViewStatus", new Integer(1));
                EntityViewInfo botpFilter = (EntityViewInfo)map.get(str);
                uiCtx.put("BOTPFilter", botpFilter);
                uiCtx.put("BTPNAVCTX", uiContext);
                if (this.getUIContext().get("BTPNAVCTX") != null) {
                    Map btpNavCtx = (Map)this.getUIContext().get("BTPNAVCTX");
                    uiCtx.put("BTPNAVCTX", btpNavCtx);
                }
                ListUI billListUI = (ListUI)UIFactoryHelper.initUIObject((String)listUIName, uiCtx, null, (String)"FINDVIEW");
                int width = 790;
                int height = 580;
                billListUI.getUIContentPane().setSize(new Dimension(width, height));
                KDTable kdTable = billListUI.getMainTable();
                kdTable.setBounds(new Rectangle(10, 10, width - 10, height - 10));
                this.tpRelatedBills.addTab(displayString, (Component)billListUI);
                this.BOSTypeVector.add(key);
                if (++tabNumbers == 0) {
                    MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"canNotNav"));
                    SysUtil.abort();
                }
            }
            if (!(this.tpRelatedBills.getSelectedComponent() instanceof ListUI)) continue;
            this.curentBillListUI = (ListUI)this.tpRelatedBills.getSelectedComponent();
        }
    }

    private void refreshTP(HashMap hashMap, Map uiContext) throws Exception {
        int compnentNum;
        for (int i = compnentNum = this.tpRelatedBills.getTabCount(); i > 0; --i) {
            Component obj = this.tpRelatedBills.getComponentAt(i - 1);
            if (obj != null && obj instanceof ListUI) {
                ((ListUI)obj).destroyWindow();
            }
            this.tpRelatedBills.remove(i - 1);
        }
        this.BOSTypeVector = new Vector();
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        Iterator itr = hashMap.keySet().iterator();
        int tabNumbers = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            String displayString = iBTPManager.getEntityObjectInfoDisplayName(key);
            String listUIName = iBTPManager.getEntityObjectInfoExtendPro(key, "listUI");
            if (listUIName != null && listUIName.trim().length() > 0) {
                HashMap uiCtx = new HashMap();
                uiCtx.put("OwnerWindow", this.getUIContext().get("OwnerWindow"));
                uiCtx.put("BOTPViewStatus", new Integer(1));
                EntityViewInfo botpFilter = this.initIdFilter((Vector)hashMap.get(key));
                uiCtx.put("BOTPFilter", botpFilter);
                uiCtx.put("BTPNAVCTX", uiContext);
                if (this.getUIContext().get("BTPNAVCTX") != null) {
                    Map btpNavCtx = (Map)this.getUIContext().get("BTPNAVCTX");
                    uiCtx.put("BTPNAVCTX", btpNavCtx);
                }
                ListUI billListUI = (ListUI)UIFactoryHelper.initUIObject((String)listUIName, uiCtx, null, (String)"FINDVIEW");
                int width = 790;
                int height = 580;
                billListUI.getUIContentPane().setSize(new Dimension(width, height));
                KDTable kdTable = billListUI.getMainTable();
                kdTable.setBounds(new Rectangle(10, 10, width - 10, height - 10));
                this.tpRelatedBills.addTab(displayString, (Component)billListUI);
                this.BOSTypeVector.add(key);
                ++tabNumbers;
            }
            if (tabNumbers != 0) continue;
            MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"canNotNav"));
            SysUtil.abort();
        }
        if (this.tpRelatedBills.getSelectedComponent() instanceof ListUI) {
            this.curentBillListUI = (ListUI)this.tpRelatedBills.getSelectedComponent();
        }
    }

    private EntityViewInfo initIdFilter(Vector idList) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        maskString.append("(");
        for (int i = 0; i < idList.size(); ++i) {
            if (i != 0) {
                maskString.append(" or ");
            }
            maskString.append("#" + i);
            String BOSType = BOSUuid.read((String)idList.get(i).toString()).getType().toString();
            filter.getFilterItems().add(new FilterItemInfo(this.getTableColumnFieldNameByPropName("id", BOSType), (Object)((String)idList.get(i)), CompareType.EQUALS));
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private void getColumnFieldNameVector(KDTable kdTable, HashMap columnFieldTOName, HashMap columnNameTOField) {
        for (int i = 0; i < kdTable.getColumnCount(); ++i) {
            columnFieldTOName.put(kdTable.getColumn(i).getFieldName(), kdTable.getColumn(i).getKey());
            columnNameTOField.put(kdTable.getColumn(i).getKey(), kdTable.getColumn(i).getFieldName());
        }
    }

    private String getSelectedRowKeyColumnValue(IRow iRow, HashMap columnFieldTOName, HashMap columnNameTOField) throws Exception {
        String selectedBOSType = (String)this.BOSTypeVector.get(this.tpRelatedBills.getSelectedIndex());
        String tableColunmField = this.getTableColumnFieldNameByPropName("id", selectedBOSType);
        String keyValue = null;
        if (columnFieldTOName.get(tableColunmField) != null) {
            keyValue = iRow.getCell((String)columnFieldTOName.get(tableColunmField)).getValue().toString();
        }
        return keyValue;
    }

    private void getSelectedBillID() throws BTPException, Exception {
        KDTable kdTable;
        HashMap columnFieldTOName = new HashMap();
        HashMap columnNameTOField = new HashMap();
        if (this.tpRelatedBills.getSelectedComponent() != null) {
            kdTable = ((ListUI)this.tpRelatedBills.getSelectedComponent()).getMainTable();
            this.getColumnFieldNameVector(kdTable, columnFieldTOName, columnNameTOField);
            if (kdTable.getSelectManager().getActiveRowIndex() < 0) {
                throw new BTPException(BTPException.NOSELECTROW);
            }
        } else {
            throw new BTPException(BTPException.NOSELECTROW);
        }
        IRow iRow = kdTable.getRow(kdTable.getSelectManager().getActiveRowIndex());
        this.billInfoID = this.getSelectedRowKeyColumnValue(iRow, columnFieldTOName, columnNameTOField);
    }

    protected void btnPre_actionPerformed(ActionEvent e) throws Exception {
        this.KDBtPrev_actionPerformed(e);
    }

    protected void btnNext_actionPerformed(ActionEvent e) throws Exception {
        this.KDBtNext_actionPerformed(e);
    }

    public void actionNavView_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI != null && this.curentBillListUI.getTableForBOTP().getRowCount() > 0) {
            this.curentBillListUI.actionView_actionPerformed(e);
        }
    }

    protected void KDBtNext_actionPerformed(ActionEvent e) throws Exception {
        this.getSelectedBillID();
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)this.billInfoID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        if (relations == null || relations.size() == 0) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        Vector<String> destBillIDs = new Vector<String>();
        for (int i = 0; i < relations.size(); ++i) {
            destBillIDs.add(relations.get(i).getDestObjectID());
        }
        HashMap billTypes = this.getRelatedBillType(destBillIDs);
        this.refreshTP2(billTypes, (Map)this.getUIContext().get("BTPNAVCTX"));
    }

    private HashMap getRelatedBillType(Vector billCollection) throws BTPException {
        LinkedHashMap hashMap = new LinkedHashMap();
        if (billCollection != null) {
            for (int i = 0; i < billCollection.size(); ++i) {
                if (billCollection.get(i) == null) continue;
                String BOSTypeString = BOSUuid.read((String)((String)billCollection.get(i))).getType().toString();
                if (!hashMap.containsKey(BOSTypeString)) {
                    Vector vector = new Vector();
                    vector.add(billCollection.get(i));
                    hashMap.put(BOSTypeString, vector);
                    continue;
                }
                if (((Vector)((HashMap)hashMap).get(BOSTypeString)).contains(billCollection.get(i))) continue;
                ((Vector)((HashMap)hashMap).get(BOSTypeString)).add(billCollection.get(i));
            }
        } else {
            throw new BTPException(BTPException.BILLNORELATEDBILL);
        }
        return hashMap;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public boolean destroyWindow() {
        int count = this.tpRelatedBills.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component obj = this.tpRelatedBills.getComponentAt(i);
            if (obj == null || !(obj instanceof ListUI)) continue;
            ((ListUI)obj).destroyWindow();
        }
        return super.destroyWindow();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.curentBillListUI.getMainTable());
        this.curentBillListUI.getMainTable().getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.curentBillListUI.getMainTable());
        this.curentBillListUI.getMainTable().getPrintManager().printPreview();
    }
}

