/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.GeneralF12Enum;
import com.kingdee.eas.scm.common.client.AbstractMaterialQueryListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class MaterialQueryListUI
extends AbstractMaterialQueryListUI {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.client.MaterialQueryListUI");
    private static final long serialVersionUID = -4700452201375749410L;
    protected IMetaDataPK mainQueryPK;
    protected HashMap hmQueryCon = new HashMap();
    private String[] filterName;
    private boolean isQuickQuery = false;
    private boolean isNewF12 = false;
    private List headList = null;
    private Set boolField = null;
    private String sql = null;
    private boolean isFromF12 = false;
    private boolean isCancelled;
    private List<HashMap<String, Object>> results = new ArrayList<HashMap<String, Object>>();
    private static final String permItem = "inventory";
    protected HashMap hmResult = new HashMap();
    protected ArrayList alResult = new ArrayList();
    private MyListener l = new MyListener();
    private boolean isSetAndBackButtonVisable = true;
    private boolean isOrderBy = false;
    private boolean isFristSortTable = true;
    private ISortManager sm = null;
    private int sort = 0;
    private SorterItemInfo pre_order = null;
    private SorterItemInfo current_order = null;
    private int order_count = 0;
    private boolean theFirstFillData = true;

    public boolean isFromF12() {
        return this.isFromF12;
    }

    public void setFromF12(boolean isFromF12) {
        this.isFromF12 = isFromF12;
    }

    public MaterialQueryListUI() throws Exception {
        this.onLoad();
        this.alResult.clear();
    }

    @Override
    public void actionButton_actionPerformed(ActionEvent e) throws Exception {
        this.isCancelled = true;
        this.getALResult().clear();
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        this.detailTable.removeKeyListener((KeyListener)this.l);
        super.onLoad();
        this.isQuickQuery = false;
        this.filterName = new String[]{"lot", "assistProperty.name"};
        this.detailTable.checkParsed();
        this.detailTable.setEditable(false);
        this.detailTable.getSelectManager().setSelectMode(2);
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.im.inv", "InvQuery");
        this.detailTable.addKeyListener((KeyListener)this.l);
        this.detailTable.getActionMap().remove("FocusChangeCol");
        this.detailTable.getActionMap().remove("FocusChangeColReverse");
        this.detailTable.getActionMap().remove("FocusChangeRow");
        this.detailTable.getActionMap().remove("FocusChangeRowReverse");
        this.tHelper.setCanMoveColumn(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setAndBack.setVisible(this.isSetAndBackButtonVisable);
        this.btnQuickQuery.setEnabled(true);
        this.ckBlurQuery.setEnabled(true);
        this.detailTable.requestFocusInWindow();
    }

    protected IRow appendFootRow(IQueryExecutor iexec) {
        if (!this.isFootVisible()) {
            return null;
        }
        Object footVisible = this.getUIContext().get("SumVisible");
        if (footVisible != null && !Boolean.valueOf(footVisible.toString()).booleanValue()) {
            return null;
        }
        try {
            List fieldSumList = this.getFieldSumList();
            if (fieldSumList.size() > 0) {
                QueryFieldInfo[] fieldInfo = new QueryFieldInfo[fieldSumList.size()];
                System.arraycopy(fieldSumList.toArray(), 0, fieldInfo, 0, fieldSumList.size());
                IRowSet singleRowSet = iexec.sum(fieldInfo);
                if (singleRowSet == null) {
                    return null;
                }
                singleRowSet.next();
                IRow footRow = null;
                KDTFootManager footRowManager = this.detailTable.getFootManager();
                if (footRowManager == null) {
                    String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                    footRowManager = new KDTFootManager(this.detailTable);
                    footRowManager.addFootView();
                    this.detailTable.setFootManager(footRowManager);
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                    this.detailTable.getIndexColumn().setWidthAdjustMode((short)1);
                    this.detailTable.getIndexColumn().setWidth(30);
                    footRowManager.addIndexText(0, total);
                } else {
                    footRow = footRowManager.getFootRow(0);
                }
                String colFormat = "%{0.##########}f";
                int columnCount = this.detailTable.getColumnCount();
                for (int c = 0; c < columnCount; ++c) {
                    String fieldName = this.detailTable.getColumn(c).getFieldName();
                    for (int i = 0; i < fieldSumList.size(); ++i) {
                        QueryFieldInfo info = (QueryFieldInfo)fieldSumList.get(i);
                        String name = info.getName();
                        if (!name.equalsIgnoreCase(fieldName)) continue;
                        ICell cell = footRow.getCell(c);
                        cell.getStyleAttributes().setNumberFormat(colFormat);
                        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                        cell.getStyleAttributes().setFontColor(Color.BLACK);
                        cell.setValue((Object)singleRowSet.getBigDecimal(name));
                    }
                }
                footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
                return footRow;
            }
        }
        catch (Exception E) {
            logger.error((Object)E);
        }
        return null;
    }

    protected boolean isFootVisible() {
        return true;
    }

    public List getFieldSumList() {
        ArrayList fieldList;
        if (this.isNewF12) {
            String[] fields = new String[]{"FBaseQty", "FCurStoreQty", "FCurStoreAssistQty", "FReservationQty", "FReservationBaseQty", "FReservationAssistQty"};
            return Arrays.asList(fields);
        }
        ArrayList<QueryFieldInfo> fieldSumList = new ArrayList<QueryFieldInfo>();
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(this.mainQueryPK);
        if (queryInfo != null && (fieldList = queryInfo.getSelector().getFields()) != null) {
            for (QueryFieldInfo fieldInfo : fieldList) {
                String property = fieldInfo.getExtendedProperty("isSumField");
                if (property == null || property.equals("") || !Boolean.valueOf(property).booleanValue()) continue;
                fieldSumList.add(fieldInfo);
            }
        }
        return fieldSumList;
    }

    public void executQuery() throws BOSException, Exception, SQLException {
        this.setAndBack.setVisible(this.isSetAndBackButtonVisable);
        IQueryExecutor iexec = this.getQueryExecutor(this.mainQueryPK, this.getEntityViewInfo());
        IRowSet rowSet = iexec.executeQuery();
        this.setRowSetBeforeFillTable(rowSet);
        this.detailTable.removeRows();
        this.detailTable.getSelectManager().setSelectMode(10);
        String[] fields = new String[this.detailTable.getColumnCount()];
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i] = this.detailTable.getColumn(i).getFieldName();
        }
        Collection coll = rowSet.toCollection();
        if (coll.size() != 0) {
            boolean refresh = this.detailTable.isRefresh();
            this.detailTable.setRefresh(false);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                IRow row = this.detailTable.addRow();
                int m = fields.length;
                for (int j = 0; j < m; ++j) {
                    row.getCell(j).setValue(rowSet.getObject(fields[j]));
                }
                this.formatQtyField(row);
            }
            this.detailTable.setRefresh(refresh);
            this.detailTable.repaint();
        }
        this.appendFootRow(iexec);
        if (this.detailTable.getBody().size() > 0) {
            this.detailTable.getEditManager().editCellAt(0, 1);
            this.detailTable.requestFocusInWindow();
        }
        this.detailTable.getLayoutManager().layout();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = this.isOrderBy;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private FilterInfo getwarePerm() {
        HashSet<FullOrgUnitInfo> cuUnitSets = new HashSet<FullOrgUnitInfo>();
        CtrlUnitInfo curCU = SysContext.getSysContext().getCurrentCtrlUnit();
        FullOrgUnitInfo cuUnit = MaterialQueryListUI.getFullOrgUnit(curCU.getId().toString());
        cuUnitSets.add(cuUnit);
        int rettype = 0;
        Map warePermMap = InvClientUtils.getwarePemissionSqlMap(cuUnitSets, (int)rettype, (String)"");
        FilterInfo warefilterInfo = this.getwareMapFilter(warePermMap);
        return warefilterInfo;
    }

    private static FullOrgUnitInfo getFullOrgUnit(String orgpk) {
        FullOrgUnitInfo fo = null;
        try {
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            fo = (FullOrgUnitInfo)iFullOrgUnit.getValue((IObjectPK)new ObjectUuidPK(orgpk));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return fo;
    }

    private FilterInfo getwareMapFilter(Map warepermMap) {
        Map.Entry entry2 = null;
        String wareperm = null;
        FilterInfo wareFilter = null;
        if (warepermMap != null && warepermMap.size() > 0) {
            try {
                for (Map.Entry entry2 : warepermMap.entrySet()) {
                    wareperm = (String)entry2.getValue();
                    wareFilter = new FilterInfo(wareperm);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return wareFilter;
    }

    public EntityViewInfo getEntityViewInfo() throws Exception {
        FilterInfo warefilterInfo;
        String unitID;
        String isBaseUpdatePara;
        String trackNumberId;
        String projectId;
        EntityViewInfo ev = new EntityViewInfo();
        HashMap hm = this.getHmQueryCon();
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer(128);
        int maskIndex = 0;
        StorageOrgUnitInfo storageUnitInfo = (StorageOrgUnitInfo)hm.get("STORAGEORGUNIT");
        if (storageUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitInfo.getId().toString(), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        } else if (hm.get("STORAGEORGUNITCOL") != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)hm.get("STORAGEORGUNITCOL").toString(), CompareType.INCLUDE));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        this.bizStorageOrgUnit.setValue((Object)storageUnitInfo);
        MaterialInfo material = (MaterialInfo)hm.get("MATERIAL");
        if (material != null) {
            material = MaterialFactory.getRemoteInstance().getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId().toString()));
            this.bizmaterial.setValue((Object)material);
            if (null != material.getModel()) {
                this.txtmaterialType.setText(material.getModel().trim().toString());
            } else {
                this.txtmaterialType.setText(null);
            }
            MeasureUnitInfo measureUnibInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(material.getBaseUnit().getId().toString()));
            this.txtBaseUnit.setText(measureUnibInfo.getName());
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)material.getId().toString(), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("ASSISTANTATTR") != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty.id", (Object)((String)hm.get("ASSISTANTATTR")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("BATCH") != null) {
            filter.getFilterItems().add(new FilterItemInfo("lot", (Object)((String)hm.get("BATCH")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("WAREHOUSE") != null) {
            filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)((String)hm.get("WAREHOUSE")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("LOCATION") != null) {
            filter.getFilterItems().add(new FilterItemInfo("location.id", (Object)((String)hm.get("LOCATION")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("SUPPLIER") != null) {
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)((String)hm.get("SUPPLIER")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (hm.get("CUSTOMER") != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)((String)hm.get("CUSTOMER")), CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        MaterialInventoryInfo materialInventory = null;
        if (material != null && storageUnitInfo != null) {
            materialInventory = MaterialInventoryFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), storageUnitInfo.getId().toString());
        }
        if ((projectId = (String)hm.get("PROJECT")) != null && materialInventory != null && materialInventory.isIsProjectNumber()) {
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if ((trackNumberId = (String)hm.get("TRACKNUM")) != null && materialInventory != null && materialInventory.isIsTrackingNumber()) {
            filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)trackNumberId, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        boolean isBaseUpdate = false;
        if (storageUnitInfo != null && (isBaseUpdatePara = ipc.getParamValue((IObjectPK)new ObjectUuidPK(storageUnitInfo.getId().toString()), "INM004")) != null) {
            boolean bl = isBaseUpdate = isBaseUpdatePara.trim().equals("true");
        }
        if (!isBaseUpdate && (unitID = (String)hm.get("UNIT")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)unitID, CompareType.EQUALS));
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        String storeTypeID = null;
        String storeStateID = null;
        List storeTypeList = null;
        List storeStateList = null;
        if (hm.get("STORETYPE") != null) {
            if (hm.get("STORETYPE") instanceof List) {
                storeTypeList = (List)hm.get("STORETYPE");
            } else {
                storeTypeID = (String)hm.get("STORETYPE");
            }
        }
        if (hm.get("STORESTATE") != null) {
            if (hm.get("STORESTATE") instanceof List) {
                storeStateList = (List)hm.get("STORESTATE");
            } else {
                storeStateID = (String)hm.get("STORESTATE");
            }
        }
        String tempMask = "";
        if (storeTypeList != null && storeStateList != null && storeTypeList.size() > 0 && storeStateList.size() > 0) {
            if (storeTypeList.size() == storeStateList.size()) {
                Object[] storeTypeArr = storeTypeList.toArray();
                Object[] storeStateArr = storeStateList.toArray();
                int len = storeTypeArr.length;
                for (int i = 0; i < len; ++i) {
                    String storeType = (String)storeTypeArr[i];
                    String storeState = (String)storeStateArr[i];
                    filter.getFilterItems().add(new FilterItemInfo("storetype.id", (Object)storeType, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("storestatus.id", (Object)storeState, CompareType.EQUALS));
                    tempMask = tempMask + "(#" + maskIndex++ + " and #" + maskIndex++ + ")";
                    if (i == len - 1) continue;
                    tempMask = tempMask + " or ";
                }
                mask.append(" and " + tempMask);
            }
        } else {
            if (storeTypeID != null) {
                filter.getFilterItems().add(new FilterItemInfo("storetype.id", (Object)storeTypeID, CompareType.EQUALS));
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
            if (storeStateID != null) {
                filter.getFilterItems().add(new FilterItemInfo("storestatus.id", (Object)storeStateID, CompareType.EQUALS));
                mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
            }
        }
        FilterInfo quickFilterInfo = null;
        if (this.isQuickQuery) {
            if (!this.txtInput.getText().trim().equals("") && this.ckBlurQuery.isSelected()) {
                String compareValue = ParamHelper.getMatchString((String)this.txtInput.getText().trim());
                quickFilterInfo = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo(this.filterName[this.comboCondition.getSelectedIndex()], (Object)compareValue, CompareType.LIKE);
                quickFilterInfo.getFilterItems().add(filterItem);
            }
            if (!this.txtInput.getText().trim().equals("") && !this.ckBlurQuery.isSelected()) {
                quickFilterInfo = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo(this.filterName[this.comboCondition.getSelectedIndex()], (Object)this.txtInput.getText().trim(), CompareType.EQUALS);
                quickFilterInfo.getFilterItems().add(filterItem);
            }
        }
        if (quickFilterInfo != null) {
            filter.mergeFilter(quickFilterInfo, "and");
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if ((warefilterInfo = this.getwarePerm()) != null) {
            filter.mergeFilter(warefilterInfo, "AND");
            mask.append(mask.length() == 0 ? "#" + maskIndex++ : " AND #" + maskIndex++);
        }
        if (mask.length() > 0) {
            filter.setMaskString(mask.toString());
        }
        ev.setFilter(filter);
        String storageOrgID = null;
        if (storageUnitInfo != null) {
            storageOrgID = storageUnitInfo.getId().toString();
        }
        FilterInfo permisionFilter = SCMClientUtils.getDataPermissionFilter(storageOrgID, permItem);
        ev.getFilter().mergeFilter(permisionFilter, "and");
        if (this.current_order == null) {
            ev.getSorter().add(new SorterItemInfo("material.number"));
            ev.getSorter().add(new SorterItemInfo("warehouse.number"));
        } else {
            ev.getSorter().clear();
            ev.getSorter().add(this.current_order);
        }
        return ev;
    }

    protected void execQuery() {
    }

    protected boolean isOrderForClickTableHead() {
        return true;
    }

    @Override
    protected void detailTable_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(e);
            return;
        }
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            this.takeValues();
        }
    }

    protected boolean isCanOrderTable() {
        return true;
    }

    protected String[] getNotOrderColumns() {
        return null;
    }

    private void OrderByForTable(KDTMouseEvent e) throws Exception {
        if (!this.isCanOrderTable()) {
            return;
        }
        String columnName = null;
        if (e.getType() == 0) {
            if (this.isFristSortTable) {
                this.sm = new KDTSortManager(this.detailTable);
                this.isFristSortTable = false;
            }
            columnName = this.detailTable.getColumn(e.getColIndex()).getKey();
            if (!StringUtils.isEmpty((String)this.detailTable.getColumn(e.getColIndex()).getFieldName())) {
                columnName = this.detailTable.getColumn(e.getColIndex()).getFieldName();
            }
            if (columnName == null) {
                return;
            }
            if (this.getNotOrderColumns() != null && this.getNotOrderColumns().length > 0) {
                for (int i = 0; i < this.getNotOrderColumns().length; ++i) {
                    if (!this.getNotOrderColumns()[i].equalsIgnoreCase(columnName) && columnName.indexOf("attacheMentId") < 0) continue;
                    return;
                }
            }
            this.sort = this.sort == 0 ? 1 : 0;
            this.sm.sort(e.getColIndex(), this.sort);
            if (this.sort == 0) {
                SorterItemInfo sortName = new SorterItemInfo(columnName);
                sortName.setSortType(SortType.ASCEND);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                } else if (this.current_order != null && this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    this.current_order = (SorterItemInfo)sortName.clone();
                }
                this.setSortForQuery(sortName, this.pre_order);
            } else {
                SorterItemInfo sortName = new SorterItemInfo(columnName);
                sortName.setSortType(SortType.DESCEND);
                if (this.pre_order == null) {
                    this.pre_order = (SorterItemInfo)sortName.clone();
                    this.current_order = (SorterItemInfo)sortName.clone();
                } else if (this.current_order != null && !this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    ++this.order_count;
                    if (this.order_count > 0) {
                        this.pre_order = (SorterItemInfo)this.current_order.clone();
                        this.order_count = 0;
                        this.current_order = (SorterItemInfo)sortName.clone();
                    }
                } else if (this.current_order != null && this.current_order.getPropertyName().equals(sortName.getPropertyName())) {
                    this.current_order = (SorterItemInfo)sortName.clone();
                }
                this.setSortForQuery(this.current_order, this.pre_order);
            }
        }
    }

    protected void setSortForQuery(SorterItemInfo sortItem, SorterItemInfo oldSortItem) throws Exception {
        this.refreshListForOrder(sortItem);
    }

    protected boolean isOrderPre() {
        return true;
    }

    public void refreshListForOrder(SorterItemInfo sortItem) throws Exception {
        this.isOrderBy = true;
        CacheServiceFactory.getInstance().discardQuery(this.invQueryPK);
        this.setTheFirstFillData(true);
        if (this.isFromF12) {
            boolean tempValue = this.isQuickQuery;
            this.isQuickQuery = true;
            this.actionQuery(this.headList, null, this.actionQuickQuery(sortItem), null);
            this.isQuickQuery = tempValue;
        } else {
            this.detailTable.removeRows();
            this.executQuery();
        }
    }

    public boolean isTheFirstFillData() {
        return this.theFirstFillData;
    }

    public void setTheFirstFillData(boolean theFirstFillData) {
        this.theFirstFillData = theFirstFillData;
    }

    private void takeValues() {
        if (this.detailTable.getRowCount() > 0) {
            ActionEvent evt = new ActionEvent(this.setAndBack, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    @Override
    public void actionQuickQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isQuickQuery = true;
        if (this.isNewF12) {
            this.actionQuery(this.headList, null, this.actionQuickQuery(null), null);
        } else {
            this.executQuery();
        }
        this.isQuickQuery = false;
    }

    @Override
    public void actionSetAndBack_actionPerformed(ActionEvent e) throws Exception {
        this.isCancelled = false;
        if (this.isNewF12) {
            if (!this.isSetAndBackButtonVisable) {
                return;
            }
            this.actionSetAndBack();
            return;
        }
        if (!this.isSetAndBackButtonVisable) {
            return;
        }
        if (this.detailTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.getALResult().clear();
        KDTSelectBlock selectBlock = null;
        int size = this.detailTable.getSelectManager().size();
        for (int p = 0; p < size; ++p) {
            selectBlock = this.detailTable.getSelectManager().get(p);
            if (selectBlock == null) continue;
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                String trackNumberID;
                String projectID;
                String unitID;
                String storeStatuID;
                String storetypeID;
                String customerID;
                String supplierID;
                String locationID;
                String warehouseID;
                Object objLot;
                String assistPropertyID;
                IRow row = this.detailTable.getRow(i);
                if (row == null) continue;
                HashMap<String, Object> hs = new HashMap<String, Object>();
                MaterialInfo materialInfo = (MaterialInfo)this.bizmaterial.getValue();
                if (materialInfo != null) {
                    hs.put("material", materialInfo);
                }
                if ((assistPropertyID = (String)row.getCell("assistPropertyID").getValue()) != null) {
                    AsstAttrValueInfo asstAttrValue = new AsstAttrValueInfo();
                    IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getRemoteInstance();
                    asstAttrValue = iAsstAttrValue.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(assistPropertyID));
                    hs.put("asstAttrValue", asstAttrValue);
                }
                if ((objLot = row.getCell("batch").getValue()) != null) {
                    hs.put("lot", objLot.toString());
                }
                if ((warehouseID = (String)row.getCell("warehouseID").getValue()) != null) {
                    WarehouseInfo warehouseInfo = new WarehouseInfo();
                    IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                    warehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseID));
                    hs.put("warehouse", warehouseInfo);
                }
                if ((locationID = (String)row.getCell("locationID").getValue()) != null) {
                    LocationInfo locationInfo = new LocationInfo();
                    ILocation iLocation = LocationFactory.getRemoteInstance();
                    locationInfo = iLocation.getLocationInfo((IObjectPK)new ObjectUuidPK(locationID));
                    hs.put("location", locationInfo);
                }
                if ((supplierID = (String)row.getCell("supplierID").getValue()) != null) {
                    SupplierInfo supplierValue = new SupplierInfo();
                    ISupplier iSupplier = SupplierFactory.getRemoteInstance();
                    supplierValue = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierID));
                    hs.put("supplier", supplierValue);
                }
                if ((customerID = (String)row.getCell("customerID").getValue()) != null) {
                    CustomerInfo customerValue = new CustomerInfo();
                    ICustomer iCustomer = CustomerFactory.getRemoteInstance();
                    customerValue = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(customerID));
                    hs.put("customer", customerValue);
                }
                if ((storetypeID = (String)row.getCell("storetype.id").getValue()) != null) {
                    StoreTypeInfo storetypeValue = new StoreTypeInfo();
                    IStoreType iStoreType = StoreTypeFactory.getRemoteInstance();
                    storetypeValue = iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(storetypeID));
                    hs.put("storetype", storetypeValue);
                }
                if ((storeStatuID = (String)row.getCell("storestatus.id").getValue()) != null) {
                    StoreStateInfo storeStateValue = new StoreStateInfo();
                    IStoreState iStoreState = StoreStateFactory.getRemoteInstance();
                    storeStateValue = iStoreState.getStoreStateInfo((IObjectPK)new ObjectUuidPK(storeStatuID));
                    hs.put("storeState", storeStateValue);
                }
                BigDecimal fQty = (BigDecimal)row.getCell("curStoreQty").getValue();
                hs.put("fqty", fQty);
                BigDecimal fBaseQty = (BigDecimal)row.getCell("baseQty").getValue();
                hs.put("fBaseQty", fBaseQty);
                if (row.getCell("curStoreAssistQty") != null) {
                    BigDecimal fAssitQty = (BigDecimal)row.getCell("curStoreAssistQty").getValue();
                    hs.put("fAssitQty", fAssitQty);
                }
                if ((unitID = row.getCell("unit.id").getValue().toString()) != null) {
                    MeasureUnitInfo measureUnitInfo = null;
                    IMeasureUnit iMeasureUnit = MeasureUnitFactory.getRemoteInstance();
                    measureUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
                    hs.put("unit", measureUnitInfo);
                }
                if ((projectID = (String)row.getCell("project.id").getValue()) != null) {
                    ProjectInfo projectValue = new ProjectInfo();
                    IProject iProject = ProjectFactory.getRemoteInstance();
                    projectValue = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
                    hs.put("project", projectValue);
                }
                if ((trackNumberID = (String)row.getCell("trackNumber.id").getValue()) != null) {
                    TrackNumberInfo trackNumberValue = new TrackNumberInfo();
                    ITrackNumber iTrackNumber = TrackNumberFactory.getRemoteInstance();
                    trackNumberValue = iTrackNumber.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
                    hs.put("trackNum", trackNumberValue);
                }
                this.getALResult().add(hs);
            }
        }
        super.disposeUIWindow();
    }

    public HashMap getHmQueryCon() {
        return this.hmQueryCon;
    }

    public void setHmQueryCon(HashMap hmQueryCon) {
        this.hmQueryCon = hmQueryCon;
    }

    protected JButton getDefaultButton() {
        return this.setAndBack;
    }

    public void setSetAndBackButtonVisiable(boolean tag) {
        this.isSetAndBackButtonVisable = tag;
    }

    protected void setRowSetBeforeFillTable(IRowSet rowSet) {
        BigDecimal curStoreQty = null;
        BigDecimal curStoreAssistQty = null;
        BigDecimal baseQty = null;
        BigDecimal lockQty = null;
        BigDecimal lockBaseQty = null;
        BigDecimal curMatStoreQty = null;
        try {
            while (rowSet.next()) {
                curStoreQty = rowSet.getBigDecimal("curStoreQty");
                curStoreAssistQty = rowSet.getBigDecimal("curStoreAssistQty");
                baseQty = rowSet.getBigDecimal("baseQty");
                lockQty = rowSet.getBigDecimal("lockQty");
                lockBaseQty = rowSet.getBigDecimal("lockBaseQty");
                curMatStoreQty = rowSet.getBigDecimal("curMatStoreQty");
                if (curMatStoreQty != null) {
                    rowSet.updateObject("curMatStoreQty", (Object)curMatStoreQty.setScale(rowSet.getInt("multiUnit.qtyPrecision"), 4), rowSet.getInt("multiUnit.qtyPrecision"));
                }
                if (curStoreQty != null) {
                    rowSet.updateObject("curStoreQty", (Object)curStoreQty.setScale(rowSet.getInt("multiUnit.qtyPrecision"), 4), rowSet.getInt("multiUnit.qtyPrecision"));
                }
                if (curStoreAssistQty != null) {
                    rowSet.updateObject("curStoreAssistQty", (Object)curStoreAssistQty.setScale(rowSet.getInt("multiAssistUnit.qtyPrecision"), 4), rowSet.getInt("multiAssistUnit.qtyPrecision"));
                }
                if (baseQty != null) {
                    rowSet.updateObject("baseQty", (Object)baseQty.setScale(rowSet.getInt("multiBaseUnit.qtyPrecision"), 4), rowSet.getInt("multiBaseUnit.qtyPrecision"));
                }
                if (lockQty != null) {
                    rowSet.updateObject("lockQty", (Object)lockQty.setScale(rowSet.getInt("multiUnit.qtyPrecision"), 4), rowSet.getInt("multiUnit.qtyPrecision"));
                }
                if (lockBaseQty == null) continue;
                rowSet.updateObject("lockBaseQty", (Object)lockBaseQty.setScale(rowSet.getInt("multiBaseUnit.qtyPrecision"), 4), rowSet.getInt("multiBaseUnit.qtyPrecision"));
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public void setHmResult(HashMap hmResult) {
        this.hmResult = hmResult;
    }

    public ArrayList getALResult() {
        return this.alResult;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setALResult(ArrayList alResult) {
        this.alResult = alResult;
    }

    public HashMap getHmResult() {
        HashMap hmResult = new HashMap();
        if (this.alResult.size() > 0) {
            hmResult = (HashMap)this.alResult.get(0);
            hmResult.put("needSet", Boolean.TRUE);
        }
        return hmResult;
    }

    protected void disposeUIWindow() {
        this.getALResult().clear();
        super.disposeUIWindow();
    }

    private void formatQtyField(IRow row) {
        String[] fields = this.getQtyField();
        BigDecimal qty = null;
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            qty = (BigDecimal)row.getCell(fields[i]).getValue();
            if (qty == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatPattern((int)qty.scale()));
        }
    }

    private String[] getQtyField() {
        return new String[]{"curStoreQty", "curMatStoreQty", "baseQty", "lockQty", "lockBaseQty", "curStoreAssistQty"};
    }

    private void actionSetAndBack() throws BOSException {
        if (this.detailTable.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        this.getResults().clear();
        KDTSelectBlock selectBlock = null;
        int size = this.detailTable.getSelectManager().size();
        for (int index = 0; index < size; ++index) {
            selectBlock = this.detailTable.getSelectManager().get(index);
            if (selectBlock == null) continue;
            for (int i = selectBlock.getTop(); i <= selectBlock.getEndRow(); ++i) {
                IRow row = this.detailTable.getRow(i);
                if (row == null) continue;
                HashMap<String, Object> hs = new HashMap<String, Object>();
                String key = null;
                Object value = null;
                int count = this.detailTable.getColumnCount();
                for (int colIndex = 0; colIndex < count; ++colIndex) {
                    key = this.detailTable.getColumn(colIndex).getKey();
                    value = row.getCell(key).getValue();
                    hs.put(key, value);
                }
                this.getResults().add(hs);
            }
        }
        this.disposeUIWindow();
    }

    public void actionQuery(List headList, Map data, IRowSet rs, String sql) throws Exception {
        this.isNewF12 = true;
        if (!this.isQuickQuery) {
            this.initUI(data);
            this.boolField = (Set)data.get("boolFieldSet");
            this.buildDynColumn(headList, data);
            this.headList = headList;
            this.sql = sql;
            this.setQueryPreference(true);
            this.tHelper = null;
            this.initHelper();
        }
        this.insertRows(headList, rs);
        List sumFieldsList = this.getFieldSumList();
        this.appendFootRow(sumFieldsList);
        if (this.detailTable.getBody().size() > 0) {
            this.detailTable.getEditManager().editCellAt(0, 1);
            this.detailTable.requestFocusInWindow();
        }
        this.detailTable.getLayoutManager().layout();
    }

    private IRowSet actionQuickQuery(SorterItemInfo sortItem) throws EASBizException, BOSException {
        StringBuffer whereSQL = new StringBuffer();
        String val = this.txtInput.getText().trim();
        String loc = "l2";
        if (SysContext.getSysContext().getLocale() != null) {
            loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        }
        if (!StringUtil.isEmpty((String)val)) {
            if (this.ckBlurQuery.isSelected()) {
                val = ParamHelper.getMatchString((String)val, null);
                if (GeneralF12Enum.lot.equals(this.comboCondition.getSelectedItem())) {
                    whereSQL.append(" and inventory.FLot like '").append(val).append("'");
                } else if (GeneralF12Enum.assistProperty.equals(this.comboCondition.getSelectedItem())) {
                    whereSQL.append(" and ASSISTPROPERTY.fname_").append(loc).append(" like '").append(val).append("'");
                }
            } else if (GeneralF12Enum.lot.equals(this.comboCondition.getSelectedItem())) {
                whereSQL.append(" and inventory.FLot = '").append(val).append("'");
            } else if (GeneralF12Enum.assistProperty.equals(this.comboCondition.getSelectedItem())) {
                whereSQL.append(" and ASSISTPROPERTY.fname_").append(loc).append(" = '").append(val).append("'");
            }
        }
        String selectSql = this.sql + whereSQL;
        if (sortItem != null) {
            selectSql = selectSql + " order by " + sortItem.toString();
        }
        IRowSet rs = new SQLExecutor(selectSql).executeSQL();
        return rs;
    }

    private void initUI(Map data) throws EASBizException, BOSException {
        this.setAndBack.setVisible(this.isSetAndBackButtonVisable);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)data.get("query_storageOrgInfo");
        MaterialInfo matInfo = (MaterialInfo)data.get("query_materialInfo");
        this.bizStorageOrgUnit.setValue((Object)sou);
        this.bizmaterial.setValue((Object)matInfo);
        if (matInfo == null) {
            return;
        }
        this.txtmaterialType.setText(matInfo.getModel());
        MeasureUnitInfo baseUnit = matInfo.getBaseUnit();
        if (baseUnit != null && baseUnit.getName() == null) {
            String baseUnitID = matInfo.getBaseUnit().getId().toString();
            baseUnit = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(baseUnitID));
        }
        this.txtBaseUnit.setText(baseUnit.getName());
    }

    private void buildDynColumn(List headList, Map data) {
        this.detailTable.removeColumns();
        IColumn col = null;
        IRow row = this.detailTable.addHeadRow();
        String colKey = null;
        int size = headList.size();
        for (int i = 0; i < size; ++i) {
            col = this.detailTable.addColumn();
            colKey = headList.get(i).toString();
            col.setKey(colKey);
            row.getCell(colKey).setValue(data.get(colKey));
            if (colKey.endsWith("pk_hide")) {
                col.getStyleAttributes().setHided(true);
                continue;
            }
            if ("FReservationQty".equals(colKey) || "FReservationBaseQty".equals(colKey) || "FReservationAssistQty".equals(colKey) || "materialHelpCode".equals(colKey)) {
                col.setWidth(100);
                col.getStyleAttributes().setHided(true);
                continue;
            }
            if (!this.boolField.contains(colKey)) continue;
            KDCheckBox cb = new KDCheckBox();
            KDTDefaultCellEditor bizchkBoxEditorSelected = new KDTDefaultCellEditor((JCheckBox)cb);
            this.detailTable.getColumn(colKey).setWidth(60);
            this.detailTable.getColumn(colKey).getStyleAttributes().setLocked(true);
            this.detailTable.getColumn(colKey).setEditor((ICellEditor)bizchkBoxEditorSelected);
        }
        this.fmtDate();
    }

    private void fmtDate() {
        String[] dateField = new String[]{"FMfg", "FExp"};
        String dateTimeStr = DateTimeUtil.strDateFormat;
        for (int i = 0; i < dateField.length; ++i) {
            this.detailTable.getColumn(dateField[i]).getStyleAttributes().setNumberFormat(dateTimeStr);
        }
    }

    private BigDecimal formatDecimal(BigDecimal value, int scale) {
        if (BigDecimal.ZERO.compareTo(value) == 0) {
            return null;
        }
        return value.setScale(scale, 4);
    }

    private void insertRows(List headList, IRowSet rs) throws SQLException {
        this.detailTable.removeRows();
        this.detailTable.getSelectManager().setSelectMode(10);
        IRow row = null;
        boolean refresh = this.detailTable.isRefresh();
        this.detailTable.setRefresh(false);
        String key = null;
        this.updateRowSet(rs);
        while (rs.next()) {
            row = this.detailTable.addRow();
            int size = headList.size();
            for (int i = 0; i < size; ++i) {
                key = headList.get(i).toString();
                if (this.boolField.contains(key)) {
                    row.getCell(key).setValue((Object)rs.getBoolean(key));
                    continue;
                }
                row.getCell(key).setValue(rs.getObject(key));
            }
        }
        this.detailTable.setRefresh(refresh);
        this.detailTable.repaint();
    }

    private void updateRowSet(IRowSet rowSet) {
        BigDecimal curStoreQty = null;
        BigDecimal curStoreAssitQty = null;
        BigDecimal baseQty = null;
        BigDecimal lockQty = null;
        BigDecimal lockBaseQty = null;
        BigDecimal lockAssistQty = null;
        try {
            while (rowSet.next()) {
                curStoreQty = rowSet.getBigDecimal("FCurStoreQty");
                curStoreAssitQty = rowSet.getBigDecimal("FCurStoreAssistQty");
                baseQty = rowSet.getBigDecimal("FBaseQty");
                lockQty = rowSet.getBigDecimal("FReservationQty");
                lockBaseQty = rowSet.getBigDecimal("FReservationBaseQty");
                lockAssistQty = rowSet.getBigDecimal("FReservationAssistQty");
                int qtyPrecision = rowSet.getInt("MULTIUNITQTYPRECISION");
                int baseQqtyPrecision = rowSet.getInt("MULTIBASEUNITQTYPRECISION");
                int assQtyPrecision = rowSet.getInt("MULTIASSISTUNITQTYPRECISION");
                if (curStoreQty != null) {
                    rowSet.updateObject("FCurStoreQty", (Object)this.formatDecimal(curStoreQty, qtyPrecision));
                }
                if (curStoreAssitQty != null) {
                    rowSet.updateObject("FCurStoreAssistQty", (Object)this.formatDecimal(curStoreAssitQty, assQtyPrecision));
                }
                if (baseQty != null) {
                    rowSet.updateObject("FBaseQty", (Object)this.formatDecimal(baseQty, baseQqtyPrecision));
                }
                if (lockQty != null) {
                    rowSet.updateObject("FReservationQty", (Object)this.formatDecimal(lockQty, qtyPrecision));
                }
                if (lockBaseQty != null) {
                    rowSet.updateObject("FReservationBaseQty", (Object)this.formatDecimal(lockBaseQty, baseQqtyPrecision));
                }
                if (lockAssistQty == null) continue;
                rowSet.updateObject("FReservationAssistQty", (Object)this.formatDecimal(lockAssistQty, assQtyPrecision));
            }
            rowSet.beforeFirst();
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    private IRow appendFootRow(List sumFieldsList) {
        if (!this.isFootVisible()) {
            return null;
        }
        Object footVisible = this.getUIContext().get("SumVisible");
        if (footVisible != null && !Boolean.valueOf(footVisible.toString()).booleanValue()) {
            return null;
        }
        IRow footRow = null;
        KDTFootManager footRowManager = this.detailTable.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.detailTable);
            footRowManager.addFootView();
            this.detailTable.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.detailTable.getIndexColumn().setWidthAdjustMode((short)1);
            this.detailTable.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        String fieldName = null;
        ICell cell = null;
        BigDecimal qty = BigDecimal.ZERO;
        int scale = 2;
        int size = sumFieldsList.size();
        for (int i = 0; i < size; ++i) {
            fieldName = (String)sumFieldsList.get(i);
            cell = footRow.getCell(fieldName);
            qty = this.getSumValue(fieldName);
            scale = qty == null ? 2 : qty.scale();
            cell.getStyleAttributes().setNumberFormat(SCMClientUtils.getFormatPattern(scale));
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            cell.getStyleAttributes().setFontColor(Color.BLACK);
            cell.setValue((Object)qty);
        }
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
        return footRow;
    }

    private BigDecimal getSumValue(String fieldName) {
        BigDecimal value = BigDecimal.ZERO;
        ICell cell = null;
        int count = this.detailTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            cell = this.detailTable.getCell(i, fieldName);
            if (cell.getValue() == null) continue;
            value = value.add((BigDecimal)cell.getValue());
        }
        return value;
    }

    public List<HashMap<String, Object>> getResults() {
        return this.results;
    }

    private class MyListener
    implements KeyListener {
        private MyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                MaterialQueryListUI.this.takeValues();
            }
        }
    }
}

