/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;

public class MinusDecimalTextFieldEditor
extends KDTAbstractCellEditor {
    protected JComponent comp;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 2;

    public MinusDecimalTextFieldEditor(final JFormattedTextField textField) {
        this.comp = textField;
        this.handleEsc(textField);
        this.delegate = new EditorDelegate(){

            @Override
            public String getText() {
                String text = null;
                text = textField.getText();
                return text;
            }

            @Override
            public void setValue(Object value) {
                if (textField instanceof KDFormattedTextField) {
                    BigDecimal n = null;
                    if (value != null && !"".equals(value.toString()) && value != null && ((Number)(n = new BigDecimal(value.toString()))).doubleValue() < 0.0) {
                        n = new BigDecimal(((Object)n).toString()).negate();
                    }
                    ((KDFormattedTextField)textField).setNumberValue(n);
                }
            }

            @Override
            public Object getValue() {
                BigDecimal n;
                Number value = null;
                if (textField instanceof KDFormattedTextField && (value = ((KDFormattedTextField)textField).getNumberValue()) != null && ((Number)(n = new BigDecimal(value.toString()))).doubleValue() > 0.0) {
                    value = new BigDecimal(value.toString()).negate();
                }
                return value;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                if (anEvent instanceof KeyEvent) {
                    String str = String.valueOf(((KeyEvent)anEvent).getKeyChar());
                    this.initComponent(str);
                } else if (anEvent instanceof InputMethodEvent) {
                    String str = KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)((InputMethodEvent)anEvent));
                    this.initComponent(str);
                } else if (anEvent instanceof ActionEvent) {
                    String str = KDTDefaultCellEditor.getActionEventText((ActionEvent)((ActionEvent)anEvent));
                    this.initComponent(str);
                } else if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(true);
                } else {
                    textField.selectAll();
                }
                MinusDecimalTextFieldEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                MinusDecimalTextFieldEditor.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                MinusDecimalTextFieldEditor.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                MinusDecimalTextFieldEditor.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
            }

            void initComponent(String str) {
                if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        if (!"-".equals(str)) {
                            try {
                                new BigDecimal(str);
                            }
                            catch (Exception e) {
                                str = null;
                            }
                        }
                        textField.selectAll();
                        ((KDFormattedTextField)textField).replaceSelection(str);
                    }
                } else if (textField instanceof BasicNumberTextField) {
                    ((BasicNumberTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        int length = str.length();
                        try {
                            new Double(str);
                        }
                        catch (Exception e) {
                            str = null;
                            length = 0;
                        }
                        ((BasicNumberTextField)textField).setText(str);
                        textField.setCaretPosition(length);
                    }
                } else {
                    textField.setText(str);
                    if (!StringUtil.isEmptyString((String)str)) {
                        textField.setCaretPosition(str.length());
                    }
                }
            }

            @Override
            public void releaseComponent() {
                MinusDecimalTextFieldEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                MinusDecimalTextFieldEditor.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                MinusDecimalTextFieldEditor.this.comp.getActionMap().remove("SelectUpCell");
                MinusDecimalTextFieldEditor.this.comp.getActionMap().remove("SelectDownCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
        textField.addActionListener(this.delegate);
    }

    private void handleEsc(JComponent comp) {
        comp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "esc2");
        comp.getActionMap().put("esc2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MinusDecimalTextFieldEditor.this.fireEditingCanceled();
            }
        });
    }

    public String getText() {
        return this.delegate.getText();
    }

    public void setText(String text) {
        this.delegate.setText(text);
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
        if (this.isDisplayable()) {
            this.delegate.initComponent(value, expandValue, style, anEvent);
            return this.comp;
        }
        this.delegate.actionPerformed(value, anEvent);
        return null;
    }

    public Component getFocusComponent() {
        return this.delegate.getFocusComponent();
    }

    public Component getComponent() {
        return this.comp;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    Color getBackgroundColor(Color color) {
        if (color.getAlpha() == 0) {
            return Color.WHITE;
        }
        return color;
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener {
        protected EditorDelegate() {
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void setExpandValue(Object value) {
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= MinusDecimalTextFieldEditor.this.clickCountToStart;
            }
            return false;
        }

        public boolean isDisplayable() {
            return true;
        }

        public Component getFocusComponent() {
            return MinusDecimalTextFieldEditor.this.comp;
        }

        public void setBounds(int x, int y, int width, int height) {
            MinusDecimalTextFieldEditor.this.comp.setBounds(x, y, width, height);
        }

        public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            MinusDecimalTextFieldEditor.this.comp.setOpaque(true);
            MinusDecimalTextFieldEditor.this.comp.setBorder(null);
            MinusDecimalTextFieldEditor.this.comp.setBackground(MinusDecimalTextFieldEditor.this.getBackgroundColor(style.getBackground()));
            MinusDecimalTextFieldEditor.this.comp.setForeground(style.getFontColor());
            MinusDecimalTextFieldEditor.this.comp.setFont((Font)style.getKDFont());
            this.setValue(value);
        }

        public void releaseComponent() {
        }

        public void actionPerformed(Object value, EventObject anEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MinusDecimalTextFieldEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            MinusDecimalTextFieldEditor.this.stopCellEditing();
        }
    }
}

