/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PriceParamControlHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.client.PriceParamControlHelper");
    private SCMBillEditUI scmBillEditUI;
    private String cuID;
    private HashMap editCtrTabCollMap = new HashMap();
    private int curCtrlType = -1;
    public static final int CTRLFIELDSTATUS_UNENABLED = 0;
    public static final int CTRLFIELDSTATUS_ENABLEDANDPASSWORDCHECK = 1;
    public static final int CTRLFIELDSTATUS_ENABLEDANDMSG = 2;
    public static final int CTRLFIELDSTATUS_ENABLED = 3;
    private boolean isStartPriceDiscount;
    private KDTEditAdapter entryTableChange = null;
    private PriceParamInfo priceParamInfo = null;
    private boolean ischecked = false;

    public PriceParamControlHelper(SCMBillEditUI ui, String cuID) {
        this.scmBillEditUI = ui;
        this.cuID = cuID;
        try {
            PriceParamInfo priceParamInfo;
            IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
            this.priceParamInfo = priceParamInfo = iPriceParam.getParameter(cuID);
            this.isStartPriceDiscount = priceParamInfo.isStartPriceDiscountM();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.isStartPriceDiscount = false;
        }
    }

    public PriceParamControlHelper(SCMBillEditUI ui, String cuID, PriceParamInfo inPriceParamInfo) {
        this.scmBillEditUI = ui;
        this.cuID = cuID;
        try {
            if (inPriceParamInfo != null) {
                this.priceParamInfo = inPriceParamInfo;
            } else {
                PriceParamInfo npriceParamInfo;
                IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
                this.priceParamInfo = npriceParamInfo = iPriceParam.getParameter(cuID);
            }
            this.isStartPriceDiscount = this.priceParamInfo.isStartPriceDiscountM();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.isStartPriceDiscount = false;
        }
    }

    public PriceParamInfo getPriceParamInfo() {
        return this.priceParamInfo;
    }

    public void unRegisterCtrlTableCol(KDTable table, String[] unTabColName) {
        if (unTabColName != null && unTabColName.length > 0 && table != null) {
            ArrayList tabColNameList = null;
            if (!this.editCtrTabCollMap.containsKey(table)) {
                return;
            }
            tabColNameList = (ArrayList)this.editCtrTabCollMap.get(table);
            if (tabColNameList == null || tabColNameList.size() == 0) {
                return;
            }
            int num = unTabColName.length;
            for (int i = 0; i < num; ++i) {
                if (unTabColName[i] == null || unTabColName[i].trim().length() <= 0) continue;
                tabColNameList.remove(unTabColName[i]);
            }
        }
    }

    public void registerCtrlTableCol(KDTable table, String[] tabColName) {
        this.curCtrlType = -1;
        if (tabColName != null && tabColName.length > 0 && table != null) {
            ArrayList tabColNameList = null;
            if (this.editCtrTabCollMap.containsKey(table)) {
                tabColNameList = (ArrayList)this.editCtrTabCollMap.get(table);
            } else {
                tabColNameList = new ArrayList();
                this.editCtrTabCollMap.put(table, tabColNameList);
            }
            int num = tabColName.length;
            for (int i = 0; i < num; ++i) {
                if (tabColName[i] == null || tabColName[i].trim().length() <= 0 || tabColNameList.contains(tabColName[i])) continue;
                tabColNameList.add(tabColName[i]);
            }
        }
    }

    private boolean checkModifyCtrlPassWord() throws Exception {
        IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
        PriceParamInfo priceParamInfo = iPriceParam.getParameter(this.cuID);
        String rightPassWord = priceParamInfo.getEditPass();
        boolean isPass = false;
        String passWord = SCMClientUtils.showPassWordDialog(this.scmBillEditUI.getUIContext(), this.scmBillEditUI.getUIWindow());
        if (passWord == null) {
            isPass = false;
        } else if (passWord.trim().length() == 0 && rightPassWord == null) {
            isPass = true;
        } else if (passWord != null && rightPassWord != null && passWord.equals(rightPassWord)) {
            isPass = true;
        } else {
            MsgBox.showInfo((Component)((Object)this.scmBillEditUI), (String)SCMClientUtils.getResource("EDITCTRL_PASSWORDERROR"));
        }
        return isPass;
    }

    public boolean checkByCanModifyParam() throws Exception {
        if (this.curCtrlType == 3) {
            return true;
        }
        if (this.curCtrlType == 0) {
            return false;
        }
        if (this.curCtrlType == 1) {
            if (this.ischecked) {
                return true;
            }
            boolean ret = this.checkModifyCtrlPassWord();
            if (ret) {
                this.ischecked = ret;
            }
            return ret;
        }
        if (this.curCtrlType == 2) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this.scmBillEditUI), (String)SCMClientUtils.getResource("CHANGEPRICE_CONFIRE")));
        }
        IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
        PriceParamInfo priceParamInfo = iPriceParam.getParameter(this.cuID);
        int editCtrlType = priceParamInfo.getEditCtl();
        boolean ret = true;
        switch (editCtrlType) {
            case 0: {
                ret = false;
                this.curCtrlType = 0;
                break;
            }
            case 1: {
                ret = this.checkModifyCtrlPassWord();
                break;
            }
            case 2: {
                ret = MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this.scmBillEditUI), (String)SCMClientUtils.getResource("CHANGEPRICE_CONFIRE")));
                this.curCtrlType = 2;
                break;
            }
            case 3: {
                ret = true;
                this.curCtrlType = 3;
            }
        }
        return ret;
    }

    public void initUI() {
        if (this.editCtrTabCollMap.size() == 0 || this.cuID == null || this.cuID.trim().length() == 0) {
            return;
        }
        try {
            this.curCtrlType = this.getModifyCtrlStatus();
            switch (this.curCtrlType) {
                case 0: {
                    this.setCtrlTableColEnabled(false);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    this.setCtrlTableColEnabled(true);
                    break;
                }
            }
        }
        catch (PriceParamException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        Iterator keyIt = this.editCtrTabCollMap.keySet().iterator();
        KDTable table = null;
        while (keyIt.hasNext()) {
            table = (KDTable)keyIt.next();
            if (this.entryTableChange != null) {
                table.removeKDTEditListener((KDTEditListener)this.entryTableChange);
            }
            this.bindingTableEvent(table);
        }
    }

    private void bindingTableEvent(final KDTable table) {
        this.entryTableChange = new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    PriceParamControlHelper.this.handleEditCtrl(table, e);
                }
                catch (Exception exc) {
                    PriceParamControlHelper.this.scmBillEditUI.handUIException(exc);
                }
            }
        };
        table.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void handleEditCtrl(KDTable table, KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        ICell cell = table.getRow(rowIndex).getCell(colIndex);
        Object value = cell.getValue();
        String fieldName = table.getColumnKey(colIndex);
        if (table.getRow(rowIndex).getStyleAttributes().isLocked() || cell.getStyleAttributes().isLocked()) {
            return;
        }
        ArrayList colName = (ArrayList)this.editCtrTabCollMap.get(table);
        int num = colName.size();
        for (int i = 0; i < num; ++i) {
            if (colName.get(i) == null || !((String)colName.get(i)).equalsIgnoreCase(fieldName) || this.checkByCanModifyParam()) continue;
            e.setCancel(true);
            break;
        }
    }

    private void setCtrlTableColEnabled(boolean enabled) {
        if (this.editCtrTabCollMap.size() == 0) {
            return;
        }
        Iterator keyIt = this.editCtrTabCollMap.keySet().iterator();
        KDTable table = null;
        ArrayList colName = null;
        while (keyIt.hasNext()) {
            table = (KDTable)keyIt.next();
            colName = (ArrayList)this.editCtrTabCollMap.get(table);
            int num = colName.size();
            for (int i = 0; i < num; ++i) {
                if (colName.get(i) == null) continue;
                table.getColumn((String)colName.get(i)).getStyleAttributes().setLocked(!enabled);
            }
        }
    }

    public int getModifyCtrlStatus() throws PriceParamException, BOSException {
        int editCtrlType = this.priceParamInfo.getEditCtl();
        switch (editCtrlType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    public boolean checkByLimitPriceParam(BigDecimal price, BigDecimal priceMin) throws PriceParamException, BOSException {
        if (price == null) {
            return false;
        }
        if (priceMin == null) {
            priceMin = price;
        }
        if (price.compareTo(priceMin) != -1) {
            return true;
        }
        IPriceParam iPriceParam = PriceParamFactory.getRemoteInstance();
        PriceParamInfo priceParamInfo = iPriceParam.getParameter(this.cuID);
        int limitPriceCtrlType = priceParamInfo.getLimitPriceCtl();
        int limitPriceCtrlTime = priceParamInfo.getLimitPriceCtlTime();
        boolean ret = true;
        switch (limitPriceCtrlType) {
            case 0: {
                ret = false;
                break;
            }
            case 1: {
                String rightPassWord = priceParamInfo.getLimitPricePass();
                String passWord = SCMClientUtils.showPassWordDialog(this.scmBillEditUI.getUIContext(), this.scmBillEditUI.getUIWindow());
                if (passWord == null) {
                    ret = false;
                    break;
                }
                if (passWord.trim().length() == 0 && rightPassWord == null) {
                    ret = true;
                    break;
                }
                if (passWord != null && rightPassWord != null && passWord.equals(rightPassWord)) {
                    ret = true;
                    break;
                }
                MsgBox.showInfo((Component)((Object)this.scmBillEditUI), (String)SCMClientUtils.getResource("LIMITPRICECTRL_PASSWORDERROR"));
                ret = false;
                break;
            }
            case 2: {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this.scmBillEditUI), (String)SCMClientUtils.getResource("LIMITPRICECTRL_CHANGEPRICE_CONFIRE")))) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 3: {
                ret = true;
            }
        }
        return ret;
    }
}

