/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.DefaultPromptBoxFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;

public class SCMPromptBoxFactory
extends DefaultPromptBoxFactory {
    private CustomerQueryPanel filterUI = null;
    private OrgType mainOrgType = null;
    private F7ContextManager f7Manager = null;

    public SCMPromptBoxFactory(CustomerQueryPanel filterUI, OrgType mainOrgType) {
        this.filterUI = filterUI;
        this.mainOrgType = mainOrgType;
        try {
            this.f7Manager = new F7ContextManager((Component)filterUI, mainOrgType, 1);
        }
        catch (EASBizException e) {
            filterUI.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            filterUI.handUIException((Throwable)e);
        }
    }

    public KDPromptBox create(String f7QueryName, QueryInfo mainQuery, String queryFieldName) {
        String mainEntityName = SCMGroupClientUtils.getMainEntityName(f7QueryName);
        KDBizPromptBox promptBox = (KDBizPromptBox)super.create(f7QueryName, mainQuery, queryFieldName);
        if (mainEntityName == null) {
            return promptBox;
        }
        EntityObjectInfo entity = SCMGroupClientUtils.getEntity(mainEntityName);
        BusinessObjectInfo parent = entity.getParent();
        String parentEntityName = parent.getPackage() + "." + parent.getName();
        String thisEntityName = entity.getPackage() + "." + entity.getName();
        if ("com.kingdee.eas.basedata.framework.app.DataBaseD".equals(parentEntityName)) {
            if ("com.kingdee.eas.basedata.master.cssp.app.Supplier".equals(thisEntityName)) {
                this.f7Manager.registerBizSupplierF7(promptBox, null, null, null);
                this.addF7SelectorListener(promptBox, true);
            } else if ("com.kingdee.eas.basedata.master.cssp.app.Customer".equals(thisEntityName)) {
                this.f7Manager.registerBizCustomerF7(promptBox, null, null, null);
                this.addF7SelectorListener(promptBox, true);
            } else if ("com.kingdee.eas.basedata.master.material.app.Material".equals(thisEntityName)) {
                this.f7Manager.registerBizMaterialF7(promptBox, null, null, null, false);
                this.addF7SelectorListener(promptBox, false);
            }
        } else if ("com.kingdee.eas.basedata.org.app.OrgUnit".equals(parentEntityName)) {
            this.setBizOrgF7(promptBox, thisEntityName);
            this.addF7SelectorListener(promptBox, false);
        }
        if ("com.kingdee.eas.scm.im.inv.client.PurInWarehsFilterUI".equals(this.filterUI.getClass().getName()) && "com.kingdee.eas.basedata.assistant.app.PaymentType".equals(thisEntityName)) {
            if (promptBox.getQueryInfo() == null || promptBox.getQueryInfo().length() == 0) {
                promptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7PaymentTypeQuery");
            }
            promptBox.setEntityViewInfo(null);
            promptBox.setEntityViewInfo(SCMPromptBoxFactory.getPaymentViewInfo());
            promptBox.setAutoFocusNextComponent(true);
            promptBox.setCommitParser(null);
        }
        return promptBox;
    }

    public static EntityViewInfo getPaymentViewInfo() {
        EntityViewInfo paymentViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("id", (Object)"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
        filter.appendFilterItem("id", (Object)"40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5");
        filter.setMaskString("#0 or #1 ");
        paymentViewInfo.setFilter(filter);
        return paymentViewInfo;
    }

    private void setBizOrgF7(KDBizPromptBox promptBox, String thisEntityName) {
        OrgType orgType = null;
        if ("com.kingdee.eas.basedata.org.app.PurchaseOrgUnit".equals(thisEntityName)) {
            orgType = OrgType.Purchase;
        } else if ("com.kingdee.eas.basedata.org.app.SaleOrgUnit".equals(thisEntityName)) {
            orgType = OrgType.Sale;
        } else if ("com.kingdee.eas.basedata.org.app.StorageOrgUnit".equals(thisEntityName)) {
            orgType = OrgType.Storage;
        } else if ("com.kingdee.eas.basedata.org.app.CompanyOrgUnit".equals(thisEntityName)) {
            orgType = OrgType.Company;
        } else if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(thisEntityName)) {
            orgType = OrgType.Admin;
        }
        if (orgType == null || orgType != null && orgType.equals((Object)this.mainOrgType)) {
            return;
        }
        if (orgType != null) {
            SCMGroupClientUtils.setBizOrgF7ByType(promptBox, orgType, this.mainOrgType, false);
        }
    }

    private void addF7SelectorListener(final KDBizPromptBox f7, boolean isCssp) {
        if (isCssp) {
            f7.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    OrgUnitCollection value = SCMPromptBoxFactory.this.filterUI.getMainBizOrgs();
                    if (value == null || value.size() == 0) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg(SCMPromptBoxFactory.this.mainOrgType));
                        SCMPromptBoxFactory.this.filterUI.requestFocus();
                        SysUtil.abort();
                    } else {
                        SCMPromptBoxFactory.this.changeF7Context(f7, value);
                        f7.getQueryAgent().resetRuntimeEntityView();
                        SCMPromptBoxFactory.this.f7Manager.changeF7Context(f7);
                    }
                }
            });
        } else {
            f7.addSelectorListener(new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    OrgUnitCollection value = SCMPromptBoxFactory.this.filterUI.getMainBizOrgs();
                    if (value == null || value.size() == 0) {
                        MsgBox.showInfo((String)SCMGroupClientUtils.getMainOrgNullMsg(SCMPromptBoxFactory.this.mainOrgType));
                        SCMPromptBoxFactory.this.filterUI.requestFocus();
                        SysUtil.abort();
                    } else {
                        f7.setMainBizOrgs(value, SCMPromptBoxFactory.this.mainOrgType);
                        f7.getQueryAgent().resetRuntimeEntityView();
                        SCMPromptBoxFactory.this.f7Manager.changeF7Context(f7);
                    }
                }
            });
        }
    }

    private void addF7DataChangeListener(final KDBizPromptBox f7) {
        f7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                OrgUnitCollection value = SCMPromptBoxFactory.this.filterUI.getMainBizOrgs();
                if (value != null && value.size() > 0) {
                    SCMPromptBoxFactory.this.changeF7Context(f7, value);
                    f7.getQueryAgent().resetRuntimeEntityView();
                }
            }
        });
    }

    private void addF7CtxDataChangeListener(final KDBizPromptBox f7, boolean isCssp) {
        if (isCssp) {
            f7.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    OrgUnitCollection value = SCMPromptBoxFactory.this.filterUI.getMainBizOrgs();
                    if (value != null && value.size() > 0) {
                        SCMPromptBoxFactory.this.changeF7Context(f7, value);
                        f7.getQueryAgent().resetRuntimeEntityView();
                        SCMPromptBoxFactory.this.f7Manager.changeF7Context(f7);
                    }
                }
            });
        } else {
            f7.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    OrgUnitCollection value = SCMPromptBoxFactory.this.filterUI.getMainBizOrgs();
                    if (value != null && value.size() > 0) {
                        f7.setMainBizOrgs(value, SCMPromptBoxFactory.this.mainOrgType);
                        f7.getQueryAgent().resetRuntimeEntityView();
                        SCMPromptBoxFactory.this.f7Manager.changeF7Context(f7);
                    }
                }
            });
        }
    }

    private void changeF7Context(KDBizPromptBox f7, OrgUnitCollection value) {
        if (this.mainOrgType.equals((Object)OrgType.Storage)) {
            try {
                OrgUnitCollection delegatedOrgs = SCMGroupFacadeFactory.getRemoteInstance().obtainDelegatedOrgs(value, this.mainOrgType, OrgType.Company);
                f7.setMainBizOrgs(delegatedOrgs, OrgType.Company);
            }
            catch (EASBizException e) {
                this.filterUI.handUIException((Throwable)e);
            }
            catch (BOSException e) {
                this.filterUI.handUIException((Throwable)e);
            }
        } else {
            f7.setMainBizOrgs(value, this.mainOrgType);
        }
    }
}

