/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.LogTypeEnum;
import com.kingdee.eas.scm.common.SCMSqlLogConfigFactory;
import com.kingdee.eas.scm.common.SCMSqlLogConfigInfo;
import com.kingdee.eas.scm.common.SQLTypeEnum;
import com.kingdee.eas.scm.common.client.AbstractSCMSqlLogConfigEditUI;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SCMSqlLogConfigEditUI
extends AbstractSCMSqlLogConfigEditUI {
    private static final String CONFIG_ACTIVE = "configActive";
    private static final Logger logger = CoreUIObject.getLogger(SCMSqlLogConfigEditUI.class);
    private static final String RES = "com.kingdee.eas.scm.common.SCMLogResource";
    private transient ItemListener logTypeChangeListner = null;

    protected IObjectValue createNewData() {
        SCMSqlLogConfigInfo configInfo = new SCMSqlLogConfigInfo();
        configInfo.setSqlType(SQLTypeEnum.UPDATE);
        configInfo.setLogType(LogTypeEnum.DATABASE);
        configInfo.setStatus(UseStatusEnum.ADDNEW);
        configInfo.setStoreDays(30);
        return configInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (OprtState.EDIT.equals(this.getOprtState()) && UseStatusEnum.ACTIVE == this.editData.getStatus()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)CONFIG_ACTIVE));
            SysUtil.abort();
        }
        this.setSpinnerRange();
    }

    private void setSpinnerRange() {
        SpinnerNumberModel model = new SpinnerNumberModel(30, 1, 90, 1);
        this.spinnerDay.setModel((SpinnerModel)model);
        model = new SpinnerNumberModel(5, 1, 50, 1);
        this.spLogSize.setModel((SpinnerModel)model);
        model = new SpinnerNumberModel(10, 1, 100, 1);
        this.spLogCount.setModel((SpinnerModel)model);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SCMSqlLogConfigFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initUIStatus();
    }

    private void addListener() {
        this.logTypeChangeListner = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogTypeEnum selectedItem = (LogTypeEnum)((Object)SCMSqlLogConfigEditUI.this.comboLogType.getSelectedItem());
                SCMSqlLogConfigEditUI.this.setUIByLogType(selectedItem);
            }
        };
        this.comboLogType.addItemListener(this.logTypeChangeListner);
    }

    private void setUIByLogType(LogTypeEnum logType) {
        if (LogTypeEnum.DATABASE.equals((Object)logType)) {
            this.storeDay.setVisible(true);
            this.labelLogCount.setVisible(false);
            this.labelLogSize.setVisible(false);
        } else {
            this.storeDay.setVisible(false);
            this.labelLogCount.setVisible(true);
            this.labelLogSize.setVisible(true);
        }
    }

    private void removeListener() {
        if (this.logTypeChangeListner != null) {
            this.comboLogType.removeItemListener(this.logTypeChangeListner);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.initUIStatus();
    }

    private void initUIStatus() {
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(false);
        } else if (null != this.editData && UseStatusEnum.ACTIVE == this.editData.getStatus()) {
            this.actionCancel.setEnabled(true);
            this.actionCancelCancel.setEnabled(false);
        } else {
            this.actionCancel.setEnabled(false);
            this.actionCancelCancel.setEnabled(true);
        }
        if (this.editData != null) {
            this.setUIByLogType(this.editData.getLogType());
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setOprtState(OprtState.VIEW);
        super.actionCancelCancel_actionPerformed(e);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        SCMSqlLogConfigInfo data = (SCMSqlLogConfigInfo)dataObject;
        if ("EDIT".equals(this.getOprtState()) && UseStatusEnum.ACTIVE == data.getStatus()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)CONFIG_ACTIVE));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (UseStatusEnum.ACTIVE == this.editData.getStatus()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)CONFIG_ACTIVE));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        SCMSqlLogConfigInfo data = (SCMSqlLogConfigInfo)newData;
        data.setStatus(UseStatusEnum.ADDNEW);
        data.setNumber(null);
    }

    protected boolean isContinueAddNew() {
        return false;
    }
}

