/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.client.AbstractSDSMBillEditUI;
import com.kingdee.eas.scm.common.client.BillOptionsHelper;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class SDSMBillEditUI
extends AbstractSDSMBillEditUI {
    private static final long serialVersionUID = 1L;
    private boolean initBillOptions = true;
    private static final String STATUS_ALTER = "ALERT";
    protected boolean isIgnoreIsBOTPBill = false;

    public BigDecimal[] sumColumns(String[] cols, KDTable kdtEntries) {
        BigDecimal[] colsTotal = new BigDecimal[cols.length];
        for (int j = 0; j < cols.length; ++j) {
            BigDecimal sumTotal = new BigDecimal("0.00");
            int num = kdtEntries.getRowCount();
            for (int i = 0; i < num; ++i) {
                BigDecimal total = (BigDecimal)kdtEntries.getCell(i, cols[j]).getValue();
                if (total == null) continue;
                sumTotal = sumTotal.add(total);
            }
            colsTotal[j] = sumTotal;
        }
        return colsTotal;
    }

    @Override
    public void actionISDMMsg_actionPerformed(ActionEvent e) throws Exception {
        if (this.billOptionsHelper != null) {
            this.billOptionsHelper.putConfigType("ISDMMsg", this.chkMenuItemIsDMMsg.isSelected());
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (this.initBillOptions) {
            this.initBillOptions = false;
            if (this.getSCMBizDataVO() != null) {
                this.billOptionsHelper = new BillOptionsHelper(this, this.getSCMBizDataVO().getOptionConfigMap());
                this.chkMenuItemIsDMMsg.setSelected(BillOptionsHelper.takeConfigType(this.getSCMBizDataVO().getOptionConfigMap(), "ISDMMsg"));
                this.chkMenuItemTransAssistQty.setSelected(BillOptionsHelper.takeConfigType(this.getSCMBizDataVO().getOptionConfigMap(), "chkMenuItemTransAssistQty"));
                this.chkMenuItemTransQty.setSelected(BillOptionsHelper.takeConfigType(this.getSCMBizDataVO().getOptionConfigMap(), "chkMenuItemTransQty", true));
                this.assistForNumber = BillOptionsHelper.takeConfigType(this.getSCMBizDataVO().getOptionConfigMap(), "isTransAssistByQty", true);
                this.numberForAssist = BillOptionsHelper.takeConfigType(this.getSCMBizDataVO().getOptionConfigMap(), "isTransQtyByAssist", false);
            } else {
                this.chkMenuItemTransAssistQty.setSelected(true);
                this.chkMenuItemTransQty.setSelected(true);
                this.assistForNumber = true;
                this.numberForAssist = false;
                this.billOptionsHelper = new BillOptionsHelper(this, null);
            }
            this.menuItemBillOptions.setVisible(false);
            this.chkMenuItemIsDMMsg.setEnabled(true);
            this.chkMenuItemIsDMMsg.setVisible(true);
            this.menuSubmitOption.setVisible(true);
            this.chkMenuItemSubmitAndAddNew.setVisible(true);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected MaterialInfo[] verifyMaterials(MaterialInfo[] materials, int rowIdx, Map dataMap, String materialFieldname) throws Exception {
        if (!this.chkMenuItemIsDMMsg.isSelected() && !this.billOptionsHelper.isSameMaterialTip()) {
            return materials;
        }
        MaterialInfo[] infos = materials;
        int len = materials.length;
        ArrayList<MaterialInfo> materialList = new ArrayList<MaterialInfo>(len);
        for (int i = 0; i < len; ++i) {
            MaterialInfo info = infos[i];
            if (info != null && this.checkEntryMaterialDouble(info, materialFieldname, rowIdx)) {
                info = null;
            }
            if (info == null) continue;
            materialList.add(info);
        }
        if (materialList.size() != 0) {
            return materialList.toArray(new MaterialInfo[0]);
        }
        return null;
    }

    public boolean checkEntryMaterialDouble(MaterialInfo aMaterialInfo, String materialCol, int rowIndex) {
        MaterialInfo eMaterialInfo = null;
        StringBuffer msg = new StringBuffer();
        int num = this.getDetailTable().getRowCount();
        for (int i = 0; i < num; ++i) {
            if (this.getDetailTable().getRowCount() == 1 || i == rowIndex || this.getDetailTable().getRow(i).getCell(materialCol).getValue() == null || !(eMaterialInfo = (MaterialInfo)this.getDetailTable().getRow(i).getCell(materialCol).getValue()).getId().toString().equals(aMaterialInfo.getId().toString())) continue;
            return !MsgBox.isYes((int)MsgBox.showConfirm2New((Component)((Object)this), (String)(aMaterialInfo.getName() + "," + SDSMBillEditUI.getUIResource("isDoubleMaterial"))));
        }
        return false;
    }

    public boolean checkEntryMaterialDouble(MaterialInfo aMaterialInfo, String materialCol) {
        MaterialInfo eMaterialInfo = null;
        int num = this.getDetailTable().getRowCount();
        for (int i = 0; i < num; ++i) {
            if (this.getDetailTable().getRowCount() == 1 || this.getDetailTable().getRow(i).getCell(materialCol).getValue() == null || !(eMaterialInfo = (MaterialInfo)this.getDetailTable().getRow(i).getCell(materialCol).getValue()).getId().toString().equals(aMaterialInfo.getId().toString())) continue;
            return !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)SDSMBillEditUI.getUIResource("isDoubleMaterial")));
        }
        return false;
    }

    public boolean checkEntryMaterialQtyDouble(MaterialInfo aMaterialInfo, String materialCol, String aQty, String qtyCol) {
        MaterialInfo eMaterialInfo = null;
        String eQty = "";
        int num = this.getDetailTable().getRowCount();
        for (int i = 0; i < num; ++i) {
            if (this.getDetailTable().getRowCount() == 1 || this.getDetailTable().getRow(i).getCell(materialCol).getValue() == null) continue;
            eMaterialInfo = (MaterialInfo)this.getDetailTable().getRow(i).getCell(materialCol).getValue();
            if (this.getDetailTable().getRow(i).getCell(qtyCol).getValue() != null) {
                eQty = ((BigDecimal)this.getDetailTable().getRow(i).getCell(qtyCol).getValue()).toString();
            }
            if (!eMaterialInfo.getId().toString().equals(aMaterialInfo.getId().toString()) || !eQty.equals(aQty)) continue;
            return !MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)SDSMBillEditUI.getUIResource("isDoubleMaterial")));
        }
        return false;
    }

    public static String getUIResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)key);
    }

    protected void setTableToSumField() {
        if (this.getDetailTable() != null && this.getSumColNames() != null) {
            this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
        }
    }

    protected String[] getSumColNames() {
        return null;
    }

    @Override
    public void actionBillOptions_actionPerformed(ActionEvent e) throws Exception {
        this.billOptionsHelper.getUI(null).show();
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.billOptionsHelper.isCopyHead()) {
            super.doCopyDataObjectWithHeader(e, null);
        } else {
            super.actionCopy_actionPerformed(e);
        }
    }

    protected void setDataObjectPropertyForHeaderCopy(AbstractObjectValue dataObject) {
        ((SCMBillBaseInfo)dataObject).setAuditor(null);
        ((SCMBillBaseInfo)dataObject).setAuditTime(null);
        ((SCMBillBaseInfo)dataObject).setModifier(null);
        ((SCMBillBaseInfo)dataObject).setModificationTime(null);
        ((SCMBillBaseInfo)dataObject).setBaseStatus(BillBaseStatusEnum.ADD);
        ((SCMBillBaseInfo)dataObject).setSourceBillType(null);
        ((SCMBillBaseInfo)dataObject).setSourceBillId(null);
        try {
            Timestamp curDate = SCMClientUtils.getServerDate();
            ((SCMBillBaseInfo)dataObject).setBizDate(curDate);
            ((SCMBillBaseInfo)dataObject).setCreateTime(curDate);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.useMenuItemBillOptions()) {
            if (this.menuItemBillOptions.isVisible() && this.editData.getBaseStatus().getValue() == 0) {
                this.chkMenuItemSubmitAndAddNew.setSelected(this.billOptionsHelper.isSubmitAndAddnew());
            } else {
                this.chkMenuItemSubmitAndAddNew.setSelected(false);
            }
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected boolean useMenuItemBillOptions() {
        return false;
    }

    @Override
    protected void initSCMBizDataVO(SCMBizDataVO vo) {
        if (this.isFirstLoading()) {
            vo.setOptionConfigNames(new String[]{"IsSubmitAndAddnew", "IsSameMerialTip", "IsCopyHead", "IsCopyBill", "ISDMMsg", "isQtyUnctrl", "isTransAssistByQty", "isTransQtyByAssist", "chkMenuItemTransAssistQty", "chkMenuItemTransQty"});
            vo.setUiClassName(this.getMetaDataPK().getFullName());
        }
        super.initSCMBizDataVO(vo);
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.allowAddEntry() || this.isIgnoreIsBOTPBill || STATUS_ALTER.equalsIgnoreCase(this.getOprtState())) {
            if (STATUS_ALTER.equalsIgnoreCase(this.getOprtState()) && !this.isAlterAddMaterial()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getSDSMResource("BILL_ALTER_CANNOT_ADDLINE"));
                return;
            }
            super.actionAddLine_actionPerformed(e);
        }
    }

    protected void addLine(KDTable table) {
        if (table == this.getDetailTable()) {
            if (this.allowAddEntry() || this.isIgnoreIsBOTPBill || STATUS_ALTER.equalsIgnoreCase(this.getOprtState())) {
                try {
                    if (STATUS_ALTER.equalsIgnoreCase(this.getOprtState()) && !this.isAlterAddMaterial()) {
                        return;
                    }
                    super.addLine(table);
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (BOSException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
        } else {
            super.addLine(table);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.allowAddEntry() || this.isIgnoreIsBOTPBill) {
            if (STATUS_ALTER.equalsIgnoreCase(this.getOprtState())) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getSDSMResource("BILL_ALTER_CANNOT_INSERTLINE"));
                return;
            }
            super.actionInsertLine_actionPerformed(e);
        }
    }

    protected void checkRemoveLineOnAlter() {
        if (STATUS_ALTER.equalsIgnoreCase(this.getOprtState()) || "ALTER".equalsIgnoreCase(this.getOprtState())) {
            KDTable table = this.getDetailTable();
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            if (size == 0 || this.isTableColumnSelected(table)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                SysUtil.abort();
            }
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                KDTSelectBlock selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                for (int i = top; i <= bottom; ++i) {
                    if (((SCMBillEntryBaseInfo)table.getRow(i).getUserObject()).getId() == null || EntryBaseStatusEnum.ADD.equals((Object)((SCMBillEntryBaseInfo)table.getRow(i).getUserObject()).getBaseStatus())) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)this.getSDSMResource("BILL_ALERT_CANNOT_DELETE_OLD_LINE"));
                    SysUtil.abort();
                }
            }
        }
    }

    protected final String getSDSMResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.common.SDSMResource", (String)key);
    }

    @Override
    protected boolean isAlterAddMaterial() throws EASBizException, BOSException {
        return super.isAlterAddMaterial();
    }

    @Override
    public void actionTransQty_actionPerformed(ActionEvent e) throws Exception {
        BillOptionsHelper.putConfigType((IUIObject)this, "chkMenuItemTransQty", this.chkMenuItemTransQty.isSelected());
    }

    @Override
    public void actionTransAssistQty_actionPerformed(ActionEvent e) throws Exception {
        BillOptionsHelper.putConfigType((IUIObject)this, "chkMenuItemTransAssistQty", this.chkMenuItemTransAssistQty.isSelected());
    }

    @Override
    protected String getBillEntryName() {
        return "entries";
    }

    @Override
    protected boolean isSupportF12() {
        return true;
    }

    protected String getQtyColName() {
        return "qty";
    }

    @Override
    protected HashMap getMaterialQueryConditions() {
        HashMap<String, MaterialInfo> conditions = new HashMap<String, MaterialInfo>();
        KDTSelectBlock selectBlock = this.getDetailTable().getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.getDetailTable().getRow(rowIndex);
            ICell cell = null;
            if (row != null) {
                cell = row.getCell(this.getMaterialName());
            }
            if (cell != null) {
                MaterialInfo material = (MaterialInfo)cell.getValue();
                conditions.put("MATERIAL", material);
            }
        }
        return conditions;
    }

    @Override
    protected void afterQueryByMaterial(int rowIndex, int rowCount) throws Exception {
        super.afterQueryByMaterial(rowIndex, rowCount);
    }

    protected AdminOrgUnitInfo getAdminUnitByPerson(PersonInfo aPersonInfo) throws BOSException {
        AdminOrgUnitInfo aAdminOrgUnitInfo = null;
        PersonCollection personCollection = PersonFactory.getRemoteInstance().getPersonCollection("select gkAdmin.* where id ='" + aPersonInfo.getId().toString() + "'");
        if (personCollection.size() > 0) {
            aAdminOrgUnitInfo = personCollection.get(0).getGkAdmin();
        }
        return aAdminOrgUnitInfo;
    }
}

