/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SplitOptionConfig {
    private static final Logger logger = CoreUIObject.getLogger(SplitOptionConfig.class);
    private int splitNum = 2;
    private int splitType = 0;
    private int splitPos = 0;
    private String editUIName = null;
    private Map configMap = new HashMap();

    public SplitOptionConfig(String editUIName) {
        this.editUIName = editUIName;
        this.cacheCinfigValue(new String[]{"splitNum", "splitType", "splitPos"});
        this.splitNum = this.getConfigValue("splitNum", 2);
        this.splitType = this.getConfigValue("splitType", 0);
        this.splitPos = this.getConfigValue("splitPos", 0);
    }

    private void cacheCinfigValue(String[] names) {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("billClassName", (Object)this.editUIName);
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        filter.appendFilterItem("userID", (Object)userId);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            set.add(names[i]);
            this.configMap.put(this.editUIName + names[i] + userId, null);
        }
        filter.getFilterItems().add(new FilterItemInfo("configType", set, CompareType.INCLUDE));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            SMSDBillConfigCollection configCol = SMSDBillConfigFactory.getRemoteInstance().getSMSDBillConfigCollection(ev);
            int size = configCol.size();
            for (int i = 0; i < size; ++i) {
                SMSDBillConfigInfo config = configCol.get(i);
                this.configMap.put(config.getBillClassName() + config.getConfigType() + userId, config);
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public SplitOptionConfig(String editUIName, HashMap optionConfigMap) {
        this.editUIName = editUIName;
        if (optionConfigMap != null) {
            this.splitNum = optionConfigMap.get("splitNum") == null ? 2 : Integer.valueOf(optionConfigMap.get("splitNum").toString());
            this.splitType = optionConfigMap.get("splitType") == null ? 0 : Integer.valueOf(optionConfigMap.get("splitType").toString());
            this.splitPos = optionConfigMap.get("splitPos") == null ? 0 : Integer.valueOf(optionConfigMap.get("splitPos").toString());
        }
    }

    private SMSDBillConfigInfo getConfInfo(String configKey) throws BOSException {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.configMap.containsKey(this.editUIName + configKey + userId)) {
            return (SMSDBillConfigInfo)this.configMap.get(this.editUIName + configKey + userId);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)this.editUIName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configKey, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        if (aSMSDBillConfigCollection.size() > 0) {
            aSMSDBillConfig = aSMSDBillConfigCollection.get(0);
        }
        return aSMSDBillConfig;
    }

    private int getConfigValue(String configKey, int defaultValue) {
        int result = defaultValue;
        try {
            SMSDBillConfigInfo config = this.getConfInfo(configKey);
            if (config != null) {
                result = Integer.valueOf(config.getConfigValue().toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error getting split config, error is:" + e));
            result = defaultValue;
        }
        return result;
    }

    private void saveConfigValue(String configKey, int configValue) {
        try {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)this.editUIName, CompareType.EQUALS);
            FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)SysContext.getSysContext().getCurrentUserInfo().getId(), CompareType.EQUALS);
            FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configKey, CompareType.EQUALS);
            filter.getFilterItems().add(billClassNameFilter);
            filter.getFilterItems().add(userIDFilter);
            filter.getFilterItems().add(configTypeFilter);
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
            SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
            SMSDBillConfigInfo config = null;
            config = aSMSDBillConfigCollection.size() > 0 ? aSMSDBillConfigCollection.get(0) : new SMSDBillConfigInfo();
            config.setConfigValue(String.valueOf(configValue));
            config.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
            config.setBillClassName(this.editUIName);
            config.setConfigType(configKey);
            iSMSDBillConfig.submit(config);
        }
        catch (Exception e) {
            logger.error((Object)("Error saving split config, error is:" + e));
        }
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public void setSplitNum(int splitNum) {
        if (this.splitNum != splitNum) {
            this.splitNum = splitNum;
            this.saveConfigValue("splitNum", splitNum);
        }
    }

    public int getSplitType() {
        return this.splitType;
    }

    public void setSplitType(int splitType) {
        if (this.splitType != splitType) {
            this.splitType = splitType;
            this.saveConfigValue("splitType", splitType);
        }
    }

    public int getSplitPos() {
        return this.splitPos;
    }

    public void setSplitPos(int splitPos) {
        if (this.splitPos != splitPos) {
            this.splitPos = splitPos;
            this.saveConfigValue("splitPos", splitPos);
        }
    }
}

