/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMMinusFormattedTextField;
import java.math.BigDecimal;
import javax.swing.JTextField;

public final class FormattedEditorFactory {
    private static KDFormattedTextField[] kdFtfs = new KDFormattedTextField[22];
    private static KDTDefaultCellEditor[] kdCellEditors = new KDTDefaultCellEditor[22];
    private static KDFormattedTextField ratedFtfs = new KDFormattedTextField();
    private static KDTDefaultCellEditor ratedCellEditor;
    private static KDFormattedTextField[] disFtfs;
    private static KDTDefaultCellEditor[] disCellEditors;
    private static KDFormattedTextField[] minusFtfs;
    private static KDTDefaultCellEditor[] minusEditors;
    private static final int MAXPRESION = 10;

    private FormattedEditorFactory() {
    }

    public static KDTDefaultCellEditor getBigDecimalCellEditor(int precision, boolean isNegatived) {
        int idx = FormattedEditorFactory.getIndex(precision, isNegatived);
        FormattedEditorFactory.createBigDecimalCellEditor(idx, isNegatived);
        return kdCellEditors[idx];
    }

    public static KDTDefaultCellEditor getMinusCellEditor(int precision) {
        return FormattedEditorFactory.createMinusCellEditor(FormattedEditorFactory.getIndex(precision, false));
    }

    public static KDFormattedTextField getMinusFormattedTextField(int precision) {
        return FormattedEditorFactory.createMinusFormattedTextField(FormattedEditorFactory.getIndex(precision, false));
    }

    public static KDFormattedTextField getBigDecimalFormattedTextField(int precision, boolean isNegatived) {
        int idx = FormattedEditorFactory.getIndex(precision, isNegatived);
        FormattedEditorFactory.createBigDecimalFormattedTextField(idx, isNegatived);
        return kdFtfs[idx];
    }

    public static KDTDefaultCellEditor getRatedCellEditor() {
        return ratedCellEditor;
    }

    public static KDTDefaultCellEditor getDiscountCellEditor(int precision) {
        if (precision > 10) {
            throw new IndexOutOfBoundsException("Precision must be less and equal than 10");
        }
        if (disCellEditors[precision] == null) {
            FormattedEditorFactory.createDiscountFormattedTextField(precision);
            FormattedEditorFactory.disCellEditors[precision] = new KDTDefaultCellEditor((JTextField)disFtfs[precision]);
        }
        return disCellEditors[precision];
    }

    private static int getIndex(int precision, boolean isNegatived) {
        if (precision > 10) {
            throw new IndexOutOfBoundsException("Precision must be less and equal than 10");
        }
        int idx = precision;
        if (isNegatived) {
            idx = 10 + precision + 1;
        }
        return idx;
    }

    private static KDFormattedTextField createMinusFormattedTextField(int i) {
        if (minusFtfs[i] == null) {
            FormattedEditorFactory.minusFtfs[i] = new SCMMinusFormattedTextField();
            minusFtfs[i].setDataType(1);
            minusFtfs[i].setPrecision(i);
            minusFtfs[i].setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
            minusFtfs[i].setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            minusFtfs[i].setHorizontalAlignment(4);
            minusFtfs[i].setSupportedEmpty(true);
            minusFtfs[i].setRemoveingZeroInDispaly(false);
            minusFtfs[i].setNegatived(false);
        }
        return minusFtfs[i];
    }

    private static KDTDefaultCellEditor createMinusCellEditor(int i) {
        if (minusEditors[i] == null) {
            FormattedEditorFactory.minusEditors[i] = new KDTDefaultCellEditor((JTextField)FormattedEditorFactory.createMinusFormattedTextField(i));
        }
        return minusEditors[i];
    }

    private static void createBigDecimalFormattedTextField(int i, boolean isNegatived) {
        if (kdFtfs[i] == null) {
            FormattedEditorFactory.kdFtfs[i] = new KDFormattedTextField();
            kdFtfs[i].setDataType(1);
            kdFtfs[i].setPrecision(i % 11);
            kdFtfs[i].setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
            kdFtfs[i].setMinimumValue((Comparable)SCMClientUtils.MINVAL);
            kdFtfs[i].setHorizontalAlignment(4);
            kdFtfs[i].setSupportedEmpty(true);
            kdFtfs[i].setRemoveingZeroInDispaly(false);
            kdFtfs[i].setNegatived(isNegatived);
        }
    }

    private static void createBigDecimalCellEditor(int i, boolean isNegatived) {
        if (kdCellEditors[i] == null) {
            FormattedEditorFactory.createBigDecimalFormattedTextField(i, isNegatived);
            FormattedEditorFactory.kdCellEditors[i] = new KDTDefaultCellEditor((JTextField)kdFtfs[i]);
        }
    }

    private static void createDiscountFormattedTextField(int i) {
        if (disFtfs[i] == null) {
            FormattedEditorFactory.disFtfs[i] = new KDFormattedTextField();
            disFtfs[i].setDataType(1);
            disFtfs[i].setPrecision(i);
            disFtfs[i].setMaximumValue((Comparable)new BigDecimal("99.9999999999"));
            disFtfs[i].setMinimumValue((Comparable)SCMClientUtils.ZERO);
            disFtfs[i].setRemoveingZeroInDispaly(false);
            disFtfs[i].setSupportedEmpty(true);
        }
    }

    static {
        ratedFtfs.setDataType(1);
        ratedFtfs.setPrecision(2);
        ratedFtfs.setRemoveingZeroInDispaly(false);
        ratedFtfs.setMinimumValue((Comparable)SCMClientUtils.ZERO);
        ratedFtfs.setMaximumValue((Comparable)new BigDecimal("100.00"));
        ratedFtfs.setSupportedEmpty(true);
        ratedFtfs.setDataVerifierType(12);
        ratedCellEditor = new KDTDefaultCellEditor((JTextField)ratedFtfs);
        disFtfs = new KDFormattedTextField[11];
        disCellEditors = new KDTDefaultCellEditor[11];
        minusFtfs = new SCMMinusFormattedTextField[11];
        minusEditors = new KDTDefaultCellEditor[11];
    }
}

