/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.client.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SupplierInfoCondition;
import com.kingdee.eas.basedata.scm.sm.srm.SupplierInfoConditionCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.batchaction.util.ResourceUtils;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.client.KDTableUtils;
import com.kingdee.eas.scm.common.client.SCMBillEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.scm.common.client.helper.UiHandlingHelper;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.ListMap;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import com.kingdee.eas.scm.common.util.PrecisionUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;

public class PurUiHandlingHelper
extends UiHandlingHelper {
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(PurUiHandlingHelper.class);
    private Map tempMap = new HashMap();
    private boolean isCalcThisTurn = true;
    private boolean isTax = false;
    ListMap convertMap = null;

    public PurUiHandlingHelper(OrgType mainOrgType, SCMBillEditUI editUi) {
        super(mainOrgType, editUi);
    }

    public boolean isSuppInfoOnDeliveryDate() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURORDER004", false);
    }

    public boolean isPriceOnQty() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP007", false);
    }

    public boolean isUseRecOrg() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP010", false);
    }

    public boolean isEnablePurOrderAssistAttr() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURORDER100", false);
    }

    private boolean isUseSupplyList() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP001", false);
    }

    private boolean isUseSupplyPrice() throws EASBizException, BOSException {
        return this.isPurParamPUR("PURSUP008", false);
    }

    private SupplierInfoConditionCollection makeSupplierInfoConditionCollection(MaterialInfo[] materialInfos, Map[] params, boolean isDeliveryDate) throws EASBizException, BOSException {
        SupplierInfo supplierInfo = (SupplierInfo)this.prmtSupplier.getData();
        OrgUnitInfo mainOrgInfo = this.getMainOrgInfo();
        if (supplierInfo == null || mainOrgInfo == null) {
            return null;
        }
        ObjectUuidPK purOrgPK = new ObjectUuidPK(mainOrgInfo.getId().toString());
        ObjectUuidPK supplierPK = new ObjectUuidPK(supplierInfo.getId().toString());
        SupplierInfoConditionCollection supplierInfoConCol = new SupplierInfoConditionCollection();
        Date curbizDate = (Date)this.pkBizDate.getValue();
        for (int i = 0; i < materialInfos.length; ++i) {
            if (materialInfos[i] == null) continue;
            SupplierInfoCondition condition = new SupplierInfoCondition();
            condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
            condition.setSupplierPK((IObjectPK)supplierPK);
            Map pinfo = params[i];
            String unitpk = "";
            BigDecimal qty = ZERO;
            Date jhdate = null;
            Integer materialPurchaseType = null;
            String recOrgPKid = "";
            if (pinfo != null) {
                qty = (BigDecimal)pinfo.get("qty");
                unitpk = pinfo.get("unitpk").toString();
                jhdate = (Date)pinfo.get("date");
                if (pinfo.get("materialPurchaseType") != null) {
                    materialPurchaseType = Integer.valueOf(pinfo.get("materialPurchaseType").toString());
                }
                if (pinfo.get("recOrgPk") != null) {
                    recOrgPKid = pinfo.get("recOrgPk").toString();
                }
            }
            condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materialInfos[i].getId().toString()));
            if (qty != null) {
                condition.setQty(qty);
            }
            if (unitpk.length() > 0) {
                condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitpk));
            }
            if (recOrgPKid.length() > 0) {
                condition.setRecOrgUnitPK((IObjectPK)new ObjectUuidPK(recOrgPKid));
            }
            condition.setisPriceOnQty(this.isPriceOnQty());
            condition.setisUseSupport(this.isUseSupplyPrice());
            condition.setisUseRecOrg(this.isUseRecOrg());
            if (isDeliveryDate) {
                condition.setDate(jhdate);
            } else {
                condition.setDate(curbizDate);
            }
            condition.setDeliveryDate(isDeliveryDate);
            supplierInfoConCol.add(condition);
            if (materialPurchaseType == null) continue;
            condition.setMaterialPurchaseType(materialPurchaseType.intValue());
        }
        return supplierInfoConCol;
    }

    @Override
    public void changedByMaterials(int rowIdx, MaterialInfo[] materialInfos, Map[] params, Map dataMap, int changeLevel, EventObject e, boolean allowAddEntry) throws Exception {
        if (materialInfos == null || materialInfos.length == 0) {
            return;
        }
        PurEntryDataVO vo = new PurEntryDataVO();
        PurEntryDataVO resultVO = null;
        this.prepareBeforeLoadData(vo, changeLevel, rowIdx, materialInfos, params);
        vo.setFromBotp(this.isBotpBill());
        if (changeLevel == 0) {
            vo.setModifyMaterial(true);
        }
        vo.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getData());
        vo.setBaseCurrencyInfo(this.getCurrencyInfo());
        if (this.prmtCompanyOrgUnit != null && this.prmtCompanyOrgUnit.getData() != null) {
            vo.setCompanyOrgUnitInfo((CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getData());
        }
        resultVO = SCMGroupFacadeFactory.getRemoteInstance().loadPurComplexData(vo);
        if (changeLevel == 0 && resultVO != null && resultVO.getMmuPrecisions() != null) {
            dataMap.put("muPrecisionsMap", resultVO.getMmuPrecisions());
        }
        this.getConfigMap().put("SCMENTRYVO", resultVO);
        this.handleEntries(rowIdx, materialInfos, changeLevel, resultVO, dataMap, params, allowAddEntry);
    }

    private PurEntryDataVO prepareBeforeLoadData(PurEntryDataVO vo, int changeLevel, int rowIdx, MaterialInfo[] materialInfos, Map[] params) throws EASBizException, BOSException {
        boolean isDeliveryDate = false;
        SupplierInfo supplierInfo = null;
        Object supplierObj = this.prmtSupplier.getData();
        if (supplierObj != null) {
            supplierInfo = (SupplierInfo)supplierObj;
        }
        OrgUnitInfo mainOrgInfo = this.getMainOrgInfo();
        Date bizDate = null;
        isDeliveryDate = changeLevel == 3;
        vo.setSupplierInfo(supplierInfo);
        vo.setMainOrg(mainOrgInfo);
        vo.setBizDate(bizDate);
        vo.setMaterialInfos(materialInfos);
        vo.setPriceOnQty(this.isPriceOnQty());
        vo.setUseRecOrg(this.isUseRecOrg());
        vo.setSupplierInfoConditionCol(this.makeSupplierInfoConditionCollection(materialInfos, params, isDeliveryDate));
        vo.setIsLoadingSupplyInfo(true);
        vo.setIsLoadingSupplierRelative(true);
        MeasureUnitInfo[] baseUnits = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] units = new MeasureUnitInfo[materialInfos.length];
        MeasureUnitInfo[] assistUnits = new MeasureUnitInfo[materialInfos.length];
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            units[idxOfMaterial] = (MeasureUnitInfo)this.kdtEntries.getCell(rowIndex, this.TB_UNIT).getValue();
            baseUnits[idxOfMaterial] = (MeasureUnitInfo)this.kdtEntries.getCell(rowIndex, this.TB_BASEUNIT).getValue();
            assistUnits[idxOfMaterial] = (MeasureUnitInfo)this.kdtEntries.getCell(rowIndex, this.TB_ASSISTUNIT).getValue();
            ++idxOfMaterial;
            ++rowIndex;
        }
        vo.setBaseMeasureUnitInfos(baseUnits);
        vo.setAssistMeasureUnitInfos(assistUnits);
        vo.setMeasureUnitInfos(units);
        vo.setOldMeasureUnitInfos(units);
        vo.setIsLoadingMmuPrecision(true);
        vo.setIsLoadingMou(true);
        vo.setIsLoadingMaterialPurchase(true);
        return vo;
    }

    private void carryDateFromFetchSupplyInfo(int rowIndex, ApprovedSupplierInfo approveInfo, MaterialPurchasingInfo materialPurchaseInfo, boolean isCheckSupplierEdit) throws BOSException, EASBizException {
        BigDecimal overDealBalance = ZERO;
        BigDecimal unDealBalance = ZERO;
        BigDecimal deliveryAdvanceDay = ZERO;
        BigDecimal deliveryDeferDay = ZERO;
        boolean isNotControlQty_Material = false;
        if (materialPurchaseInfo != null) {
            isNotControlQty_Material = materialPurchaseInfo.isIsNotControlQty();
        }
        boolean isNotControlQty_Current = false;
        boolean isTimeUnCtrl = false;
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).getValue() != null) {
            isNotControlQty_Current = Boolean.parseBoolean(this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).getValue().toString());
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).getValue() != null) {
            isTimeUnCtrl = Boolean.parseBoolean(this.kdtEntries.getRow(rowIndex).getCell(this.TB_TIMEUNCTRL).getValue().toString());
        }
        boolean isQuantityUnCtrl = isNotControlQty_Current;
        if (approveInfo != null) {
            if (approveInfo.getQtySupplyTop() != null) {
                overDealBalance = approveInfo.getQtySupplyTop();
            }
            if (approveInfo.getQtySupplyBottom() != null) {
                unDealBalance = approveInfo.getQtySupplyBottom();
            }
            if (approveInfo.getDayTop() != null) {
                deliveryAdvanceDay = approveInfo.getDayTop();
            }
            if (approveInfo.getDayBottom() != null) {
                deliveryDeferDay = approveInfo.getDayBottom();
            }
        } else if (materialPurchaseInfo != null) {
            overDealBalance = new BigDecimal(materialPurchaseInfo.getReceiveTopRatio());
            unDealBalance = new BigDecimal(materialPurchaseInfo.getReceiveBottomRatio());
            deliveryAdvanceDay = new BigDecimal(materialPurchaseInfo.getDaydAhead());
            deliveryDeferDay = new BigDecimal(materialPurchaseInfo.getDaysDelay());
        }
        if (this.isBotpBill("510b6503-0105-1000-e000-0107c0a812fd463ED552") && !((Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_RELATIONBILLADDFLAG).getValue()).booleanValue()) {
            boolean isEnableApprovedSupply;
            if (isNotControlQty_Material == isNotControlQty_Current && (isEnableApprovedSupply = this.isPurParamPUR("PURSUP001", false))) {
                boolean isUseSupplyList;
                if (approveInfo != null && approveInfo.getIsUseable().equals((Object)IsUseableEnum.Useable)) {
                    isQuantityUnCtrl = approveInfo.isQuantityUnCtrl();
                } else if (materialPurchaseInfo != null && (isUseSupplyList = materialPurchaseInfo.isUseSupplyList())) {
                    String materialName = (String)this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIALNAME).getValue();
                    String orgUnit = this.prmtPurchaseOrgUnit.getData().toString();
                    String supplier = this.prmtSupplier.getData().toString();
                    String[] strs = new String[]{orgUnit, supplier, materialName};
                    MsgBox.showInfo((String)ResourceUtils.getMessage((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"approvedSupplierNotExists", (String[])strs));
                    SysUtil.abort();
                }
            }
            if (approveInfo != null) {
                isTimeUnCtrl = approveInfo.isTimeUnCtrl();
            } else if (materialPurchaseInfo != null) {
                isTimeUnCtrl = materialPurchaseInfo.isIsNotControlTime();
            }
        } else if (approveInfo != null && approveInfo.getIsUseable().equals((Object)IsUseableEnum.Useable)) {
            isQuantityUnCtrl = approveInfo.isQuantityUnCtrl();
            isTimeUnCtrl = approveInfo.isTimeUnCtrl();
        } else if (materialPurchaseInfo != null) {
            isQuantityUnCtrl = materialPurchaseInfo.isIsNotControlQty();
            isTimeUnCtrl = materialPurchaseInfo.isIsNotControlTime();
        }
        this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).setValue((Object)isQuantityUnCtrl);
        this.kdtEntries.getRow(rowIndex).getCell(this.TB_TIMEUNCTRL).setValue((Object)isTimeUnCtrl);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").setValue((Object)overDealBalance);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").setValue((Object)unDealBalance);
        this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").setValue((Object)deliveryAdvanceDay);
        this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").setValue((Object)deliveryDeferDay);
        if (isCheckSupplierEdit) {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setLocked(false);
            if (isCheckSupplierEdit) {
                this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setLocked(false);
            }
            if (isCheckSupplierEdit) {
                this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").getStyleAttributes().setLocked(false);
            }
            if (isCheckSupplierEdit) {
                this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").getStyleAttributes().setLocked(false);
            }
        }
        if (isQuantityUnCtrl) {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").setValue((Object)false);
            this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").setValue((Object)false);
        }
        if (isTimeUnCtrl) {
            this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").setValue((Object)false);
            this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").setValue((Object)false);
        }
    }

    public void setSupplierLinkEdit(int rowIndex) {
        boolean isSuppinfo;
        if (this.kdtEntries.getRow(rowIndex).getCell("isSupInfo") == null) {
            return;
        }
        boolean bl = isSuppinfo = this.kdtEntries.getRow(rowIndex).getCell("isSupInfo").getValue() == null ? false : (Boolean)this.kdtEntries.getRow(rowIndex).getCell("isSupInfo").getValue();
        if (isSuppinfo) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("discountRate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TIMEUNCTRL).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").getStyleAttributes().setLocked(true);
        }
    }

    private void setSupplierInfoEdit(int rowIndex, boolean flag) {
        this.kdtEntries.getRow(rowIndex).getCell("deliverAdvanceDay").getStyleAttributes().setLocked(flag);
        this.kdtEntries.getRow(rowIndex).getCell("deliverDeferralDay").getStyleAttributes().setLocked(flag);
        if (this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate") != null) {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setLocked(flag);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setLocked(flag);
        }
        if (this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate") != null) {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setLocked(flag);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setLocked(flag);
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_QUANTITYUNCTRL).getStyleAttributes().setLocked(flag);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell("isQtyUnCtrl").getStyleAttributes().setLocked(flag);
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_TIMEUNCTRL) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TIMEUNCTRL).getStyleAttributes().setLocked(flag);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell("isTimeUnCtrl").getStyleAttributes().setLocked(flag);
        }
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE) != null) {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXRATE).getStyleAttributes().setLocked(flag);
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAX).getStyleAttributes().setLocked(flag);
        }
    }

    private void handleEntries(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, PurEntryDataVO resultVO, Map dataMap, Map[] params, boolean allowAddEntry) throws Exception {
        int length = materialInfos.length;
        boolean isFromBotp = this.isBotpBill();
        MeasureUnitInfo[] units = resultVO.getMeasureUnitInfos();
        MeasureUnitInfo[] baseUnits = resultVO.getBaseMeasureUnitInfos();
        MeasureUnitInfo[] assistUnits = resultVO.getAssistMeasureUnitInfos();
        int[] rowArray = new int[length];
        MaterialPurchasingInfo materialPurInfo = null;
        Map materialPlanMap = (Map)dataMap.get("materialPlanMap");
        this.convertMap = null;
        this.convertMap = new ObjectListMap(4);
        MaterialInfo materialInfo = null;
        MaterialPlanInfo matPlanInfo = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        int i = 0;
        int row = rowIdx;
        while (i < length) {
            materialInfo = materialInfos[i];
            if (materialInfo != null) {
                if (changeLevel == 0) {
                    this.carryMaterialNameAndModel(materialInfo, row);
                    SCMClientUtils.changeTableColPrecision(materialInfo.getPricePrecision(), this.kdtEntries, this.PRICEPRECISIONTAB, row);
                    if (!(isFromBotp && changeLevel != 0 || this.kdtEntries.getRow(row).getCell(this.TB_QTY).getValue() != null)) {
                        this.kdtEntries.getRow(row).getCell(this.TB_QTY).setValue((Object)ZERO);
                    }
                    this.setEntryAssistProperty(row, materialInfo, allowAddEntry);
                }
                if (this.kdtEntries.getRow(row).getCell(this.TB_ISPRESENT).getValue() == null || !((Boolean)this.kdtEntries.getRow(row).getCell(this.TB_ISPRESENT).getValue()).booleanValue()) {
                    Map materialPurMap;
                    if (!(resultVO.getSupplierBaseInfo() == null || this.kdtEntries.getRow(row).getCell(this.TB_ISPRESENT).getValue() != null && ((Boolean)this.kdtEntries.getRow(row).getCell(this.TB_ISPRESENT).getValue()).booleanValue())) {
                        this.kdtEntries.getRow(row).getCell(this.TB_TAXRATE).setValue((Object)resultVO.getSupplierBaseInfo().getTaxRate());
                    }
                    if (changeLevel <= 5 && (materialPurMap = resultVO.getMaterialPurchasingInfos()) != null) {
                        Object mpObj = materialPurMap.get(materialInfos[i].getId().toString());
                        materialPurInfo = (MaterialPurchasingInfo)mpObj;
                    }
                    rowArray[i] = row;
                    this.handleSupplyInfo(resultVO, materialInfos, i, row, dataMap, materialPurInfo, units, changeLevel, params);
                    if (isFromBotp) {
                        MeasureUnitInfo unit = (MeasureUnitInfo)this.kdtEntries.getRow(row).getCell(this.TB_UNIT).getValue();
                        if (units[i] != null && unit != null && !units[i].getId().toString().equals(unit.getId().toString())) {
                            this.convertMap.put2(new Integer(row), new Object[]{materialInfos[i].getId().toString(), unit.getId().toString(), units[i].getId().toString()});
                            this.isCalcThisTurn = false;
                        }
                    }
                    if (this.isCalcThisTurn && (changeLevel != 0 || i <= 0)) {
                        if (this.cbIsInTax.isSelected()) {
                            this.calEntryTaxAmount(row, 0);
                            this.calEntryTax(row, 0);
                            this.calEntryAmount(row, 0);
                            this.calEntryDiscountAmount(row, 0);
                        } else {
                            this.calEntryAmount(row, 0);
                            this.calEntryTax(row, 0);
                            this.calEntryTaxAmount(row, 0);
                            this.calEntryDiscountAmount(row, 0);
                        }
                        this.calEntryActualTaxPrice(row, 0);
                        this.calEntryActualPrice(row, 0);
                    }
                    this.setEntryDiscountEditor(row, materialInfo);
                    this.entryQtyUnCtrl(row, KDTableUtils.getFieldValue(this.kdtEntries, row, this.TB_QUANTITYUNCTRL));
                    this.entryTimeUnCtrl(row, KDTableUtils.getFieldValue(this.kdtEntries, row, this.TB_TIMEUNCTRL));
                    if (materialPlanMap != null) {
                        storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(row).getCell(this.TB_STORAGEORGUNIT).getValue();
                        matPlanInfo = null;
                        if (materialInfo != null && materialInfo.getId() != null && storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
                            matPlanInfo = (MaterialPlanInfo)materialPlanMap.get(materialInfo.getId().toString() + storageOrgUnitInfo.getId().toString());
                        }
                        InvClientUtils.setProjectTrackEditable((KDTable)this.kdtEntries, (boolean)this.isBotpBill(), (boolean)true, (int)row, matPlanInfo, (String)this.TB_PROJECTNUM, (String)this.TB_TRACKNUM);
                    }
                }
            }
            ++i;
            ++row;
        }
        this.handleMeasureUnit(rowIdx, materialInfos, changeLevel, baseUnits, units, assistUnits, this.convertMap, rowArray, dataMap, resultVO, materialPurInfo, allowAddEntry);
    }

    private void calDAmountByDRate(int row, SupplyInfoInfo supplyInfo) {
        BigDecimal discountRate = supplyInfo.getDiscountRate();
        if (discountRate != null) {
            this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT).setValue((Object)discountRate);
        }
        this.calEntryDiscountAmount(row, 0);
    }

    private void handleMeasureUnit(int rowIdx, MaterialInfo[] materialInfos, int changeLevel, MeasureUnitInfo[] baseUnits, MeasureUnitInfo[] units, MeasureUnitInfo[] assistUnits, ListMap convertMap, int[] rowIndexs, Map dataMap, PurEntryDataVO resultVO, MaterialPurchasingInfo materialPurInfo, boolean allowAddEntry) throws EASBizException, BOSException {
        if (this.editData == null) {
            return;
        }
        boolean isDirectOrInner = this.editData.getBizType() != null && (this.editData.getBizType().getId().toString().equalsIgnoreCase("d8e80652-010b-1001-e000-04c5c0a812202407435C") || this.editData.getBizType().getId().toString().equalsIgnoreCase("d8e80652-0111-1000-e000-04c5c0a812202407435C"));
        boolean isFromBotp = this.isBotpBill();
        int idxOfMaterial = 0;
        int rowIndex = rowIdx;
        while (idxOfMaterial < materialInfos.length) {
            if (changeLevel == 0) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_BASEUNIT).setValue((Object)baseUnits[idxOfMaterial]);
                if (assistUnits[idxOfMaterial] != null) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTUNIT).setValue((Object)assistUnits[idxOfMaterial]);
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).getStyleAttributes().setLocked(true);
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTQTY).setValue(null);
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTUNIT).setValue(null);
                }
            }
            if (!isDirectOrInner) {
                if (!(isFromBotp || changeLevel != 0 && changeLevel != 2)) {
                    if (units[idxOfMaterial] != null) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).setValue((Object)units[idxOfMaterial]);
                    }
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getStyleAttributes().setLocked(false);
                } else if (isFromBotp && this.editData.getBillType() != null && this.editData.getBillType().getId().toString() == "510b6503-0105-1000-e000-010bc0a812fd463ED552" && (changeLevel == 0 || changeLevel == 2)) {
                    if (units[idxOfMaterial] != null) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).setValue((Object)units[idxOfMaterial]);
                    }
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getStyleAttributes().setLocked(false);
                } else if (allowAddEntry) {
                    if (units[idxOfMaterial] != null) {
                        this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).setValue((Object)units[idxOfMaterial]);
                    }
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getStyleAttributes().setLocked(false);
                }
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getStyleAttributes().setLocked(true);
            }
            if (changeLevel != 1 && changeLevel != 2 && changeLevel != 3) {
                this.calEntryBaseQty(rowIndex, 0);
            }
            if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue() == null || !((Boolean)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ISPRESENT).getValue()).booleanValue()) {
                boolean isEditSupplierInfo = (Boolean)dataMap.get("isEditSupplierInfo");
                if (materialPurInfo != null) {
                    boolean bl = isEditSupplierInfo ? true : (isEditSupplierInfo = !materialPurInfo.isUseSupplyList());
                }
                if (materialInfos[idxOfMaterial] != null) {
                    this.setSupplierInfoEdit(rowIndex, !isEditSupplierInfo);
                }
                try {
                    if (isEditSupplierInfo) {
                        this.entryTimeUnCtrl(rowIndex, KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_TIMEUNCTRL));
                        this.entryQtyUnCtrl(rowIndex, KDTableUtils.getFieldValue(this.kdtEntries, rowIndex, this.TB_QUANTITYUNCTRL));
                    }
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                }
                boolean assistQtyRecalAllowed = this.isPurParamPUR("PURORDER007", true);
                if (assistQtyRecalAllowed && changeLevel == 0) {
                    this.calEntryAssistQty(rowIndex, 0);
                }
                if (changeLevel != 2) {
                    this.handleMumUnitPrecision(resultVO, materialInfos, idxOfMaterial, rowIndex);
                }
                if (changeLevel == 0) {
                    SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfos[idxOfMaterial], resultVO.getBaseMeasureUnitInfos()[idxOfMaterial], this.kdtEntries, this.QTYPRECISIONFROMBASEUNITTAB, rowIndex);
                    SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfos[idxOfMaterial], resultVO.getAssistMeasureUnitInfos()[idxOfMaterial], this.kdtEntries, this.QTYPRECISIONFROMASSISTUNITTAB, rowIndex);
                }
            }
            ++idxOfMaterial;
            ++rowIndex;
        }
    }

    private void handleMumUnitPrecision(PurEntryDataVO resultVO, MaterialInfo[] materialInfos, int idxOfMaterial, int rowIndex) {
        if (this.kdtEntries.getRow(rowIndex).getCell(this.TB_ROWTYPE) == null) {
            return;
        }
        RowTypeInfo rowTypeInfo = (RowTypeInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_ROWTYPE).getValue();
        if (rowTypeInfo == null) {
            return;
        }
        if (rowTypeInfo.isIsHasMaterialNumber()) {
            SCMClientUtils.changeTableColPrecision(resultVO.getMmuPrecisions(), materialInfos[idxOfMaterial], resultVO.getMeasureUnitInfos()[idxOfMaterial], this.kdtEntries, this.QTYPRECISIONFROMUNITTAB, rowIndex);
        }
    }

    private void handleTransferRatio(PurEntryDataVO resultVO, ListMap convertMap) {
        if (convertMap == null || convertMap.size() == 0) {
            return;
        }
        Map transferRatioMap = resultVO.getMmuConvsRate();
        String oldKey = null;
        String newKey = null;
        String materialKey = null;
        BigDecimal oldRatio = new BigDecimal("0.00");
        BigDecimal newRatio = new BigDecimal("0.00");
        BigDecimal ratio = null;
        Object[] keys = convertMap.keySet().toArray();
        Integer row = null;
        for (int i = 0; i < keys.length; ++i) {
            row = (Integer)keys[i];
            materialKey = (String)convertMap.get(row, 0);
            oldKey = materialKey + (String)convertMap.get(row, 1);
            newKey = materialKey + (String)convertMap.get(row, 2);
            oldRatio = (BigDecimal)transferRatioMap.get(oldKey);
            newRatio = (BigDecimal)transferRatioMap.get(newKey);
            ratio = this.transferRatio(oldRatio, newRatio);
            this.dealWithPriceBy(ratio, row);
        }
    }

    private void dealWithPriceBy(BigDecimal ratio, int rowIndex) {
        int scale;
        BigDecimal price = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        int n = scale = this.kdtEntries.getColumn(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.kdtEntries.getCell(rowIndex, this.TB_PRICE).getEditor().getComponent()).getPrecision();
        if (price != null && ratio != null) {
            if (this.cbIsInTax.isSelected()) {
                BigDecimal taxPrice = (BigDecimal)this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
                BigDecimal baseUnitPrice = taxPrice.multiply(ratio).setScale(scale, 4);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)baseUnitPrice);
                this.calEntryPriceByTaxPrice(rowIndex, 0);
            } else {
                BigDecimal baseUnitPrice = price.multiply(ratio).setScale(scale, 4);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_PRICE).setValue((Object)baseUnitPrice);
                this.calEntryTaxPricebyPrice(rowIndex, 0);
            }
        }
        if (this.cbIsInTax.isSelected()) {
            this.calEntryTaxAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryAmount(rowIndex, 0);
        } else {
            this.calEntryAmount(rowIndex, 0);
            this.calEntryTax(rowIndex, 0);
            this.calEntryTaxAmount(rowIndex, 0);
        }
        this.calEntryActualTaxPrice(rowIndex, 0);
        this.calEntryActualPrice(rowIndex, 0);
    }

    private BigDecimal transferRatio(BigDecimal oldRatio, BigDecimal newRatio) {
        BigDecimal ratio = null;
        if (oldRatio == null || newRatio == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.00");
        int oldBool = newRatio.compareTo(zero);
        if (oldBool == 0) {
            return null;
        }
        ratio = oldRatio.divide(newRatio, 10, 4);
        return ratio;
    }

    private void handleSupplyInfo(PurEntryDataVO resultVO, MaterialInfo[] materialInfos, int materialIdx, int row, Map dataMap, MaterialPurchasingInfo materialPurchasingInfo, MeasureUnitInfo[] units, int changeLevel, Map[] params) throws EASBizException, BOSException {
        FetchSupplyInfoCollection fetchSupplyInfoCollection = resultVO.getFetchSupplyInfoCollection();
        OrgUnitInfo purPhaseOrgInfo = this.getMainOrgInfo();
        SupplierInfo supplierInfo = (SupplierInfo)this.prmtSupplier.getData();
        if (fetchSupplyInfoCollection == null || purPhaseOrgInfo == null || supplierInfo == null) {
            return;
        }
        ApprovedSupplierInfo approveInfo = fetchSupplyInfoCollection.getApprovedSupplierInfoBy(purPhaseOrgInfo.getId().toString(), supplierInfo.getId().toString(), materialInfos[materialIdx].getId().toString());
        if (approveInfo == null && Boolean.valueOf(String.valueOf(dataMap.get("isUseSupplyList"))).booleanValue()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purPhaseOrgInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialInfos[materialIdx].getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)1));
            evi.setFilter(filter);
            ApprovedSupplierCollection col = ApprovedSupplierFactory.getRemoteInstance().getApprovedSupColNoPermission(evi);
            if (col != null && col.size() > 0) {
                approveInfo = col.get(0);
            }
        }
        Date date = this.getBizDateOrDeliveryDate(approveInfo, (Date)this.pkBizDate.getValue(), row, changeLevel);
        if (!this.isSuppInfoOnDeliveryDate() && params[materialIdx] != null) {
            params[materialIdx].put("date", (Date)this.pkBizDate.getValue());
        }
        params[materialIdx].put("isUseSupplyPrice", new Boolean(this.isUseSupplyPrice()));
        params[materialIdx].put("isUseSupport", new Boolean(this.isPriceOnQty()));
        String materialPurchaseType = String.valueOf(1);
        if (params[materialIdx].get("materialPurchaseType") != null && params[materialIdx].get("materialPurchaseType").equals(materialPurchaseType)) {
            params[materialIdx].put("isUseRecOrg", Boolean.FALSE);
        } else {
            params[materialIdx].put("isUseRecOrg", new Boolean(this.isUseRecOrg()));
        }
        this.handleApproveInfo(approveInfo, materialPurchasingInfo, row, changeLevel);
    }

    public void calEntryDeliveryDate(ApprovedSupplierInfo approveInfo, int rowIndex) {
        Calendar cal = Calendar.getInstance();
        if (this.pkBizDate == null || this.pkBizDate.getValue() == null) {
            return;
        }
        if (this.isBotpBill() && (null == approveInfo || 0 == approveInfo.getLeadtime())) {
            return;
        }
        Date deliverDate = (Date)this.pkBizDate.getValue();
        cal.setTime(deliverDate);
        try {
            if (approveInfo != null) {
                cal.add(5, approveInfo.getLeadtime());
            }
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_DELIVERYDATE).setValue((Object)new Date(cal.getTime().getTime()));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private BigDecimal getTransPrice(MaterialPurchasingInfo materialPurchaseInfo, int rowIndex) throws EASBizException, BOSException {
        MeasureUnitInfo curUnitOldValue = materialPurchaseInfo.getUnit();
        MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_MATERIAL).getValue();
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(rowIndex).getCell(this.TB_UNIT).getValue();
        BigDecimal baseUnitPrice = materialPurchaseInfo.getPrice();
        if (curUnitOldValue == null || measureUnitInfo == null) {
            return baseUnitPrice;
        }
        baseUnitPrice = SCMClientUtils.getBaseUnitQtyFromData(curUnitOldValue, measureUnitInfo, materialInfo, baseUnitPrice);
        return baseUnitPrice;
    }

    private void clearWhenMaterialCleared(int i) {
        this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_MATERIALNAME).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_TAXRATE).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell("materialModel").setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_ASSISTPROPERTY).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_BASEUNIT).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_BASEQTY).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_UNIT).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_QTY).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_ASSISTUNIT).setValue(null);
        this.kdtEntries.getRow(i).getCell(this.TB_ASSISTQTY).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_PRICE).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_TAXPRICE).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_DISCOUNT).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_DISCOUNTAMOUNT).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_ACTUALPRICE).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_AMOUNT).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_TAX).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell(this.TB_TAXAMOUNT).setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell("receiveOverRate").setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell("receiveOwingRate").setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell("deliverAdvanceDay").setValue((Object)ZERO);
        this.kdtEntries.getRow(i).getCell("deliverDeferralDay").setValue((Object)ZERO);
    }

    public void setDiscountRate(SupplyInfoInfo priceInfo, int row) {
        if (priceInfo != null && priceInfo.getDiscountRate() != null) {
            if (this.kdtEntries.getRow(row).getCell("discountRate") != null) {
                this.kdtEntries.getRow(row).getCell("discountRate").setValue((Object)new BigDecimal(priceInfo.getDiscountRate().toString()));
            } else if (this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT) != null) {
                this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT).setValue((Object)new BigDecimal(priceInfo.getDiscountRate().toString()));
            }
        }
    }

    public void handlePriceInfo(int row, boolean iscalprice) throws EASBizException, BOSException {
        if (this.kdtEntries.getRow(row) == null) {
            return;
        }
        PurPriceInfo priceInfo = (PurPriceInfo)this.kdtEntries.getRow(row).getCell(this.TB_PRICE).getUserObject();
        if (priceInfo == null) {
            return;
        }
        this.isTax = true;
        if (this.cbIsInTax.isSelected()) {
            this.calByEntryTaxPriceChange(row, 0, iscalprice);
        } else {
            this.calByEntryPriceChange(row, 0, iscalprice);
        }
        this.isTax = false;
    }

    public void calByEntryPriceChange(int rowIndex, int colIndex, boolean iscalprice) {
        if (iscalprice) {
            this.calEntryTaxPricebyPrice(rowIndex, colIndex);
        }
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    public void calByEntryTaxPriceChange(int rowIndex, int colIndex, boolean iscalprice) {
        if (iscalprice) {
            this.calEntryPriceByTaxPrice(rowIndex, colIndex);
        }
        this.calEntryTotalTaxAmount(rowIndex, colIndex);
        this.calEntryTax(rowIndex, colIndex);
        this.calEntryAmount(rowIndex, colIndex);
        this.calEntryActualPrice(rowIndex, colIndex);
        this.calEntryActualTaxPrice(rowIndex, colIndex);
        this.calEntryDiscountAmount(rowIndex, colIndex);
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.setDiscountAmountMaxValue(rowIndex);
        this.setActualTaxPriceMaxValue(rowIndex);
        this.setTaxMaxValue(rowIndex);
    }

    private void handleApproveInfo(ApprovedSupplierInfo approveInfo, MaterialPurchasingInfo materialPurchasingInfo, int row, int changeLevel) throws EASBizException, BOSException {
        if (approveInfo != null) {
            if (this.isFirstSuppInfoTaxRate()) {
                this.kdtEntries.getRow(row).getCell(this.TB_TAXRATE).setValue((Object)approveInfo.getTaxRate());
            }
            this.handleSupplierMaterialRelated(approveInfo, row);
            if (changeLevel < 3) {
                this.calEntryDeliveryDate(approveInfo, row);
            }
        }
        this.carryDateFromFetchSupplyInfo(row, approveInfo, materialPurchasingInfo, this.isCheckSupplierEdit());
    }

    private void handleSupplierMaterialRelated(ApprovedSupplierInfo approveInfo, int row) {
        if (this.kdtEntries.getRow(row).getCell("supplierMaterialNumber") != null) {
            this.kdtEntries.getRow(row).getCell("supplierMaterialNumber").setValue((Object)approveInfo.getSupplierMaterialNumber());
        }
        if (this.kdtEntries.getRow(row).getCell("supplierMaterialName") != null) {
            this.kdtEntries.getRow(row).getCell("supplierMaterialName").setValue((Object)approveInfo.getSupplierMaterialName());
        }
        if (this.kdtEntries.getRow(row).getCell("supplierMaterialModel") != null) {
            this.kdtEntries.getRow(row).getCell("supplierMaterialModel").setValue((Object)approveInfo.getSupplierMaterialRule());
        }
    }

    private Date getBizDateOrDeliveryDate(ApprovedSupplierInfo approveInfo, Date bizDate, int rowIdx, int changeLevel) throws EASBizException, BOSException {
        Date date = bizDate;
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (approveInfo == null) {
            return date;
        }
        if (this.isSuppInfoOnDeliveryDate()) {
            if (changeLevel == 0 || changeLevel == 1 || changeLevel == 2) {
                if (changeLevel != 2 || !this.isBotpBill()) {
                    cal.add(5, approveInfo.getLeadtime());
                    date = cal.getTime();
                }
            } else if (changeLevel == 3 || changeLevel == 4) {
                date = this.kdtEntries.getRow(rowIdx).getCell(this.TB_DELIVERYDATE).getValue() != null ? (Date)this.kdtEntries.getRow(rowIdx).getCell(this.TB_DELIVERYDATE).getValue() : bizDate;
            }
        }
        return date;
    }

    private void calRelatedPriceColBy(PurEntryDataVO resultVO, SupplyInfoInfo priceInfo, MaterialPurchasingInfo materialPurchasingInfo, int row, Date date, Map dataMap) throws EASBizException, BOSException {
        boolean isPresent = (Boolean)this.kdtEntries.getRow(row).getCell(this.TB_ISPRESENT).getValue();
        if (isPresent) {
            this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT).setValue((Object)this.getZeroBy(this.getDiscountRate()));
            return;
        }
        if (date == null && (date = (Date)this.pkBizDate.getValue()) == null) {
            date = new Date();
        }
        Date disibleDate = priceInfo.getUneffectualDate();
        boolean tempStatus = false;
        if (this.cbIsInTax != null) {
            tempStatus = this.cbIsInTax.isSelected();
        }
        if (date.getTime() <= disibleDate.getTime()) {
            if (this.cbIsInTax != null) {
                this.cbIsInTax.setSelected(priceInfo.isIsTaxPrice());
            }
            if (priceInfo.getPrice() != null && priceInfo.getPrice().compareTo(ZERO) > 0 && dataMap.get("supplierCurrencyInfo") != null && resultVO.getCompanyOrgUnitInfo() != null && resultVO.getCurrencyInfo() != null && priceInfo.get("hasConvert") == null) {
                int scale = ((KDFormattedTextField)this.kdtEntries.getRow(row).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
                BigDecimal price = ZERO;
                price = PurUiHandlingHelper.calValueByCurrencyChange(resultVO.getCompanyOrgUnitInfo(), resultVO.getCurrencyInfo(), (CurrencyInfo)dataMap.get("supplierCurrencyInfo"), priceInfo.getPrice(), scale, (Date)this.pkBizDate.getValue());
                priceInfo.put("hasConvert", (Object)Boolean.TRUE);
                priceInfo.setPrice(price);
            }
            if (priceInfo.isIsTaxPrice()) {
                this.kdtEntries.getRow(row).getCell(this.TB_TAXPRICE).setValue((Object)priceInfo.getPrice());
                this.calEntryPriceByTaxPrice(row, 0);
                this.calByEntryTaxPriceChange(row, 0);
            } else {
                this.kdtEntries.getRow(row).getCell(this.TB_PRICE).setValue((Object)priceInfo.getPrice());
                this.calEntryTaxPricebyPrice(row, 0);
                this.calByEntryPriceChange(row, 0);
            }
            if (this.cbIsInTax != null) {
                this.cbIsInTax.setSelected(tempStatus);
            }
            this.setDiscountRate(priceInfo, row);
        } else {
            this.kdtEntries.getRow(row).getCell(this.TB_PRICE).setValue(null);
            this.kdtEntries.getRow(row).getCell(this.TB_TAXPRICE).setValue(null);
            if (this.kdtEntries.getRow(row).getCell("discountRate") != null) {
                this.kdtEntries.getRow(row).getCell("discountRate").setValue((Object)new BigDecimal("0.00"));
            } else if (this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT) != null) {
                this.kdtEntries.getRow(row).getCell(this.TB_DISCOUNT).setValue((Object)new BigDecimal("0.00"));
            }
        }
    }

    public static BigDecimal calValueByCurrencyChange(CompanyOrgUnitInfo fiCompanyOrgInfo, CurrencyInfo newCurrencyInfo, CurrencyInfo oldCurrencyInfo, BigDecimal price, int scale, Date bizDate) throws EASBizException, BOSException {
        ObjectUuidPK destCurrPK;
        ObjectUuidPK sourceCurrPK;
        BigDecimal ONE = new BigDecimal("1.00");
        ExchangeRateInfo exchangeRateInfo1 = null;
        ExchangeRateInfo exchangeRateInfo2 = null;
        BigDecimal exchangerate = ONE;
        BigDecimal exchangerate1 = ONE;
        BigDecimal exchangerate2 = ONE;
        CurrencyInfo baseCurrInfo = null;
        int percision = 10;
        if (fiCompanyOrgInfo != null) {
            baseCurrInfo = fiCompanyOrgInfo.getBaseCurrency();
        }
        if (null != baseCurrInfo && !baseCurrInfo.getId().toString().equals(newCurrencyInfo.getId().toString()) && (exchangeRateInfo1 = SCMClientUtils.getExchangeRate(fiCompanyOrgInfo, (IObjectPK)(sourceCurrPK = new ObjectUuidPK(newCurrencyInfo.getId())), (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrInfo.getId())), bizDate)) != null) {
            exchangerate1 = exchangeRateInfo1.getConvertRate();
        }
        if (null != baseCurrInfo && !baseCurrInfo.getId().toString().equals(oldCurrencyInfo.getId().toString()) && (exchangeRateInfo2 = SCMClientUtils.getExchangeRate(fiCompanyOrgInfo, (IObjectPK)(sourceCurrPK = new ObjectUuidPK(oldCurrencyInfo.getId())), (IObjectPK)(destCurrPK = new ObjectUuidPK(baseCurrInfo.getId())), bizDate)) != null) {
            exchangerate2 = exchangeRateInfo2.getConvertRate();
        }
        exchangerate = exchangeRateInfo2 != null && exchangeRateInfo2.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE ? exchangerate.divide(exchangerate2, percision, 4) : exchangerate.multiply(exchangerate2);
        exchangerate = exchangeRateInfo1 != null && exchangeRateInfo1.getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE ? exchangerate.multiply(exchangerate1) : exchangerate.divide(exchangerate1, percision, 4);
        if (price != null) {
            price = price.multiply(exchangerate).setScale(scale, 4);
        }
        return price;
    }

    private BigDecimal getZeroBy(int precision) {
        StringBuffer zero = new StringBuffer("0.");
        for (int i = 0; i < precision; ++i) {
            zero.append("0");
        }
        return new BigDecimal(zero.toString());
    }

    private MaterialPurchasingInfo handleMaterialPurchasingInfo(PurEntryDataVO resultVO, MaterialInfo[] materialInfos, int materialIdx) {
        Map materialPurMap = resultVO.getMaterialPurchasingInfos();
        Object mpObj = materialPurMap.get(materialInfos[materialIdx].getId().toString());
        MaterialPurchasingInfo materialPurInfo = (MaterialPurchasingInfo)mpObj;
        if (materialPurInfo != null && materialPurInfo.getStatus().getValue() != 1) {
            materialPurInfo = null;
        }
        return materialPurInfo;
    }

    private void carryMaterialNameAndModel(MaterialInfo materialInfo, int row) {
        if (materialInfo == null) {
            this.kdtEntries.getRow(row).getCell(this.TB_MATERIALNAME).setValue(null);
            this.kdtEntries.getRow(row).getCell(this.TB_MATERIALSIZE).setValue(null);
        } else {
            this.kdtEntries.getRow(row).getCell(this.TB_MATERIALNAME).setValue((Object)materialInfo.getName());
            this.kdtEntries.getRow(row).getCell(this.TB_MATERIALSIZE).setValue((Object)materialInfo.getModel());
        }
        this.kdtEntries.getRow(row).getCell(this.TB_MATERIALNAME).getStyleAttributes().setLocked(true);
    }

    @Override
    public void setSENDRATEMaxValue(int rowIndex) {
        KDFormattedTextField colTxtField = new KDFormattedTextField();
        colTxtField.setDataType(1);
        colTxtField.setPrecision(2);
        colTxtField.setRemoveingZeroInDispaly(false);
        colTxtField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        colTxtField.setMaximumValue((Comparable)new BigDecimal("99999999.99"));
        colTxtField.setSupportedEmpty(true);
        colTxtField.setDataVerifierType(12);
        KDTDefaultCellEditor col_CellEditor_over = new KDTDefaultCellEditor((JTextField)colTxtField);
        KDTDefaultCellEditor col_CellEditor = FormattedEditorFactory.getRatedCellEditor();
        String colPrecision = PrecisionUtil.getFormatString(2);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").setEditor((ICellEditor)col_CellEditor_over);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setNumberFormat(colPrecision);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOverRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").setEditor((ICellEditor)col_CellEditor);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setNumberFormat(colPrecision);
        this.kdtEntries.getRow(rowIndex).getCell("receiveOwingRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo, boolean allowAddEntry) throws EASBizException, BOSException {
        if (materialInfo != null && materialInfo.getAssistAttr() != null) {
            String assistAttrTypeID = materialInfo.getAssistAttr().getId().toString();
            if (assistAttrTypeID == null) {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).setValue(null);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setBackground(Color.WHITE);
            } else {
                this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setBackground(SCMClientUtils.necessaryColor);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
                this.kdtEntries.getColumn(this.TB_ASSISTPROPERTY).setRenderer((IBasicRender)avr);
                boolean isEnabledAssistProperty = this.isPurParamPUR("PURORDER100", false);
                if (!isEnabledAssistProperty) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
                    return;
                }
                if (this.isBotpBill("510b6503-0105-1000-e000-010bc0a813fd463ED552") || !this.isBotpBill() || allowAddEntry) {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setLocked(false);
                } else {
                    this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
                }
            }
        } else {
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).setValue(null);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(rowIndex).getCell(this.TB_ASSISTPROPERTY).getStyleAttributes().setBackground(Color.WHITE);
        }
    }

    @Override
    protected SCMEntryDataVO loadComplexData(SCMEntryDataVO inDataVO, boolean hasMaterial) throws EASBizException, BOSException {
        return SCMGroupFacadeFactory.getRemoteInstance().loadPurComplexData((PurEntryDataVO)inDataVO);
    }

    public Map getMaterialPlanMap() throws BOSException {
        StringBuffer storageId = new StringBuffer();
        StringBuffer materialId = new StringBuffer();
        HashMap<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
        String[] storage = new String[this.kdtEntries.getRowCount()];
        MaterialPlanCollection materialPlanCollection = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.kdtEntries.getRow(i).getCell(this.TB_STORAGEORGUNIT).getValue();
            if (storageOrgUnitInfo != null && storageOrgUnitInfo.getId() != null) {
                storage[i] = storageOrgUnitInfo.getId().toString();
                storageId.append("'").append(storageOrgUnitInfo.getId().toString()).append("',");
            }
            MaterialInfo materialInfo = null;
            materialInfo = this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue() instanceof MaterialInfo[] ? ((MaterialInfo[])this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue())[0] : (MaterialInfo)this.kdtEntries.getRow(i).getCell(this.TB_MATERIAL).getValue();
            if (materialInfo == null || materialInfo.getId() == null) continue;
            materialId.append("'").append(materialInfo.getId().toString()).append("',");
        }
        if (storageId != null && storageId.length() > 0) {
            storageId.setLength(storageId.length() - 1);
        }
        if (materialId != null && materialId.length() > 0) {
            materialId.setLength(materialId.length() - 1);
        }
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getRemoteInstance();
        if (materialId.length() > 0 && storageId.length() > 0) {
            materialPlanCollection = iMaterialPlan.getMaterialPlanCollection(" select id,material.id,orgUnit.id,manufactureStrategy.id,manufactureStrategy.number,isolatedRule,status  where material.id in ( " + materialId.toString() + " ) and orgUnit.id in ( " + storageId.toString() + ")");
        }
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo info = materialPlanCollection.get(i);
                if (info == null || info.getMaterial() == null || info.getMaterial().getId() == null || info.getOrgUnit() == null || info.getOrgUnit().getId() == null) continue;
                materialPlanMap.put(info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString(), info);
            }
        }
        return materialPlanMap;
    }

    public MaterialPlanInfo getMaterialPlan(Map materialPlanMap, String materialID, String orgUnitID) throws EASBizException, BOSException {
        if (materialPlanMap == null) {
            materialPlanMap = new HashMap<String, MaterialPlanInfo>(0);
        }
        if (!materialPlanMap.containsKey(materialID + orgUnitID) && materialID != null && materialID.length() > 0 && orgUnitID != null && orgUnitID.length() > 0) {
            materialPlanMap.put(materialID + orgUnitID, MaterialPlanFactory.getRemoteInstance().getPlanInfo(materialID, orgUnitID));
        }
        return (MaterialPlanInfo)materialPlanMap.get(materialID + orgUnitID);
    }

    @Override
    public void calEntryTaxPricebyPrice(int rowIndex, int colIndex) {
        if (this.isTax) {
            this.isTax = false;
            return;
        }
        if (this.TB_PRICE == null) {
            return;
        }
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal taxRate = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXRATE).getValue();
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getEditor().getComponent()).getPrecision();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
        if (this.chkIsPriceInTax != null && !this.chkIsPriceInTax.isSelected()) {
            taxPrice = this.calTaxPriceIsPriceInTax(price, taxRate, scale);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).setValue((Object)taxPrice);
    }

    @Override
    public void calEntryPriceByTaxPrice(int rowIndex, int colIndex) {
        if (this.isTax) {
            this.isTax = false;
            return;
        }
        super.calEntryPriceByTaxPrice(rowIndex, colIndex);
    }

    public BigDecimal calTaxPriceIsPriceInTax(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return null;
        }
        taxRate = taxRate == null ? SCMConstant.BIGDECIMAL_ZERO : taxRate;
        BigDecimal taxPrice = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, this.getScale(taxRate), 4);
        taxPrice = price.divide(one.subtract(taxRate), scale, 4);
        return taxPrice;
    }

    private int getScale(BigDecimal num) {
        return num.scale() + 2;
    }

    @Override
    public void calEntryActualTaxPrice(int rowIndex, int colIndex) {
        if (this.TB_DISCOUNT == null || this.TB_ACTUALTAXPRICE == null) {
            return;
        }
        BigDecimal discount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_DISCOUNT).getValue();
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        if ((discount == null || discount != null && discount.compareTo(zero) == 0) && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXPRICE).getValue();
            KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALTAXPRICE, (Object)price);
            return;
        }
        int scale = 2;
        if (this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE) != null) {
            scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).getEditor().getComponent()).getPrecision();
        }
        BigDecimal taxAmount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_TAXAMOUNT).getValue();
        BigDecimal actualTaxPrice = SysConstant.BIGZERO;
        if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
            actualTaxPrice = taxAmount.divide(qty, scale, 4);
        }
        this.getDetailTable().getRow(rowIndex).getCell(this.TB_ACTUALTAXPRICE).setValue((Object)actualTaxPrice);
    }

    @Override
    public void calEntryActualPrice(int rowIndex, int colIndex) {
        if (this.TB_PRICE == null || this.TB_ACTUALPRICE == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor() == null ? 2 : ((KDFormattedTextField)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getEditor().getComponent()).getPrecision();
        BigDecimal amount = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_AMOUNT).getValue();
        BigDecimal qty = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_QTY).getValue();
        KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)SysConstant.BIGZERO);
        BigDecimal price = (BigDecimal)this.getDetailTable().getRow(rowIndex).getCell(this.TB_PRICE).getValue();
        BigDecimal discountRate = (BigDecimal)KDTableUtils.getFieldValue(this.getDetailTable(), rowIndex, this.TB_DISCOUNT);
        BigDecimal bigDecimal = discountRate = discountRate == null ? zero : discountRate;
        if (discountRate.compareTo(zero) == 0) {
            if (price != null && qty != null && SysConstant.BIGZERO.compareTo(qty) < 0) {
                KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)price);
            }
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualTaxPrice = amount.divide(qty, scale, 4);
            KDTableUtils.setFieldValue(this.getDetailTable(), rowIndex, this.TB_ACTUALPRICE, (Object)actualTaxPrice);
        }
    }

    @Override
    public boolean iscalTaxRateByQtyChangeed() {
        return false;
    }
}

