/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.util.enums.IntEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class CheckRadioGroupFilterElment
extends FilterElement {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.filter.CheckRadioGroupFilterElment");
    private Map buttonMap = null;
    private List checkList = null;
    private Map filterMap = null;

    public void addButton(JToggleButton button, Object checkValue) {
        this.buttonMap.put(button, checkValue);
    }

    public void addButton(JToggleButton button, Object checkValue, boolean defaultStatus) {
        this.buttonMap.put(button, checkValue);
        if (defaultStatus) {
            this.checkList.add(button);
        }
    }

    public void addButton(JToggleButton button, Object checkValue, FilterInfo filter) {
        this.addButton(button, checkValue);
        this.filterMap.put(button, filter);
    }

    @Override
    public FilterInfo getFilterInfo() {
        if (this.isExclude()) {
            return null;
        }
        FilterInfo filterInfo = null;
        if (this.buttonMap != null && this.buttonMap.size() > 0) {
            int size = this.buttonMap.size();
            HashSet sets = new HashSet(this.buttonMap.size());
            Iterator iter = this.buttonMap.keySet().iterator();
            FilterInfo filter = null;
            while (iter.hasNext()) {
                JToggleButton button = (JToggleButton)iter.next();
                if (!button.isSelected()) continue;
                Object value = this.buttonMap.get(button);
                if (value instanceof IntEnum) {
                    IntEnum itemEnum = (IntEnum)value;
                    value = new Integer(itemEnum.getValue());
                } else if (!(value instanceof Integer)) {
                    value = value.toString();
                }
                sets.add(value);
                filter = (FilterInfo)this.filterMap.get(button);
            }
            size = sets.size();
            if (size > 0) {
                filterInfo = new FilterInfo();
                if (size == 1) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(this.getId(), sets.toArray()[0], CompareType.EQUALS));
                    if (filter != null) {
                        try {
                            filterInfo.mergeFilter(filter, "AND");
                        }
                        catch (BOSException e) {
                            logger.error((Object)e);
                        }
                    }
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo(this.getId(), sets, CompareType.EQUALS));
                }
            }
        }
        return filterInfo;
    }

    @Override
    public void clear() {
        Iterator iter = this.buttonMap.keySet().iterator();
        while (iter.hasNext()) {
            JToggleButton button;
            button.setSelected(this.checkList.indexOf(button = (JToggleButton)iter.next()) > -1);
        }
    }

    @Override
    public void setParam(Map map) {
    }

    @Override
    protected void setData(Map paramMap, Map propMap) {
    }

    @Override
    public void addCustomerParam(CustomerParams cp) {
        for (JToggleButton button : this.buttonMap.keySet()) {
            super.addCustomerParam(cp, button);
        }
    }

    @Override
    public void setElementValue(CustomerParams cp) {
        if (cp != null) {
            for (JToggleButton button : this.buttonMap.keySet()) {
                String value = cp.getCustomerParam(this.getName(button));
                if (value == null) continue;
                this.setNumber(button, value);
            }
        }
    }

    @Override
    protected void setElementData(CustomerParams cp, String key) {
    }

    @Override
    public void addRptParams(RptParams cp) {
        cp.setObject(this.getId(), (Object)this.getParamValue());
    }

    private String[] getParamValue() {
        if (this.buttonMap != null && this.buttonMap.size() > 0) {
            int size = this.buttonMap.size();
            HashSet sets = new HashSet(this.buttonMap.size());
            for (JToggleButton button : this.buttonMap.keySet()) {
                if (!button.isSelected()) continue;
                Object value = this.buttonMap.get(button);
                value = value instanceof IntEnum ? "" + ((IntEnum)value).getValue() : (!(value instanceof Integer) ? value.toString() : ((Integer)value).toString());
                sets.add(value);
            }
            size = sets.size();
            if (size > 0) {
                String[] values = new String[size];
                sets.toArray(values);
                return values;
            }
        }
        return null;
    }

    @Override
    public void setElementValue(RptParams cp) {
    }

    @Override
    protected boolean verify(VerifyItem verifyItem) {
        return false;
    }

    @Override
    public void setDefaultValue(Object value) {
    }

    public CheckRadioGroupFilterElment(String id) {
        super(id);
        this.init();
    }

    private void init() {
        this.buttonMap = new HashMap();
        this.filterMap = new HashMap();
        this.checkList = new ArrayList();
    }
}

