/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.filter;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.MultiOrgsFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryFilterManager {
    private FilterElement element = null;
    private FilterElement mainOrgElement = null;
    private String mainOrgId = null;

    public void setElement(FilterElement element) {
        this.element = element;
    }

    public FilterElement getElement() {
        return this.element;
    }

    public void clearAll() {
        if (this.element != null) {
            this.element.clear();
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.element != null) {
            return this.element.getFilterInfo();
        }
        return new FilterInfo();
    }

    public void setParam(Map map) {
        this.element.setParam(map);
        if (this.mainOrgElement != null && this.mainOrgElement instanceof SingleFilterElement) {
            this.mainOrgElement.setParam(map, this.mainOrgId, ((SingleFilterElement)this.mainOrgElement).getComponent());
        }
    }

    public void setData(Map map, EntityViewInfo entityViewInfo) {
        FilterItemCollection currentFilterItemCollection = null;
        Object value = null;
        ArrayList<Object> list = null;
        HashMap propMap = new HashMap();
        if (entityViewInfo.getFilter() != null) {
            currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        }
        if (currentFilterItemCollection != null) {
            for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
                String propName = currentFilterItemCollection.get(i).getPropertyName();
                CompareType comp = currentFilterItemCollection.get(i).getCompareType();
                if (propMap.containsKey(propName)) {
                    value = propMap.get(propName);
                    if (value instanceof List) {
                        list = value;
                    } else {
                        list = new ArrayList<Object>();
                        list.add(propMap.get(propName));
                    }
                    list.add(comp);
                    propMap.put(propName, list);
                    continue;
                }
                propMap.put(propName, comp);
            }
            this.element.setData(map, propMap);
        }
    }

    public void setMainOrgElement(FilterElement element, String id) {
        this.mainOrgElement = element;
        this.mainOrgId = id;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.element == null) {
            return cp;
        }
        this.element.addCustomerParam(cp);
        if (this.mainOrgElement != null && this.mainOrgElement instanceof SingleFilterElement) {
            this.mainOrgElement.addCustomerParamWithPK(cp, this.mainOrgId, ((SingleFilterElement)this.mainOrgElement).getComponent());
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp, boolean isInBOTP) {
        String value;
        if (this.element == null) {
            return;
        }
        if (cp != null && this.mainOrgElement instanceof SingleFilterElement && (value = cp.getCustomerParam(this.mainOrgId)) != null) {
            if (isInBOTP) {
                this.mainOrgElement.setData(((SingleFilterElement)this.mainOrgElement).getComponent(), SCMGroupClientUtils.getOrgUnitInfos(value));
            } else {
                if (value.indexOf(";") > -1) {
                    value = value.substring(0, value.indexOf(";"));
                }
                this.mainOrgElement.setData(((SingleFilterElement)this.mainOrgElement).getComponent(), SCMGroupClientUtils.getOrgUnitInfo(value));
            }
        }
        this.element.setElementValue(cp);
    }

    public boolean verify() {
        if (this.element != null) {
            return this.element.verify();
        }
        return true;
    }

    public RptParams getRptParams() {
        RptParams rp = new RptParams();
        if (this.element == null) {
            return rp;
        }
        this.element.addRptParams(rp);
        return rp;
    }

    public void setRptParams(RptParams rp) {
        if (this.element != null) {
            this.element.setElementValue(rp);
        }
    }

    public Object getMainOrgs() {
        if (this.mainOrgElement != null && this.mainOrgElement instanceof MultiOrgsFilterElement) {
            return ((MultiOrgsFilterElement)this.mainOrgElement).getFullData();
        }
        return null;
    }
}

