/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.gpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeInfo;
import com.kingdee.eas.basedata.master.cssp.CsManagerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SCMGptFacade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.gpt.SCMGptFacade");
    public static final String PRICE_MAP = "priceMap";
    public static final String ENTRY = "entry";
    public static final String COMPANY_ID = "companyId";
    public static final String SUPPLIER = "supplier";
    public static final String SUPPLIER_INFO = "supplierInfo";
    public static final String MATERIAL_ID = "materialId";
    public static final String CURRENCY = "currency";
    public static final String PURCHASE_ORG_UNIT = "purchaseOrgUnit";
    public static final String NULL = "null";

    public static Map analyzeSupplier(Map map) {
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        try {
            String uiPk;
            StringBuffer msg = new StringBuffer();
            boolean isSupportUI = false;
            if (map.get("uiPk") != null && ("com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI".equals(uiPk = map.get("uiPk").toString()) || "com.kingdee.eas.scm.sm.pur.purOrderViewPage".equals(uiPk) || "com.kingdee.eas.scm.sm.pur.purOrderEditPage".equals(uiPk))) {
                isSupportUI = true;
            }
            msg.append("isSupportUI:").append(isSupportUI).append(" ");
            if (map.get(SUPPLIER) == null) {
                msg.append("supplier:null");
                result.put("msg", msg);
                return result;
            }
            Context ctx = (Context)map.get("bosCtx");
            Map paramMap = SCMGptFacade.handleMap(ctx, map);
            SupplierInfo supplierInfo = (SupplierInfo)paramMap.get(SUPPLIER_INFO);
            msg.append("supplier:").append(supplierInfo.getNumber()).append(" ");
            msg.append("QualificationRisk:").append(supplierInfo.getUsedStatus().toString()).append(" ");
            msg.append("PriceRisk:").append(SCMGptFacade.getPriceRisk(ctx, paramMap)).append(" ");
            msg.append("QualityRisk:").append(SCMGptFacade.getQualityRisk(ctx, paramMap)).append(" ");
            msg.append("CreditRisk:").append(SCMGptFacade.getCreditRisk(ctx, paramMap)).append(" ");
            result.put("msg", msg);
        }
        catch (Exception e) {
            result.put("Exception", e.getMessage() + "\n" + e.getCause());
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return result;
    }

    private static String getPriceRisk(Context ctx, Map map) throws BOSException {
        if (map.get(MATERIAL_ID) == null) {
            return NULL;
        }
        StringBuffer msg = new StringBuffer();
        Map priceMap = (Map)map.get(PRICE_MAP);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT entry.fmaterialid, mat.fnumber,entry.FUNITID,entry.FASSISTPROPERTYID,min(entry.FTAXPRICE) FTAXPRICE");
        sql.append(" FROM t_sm_purorderEntry ENTRY ");
        sql.append(" INNER JOIN t_sm_purorder BILL ON bill.fid = entry.FPARENTID ");
        sql.append(" INNER JOIN t_bd_material mat ON mat.fid = entry.FMaterialID ");
        sql.append(" where bill.FBIZDATE <=now() and bill.FBIZDATE >= DATEADD(yy, -1, now()) ");
        sql.append(" and entry.FBASESTATUS in (4,7) and entry.FISPRESENT = 0 ");
        sql.append(" and entry.fmaterialid in (" + map.get(MATERIAL_ID) + ") ");
        sql.append(" and entry.FCOMPANYORGUNITID = '" + map.get(COMPANY_ID) + "' ");
        sql.append(" and BILL.FCURRENCYID = '" + map.get(CURRENCY) + "' ");
        sql.append(" and BILL.FPURCHASEORGUNITID = '" + map.get(PURCHASE_ORG_UNIT) + "' ");
        sql.append("group by entry.fmaterialid,mat.fnumber,entry.FUNITID,entry.FASSISTPROPERTYID");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal taxPrice;
                String key = rs.getString("fmaterialid") + "+" + rs.getString("FUNITID");
                if (rs.getString("FASSISTPROPERTYID") != null) {
                    key = key + "+" + rs.getString("FASSISTPROPERTYID");
                }
                if (!priceMap.containsKey(key) || (taxPrice = (BigDecimal)priceMap.get(key)).compareTo(rs.getBigDecimal("FTAXPRICE")) <= 0) continue;
                msg.append(rs.getString("fnumber")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.length() > 0 ? msg.substring(0, msg.length() - 1) : NULL;
    }

    private static String getQualityRisk(Context ctx, Map map) throws BOSException {
        if (map.get(MATERIAL_ID) == null) {
            return NULL;
        }
        StringBuffer msg = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mat.fnumber ");
        sql.append(" FROM t_sm_purorderEntry ENTRY ");
        sql.append(" INNER JOIN t_sm_purorder BILL ON bill.fid = entry.FPARENTID ");
        sql.append(" INNER JOIN t_bd_material mat ON mat.fid = entry.FMaterialID ");
        sql.append(" where bill.FBIZDATE <=now() and bill.FBIZDATE >= DATEADD(MM, -5, now()) ");
        sql.append(" and ENTRY.fmaterialid in (" + map.get(MATERIAL_ID) + ") and ENTRY.FTOTALCANCELLEDSTOCKQTY > 0");
        sql.append(" and entry.FCOMPANYORGUNITID = '" + map.get(COMPANY_ID) + "' ");
        sql.append(" and bill.FSUPPLIERID = '" + map.get(SUPPLIER) + "' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                msg.append(rs.getString("fnumber")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.length() > 0 ? msg.substring(0, msg.length() - 1) : NULL;
    }

    private static String getCreditRisk(Context ctx, Map map) throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        try {
            StringBuffer id = new StringBuffer();
            id.append("'").append(map.get(SUPPLIER)).append("'");
            SupplierInfo supplierInfo = (SupplierInfo)map.get(SUPPLIER_INFO);
            BizAnalysisCodeInfo vo = supplierInfo.getBizAnalysisCode();
            if (vo != null && vo.getId() != null) {
                CustomerCollection customerColl = CsManagerFactory.getLocalInstance((Context)ctx).getCustomerCollectionByBizCode((IObjectPK)new ObjectUuidPK(vo.getId()));
                for (int i = 0; i < customerColl.size(); ++i) {
                    id.append(",").append("'").append(customerColl.get(i).getId().toString()).append("'");
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT sum(b.FUNVERIFYAMOUNT) FUNVERIFYAMOUNT");
            sql.append(" FROM t_ar_otherbill a ");
            sql.append(" inner join T_AR_OtherBillPlan b on a.fid = b.FPARENTID ");
            sql.append(" where a.FCOMPANYID  ='").append(map.get(COMPANY_ID)).append("' ");
            sql.append(" and fasstactid in (").append(id).append(") ");
            sql.append("and b.FUNVERIFYAMOUNT  > 0 and b.FRECIEVEPAYDATE < now() ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next() && rs.getBigDecimal("FUNVERIFYAMOUNT") != null && rs.getBigDecimal("FUNVERIFYAMOUNT").compareTo(BigDecimal.ZERO) != 0) {
                msg.append(rs.getBigDecimal("FUNVERIFYAMOUNT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return msg.length() > 0 ? msg.toString() : NULL;
    }

    private static String getLegalRisk(Context ctx, Map map) throws BOSException, EASBizException {
        return "";
    }

    private static Map handleMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(paramMap.get(SUPPLIER).toString()));
        paramMap.put(SUPPLIER_INFO, supplierInfo);
        if (paramMap.get(ENTRY) != null && paramMap.get(ENTRY).toString().length() > 2) {
            Map priceMap = SCMGptFacade.handleStrToMap(paramMap.get(ENTRY).toString());
            paramMap.put(PRICE_MAP, priceMap);
            paramMap.put(MATERIAL_ID, priceMap.get(MATERIAL_ID));
        }
        return paramMap;
    }

    private static Map handleStrToMap(String str) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer matId = new StringBuffer();
        String[] entryStr = str.substring(2, str.length() - 2).split("}, \\{");
        for (int i = 0; i < entryStr.length; ++i) {
            String[] entryField = entryStr[i].split(", ");
            HashMap<String, String> keyMap = new HashMap<String, String>();
            for (int j = 0; j < entryField.length; ++j) {
                int index = entryField[j].indexOf("=");
                keyMap.put(entryField[j].substring(0, index), entryField[j].substring(index + 1));
            }
            String key = (String)keyMap.get("material") + "+" + (String)keyMap.get("unit");
            if (StringUtil.isEmpty((String)keyMap.get("assistProperty")) && !NULL.equals(keyMap.get("assistProperty"))) {
                key = key + "+" + (String)keyMap.get("assistProperty");
            }
            map.put(key, new BigDecimal(((String)keyMap.get("taxPrice")).toString()));
            matId.append("'").append((String)keyMap.get("material")).append("',");
        }
        map.put(MATERIAL_ID, matId.substring(0, matId.length() - 1));
        return map;
    }
}

