/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.SCMGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class InvBatchCalculater
extends SCMBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.InvBatchCalculater");
    protected String[] canNullCapitalProperties = new String[]{"CompanyNumber", "MainBizOrgNumber", "TransactionTypeNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber"};
    protected String[] canNullPropertiesSplit = new String[]{";", ";", ";", ";", ";", ";", ";"};
    public String sumField = "d.FBaseQty";
    private SCMGetParamBean param;

    public InvBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            int lastQueryIndex = queryIndex;
            this.params.clear();
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                Parameter param = paramArray.getParameter(queryIndex);
                InvGetParamBean formulaParam = this.getInvGetParamBean(param);
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    SCMReportBatchUtils.reviseInvParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                    for (int j = lastQueryIndex; j < queryIndex; ++j) {
                        FormulaValueBackfill.setException((Parameter)paramArray.getParameter(j), (Throwable)e);
                    }
                }
                ++queryIndex;
            }
            try {
                this.innerExecute();
            }
            catch (Exception e) {
                logger.error((Object)e);
                for (int j = lastQueryIndex; j < queryIndex; ++j) {
                    FormulaValueBackfill.setException((Parameter)paramArray.getParameter(j), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerExecute() throws Exception {
        String sql = null;
        this.groupByParam();
        this.loadNumberIDCacheData();
        ResultSet rs = null;
        int count = this.groupedParams.length;
        for (int i = 0; i < count; ++i) {
            PreparedStatement pstmt = null;
            try {
                ArrayList paramList = this.groupedParams[i];
                if (paramList == null || paramList.size() <= 0) continue;
                for (int k = 0; k < paramList.size(); ++k) {
                    InvGetParamBean invParamBean = (InvGetParamBean)paramList.get(k);
                    this.setParam(invParamBean);
                    this.setSumField(invParamBean);
                    sql = this.getSqlByID(i);
                    pstmt = this.conn.prepareStatement(sql);
                    try {
                        this.setSqlParamsByID(pstmt, invParamBean, i);
                        rs = pstmt.executeQuery();
                        BigDecimal value = SCMBatchCalculater.ZERO;
                        while (rs.next()) {
                            BigDecimal tmp = rs.getBigDecimal(this.getReturnField());
                            if (tmp == null) continue;
                            value = value.add(tmp);
                        }
                        invParamBean.getBackFiller().setValue((Object)value);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, (Statement)pstmt);
                        throw throwable;
                    }
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                }
                continue;
            }
            finally {
                SQLUtils.cleanup(rs, pstmt);
            }
        }
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit;
    }

    @Override
    protected String getSql(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" left join T_ORG_Company company on company.fid = d.FCompanyOrgUnitID");
        sql.append(this.getJoinCurrencyTable());
        sql.append(" left join T_BD_Material material on material.fid = d.FMaterialID");
        sql.append(" left join T_BD_MaterialGroupStandard materialGroupStd on materialGroupStd.fid = materialGroup.FGroupStandard ");
        sql.append(" left join T_BD_MaterialGroup materialGroup on materialGroup.fid = material.FMaterialGroupID ");
        sql.append(" left join T_SCM_TransactionType transactionType on transactionType.fid=h.FTransactionTypeID ");
        sql.append(" left join T_DB_WAREHOUSE warehouse on warehouse.fid = d.FWarehouseID");
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4)");
        sql.append(this.getMainOrgCondSql(group));
        sql.append(this.getTransactionTypecondSql(group));
        sql.append(this.getMaterialGroupCondSql(group));
        sql.append(this.getMaterialCondSql(group));
        sql.append(this.getWarehouseCondSql(group));
        return sql.toString();
    }

    @Override
    String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4)");
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getTransactionTypecondSqlByID(group));
        sql.append(" and d.FMaterialID in ( ");
        sql.append(" select material.fid from T_BD_Material material ");
        sql.append(" inner join T_BD_MaterialGroupDetial materialGroupDetail on materialGroupDetail.FMaterialid = material.fid ");
        sql.append(" inner join T_BD_MaterialGroupStandard materialGroupStd on materialGroupStd.fid = materialGroupDetail.FMaterialGroupStandardID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup1 on materialGroup1.fid = materialGroupDetail.FMaterialGroupID ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup on charindex(materialGroup.flongnumber,materialGroup1.flongnumber) = 1 ");
        sql.append(" where 1 = 1 ");
        sql.append(this.getMaterialGroupStdCondSqlByID(group));
        sql.append(this.getMaterialGroupCondSqlByID(group));
        sql.append(this.getMaterialCondSql(group));
        sql.append(" )");
        sql.append(this.getWarehouseCondSqlByID(group));
        return sql.toString();
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block9: {
            WarehouseCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    ctx = this.contextProvider.getServerContext();
                                    ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                    if (index != 0) break block8;
                                    CompanyOrgUnitCollection ouc2 = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                    if (ouc2 == null || ouc2.size() <= 0) break block9;
                                    int n = ouc2.size();
                                    for (int i = 0; i < n; ++i) {
                                        CompanyOrgUnitInfo info = ouc2.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block9;
                                }
                                if (index != 1) break block10;
                                StorageOrgUnitCollection ouc3 = SCMReportBatchUtils.getStorageOrgUnitCollection(ctx, ev);
                                if (ouc3 == null || ouc3.size() <= 0) break block9;
                                int n = ouc3.size();
                                for (int i = 0; i < n; ++i) {
                                    StorageOrgUnitInfo info = ouc3.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block9;
                            }
                            if (index != 2) break block11;
                            TransactionTypeCollection ouc4 = SCMReportBatchUtils.getTransactionTypeCollection(ctx, ev);
                            if (ouc4 == null || ouc4.size() <= 0) break block9;
                            int n = ouc4.size();
                            for (int i = 0; i < n; ++i) {
                                TransactionTypeInfo info = ouc4.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block9;
                        }
                        if (index != 3) break block12;
                        MaterialGroupStandardCollection ouc5 = SCMReportBatchUtils.getMaterialGroupStdCollection(ctx, ev);
                        if (ouc5 == null || ouc5.size() <= 0) break block9;
                        int n = ouc5.size();
                        for (int i = 0; i < n; ++i) {
                            MaterialGroupStandardInfo info = ouc5.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block9;
                    }
                    if (index != 4) break block13;
                    MaterialGroupCollection ouc6 = SCMReportBatchUtils.getMaterialGroupCollection(ctx, ev);
                    if (ouc6 == null || ouc6.size() <= 0) break block9;
                    int n = ouc6.size();
                    for (int i = 0; i < n; ++i) {
                        MaterialGroupInfo info = ouc6.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block9;
                }
                if (index != 5) break block14;
                MaterialCollection ouc7 = SCMReportBatchUtils.getMaterialCollection(ctx, ev);
                if (ouc7 == null || ouc7.size() <= 0) break block9;
                int n = ouc7.size();
                for (int i = 0; i < n; ++i) {
                    MaterialInfo info = ouc7.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block9;
            }
            if (index == 6 && (ouc = SCMReportBatchUtils.getWarehouseCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    WarehouseInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    protected String getReturnField() {
        return "FValue";
    }

    protected String getSumField() {
        return this.sumField;
    }

    protected abstract String getHeadTableName();

    protected abstract String getDetailTableName();

    protected String getMainOrgTableName() {
        return "T_ORG_Storage";
    }

    protected String getJoinCurrencyTable() {
        return " left join T_BD_Currency currency on currency.fid = company.FBaseCurrencyID";
    }

    protected String getMainOrgField() {
        return "h.FStorageOrgUnitID";
    }

    protected String getCompanyCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 0)) {
            return " and (company.FNumber = ?)";
        }
        return "";
    }

    protected String getCompanyCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 0)) {
            return " and (d.FCompanyOrgUnitID = ?)";
        }
        return "";
    }

    protected String getMainOrgCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 1)) {
            return " and (h.FStorageOrgUnitID = ?)";
        }
        return "";
    }

    protected String getMainOrgCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 1)) {
            return " and (mainOrg.FNumber = ?)";
        }
        return "";
    }

    protected String getTransactionTypecondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 2)) {
            return " and (transactionType.FNumber = ?)";
        }
        return "";
    }

    protected String getTransactionTypecondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 2)) {
            return " and (h.FTransactionTypeID = ?)";
        }
        return "";
    }

    protected String getMaterialGroupStdCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 3)) {
            return " and (materialGroupStd.FID = ?)";
        }
        return "";
    }

    protected String getMaterialGroupStdCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 3)) {
            return " and (materialGroupStd.FNumber = ?)";
        }
        return "";
    }

    protected String getMaterialGroupCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 4)) {
            return " and (materialGroup.FNumber = ?)";
        }
        return "";
    }

    protected String getMaterialGroupCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 4)) {
            return " and (materialGroup.Fnumber = ?)";
        }
        return "";
    }

    protected String getMaterialCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 5)) {
            return " and (d.FMaterialID = ?)";
        }
        return "";
    }

    protected String getMaterialCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 5)) {
            String materialNumber = this.param.getMaterialNumber();
            String[] mNumbers = materialNumber.split(";");
            String nums = "";
            for (int i = 0; i < mNumbers.length; ++i) {
                nums = nums + "?,";
            }
            nums = nums.substring(0, nums.length() - 1);
            return " and (material.FNumber in (" + nums + "))";
        }
        return "";
    }

    protected String getWarehouseCondSql(int group) {
        if (InvBatchCalculater.checkBit(group, 6)) {
            return " and (warehouse.FNumber = ?)";
        }
        return "";
    }

    protected String getWarehouseCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 6)) {
            return " and (d.FWarehouseID = ?)";
        }
        return "";
    }

    public void setSumField(String sumField) {
        this.sumField = sumField;
    }

    protected String getCostCenterCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 7)) {
            return " and (d.FCostCenterOrgUnitID = ?)";
        }
        return "";
    }

    protected String getAdminOrgUnitCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 8)) {
            return " and (d.FAdminOrgUnitID = ?)";
        }
        return "";
    }

    public void setSumField(InvGetParamBean invParamBean) {
        if ("FETCH_BASEQTY".equals(invParamBean.getGetDataType())) {
            this.setSumField("d.FBaseQty");
        } else if ("FETCH_ACTUALCOST".equals(invParamBean.getGetDataType())) {
            this.setSumField("d.FActualCost");
        } else {
            this.setSumField("d.FAmount");
        }
    }

    protected List[] groupByDataType(ArrayList paramList) {
        List[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < paramList.size(); ++i) {
            InvGetParamBean invParamBean = (InvGetParamBean)paramList.get(i);
            if ("FETCH_BASEQTY".equals(invParamBean.getGetDataType())) {
                lists[0].add(invParamBean);
                continue;
            }
            if ("FETCH_ACTUALCOST".equals(invParamBean.getGetDataType())) {
                lists[1].add(invParamBean);
                continue;
            }
            lists[2].add(invParamBean);
        }
        return lists;
    }

    protected String getCostObjectCondSqlByID(int group) {
        if (InvBatchCalculater.checkBit(group, 9)) {
            return " and (costObject.FID = ?)";
        }
        return "";
    }

    public void setParam(SCMGetParamBean param) {
        this.param = param;
    }

    public SCMGetParamBean getParam() {
        return this.param;
    }

    public InvGetParamBean getInvGetParamBean(Parameter param) {
        return new InvGetParamBean(param);
    }
}

