/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.scm.common.rptformula.InvBatchCalculater;
import com.kingdee.eas.scm.common.rptformula.InvGetParamBean;
import com.kingdee.eas.scm.common.rptformula.InvSOPIGetParamBean;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class InvSOPIBatchCalculater
extends InvBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.rptformula.InvSOPIBatchCalculater");
    protected String[] canNullCapitalProperties4InvSOPIBatchCalculater = new String[]{"CompanyNumber", "MainBizOrgNumber", "SaleOrgNumber", "TransactionTypeNumber", "CsspGroupStdNumber", "CsspGroupNumber", "CsspNumber", "MaterialGroupStdNumber", "MaterialGroupNumber", "MaterialNumber", "WarehouseNumber", "CurrencyNumber"};
    protected String[] canNullPropertiesSplit4InvSOPIBatchCalculater = new String[]{";", ";", ";", ";", ";", ";", ";", ";", ";", ";", ";", ";"};

    public InvSOPIBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String[] getCanNullCapitalProperty() {
        return this.canNullCapitalProperties4InvSOPIBatchCalculater;
    }

    @Override
    protected String[] getCanNullPropertySplit() {
        return this.canNullPropertiesSplit4InvSOPIBatchCalculater;
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block18: {
            CurrencyCollection ouc;
            EntityViewInfo ev;
            Context ctx;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block17: {
                                                ctx = this.contextProvider.getServerContext();
                                                ev = SCMReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                                if (index != 0) break block17;
                                                CompanyOrgUnitCollection ouc2 = SCMReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                                if (ouc2 == null || ouc2.size() <= 0) break block18;
                                                int n = ouc2.size();
                                                for (int i = 0; i < n; ++i) {
                                                    CompanyOrgUnitInfo info = ouc2.get(i);
                                                    String number = info.getNumber();
                                                    String id = info.getId().toString();
                                                    map.put(number, id);
                                                }
                                                break block18;
                                            }
                                            if (index != 1) break block19;
                                            StorageOrgUnitCollection ouc3 = SCMReportBatchUtils.getStorageOrgUnitCollection(ctx, ev);
                                            if (ouc3 == null || ouc3.size() <= 0) break block18;
                                            int n = ouc3.size();
                                            for (int i = 0; i < n; ++i) {
                                                StorageOrgUnitInfo info = ouc3.get(i);
                                                String number = info.getNumber();
                                                String id = info.getId().toString();
                                                map.put(number, id);
                                            }
                                            break block18;
                                        }
                                        if (index != 3) break block20;
                                        TransactionTypeCollection ouc4 = SCMReportBatchUtils.getTransactionTypeCollection(ctx, ev);
                                        if (ouc4 == null || ouc4.size() <= 0) break block18;
                                        int n = ouc4.size();
                                        for (int i = 0; i < n; ++i) {
                                            TransactionTypeInfo info = ouc4.get(i);
                                            String number = info.getNumber();
                                            String id = info.getId().toString();
                                            map.put(number, id);
                                        }
                                        break block18;
                                    }
                                    if (index != 4) break block21;
                                    if (ev != null && ev.getFilter() != null && ev.getFilter().getFilterItems() != null && ev.getFilter().getFilterItems().size() == 0) {
                                        return;
                                    }
                                    FilterInfo filterInfo = new FilterInfo();
                                    if (ev.getFilter() != null) {
                                        filterInfo = ev.getFilter();
                                    }
                                    FilterItemInfo filterItemInfo = null;
                                    if (this.getHeadTableName().equals("T_IM_SaleIssueBill")) {
                                        filterItemInfo = new FilterItemInfo("type", (Object)"1");
                                    } else if (this.getHeadTableName().equals("T_IM_PurInWarehsBill")) {
                                        filterItemInfo = new FilterItemInfo("type", (Object)"2");
                                    }
                                    filterInfo.getFilterItems().add(filterItemInfo);
                                    String maskString = filterInfo.getMaskString();
                                    if (maskString != null) {
                                        int size = filterInfo.getFilterItems().size();
                                        filterInfo.setMaskString("(" + maskString + ") and #" + --size);
                                    }
                                    ev.setFilter(filterInfo);
                                    CSSPGroupStandardCollection csspGroupStdCo = SCMReportBatchUtils.getCSSPGroupStdCollection(ctx, ev);
                                    if (csspGroupStdCo == null || csspGroupStdCo.size() <= 0) break block18;
                                    int n = csspGroupStdCo.size();
                                    for (int i = 0; i < n; ++i) {
                                        CSSPGroupStandardInfo info = csspGroupStdCo.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block18;
                                }
                                if (index != 5) break block22;
                                CSSPGroupCollection csspGroupCo = SCMReportBatchUtils.getCSSPGroupCollection(ctx, ev);
                                if (csspGroupCo == null || csspGroupCo.size() <= 0) break block18;
                                int n = csspGroupCo.size();
                                for (int i = 0; i < n; ++i) {
                                    CSSPGroupInfo info = csspGroupCo.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block18;
                            }
                            if (index != 7) break block23;
                            MaterialGroupStandardCollection ouc5 = SCMReportBatchUtils.getMaterialGroupStdCollection(ctx, ev);
                            if (ouc5 == null || ouc5.size() <= 0) break block18;
                            int n = ouc5.size();
                            for (int i = 0; i < n; ++i) {
                                MaterialGroupStandardInfo info = ouc5.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block18;
                        }
                        if (index != 8) break block24;
                        MaterialGroupCollection ouc6 = SCMReportBatchUtils.getMaterialGroupCollection(ctx, ev);
                        if (ouc6 == null || ouc6.size() <= 0) break block18;
                        int n = ouc6.size();
                        for (int i = 0; i < n; ++i) {
                            MaterialGroupInfo info = ouc6.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block18;
                    }
                    if (index != 9) break block25;
                    MaterialCollection ouc7 = SCMReportBatchUtils.getMaterialCollection(ctx, ev);
                    if (ouc7 == null || ouc7.size() <= 0) break block18;
                    int n = ouc7.size();
                    for (int i = 0; i < n; ++i) {
                        MaterialInfo info = ouc7.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block18;
                }
                if (index != 10) break block26;
                WarehouseCollection ouc8 = SCMReportBatchUtils.getWarehouseCollection(ctx, ev);
                if (ouc8 == null || ouc8.size() <= 0) break block18;
                int n = ouc8.size();
                for (int i = 0; i < n; ++i) {
                    WarehouseInfo info = ouc8.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block18;
            }
            if (index == 11 && (ouc = SCMReportBatchUtils.getCurrencyCollection(ctx, ev)) != null && ouc.size() > 0) {
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    CurrencyInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    String getSqlByID(int group) {
        StringBuffer sql = new StringBuffer();
        sql.append("select SUM(").append(this.getSumField()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" h");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" d on d.fparentid=h.fid");
        sql.append(" left join ").append(this.getMainOrgTableName()).append(" mainOrg on mainOrg.fid=").append(this.getMainOrgField());
        sql.append(" left join T_ORG_Company company on company.fid = d.FCompanyOrgUnitID");
        sql.append(" left join T_BD_Currency currency on currency.fid = company.FBaseCurrencyID");
        sql.append(" where (h.FBizDate>=? and h.FBizDate<=?) and (h.FBaseStatus=4) and ( (h.fisinitbill <> 1) or (h.fisinitbill is null) )");
        sql.append(this.getCompanyCondSqlByID(group));
        sql.append(this.getMainOrgCondSqlByID(group));
        sql.append(this.getSOPIOrgCondSqlByID(group));
        sql.append(this.getTransactionTypecondSqlByID(group));
        sql.append(" and " + this.getCSSPField() + " in ( ");
        sql.append(this.getCSSPDetailTableSql());
        sql.append(" where 1 = 1 ");
        sql.append(this.getCSSPGroupStdCondSqlByID(group));
        sql.append(this.getCSSPGroupCondSqlByID(group));
        sql.append(" )");
        sql.append(this.getCSSPCondSqlByID(group));
        sql.append(" and d.FMaterialID in ( ");
        sql.append(" select material.fid from T_BD_Material material ");
        sql.append(" inner join T_BD_MaterialGroupDetial MGD on MGD.FMaterialid = material.fid ");
        sql.append(" inner join T_BD_MaterialGroup materialGroup1 on materialGroup1.fid = MGD.FMaterialGroupID ");
        sql.append(" inner join T_BD_MaterialGroup g on charindex(g.flongnumber,materialGroup1.flongnumber) = 1 ");
        sql.append(" where 1 = 1 ");
        sql.append(this.getMaterialGroupStdCondSqlByID(group));
        sql.append(this.getMaterialGroupCondSqlByID(group));
        sql.append(this.getMaterialCondSql(group));
        sql.append(" )");
        sql.append(this.getWarehouseCondSqlByID(group));
        if (!this.getSumField().equals("d.FBaseQty")) {
            sql.append(this.getCurrencyCondSqlByID(group));
        } else {
            sql.append(this.getCurrencyCondSqlByID2(group));
        }
        return sql.toString();
    }

    protected abstract String getCsspTable();

    protected abstract String getJoinField();

    protected abstract String getSOPIOrgCondSqlByID(int var1);

    @Override
    protected String getTransactionTypecondSql(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 3)) {
            return " and (transactionType.FNumber = ?)";
        }
        return "";
    }

    @Override
    protected String getTransactionTypecondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 3)) {
            return " and (h.FTransactionTypeID = ?)";
        }
        return "";
    }

    protected String getCSSPGroupStdCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 4)) {
            return " and (csspGroupStd.FID = ?)";
        }
        return "";
    }

    protected String getCSSPGroupCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 5)) {
            return " and (csspGroup.Fnumber = ?)";
        }
        return "";
    }

    protected abstract String getCSSPCondSqlByID(int var1);

    @Override
    protected String getMaterialGroupStdCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 7)) {
            return " and (MGD.FMATERIALGROUPSTANDARDID = ?)";
        }
        return "";
    }

    @Override
    protected String getMaterialGroupStdCondSql(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 7)) {
            return " and (materialGroupStd.FNumber = ?)";
        }
        return "";
    }

    @Override
    protected String getMaterialGroupCondSql(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 8)) {
            return " and (g.FNumber = ?)";
        }
        return "";
    }

    @Override
    protected String getMaterialGroupCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 8)) {
            return " and (g.fnumber = ?)";
        }
        return "";
    }

    @Override
    protected String getMaterialCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 9)) {
            return " and (d.FMaterialID = ?)";
        }
        return "";
    }

    @Override
    protected String getMaterialCondSql(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 9)) {
            String materialNumber = this.getParam().getMaterialNumber();
            String[] mNumbers = materialNumber.split(";");
            String nums = "";
            for (int i = 0; i < mNumbers.length; ++i) {
                nums = nums + "?,";
            }
            nums = nums.substring(0, nums.length() - 1);
            return " and (material.FNumber in (" + nums + "))";
        }
        return "";
    }

    @Override
    protected String getWarehouseCondSql(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 10)) {
            return " and (warehouse.FNumber = ?)";
        }
        return "";
    }

    @Override
    protected String getWarehouseCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 10)) {
            return " and (d.FWarehouseID = ?)";
        }
        return "";
    }

    protected String getCurrencyCondSqlByID(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 11)) {
            return " and (company.FBaseCurrencyID = ?)";
        }
        return "";
    }

    protected String getCurrencyCondSqlByID2(int group) {
        if (InvSOPIBatchCalculater.checkBit(group, 11)) {
            return " and ( (1=1 ) or  (company.FBaseCurrencyID = ?))";
        }
        return "";
    }

    @Override
    public void setSumField(InvGetParamBean invParamBean) {
        InvSOPIGetParamBean formulaParam = (InvSOPIGetParamBean)invParamBean;
        if ("FETCH_BASEQTY".equals(formulaParam.getGetDataType())) {
            this.setSumField("d.FBaseQty");
        } else if ("FETCH_ACTUALCOST".equals(formulaParam.getGetDataType())) {
            this.setSumField("d.FActualCost");
        } else if ("FETCH_NONTAXAMOUNT".equals(formulaParam.getGetDataType())) {
            this.setSumField("d.FNonTaxAmount");
        } else if ("FETCH_TAXAMOUNT".equals(invParamBean.getGetDataType())) {
            this.setSumField("d.FTaxAmount");
        } else {
            this.setSumField("d.FAmount");
        }
    }

    @Override
    protected List[] groupByDataType(ArrayList paramList) {
        List[] lists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < paramList.size(); ++i) {
            InvSOPIGetParamBean formulaParam = (InvSOPIGetParamBean)paramList.get(i);
            if ("FETCH_BASEQTY".equals(formulaParam.getGetDataType())) {
                lists[0].add(formulaParam);
                continue;
            }
            if ("FETCH_ACTUALCOST".equals(formulaParam.getGetDataType())) {
                lists[1].add(formulaParam);
                continue;
            }
            if ("FETCH_NONTAXAMOUNT".equals(formulaParam.getGetDataType())) {
                lists[2].add(formulaParam);
                continue;
            }
            lists[3].add(formulaParam);
        }
        return lists;
    }

    protected abstract String getCSSPField();

    protected abstract String getCSSPDetailTableSql();
}

