/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.rptformula.client.inv.winzardui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.rptformula.SCMReportBatchUtils;
import com.kingdee.eas.scm.common.rptformula.client.SCMQtyFormulaWizardUI;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class InvFormulaWinzardUI
extends SCMQtyFormulaWizardUI
implements DataChangeListener,
ItemListener,
SelectorListener {
    protected KDBizPromptBox storeOrgUnitF7 = null;
    protected KDDatePicker startTimePicker = null;
    protected KDDatePicker endTimePicker = null;
    protected KDBizPromptBox transactionTypeF7 = null;
    protected KDBizPromptBox materialGroupStdF7 = null;
    protected KDBizPromptBox materialGroupF7 = null;
    protected KDBizPromptBox warehouseF7 = null;
    protected KDBizPromptBox currencyF7 = null;
    protected KDComboBox fetchDataType = null;
    private static final String RESCLASSNAME = "com.kingdee.eas.scm.common.SCM_COMMONResource";
    private HashMap permissionFullOrgs = null;
    private HashSet set = new HashSet();
    boolean first = true;

    @Override
    protected void onOpen() {
        this.companyOrgUnitF7 = (KDBizPromptBox)this.getParamComponent("fiOrgUnit");
        this.storeOrgUnitF7 = (KDBizPromptBox)this.getParamComponent("storageOrgUnit");
        this.startTimePicker = (KDDatePicker)this.getParamComponent("startTime");
        this.endTimePicker = (KDDatePicker)this.getParamComponent("endTime");
        this.transactionTypeF7 = (KDBizPromptBox)this.getParamComponent("transactionType");
        this.materialGroupStdF7 = (KDBizPromptBox)this.getParamComponent("materialGroupStd");
        this.materialGroupF7 = (KDBizPromptBox)this.getParamComponent("materialGroup");
        this.materialF7 = (KDBizPromptBox)this.getParamComponent("material");
        this.warehouseF7 = (KDBizPromptBox)this.getParamComponent("warehouse");
        this.currencyF7 = (KDBizPromptBox)this.getParamComponent("currency");
        this.fetchDataType = (KDComboBox)this.getParamComponent("fetchDateType");
        this.init();
        this.initControl();
        this.companyOrgUnitF7.addDataChangeListener((DataChangeListener)this);
        this.storeOrgUnitF7.addDataChangeListener((DataChangeListener)this);
        this.startTimePicker.addDataChangeListener((DataChangeListener)this);
        this.endTimePicker.addDataChangeListener((DataChangeListener)this);
        this.transactionTypeF7.addDataChangeListener((DataChangeListener)this);
        this.materialGroupStdF7.addDataChangeListener((DataChangeListener)this);
        this.materialGroupF7.addDataChangeListener((DataChangeListener)this);
        this.materialF7.addDataChangeListener((DataChangeListener)this);
        this.warehouseF7.addDataChangeListener((DataChangeListener)this);
        this.currencyF7.addDataChangeListener((DataChangeListener)this);
        this.fetchDataType.addItemListener((ItemListener)this);
        this.warehouseF7.addSelectorListener((SelectorListener)this);
    }

    protected void initControl() {
        String storageNum;
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (this.storeOrgUnitF7.getValue() instanceof String && (storageNum = (String)this.storeOrgUnitF7.getValue()) != null && storageNum.trim().length() > 0) {
            String[] strs = storageNum.split(";");
            StringBuffer bf = new StringBuffer("");
            for (int i = 0; i < strs.length; ++i) {
                bf.append(strs[i].trim()).append(",");
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrg.number", (Object)bf.toString(), CompareType.INCLUDE));
            entiryView.setFilter(filterInfo);
            this.warehouseF7.setEntityViewInfo(entiryView);
        }
        this.fetchDataType.setEditable(false);
    }

    public void willShow(SelectorEvent e) {
        Object source = e.getSource();
        if (!this.warehouseF7.equals(source) || this.storeOrgUnitF7.getValue() instanceof String) {
            // empty if block
        }
    }

    protected void init() {
        this.currencyF7.setEnabled(false);
        try {
            IMaterialGroupStandard iGroupStd = MaterialGroupStandardFactory.getRemoteInstance();
            MaterialGroupStandardCollection groupStdCollection = iGroupStd.getMaterialGroupStandardCollection();
            MaterialGroupStandardInfo mgroupStd = null;
            for (int i = 0; i < groupStdCollection.size(); ++i) {
                mgroupStd = groupStdCollection.get(i);
                if (mgroupStd == null || mgroupStd.getStandardType() == null || mgroupStd.getStandardType().getValue() != 1) continue;
                if (this.materialGroupStdF7 == null || this.materialGroupStdF7.getValue() != null && !"".equals(this.materialGroupStdF7.getValue())) break;
                this.materialGroupStdF7.setData((Object)mgroupStd);
                break;
            }
            this.initBillType();
            Timestamp startTime = SCMClientUtils.getServerDate();
            if (this.startTimePicker.getValue() == null) {
                this.startTimePicker.setValue((Object)startTime);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public abstract void initBillType();

    public void dataChanged(DataChangeEvent e) {
        try {
            Object source = e.getSource();
            if (e.getOldValue() != null && InvFormulaWinzardUI.getNumber(e.getOldValue()).equals(InvFormulaWinzardUI.getNumber(e.getNewValue()))) {
                return;
            }
            if (this.companyOrgUnitF7.equals(source)) {
                CompanyOrgUnitInfo companyOrgUnitInfo;
                PeriodInfo periodInfo;
                this.companyOrgUnitDataChanged(e);
                Object newValue = e.getNewValue();
                if (newValue instanceof CompanyOrgUnitInfo && (periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)(companyOrgUnitInfo = (CompanyOrgUnitInfo)newValue))) != null) {
                    this.startTimePicker.setValue((Object)periodInfo.getBeginDate());
                    this.endTimePicker.setValue((Object)periodInfo.getEndDate());
                }
            } else if (this.storeOrgUnitF7.equals(source)) {
                this.storeOrgChanged(e);
            } else if (this.materialGroupStdF7.equals(source)) {
                this.materialGroupStdChanged();
            } else if (this.materialGroupF7.equals(source)) {
                this.materialGroupChanged();
            }
        }
        catch (Exception exc) {
            this.handUIException(exc);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            Object source = e.getSource();
            if (this.fetchDataType.equals(source)) {
                this.fetchDataTypeChanged();
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected void companyOrgUnitDataChanged(DataChangeEvent e) {
        OrgUnitCollection ouc;
        this.first = true;
        this.set.clear();
        Object[] objs = null;
        CompanyOrgUnitInfo company = null;
        if (this.companyOrgUnitF7.getValue() instanceof Object[]) {
            objs = (Object[])this.companyOrgUnitF7.getValue();
        } else if (this.companyOrgUnitF7.getValue() instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)this.companyOrgUnitF7.getValue();
        }
        HashSet<CompanyOrgUnitInfo> set = new HashSet<CompanyOrgUnitInfo>();
        if (objs != null && company == null) {
            for (int k = 0; k < objs.length; ++k) {
                company = (CompanyOrgUnitInfo)objs[k];
                if (!company.isIsBizUnit()) continue;
                set.add(company);
            }
            objs = set.toArray();
            this.companyOrgUnitF7.removeDataChangeListener((DataChangeListener)this);
            this.companyOrgUnitF7.setData((Object)objs);
            this.companyOrgUnitF7.addDataChangeListener((DataChangeListener)this);
            company = null;
        }
        EntityViewInfo entiryView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer mskStr = new StringBuffer("");
        String msk = "";
        int k = 0;
        if (company != null) {
            CurrencyInfo currency = company.getBaseCurrency();
            try {
                if (currency != null && currency.getId() != null) {
                    currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
                    this.currencyF7.setValue((Object)currency);
                }
                ouc = InvClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)company);
                StorageOrgUnitInfo storageUnit = null;
                for (int i = 0; i < ouc.size(); ++i) {
                    storageUnit = (StorageOrgUnitInfo)ouc.get(i);
                    if (storageUnit == null || storageUnit.getId() == null) continue;
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageUnit.getId().toString()));
                    mskStr.append("#").append(k++).append(" or ");
                }
                if (!this.checkCompanyCur(company)) {
                    return;
                }
            }
            catch (Exception d) {
                this.handUIException(d);
            }
        } else if (objs != null) {
            this.currencyF7.setValue(null);
            for (int j = 0; j < objs.length; ++j) {
                company = (CompanyOrgUnitInfo)objs[j];
                if (!this.checkCompanyCur(company)) {
                    return;
                }
                ouc = InvClientUtils.getStorageUnitInfo((CompanyOrgUnitInfo)company);
                StorageOrgUnitInfo storageUnit = null;
                for (int i = 0; i < ouc.size(); ++i) {
                    storageUnit = (StorageOrgUnitInfo)ouc.get(i);
                    if (storageUnit == null || storageUnit.getId() == null) continue;
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)storageUnit.getId().toString()));
                    mskStr.append("#").append(k++).append(" or ");
                }
            }
        }
        if (objs != null || company != null) {
            if (mskStr.length() > 0) {
                msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
                filterInfo.setMaskString(msk);
            }
            entiryView.setFilter(filterInfo);
            this.storeOrgUnitF7.setEntityViewInfo(entiryView);
            CurrencyInfo currency = company.getBaseCurrency();
            try {
                if (currency != null && currency.getId() != null) {
                    currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
                    this.currencyF7.setValue((Object)currency);
                }
            }
            catch (Exception es) {
                this.handUIException(es);
            }
        } else {
            this.storeOrgUnitF7.setEntityViewInfo(null);
            this.currencyF7.setValue(null);
        }
    }

    private boolean checkCompanyCur(CompanyOrgUnitInfo company) {
        boolean flag = true;
        if (!company.isIsBizUnit()) {
            try {
                HashMap allPermissionOrgs = this.getUserPermissionOrgs();
                if (!this.checkBaseCurrency(allPermissionOrgs, company)) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"12_InvFormulaWinzardUI"));
                    this.companyOrgUnitF7.setValue(null);
                    flag = false;
                }
            }
            catch (Exception es) {
                this.handUIException(es);
            }
        } else if (!this.checkBaseCurrency(null, company)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"12_InvFormulaWinzardUI"));
            this.companyOrgUnitF7.setValue(null);
            flag = false;
        }
        return flag;
    }

    public HashMap getUserPermissionOrgs() throws Exception {
        if (this.permissionFullOrgs != null) {
            return this.permissionFullOrgs;
        }
        Map hasPermissionOrgs = SCMReportBatchUtils.getRptAuthorizedCompany(null);
        this.permissionFullOrgs = new HashMap();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("isBizUnit"));
        ev.getSelector().add(new SelectorItemInfo("accountPeriodType"));
        ev.getSelector().add(new SelectorItemInfo("reportConvertMode"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.id"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.number"));
        ev.getSelector().add(new SelectorItemInfo("reportCurrency.precision"));
        ev = SCMReportBatchUtils.getMultiEqualEntityView(ev, "id", hasPermissionOrgs.keySet());
        CompanyOrgUnitCollection ouc = SCMReportBatchUtils.getCompanyOrgUnitCollection(null, ev);
        int n = ouc.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo info = ouc.get(i);
            String number = info.getNumber();
            this.permissionFullOrgs.put(number, info);
        }
        return this.permissionFullOrgs;
    }

    protected boolean checkBaseCurrency(Map map, CompanyOrgUnitInfo info) {
        boolean flag = true;
        String longNumber = info.getLongNumber();
        if (longNumber == null && info.getId() != null) {
            try {
                info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                longNumber = info.getLongNumber();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        String temp = null;
        if (!info.isIsBizUnit()) {
            for (Map.Entry entry : map.entrySet()) {
                CompanyOrgUnitInfo tmpInfo = (CompanyOrgUnitInfo)entry.getValue();
                if (!tmpInfo.isIsBizUnit() || !tmpInfo.getLongNumber().startsWith(longNumber) || tmpInfo.getBaseCurrency() == null || tmpInfo.getBaseCurrency().getId() == null) continue;
                temp = tmpInfo.getBaseCurrency().getId().toString();
                if (this.first) {
                    this.set.add(tmpInfo.getBaseCurrency().getId().toString());
                    this.first = false;
                }
                if (this.set.contains(temp)) continue;
                flag = false;
                break;
            }
        } else if (info.getBaseCurrency() != null && info.getBaseCurrency().getId() != null) {
            temp = info.getBaseCurrency().getId().toString();
            if (this.first) {
                this.set.add(info.getBaseCurrency().getId().toString());
                this.first = false;
            }
            if (!this.set.contains(temp)) {
                flag = false;
            }
        }
        return flag;
    }

    protected void storeOrgChanged(DataChangeEvent e) {
        Object[] storageOrgUnits = null;
        if (this.storeOrgUnitF7.getValue() instanceof StorageOrgUnitInfo) {
            storageOrgUnits = new Object[]{this.storeOrgUnitF7.getValue()};
        } else if (this.storeOrgUnitF7.getValue() instanceof Object[]) {
            storageOrgUnits = (Object[])this.storeOrgUnitF7.getValue();
        }
        if (storageOrgUnits == null) {
            this.warehouseF7.setEntityViewInfo(null);
            this.materialF7.setEntityViewInfo(null);
            return;
        }
        StorageOrgUnitInfo storageOrg = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        EntityViewInfo viewInfo2 = this.materialF7.getEntityViewInfo();
        if (viewInfo2 == null) {
            viewInfo2 = new EntityViewInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        StringBuffer mskStr = new StringBuffer("");
        String msk = "";
        for (int i = 0; i < storageOrgUnits.length; ++i) {
            storageOrg = (StorageOrgUnitInfo)storageOrgUnits[i];
            if (storageOrg == null || storageOrg.getId() == null) continue;
            FilterItemInfo filterItemInfo = new FilterItemInfo("storageOrg.id", (Object)storageOrg.getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo2.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)storageOrg.getId().toString()));
            mskStr.append("#").append(i).append(" or ");
        }
        if (storageOrgUnits.length > 1) {
            msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
            filterInfo.setMaskString(msk);
            filterInfo2.setMaskString(msk);
        }
        viewInfo.setFilter(filterInfo);
        viewInfo2.setFilter(filterInfo2);
        this.warehouseF7.setEntityViewInfo(viewInfo);
        this.materialF7.setEntityViewInfo(viewInfo2);
    }

    protected void checkEndTime() {
        Timestamp startTime = (Timestamp)this.startTimePicker.getValue();
        Timestamp endTime = (Timestamp)this.endTimePicker.getValue();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"13_InvFormulaWinzardUI"));
        }
    }

    protected void checkStartTime() {
        Timestamp startTime = (Timestamp)this.startTimePicker.getValue();
        Timestamp endTime = (Timestamp)this.endTimePicker.getValue();
        if (startTime == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"14_InvFormulaWinzardUI"));
        } else if (startTime.after(endTime)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.scm.common.COMMONAutoGenerateResource", (String)"13_InvFormulaWinzardUI"));
        }
    }

    protected void materialGroupStdChanged() {
        this.materialGroupF7.setData(null);
        this.materialF7.setData(null);
        MaterialGroupStandardInfo mGroupStd = (MaterialGroupStandardInfo)this.materialGroupStdF7.getValue();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (mGroupStd != null && mGroupStd.getId() != null) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("groupStandard.id", (Object)mGroupStd.getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            viewInfo.setFilter(filterInfo);
            this.materialGroupF7.setEntityViewInfo(viewInfo);
        } else {
            this.materialGroupF7.setEntityViewInfo(null);
        }
    }

    protected void materialGroupChanged() {
        this.materialF7.setData(null);
        if (this.materialGroupF7.getValue() == null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)" ", CompareType.NOTEQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            this.materialF7.setEntityViewInfo(viewInfo);
            return;
        }
        Object[] materialGroups = null;
        if (this.materialGroupF7.getValue() instanceof MaterialGroupInfo) {
            materialGroups = new Object[]{this.materialGroupF7.getValue()};
        } else if (this.materialGroupF7.getValue() instanceof Object[]) {
            materialGroups = (Object[])this.materialGroupF7.getValue();
        }
        EntityViewInfo viewInfo = this.materialF7.getEntityViewInfo();
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        MaterialGroupInfo materialGroup = null;
        StringBuffer mskStr = new StringBuffer("");
        String msk = "";
        for (int i = 0; i < materialGroups.length; ++i) {
            materialGroup = (MaterialGroupInfo)materialGroups[i];
            if (materialGroup == null) continue;
            filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup.getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            mskStr.append("#").append(i).append(" or ");
        }
        if (materialGroups.length > 1) {
            msk = mskStr.delete(mskStr.lastIndexOf("or"), mskStr.length() - 1).toString();
            filterInfo.setMaskString(msk);
        }
        viewInfo.setFilter(filterInfo);
        this.materialF7.setEntityViewInfo(viewInfo);
    }

    protected void fetchDataTypeChanged() {
        int i = this.fetchDataType.getSelectedIndex();
    }

    public static String getNumber(Object value) {
        String number = value != null ? (value instanceof IObjectValue ? ((IObjectValue)value).getString("number") : value.toString()) : null;
        return number;
    }
}

