/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.security.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class SCMSqlUtil {
    private static final Logger logger = Logger.getLogger(SCMSqlUtil.class);
    public static final String DEFAULT_DELIMITER_COMMA = ",";
    public static final int MAX_ID_COUNT = 500;
    public static final int ID_LENGTH = 44;
    public static final int MAX_BATCH_COUNT = 3000;
    public static final String CREATE_TEMP_TABLE_SQL = "CREATE TABLE TEMP_KSQL_TABLE (FID VARCHAR(44)) ";
    public static final String SELECT_TEMP_TBALE_SQL = "SELECT FID FROM {0} ";
    public static final String INSERT_TEMP_TABLE_SQL = "INSERT INTO {0} (FID) VALUES (?) ";

    public static Result convertIds(Context ctx, String ids) throws BOSException {
        return SCMSqlUtil.convertIds(ctx, ids, DEFAULT_DELIMITER_COMMA);
    }

    public static Result convertIds(Context ctx, Set idSet) throws BOSException {
        StringBuffer ids = new StringBuffer();
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            ids.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            ids.append(DEFAULT_DELIMITER_COMMA);
        }
        return SCMSqlUtil.convertIds(ctx, ids.toString());
    }

    public static int getLimitForIDTempTab(Context ctx) {
        String limitForIDTempTab = SCMServerUtil.getDTTEMPPARAM((Context)ctx, (String)"limitForIDTempTab");
        if (StringUtils.isEmpty((String)limitForIDTempTab)) {
            limitForIDTempTab = String.valueOf(500);
        }
        return Integer.valueOf(limitForIDTempTab);
    }

    public static Result convertIds(Context ctx, String ids, String delimiter) throws BOSException {
        int maxCount = SCMSqlUtil.getLimitForIDTempTab(ctx);
        Result result = new Result();
        if (!StringUtils.isEmpty((String)ids)) {
            int length;
            result.setParameters(ids.split(delimiter));
            int n = length = null == result.getParameters() ? 0 : result.getParameters().length;
            if (length > 0 && length <= maxCount) {
                result.setResultType(resultTypeEnum.simple);
                StringBuilder buf = new StringBuilder(maxCount);
                for (int i = 0; i < length; ++i) {
                    buf.append("?");
                    if (i == length - 1) continue;
                    buf.append(" , ");
                }
                result.setPlaceholder(buf.toString());
            } else {
                result.setResultType(resultTypeEnum.complex);
                String tempTable = SCMSqlUtil.convertIdArrToTempTab(ctx, result.getParameters());
                result.setTempTable(tempTable).setSelectSQL(MessageFormat.format(SELECT_TEMP_TBALE_SQL, tempTable));
            }
        } else {
            result.setErrorMsg("input param[ids] is empty!");
        }
        return result;
    }

    public static String convertIdArrToTempTab(Context ctx, String[] idArr) throws BOSException {
        String tempTable = "";
        if (null == idArr) {
            return tempTable;
        }
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            tempTable = tmpTblPool.createTempTable(CREATE_TEMP_TABLE_SQL);
            tmpTblPool.createIndex(tempTable, "FID", false, true);
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(MessageFormat.format(INSERT_TEMP_TABLE_SQL, tempTable));
            int count = 0;
            for (int i = 0; i < idArr.length; ++i) {
                ps.setString(1, idArr[i]);
                ps.addBatch();
                if (++count % 3000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException("cannot create tempTable ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SCMSqlUtil.cleanup(null, ps, con);
                throw throwable;
            }
        }
        SCMSqlUtil.cleanup(null, ps, con);
        return tempTable;
    }

    public static String createTempTable(Context ctx, String tblDefine) throws BOSException {
        String tblName = null;
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tblName = tmpTblPool.createTempTable("CREATE TABLE TEML_KSQL_0 " + tblDefine);
        }
        catch (Exception e) {
            throw new BOSException("cannot create tempTable", (Throwable)e);
        }
        return tblName;
    }

    public static void releasTempTable(Context ctx, String tmpTableName) throws BOSException {
        if (StringUtils.isEmpty((String)tmpTableName)) {
            return;
        }
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tmpTblPool.releaseTable(tmpTableName);
        }
        catch (Exception e) {
            throw new BOSException("cannot release tempTable", (Throwable)e);
        }
    }

    public static void cleanup(ResultSet rs, Statement stmt, Connection cn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            rs = null;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            stmt = null;
        }
        if (cn != null) {
            try {
                cn.close();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            cn = null;
        }
    }

    public static class Result {
        private resultTypeEnum resultType = resultTypeEnum.exception;
        private String placeholder;
        private String[] parameters;
        private String selectSQL;
        private String errorMsg;
        private String tempTable;

        Result() {
        }

        public resultTypeEnum getResultType() {
            return this.resultType;
        }

        public Result setResultType(resultTypeEnum resultType) {
            this.resultType = resultType;
            return this;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public Result setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public Result setParameters(String[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public String getSelectSQL() {
            return this.selectSQL;
        }

        public Result setSelectSQL(String selectSQL) {
            this.selectSQL = selectSQL;
            return this;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public Result setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public String getTempTable() {
            return this.tempTable;
        }

        public Result setTempTable(String tempTable) {
            this.tempTable = tempTable;
            return this;
        }

        public String getCommonResult() {
            if (this.resultType.equals((Object)resultTypeEnum.simple)) {
                return this.getPlaceholder();
            }
            if (this.resultType.equals((Object)resultTypeEnum.complex)) {
                return this.getSelectSQL();
            }
            return null;
        }

        public String[] getCommonParam() {
            if (this.resultType.equals((Object)resultTypeEnum.simple)) {
                return this.getParameters();
            }
            if (this.resultType.equals((Object)resultTypeEnum.complex)) {
                return new String[0];
            }
            return null;
        }
    }

    public static enum resultTypeEnum {
        exception,
        simple,
        complex;

    }
}

