/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import java.util.Map;

public class PermissionServiceHelper {
    private static PermissionServiceHelper permissionHelper;
    private static final String ERROR_NOPERMISSION = "ERROR_NOPERMISSION";

    private PermissionServiceHelper() {
    }

    public static PermissionServiceHelper getInstance() {
        if (permissionHelper == null) {
            permissionHelper = new PermissionServiceHelper();
        }
        return permissionHelper;
    }

    public void doPermissionService(ActionProxy actionProxy, BatchSelectionEntries selectionEntry, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException {
        Map resultMap = SCMServiceFactory.getPermissionService().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), selectionEntry.getOrgList(), uiMedataPK, actionPK);
        this.processPermissionResult(resultMap, actionProxy, selectionEntry);
    }

    private void processPermissionResult(Map resultMap, ActionProxy actionProxy, BatchSelectionEntries selectionEntry) {
        String PERM_ERROR = ResourceUtils.getMessageInOrder("com.kingdee.eas.scm.common.ActionResource", ERROR_NOPERMISSION, new String[]{(String)actionProxy.getValue("ShortDescription")});
        int size = selectionEntry.size();
        for (int idx = 0; idx < size; ++idx) {
            BatchSelectionEntry entry = selectionEntry.get(idx);
            if (resultMap.containsKey(entry.getOrgId())) {
                entry.setResult(ActionResultEnum.ERROR);
                Exception e = (Exception)resultMap.get(entry.getOrgId());
                entry.setResultMsg(e == null ? PERM_ERROR : e.getMessage());
                continue;
            }
            entry.setResult(ActionResultEnum.SUCCESS);
        }
    }
}

