/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class AdminPasswordCheckUtil {
    private AdminPasswordCheckUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showPasswordUIandCheck() throws EASBizException, BOSException {
        if (System.getProperty("debug") != null) {
            return true;
        }
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        JPasswordField pwd = new JPasswordField("");
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"inputPassword"), pwd};
        int res = JOptionPane.showConfirmDialog(null, message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        char[] password = pwd.getPassword();
        try {
            if (EmptyUtil.isEmpty((String)new String(password))) {
                MsgBox.showInfo(null, (String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"passwordIsNull"));
                SysUtil.abort();
            }
            if (AdminPasswordCheckUtil.matchPassword(userInfo = UserFactory.getRemoteInstance().getUserInfoByNumber("administrator"), new String(password))) {
                boolean bl = true;
                return bl;
            }
            MsgBox.showInfo(null, (String)EASResource.getString((String)"com.kingdee.eas.scm.common.SCMLogResource", (String)"passwordError"));
            SysUtil.abort();
        }
        finally {
            Arrays.fill(password, ' ');
        }
        return false;
    }

    private static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        Method matchPssworMethod = null;
        Class<?> permClz = null;
        try {
            permClz = Class.forName("com.kingdee.eas.base.permission.PermissionUtils");
            matchPssworMethod = permClz.getDeclaredMethod("matchPassword", UserInfo.class, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (matchPssworMethod != null) {
            try {
                return (Boolean)matchPssworMethod.invoke(permClz, userInfo, password);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return AdminPasswordCheckUtil.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
        }
        return false;
    }

    private static String encrypt(String userID, String password) throws EASBizException {
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }
}

