/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfoFacadeFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IFetchSupplyInfoFacade;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplierInfoCondition;
import com.kingdee.eas.basedata.scm.sm.srm.SupplierInfoConditionCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.ListMap;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BatchFetchDataUtils {
    public static Map getFetchSupplyInfoMap(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate) throws BOSException, EASBizException {
        return BatchFetchDataUtils.getFetchSupplyInfoMap(materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, 0);
    }

    public static Map getFetchSupplyInfoMap(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType) throws BOSException, EASBizException {
        return BatchFetchDataUtils.getFetchSupplyInfoMap(null, materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, 0);
    }

    public static Map getFetchSupplyInfoMap(Context ctx, Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        if (materialMap != null && materialMap.size() > 0) {
            String[] materials = materialMap.keySet().toArray(new String[materialMap.size()]);
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
            int n = materials.length;
            for (int i = 0; i < n; ++i) {
                String check;
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                String tmp = materials[i];
                String materialPK = "";
                BigDecimal qty = SysConstant.BIGZERO;
                String unitPK = "";
                boolean isPriceOnQty = false;
                int k = tmp.indexOf("_qty_");
                int j = tmp.indexOf("_ischeck_");
                String tmp1 = "";
                if (k > 0) {
                    materialPK = tmp.substring(0, k);
                    if (j > 0) {
                        tmp1 = tmp.substring(k + 5, j);
                        if (tmp1.length() > 0) {
                            int h = tmp1.indexOf("~|~");
                            if (h > 0) {
                                qty = new BigDecimal(tmp1.substring(0, h));
                                unitPK = tmp1.substring(h + 3);
                            } else {
                                qty = new BigDecimal(tmp1);
                            }
                        }
                    } else {
                        tmp1 = tmp.substring(k + 5);
                        if (tmp1.length() > 0) {
                            int h = tmp1.indexOf("~|~");
                            if (h > 0) {
                                qty = new BigDecimal(tmp1.substring(0, h));
                                unitPK = tmp1.substring(h + 3);
                            } else {
                                qty = new BigDecimal(tmp1);
                            }
                        }
                    }
                } else {
                    materialPK = tmp;
                }
                if (j > 0 && (check = tmp.substring(j + 9)).equalsIgnoreCase("1")) {
                    isPriceOnQty = true;
                }
                condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materialPK));
                condition.setQty(qty);
                if (unitPK.length() > 0) {
                    condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitPK));
                }
                condition.setisPriceOnQty(isPriceOnQty);
                condition.setisUseSupport(isPriceOnQty);
                condition.setDate(bizDate);
                condition.setDeliveryDate(isDeliveryDate);
                condition.setMaterialPurchaseType(materialPurchaseType);
                conditions.add(condition);
            }
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = null;
            fetchSupplyInfoFacade = ctx == null ? FetchSupplyInfoFacadeFactory.getRemoteInstance() : FetchSupplyInfoFacadeFactory.getLocalInstance((Context)ctx);
            FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
            if (collection != null && collection.size() > 0) {
                int n2 = collection.size();
                for (int i = 0; i < n2; ++i) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(i);
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }

    public static Map getFetchSupplyInfoMap2(String[] materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate) throws BOSException, EASBizException {
        return BatchFetchDataUtils.getFetchSupplyInfoMap2(materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, 0, false, true);
    }

    public static Map getFetchSupplyInfoMap2(String[] materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType) throws BOSException, EASBizException {
        return BatchFetchDataUtils.getFetchSupplyInfoMap2(materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, materialPurchaseType, false, true);
    }

    public static Map getFetchSupplyInfoMap2(String[] materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType, boolean isVMI, boolean isIgnoreVMI) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        if (materialMap != null && materialMap.length > 0) {
            String[] materials = materialMap;
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = FetchSupplyInfoFacadeFactory.getRemoteInstance();
            int n = materials.length;
            for (int i = 0; i < n; ++i) {
                SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                String tmp = materials[i];
                String materialPK = "";
                BigDecimal qty = SysConstant.BIGZERO;
                String unitPK = "";
                boolean isPriceOnQty = false;
                if (tmp != null) {
                    String check;
                    int k = tmp.indexOf("_qty_");
                    int j = tmp.indexOf("_ischeck_");
                    String tmp1 = "";
                    if (k > 0) {
                        materialPK = tmp.substring(0, k);
                        if (j > 0) {
                            tmp1 = tmp.substring(k + 5, j);
                            if (tmp1.length() > 0) {
                                int h = tmp1.indexOf("~|~");
                                if (h > 0) {
                                    qty = new BigDecimal(tmp1.substring(0, h));
                                    unitPK = tmp1.substring(h + 3);
                                } else {
                                    qty = new BigDecimal(tmp1);
                                }
                            }
                        } else {
                            tmp1 = tmp.substring(k + 5);
                            if (tmp1.length() > 0) {
                                int h = tmp1.indexOf("~|~");
                                if (h > 0) {
                                    qty = new BigDecimal(tmp1.substring(0, h));
                                    unitPK = tmp1.substring(h + 3);
                                } else {
                                    qty = new BigDecimal(tmp1);
                                }
                            }
                        }
                    } else {
                        materialPK = tmp;
                    }
                    if (j > 0 && (check = tmp.substring(j + 9)).equalsIgnoreCase("1")) {
                        isPriceOnQty = true;
                    }
                }
                if (materialPK.length() > 0) {
                    condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materialPK));
                }
                if (qty != null && qty.compareTo(SysConstant.BIGZERO) != 0) {
                    condition.setQty(qty);
                }
                if (unitPK.length() > 0) {
                    condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitPK));
                }
                condition.setisPriceOnQty(isPriceOnQty);
                condition.setisUseSupport(isPriceOnQty);
                condition.setDate(bizDate);
                condition.setDeliveryDate(isDeliveryDate);
                condition.setMaterialPurchaseType(materialPurchaseType);
                condition.setIgnoreVMI(isIgnoreVMI);
                condition.setVMI(isVMI);
                conditions.add(condition);
                FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
                if (collection == null || collection.size() <= 0) continue;
                int m = collection.size();
                for (int f = 0; f < m; ++f) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(f);
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        if (approvedSupplierInfo.getMaterialItem() == null) continue;
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID + "~|~" + i, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null || supplyInfoInfo.getMaterialItem() == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID + "~|~" + i, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }

    public static Map getFetchSupplyInfoMapReq(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate) throws BOSException, EASBizException {
        return BatchFetchDataUtils.getFetchSupplyInfoMapReq(materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, 0);
    }

    public static Map getFetchSupplyInfoMapReq(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        if (materialMap != null && materialMap.size() > 0) {
            String[] materials = materialMap.keySet().toArray(new String[materialMap.size()]);
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
            int n = materials.length;
            for (int i = 0; i < n; ++i) {
                String check;
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                String tmp = materials[i];
                String materialPK = "";
                BigDecimal qty = SysConstant.BIGZERO;
                String unitPK = "";
                boolean isPriceOnQty = false;
                int k = tmp.indexOf("_qty_");
                int j = tmp.indexOf("_ischeck_");
                String tmp1 = "";
                if (k > 0) {
                    materialPK = tmp.substring(0, k);
                    if (j > 0) {
                        tmp1 = tmp.substring(k + 5, j);
                        if (tmp1.length() > 0) {
                            int h = tmp1.indexOf("~|~");
                            if (h > 0) {
                                qty = new BigDecimal(tmp1.substring(0, h));
                                unitPK = tmp1.substring(h + 3);
                            } else {
                                qty = new BigDecimal(tmp1);
                            }
                        }
                    } else {
                        tmp1 = tmp.substring(k + 5);
                        if (tmp1.length() > 0) {
                            int h = tmp1.indexOf("~|~");
                            if (h > 0) {
                                qty = new BigDecimal(tmp1.substring(0, h));
                                unitPK = tmp1.substring(h + 3);
                            } else {
                                qty = new BigDecimal(tmp1);
                            }
                        }
                    }
                } else {
                    materialPK = tmp;
                }
                if (j > 0 && (check = tmp.substring(j + 9)).equalsIgnoreCase("1")) {
                    isPriceOnQty = true;
                }
                condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materialPK));
                condition.setQty(qty);
                if (unitPK.length() > 0) {
                    condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitPK));
                }
                condition.setisPriceOnQty(isPriceOnQty);
                condition.setisUseSupport(isPriceOnQty);
                condition.setDate(bizDate);
                condition.setDeliveryDate(isDeliveryDate);
                condition.setMaterialPurchaseType(materialPurchaseType);
                condition.put("isRequest", (Object)"true");
                conditions.add(condition);
            }
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = FetchSupplyInfoFacadeFactory.getRemoteInstance();
            FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
            if (collection != null && collection.size() > 0) {
                int n2 = collection.size();
                for (int i = 0; i < n2; ++i) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(i);
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }

    public static Map getSupplierInfos(Map materialMap, String purchaseOrgId, Date bizDate, String supplierId) throws BOSException, EASBizException {
        HashMap<String, SupplyInfoInfo> supplierMap = new HashMap<String, SupplyInfoInfo>();
        ISupplyInfo iSupplyInfo = SupplyInfoFactory.getRemoteInstance();
        Object[] objects = materialMap.keySet().toArray();
        String[] materials = new String[materialMap.size()];
        System.arraycopy(objects, 0, materials, 0, materials.length);
        SupplyInfoCollection collection = iSupplyInfo.getSupplyInfoCollection(materials, purchaseOrgId, bizDate, supplierId);
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                supplierMap.put(collection.get(i).getMaterialItem().getId().toString(), collection.get(i));
            }
        }
        return supplierMap;
    }

    public static Map getMeasureUnitInfos(Map unitIdMap) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        Iterator iter = unitIdMap.keySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        IMeasureUnit iunit = MeasureUnitFactory.getRemoteInstance();
        MeasureUnitCollection collection = iunit.getMeasureUnitCollection(view);
        if (collection != null) {
            for (int i = 0; i < collection.size(); ++i) {
                MeasureUnitInfo unit = collection.get(i);
                unitMap.put(unit.getId().toString(), unit);
            }
        }
        return unitMap;
    }

    public static void getUOM4Entries(MeasureUnitInfo[] baseUnits, MeasureUnitInfo[] units, MeasureUnitInfo[] assistUnits, int changeLevel) throws BOSException {
        Map unitVOMap;
        int i;
        HashMap unitMap = new HashMap();
        if (changeLevel == 0) {
            for (i = 0; i < baseUnits.length; ++i) {
                if (baseUnits[i] != null) {
                    unitMap.put(baseUnits[i].getId().toString(), null);
                }
                if (assistUnits[i] == null) continue;
                unitMap.put(assistUnits[i].getId().toString(), null);
            }
        }
        for (i = 0; i < baseUnits.length; ++i) {
            if (units[i] == null) continue;
            unitMap.put(units[i].getId().toString(), null);
        }
        if (unitMap.size() > 0 && (unitVOMap = BatchFetchDataUtils.getMeasureUnitInfos(unitMap)) != null && unitVOMap.size() > 0) {
            int i2;
            if (changeLevel == 0) {
                for (i2 = 0; i2 < baseUnits.length; ++i2) {
                    if (baseUnits[i2] != null) {
                        baseUnits[i2] = (MeasureUnitInfo)unitVOMap.get(baseUnits[i2].getId().toString());
                    }
                    if (assistUnits[i2] == null) continue;
                    assistUnits[i2] = (MeasureUnitInfo)unitVOMap.get(assistUnits[i2].getId().toString());
                }
            }
            for (i2 = 0; i2 < baseUnits.length; ++i2) {
                if (units[i2] == null) continue;
                units[i2] = (MeasureUnitInfo)unitVOMap.get(units[i2].getId().toString());
            }
        }
    }

    public static void fetchUOMRates(ListMap convertMap) throws BOSException, EASBizException {
        if (convertMap != null && convertMap.size() > 0) {
            ObjectListMap map = new ObjectListMap(2);
            Object[] keys = convertMap.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                if (!map.containsKey(key)) {
                    map.put2(key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 1)});
                }
                if (convertMap.get(keys[i], 2) == null || map.containsKey(key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2))) continue;
                map.put2(key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 2)});
            }
            if (map.size() > 0) {
                String[] materialIds = new String[map.size()];
                String[] unitIds = new String[map.size()];
                Iterator iter = map.keySet().iterator();
                int idx = 0;
                while (iter.hasNext()) {
                    Object akey = iter.next();
                    materialIds[idx] = (String)map.get(akey, 0);
                    unitIds[idx] = (String)map.get(akey, 1);
                    ++idx;
                }
                IMultiMeasureUnit iMultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                Map rateMap = iMultiUnit.getConvRatesByMaterial(materialIds, unitIds);
                if (rateMap != null && rateMap.size() > 0) {
                    BigDecimal zero = new BigDecimal(0.0);
                    for (int i = 0; i < keys.length; ++i) {
                        String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                        BigDecimal value1 = (BigDecimal)rateMap.get(key);
                        if (convertMap.get(keys[i], 2) != null) {
                            key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2);
                            BigDecimal value2 = (BigDecimal)rateMap.get(key);
                            if (value1 == null || value2 == null || value2.compareTo(zero) == 0) continue;
                            BigDecimal value = value1.divide(value2, 10, 4);
                            convertMap.set(keys[i], 3, value);
                            continue;
                        }
                        convertMap.set(keys[i], 3, value1);
                    }
                }
            }
        }
    }

    public static List getIsInnerCompany(Map customerMap) throws BOSException, EASBizException {
        ICustomer iCustomer = CustomerFactory.getRemoteInstance();
        ArrayList customerList = new ArrayList();
        customerList.addAll(customerMap.keySet());
        return iCustomer.isExistCustomerByInter(customerList);
    }

    public static Map getFetchSupplyInfoMapReturns(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        if (materialMap != null && materialMap.size() > 0) {
            String[] materials = materialMap.keySet().toArray(new String[materialMap.size()]);
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
            int n = materials.length;
            for (int i = 0; i < n; ++i) {
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materials[i]));
                condition.setDate(bizDate);
                condition.setDeliveryDate(isDeliveryDate);
                condition.put("isRequest", (Object)"true");
                conditions.add(condition);
            }
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = FetchSupplyInfoFacadeFactory.getRemoteInstance();
            FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
            if (collection != null && collection.size() > 0) {
                int n2 = collection.size();
                for (int i = 0; i < n2; ++i) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(i);
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }

    public static Map getFetchSupplyInfoMapReturns(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, MeasureUnitInfo unitInfo) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        if (materialMap != null && materialMap.size() > 0) {
            String[] materials = materialMap.keySet().toArray(new String[materialMap.size()]);
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
            int n = materials.length;
            for (int i = 0; i < n; ++i) {
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materials[i]));
                condition.setDate(bizDate);
                condition.setDeliveryDate(isDeliveryDate);
                if (unitInfo != null) {
                    condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitInfo.getId().toString()));
                }
                condition.put("isRequest", (Object)"true");
                conditions.add(condition);
            }
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = FetchSupplyInfoFacadeFactory.getRemoteInstance();
            FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
            if (collection != null && collection.size() > 0) {
                int n2 = collection.size();
                for (int i = 0; i < n2; ++i) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(i);
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }

    public static Map getFetchSupplyInfoMap3(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, boolean isVMI, boolean isIgnoreVMI) throws BOSException, EASBizException {
        int materialPurchaseType = 0;
        if (materialMap != null && materialMap.get("materialPurchaseType") != null) {
            materialPurchaseType = Integer.parseInt(materialMap.get("materialPurchaseType").toString());
        }
        return BatchFetchDataUtils.getFetchSupplyInfoMap3(materialMap, purchaseOrgId, supplierId, bizDate, isDeliveryDate, materialPurchaseType, isVMI, isIgnoreVMI);
    }

    public static Map getFetchSupplyInfoMap3(Map materialMap, String purchaseOrgId, String supplierId, Date bizDate, boolean isDeliveryDate, int materialPurchaseType, boolean isVMI, boolean isIgnoreVMI) throws BOSException, EASBizException {
        HashMap<String, FetchSupplyInfo> fetchSupplyInfoMap = new HashMap<String, FetchSupplyInfo>();
        ArrayList aryItem = null;
        Map itemInfoMap = null;
        if (materialMap != null && materialMap.size() > 0) {
            aryItem = (ArrayList)materialMap.get("itemInfo");
            ObjectUuidPK purOrgPK = new ObjectUuidPK(purchaseOrgId);
            ObjectUuidPK supplierPK = new ObjectUuidPK(supplierId);
            IFetchSupplyInfoFacade fetchSupplyInfoFacade = FetchSupplyInfoFacadeFactory.getRemoteInstance();
            SupplierInfoConditionCollection conditions = new SupplierInfoConditionCollection();
            int n = aryItem.size();
            for (int i = 0; i < n; ++i) {
                SupplierInfoCondition condition = new SupplierInfoCondition();
                condition.setPurOrgUnitPK((IObjectPK)purOrgPK);
                condition.setSupplierPK((IObjectPK)supplierPK);
                itemInfoMap = (Map)aryItem.get(i);
                String materialPK = "";
                if (itemInfoMap.get("itemPk") != null) {
                    materialPK = itemInfoMap.get("itemPk").toString();
                }
                String unitPK = "";
                if (itemInfoMap.get("unitPk") != null) {
                    unitPK = itemInfoMap.get("unitPk").toString();
                }
                BigDecimal qty = SysConstant.BIGZERO;
                if (itemInfoMap.get("qty") != null) {
                    qty = new BigDecimal(itemInfoMap.get("qty").toString());
                }
                String recOrgPk = "";
                if (itemInfoMap.get("recOrgPk") != null) {
                    recOrgPk = itemInfoMap.get("recOrgPk").toString();
                }
                boolean isPriceOnQty = false;
                boolean isUseRecOrg = false;
                if (itemInfoMap.get("isPriceOnQty") != null) {
                    boolean bl = isPriceOnQty = new Integer(itemInfoMap.get("isPriceOnQty").toString()) == 1;
                }
                if (itemInfoMap.get("isUseRecOrg") != null) {
                    isUseRecOrg = new Integer(itemInfoMap.get("isUseRecOrg").toString()) == 1;
                }
                condition.setMaterialPK((IObjectPK)new ObjectUuidPK(materialPK));
                condition.setQty(qty);
                if (unitPK.length() > 0) {
                    condition.setUnitPK((IObjectPK)new ObjectUuidPK(unitPK));
                }
                condition.setisPriceOnQty(isPriceOnQty);
                condition.setisUseSupport(isPriceOnQty);
                condition.setisUseRecOrg(isUseRecOrg);
                if (recOrgPk.length() > 0) {
                    condition.setRecOrgUnitPK((IObjectPK)new ObjectUuidPK(recOrgPk));
                }
                Date date = null;
                date = bizDate;
                condition.setDate(date);
                condition.setDeliveryDate(isDeliveryDate);
                condition.setMaterialPurchaseType(materialPurchaseType);
                condition.setVMI(isVMI);
                condition.setIgnoreVMI(isIgnoreVMI);
                conditions.add(condition);
            }
            FetchSupplyInfoCollection collection = fetchSupplyInfoFacade.getFetchSupplyInfoCollection(conditions);
            if (collection != null && collection.size() > 0) {
                int m = collection.size();
                for (int f = 0; f < m; ++f) {
                    String materialID;
                    FetchSupplyInfo fetchSupplyInfo = collection.get(f);
                    int i = fetchSupplyInfo.getSeq();
                    ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                    SupplyInfoInfo supplyInfoInfo = fetchSupplyInfo.getSupPriceInfo();
                    if (approvedSupplierInfo != null) {
                        materialID = approvedSupplierInfo.getMaterialItem().getId().toString();
                        fetchSupplyInfoMap.put(materialID + "~|~" + i, fetchSupplyInfo);
                        continue;
                    }
                    if (supplyInfoInfo == null) continue;
                    materialID = supplyInfoInfo.getMaterialItem().getId().toString();
                    fetchSupplyInfoMap.put(materialID + "~|~" + i, fetchSupplyInfo);
                }
            }
        }
        return fetchSupplyInfoMap;
    }
}

