/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.math.BigDecimal;

public final class CalculateUtils {
    private CalculateUtils() {
    }

    private static int getScale(BigDecimal num) {
        return num.scale() + 2;
    }

    public static BigDecimal calDiscountAmount(DiscountModeEnum discounMode, BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, BigDecimal taxRate, int scale, boolean isInTax) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return CalculateUtils.calDiscountAmountByPercent(discount, qty, taxPrice, scale);
        }
        return CalculateUtils.calDiscountAmountByPerunit(discount, qty, taxRate, scale, isInTax);
    }

    public static BigDecimal calDiscountAmountByTaxAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal taxAmount, int scale) {
        return SCMUtils.effectualNumeric(taxPrice).multiply(SCMUtils.effectualNumeric(qty)).setScale(scale, 4).subtract(SCMUtils.effectualNumeric(taxAmount)).setScale(scale, 4);
    }

    public static BigDecimal calDiscountRateByActualTaxPrice(BigDecimal actualTaxPrice, BigDecimal taxPrice, int scale) {
        BigDecimal discountRate = SysConstant.BIGZERO;
        if (!SCMUtils.equalsZero(taxPrice)) {
            discountRate = SCMConstant.BIGDECIMAL_ONE.subtract(SCMUtils.effectualNumeric(actualTaxPrice).divide(SCMUtils.effectualNumeric(taxPrice), 10, 4));
        }
        discountRate = discountRate.multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED).setScale(scale, 4);
        return discountRate;
    }

    public static BigDecimal calUnitDiscountByActualTaxPrice(BigDecimal actualTaxPrice, BigDecimal taxPrice, int scale) {
        return SCMUtils.effectualNumeric(taxPrice).subtract(SCMUtils.effectualNumeric(actualTaxPrice)).setScale(scale, 4);
    }

    public static BigDecimal calDiscountAmountByPercent(BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discount == null || qty == null || taxPrice == null) {
            return null;
        }
        BigDecimal discountAmount = null;
        BigDecimal oneHundred = new BigDecimal("100.00");
        discountAmount = taxPrice.multiply(qty).multiply(discount.divide(oneHundred, CalculateUtils.getScale(discount), 4));
        discountAmount = discountAmount.setScale(scale, 4);
        return discountAmount;
    }

    public static BigDecimal calDiscountByPercent(BigDecimal discountAmount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discountAmount == null || qty == null || taxPrice == null) {
            return null;
        }
        BigDecimal discount = null;
        BigDecimal oneHundred = new BigDecimal("100.00");
        if (qty.compareTo(new BigDecimal("0.00")) > 0 && taxPrice.compareTo(new BigDecimal("0.00")) > 0) {
            discount = discountAmount.multiply(oneHundred).divide(taxPrice.multiply(qty), scale, 4);
        }
        return discount;
    }

    public static BigDecimal calDiscountByPerunit(BigDecimal discountAmount, BigDecimal qty, BigDecimal taxRate, int scale, boolean isInTax) {
        if (discountAmount == null || qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal discount = null;
        discount = discountAmount.divide(qty, scale, 4);
        if (!isInTax) {
            BigDecimal oneHundred = new BigDecimal("100.00");
            BigDecimal one = new BigDecimal("1.0");
            discount = discount.divide(one.add(taxRate.divide(oneHundred, 10, 4)), 10, 4);
        }
        discount = discount.setScale(scale, 4);
        return discount;
    }

    public static BigDecimal calDiscountAmountByPerunit(BigDecimal discount, BigDecimal qty, BigDecimal taxRate, int scale, boolean isInTax) {
        if (taxRate == null) {
            taxRate = new BigDecimal("0.00");
        }
        if (discount == null || qty == null || taxRate == null) {
            return null;
        }
        BigDecimal discountAmount = null;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.00");
        discountAmount = qty.multiply(discount);
        if (!isInTax) {
            discountAmount = discountAmount.multiply(one.add(taxRate.divide(oneHundred, 10, 4)));
        }
        discountAmount = discountAmount.setScale(scale, 4);
        return discountAmount;
    }

    public static BigDecimal calTaxPrice(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return null;
        }
        taxRate = taxRate == null ? new BigDecimal("0.0") : taxRate;
        BigDecimal taxPrice = null;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, CalculateUtils.getScale(taxRate), 4);
        taxPrice = price.multiply(one.add(taxRate));
        taxPrice = taxPrice.setScale(scale, 4);
        return taxPrice;
    }

    public static BigDecimal calActualPrice(DiscountModeEnum discounMode, BigDecimal discount, BigDecimal price, BigDecimal taxRate, int scale) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return CalculateUtils.calActualPriceByPercent(discount, price, scale);
        }
        return CalculateUtils.calActualPriceByPerunit(discount, price, taxRate, scale);
    }

    public static BigDecimal calActualPriceByPerunit(BigDecimal discount, BigDecimal price, BigDecimal taxRate, int scale) {
        if (discount == null && price == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, CalculateUtils.getScale(taxRate), 4);
        discount = discount == null ? zero : discount;
        price = price == null ? zero : price;
        BigDecimal actualPrice = null;
        actualPrice = price.subtract(discount.divide(one.add(taxRate), scale + 1, 4));
        actualPrice = actualPrice.setScale(scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualPrice(BigDecimal amount, BigDecimal qty, int scale) {
        BigDecimal zero = new BigDecimal("0.00");
        amount = amount == null ? zero : amount;
        BigDecimal bigDecimal = qty = qty == null ? zero : qty;
        if (qty.equals(zero) || qty.compareTo(zero) == 0) {
            return zero;
        }
        BigDecimal actualPrice = amount.divide(qty, scale, 4);
        actualPrice = actualPrice.setScale(scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxAmount, BigDecimal qty, int scale) {
        BigDecimal zero = new BigDecimal("0.00");
        taxAmount = taxAmount == null ? zero : taxAmount;
        BigDecimal bigDecimal = qty = qty == null ? zero : qty;
        if (qty.compareTo(zero) == 0) {
            return zero;
        }
        BigDecimal actualPrice = taxAmount.divide(qty, scale, 4);
        actualPrice = actualPrice.setScale(scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualPriceByPercent(BigDecimal discount, BigDecimal price, int scale) {
        if (price == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.0");
        discount = discount == null ? zero : discount;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal actualPrice = null;
        actualPrice = price.multiply(one.subtract(discount.divide(oneHundred, CalculateUtils.getScale(discount), 4)));
        actualPrice = actualPrice.setScale(scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualTaxPrice(DiscountModeEnum discounMode, BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return CalculateUtils.calActualTaxPriceByPercent(taxPrice, discount, scale);
        }
        return CalculateUtils.calActualTaxPriceByPerunit(taxPrice, discount, scale);
    }

    public static BigDecimal calActualTaxPriceByPercent(BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (taxPrice == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.0");
        discount = discount == null ? zero : discount;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal discountTaxPrice = taxPrice.multiply(one.subtract(discount.divide(oneHundred, CalculateUtils.getScale(discount), 4)));
        discountTaxPrice = discountTaxPrice.setScale(scale, 4);
        return discountTaxPrice;
    }

    public static BigDecimal calActualTaxPriceByPerunit(BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (taxPrice == null && discount == null) {
            return null;
        }
        BigDecimal zero = new BigDecimal("0.0");
        taxPrice = taxPrice == null ? zero : taxPrice;
        discount = discount == null ? zero : discount;
        BigDecimal discountTaxPrice = taxPrice.subtract(discount);
        discountTaxPrice = discountTaxPrice.setScale(scale, 4);
        return discountTaxPrice;
    }

    public static BigDecimal calAmount(BigDecimal qty, BigDecimal actualPrice, int scale) {
        if (qty == null || actualPrice == null) {
            return null;
        }
        BigDecimal amount = qty.multiply(actualPrice);
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountInTax(BigDecimal taxAmount, BigDecimal tax, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        taxAmount = taxAmount == null ? zero : taxAmount;
        tax = tax == null ? zero : tax;
        BigDecimal amount = taxAmount.subtract(tax);
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountByDiscountPercent(BigDecimal qty, BigDecimal price, BigDecimal discountPercent, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        qty = qty == null ? zero : qty;
        price = price == null ? zero : price;
        discountPercent = discountPercent == null ? zero : discountPercent;
        BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountPercent.divide(oneHundred, scale + 2, 4)));
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountByDiscountAmount(BigDecimal qty, BigDecimal price, BigDecimal discountAmount, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        qty = qty == null ? zero : qty;
        price = price == null ? zero : price;
        discountAmount = discountAmount == null ? zero : discountAmount;
        BigDecimal amount = qty.multiply(price.subtract(discountAmount));
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calExpenseAmount(BigDecimal qty, BigDecimal unitExpense, int scale) {
        if (qty == null || unitExpense == null) {
            return null;
        }
        BigDecimal expenseAmount = qty.multiply(unitExpense);
        expenseAmount = expenseAmount.setScale(scale, 4);
        return expenseAmount;
    }

    public static BigDecimal calTax(BigDecimal amount, BigDecimal taxRate, int scale) {
        if (amount == null || taxRate == null) {
            return null;
        }
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, CalculateUtils.getScale(taxRate), 4);
        BigDecimal tax = amount.multiply(taxRate);
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTaxWhenPriceExludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxAmount = taxAmount == null ? zero : taxAmount;
        taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, scale + 2, 4);
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal tax = new BigDecimal("0.0");
        if (taxRate.compareTo(one) != 0) {
            tax = taxAmount.divide(one.add(taxRate), 10, 4).multiply(taxRate);
        }
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTaxWhenPriceInludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxAmount = taxAmount == null ? zero : taxAmount;
        taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, scale + 2, 4);
        BigDecimal tax = taxAmount.multiply(taxRate);
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTotalTaxAmount(BigDecimal amount, BigDecimal tax, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        amount = amount == null ? zero : amount;
        tax = tax == null ? zero : tax;
        BigDecimal totalTaxAmount = amount.add(tax);
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }

    public static BigDecimal calTotalTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountPercent, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        qty = qty == null ? zero : qty;
        taxPrice = taxPrice == null ? zero : taxPrice;
        discountPercent = discountPercent == null ? zero : discountPercent.divide(oneHundred, scale + 2, 4);
        BigDecimal totalTaxAmount = qty.multiply(taxPrice).multiply(one.subtract(discountPercent));
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }

    public static BigDecimal calTotalTaxAmountByDiscountAmount(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountAmount, int scale) {
        BigDecimal zero = new BigDecimal("0.0");
        qty = qty == null ? zero : qty;
        taxPrice = taxPrice == null ? zero : taxPrice;
        discountAmount = discountAmount == null ? zero : discountAmount;
        BigDecimal totalTaxAmount = qty.multiply(taxPrice.subtract(discountAmount));
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }

    public static BigDecimal calPrepayment(BigDecimal totalTaxAmount, BigDecimal prepaymentRate, int scale) {
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal rate = SCMUtils.effectualNumeric(prepaymentRate).divide(oneHundred, CalculateUtils.getScale(SCMUtils.effectualNumeric(prepaymentRate)), 4);
        BigDecimal prepayment = SysConstant.BIGZERO;
        if (!SCMUtils.equalsZero(totalTaxAmount) && !SCMUtils.equalsZero(rate)) {
            prepayment = SCMUtils.effectualNumeric(rate).multiply(SCMUtils.effectualNumeric(totalTaxAmount)).setScale(SCMUtils.effectualPrecision(scale), 4);
        }
        return prepayment;
    }

    public static BigDecimal calPrepayment(BigDecimal[] totalTaxAmounts, BigDecimal prepaymentRate, int scale) {
        if (prepaymentRate == null || totalTaxAmounts == null || totalTaxAmounts.length == 0) {
            return null;
        }
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        int num = totalTaxAmounts.length;
        for (int i = 0; i < num; ++i) {
            if (totalTaxAmounts[i] == null) continue;
            totalTaxAmount = totalTaxAmount.add(totalTaxAmounts[i]);
        }
        BigDecimal oneHundred = new BigDecimal("100.0");
        prepaymentRate = prepaymentRate.divide(oneHundred, CalculateUtils.getScale(prepaymentRate), 4);
        BigDecimal prepayment = prepaymentRate.multiply(totalTaxAmount).setScale(scale, 4);
        return prepayment;
    }

    public static BigDecimal calPrice(BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        if (taxPrice == null) {
            return null;
        }
        BigDecimal zero = SysConstant.BIGZERO;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        BigDecimal price = null;
        price = taxPrice.divide(one.add(taxRate), scale, 4);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceByDiscountAmount(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        BigDecimal zero = SysConstant.BIGZERO;
        if (amount == null || qty == null || qty.compareTo(zero) == 0) {
            return null;
        }
        discount = discount == null ? zero : discount;
        BigDecimal price = null;
        price = amount.divide(qty, 10, 4).add(discount);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPrice(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        BigDecimal zero = SysConstant.BIGZERO;
        if (amount == null || qty == null || qty.compareTo(zero) == 0) {
            return null;
        }
        if (discount != null && discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) == 0) {
            discount = zero;
        }
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal bigDecimal = discount = discount == null ? zero : discount;
        if (discount != null && discount.compareTo(zero) != 0) {
            discount = discount == null ? zero : discount.divide(oneHundred, CalculateUtils.getScale(discount), 4);
        }
        BigDecimal price = null;
        price = amount.divide(qty, scale + 2, 4).divide(one.subtract(discount), scale + 2, 4);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceIsPriceInTax(BigDecimal taxRate, BigDecimal taxPrice, int scale) {
        BigDecimal oneHundred = new BigDecimal("100.0");
        BigDecimal zero = SysConstant.BIGZERO;
        BigDecimal one = new BigDecimal("1.0");
        taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        taxPrice = taxPrice == null ? zero : taxPrice;
        BigDecimal price = taxPrice.multiply(one.subtract(taxRate));
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calLocalAmount(BigDecimal amount, BigDecimal exchangerate, int scale) {
        if (amount == null || exchangerate == null) {
            return null;
        }
        BigDecimal localeAmount = amount.multiply(exchangerate);
        localeAmount = localeAmount.setScale(scale, 4);
        return localeAmount;
    }

    public static BigDecimal calcByExchangeRate(ExchangeAuxInfo auxInfo, BigDecimal rate, BigDecimal numeric, int scale) {
        if (auxInfo != null && rate != null && numeric != null) {
            if (auxInfo.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                return numeric.multiply(rate).setScale(scale, 4);
            }
            return numeric.divide(rate, scale, 4);
        }
        return numeric;
    }

    public static BigDecimal calcByExchangeRate(ExchangeRateInfo auxInfo, BigDecimal rate, BigDecimal numeric, int scale) {
        if (auxInfo != null && rate != null && numeric != null) {
            if (auxInfo.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                return numeric.multiply(rate).setScale(scale, 4);
            }
            return numeric.divide(rate, scale, 4);
        }
        return numeric;
    }

    public static BigDecimal calTaxPriceByPurchaseCost(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return null;
        }
        taxRate = taxRate == null ? new BigDecimal("0.0") : taxRate;
        BigDecimal taxPrice = null;
        BigDecimal one = new BigDecimal("1.0");
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxRate = taxRate.divide(oneHundred, CalculateUtils.getScale(taxRate), 4);
        taxPrice = price.divide(one.subtract(taxRate), scale, 4);
        return taxPrice;
    }
}

