/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseCollection;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SCMCommonUtil {
    private static Map<String, MultiMeasureUnitInfo> measureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
    private static Map<String, CompanyOrgUnitInfo> sou2CouMap = new HashMap<String, CompanyOrgUnitInfo>();

    public static Map<String, IObjectValue> getSoueceBillEntryInfoMap(Context ctx, SCMBillBaseInfo scmBillInfo, IObjectCollection scmBillEntryColl, String sourceBillEntryKey) throws BOSException {
        IObjectCollection sourceBillColl = SCMCommonUtil.getSourceBillColl(ctx, scmBillInfo, scmBillEntryColl, sourceBillEntryKey);
        HashMap<String, IObjectValue> sourceBillEntryMap = new HashMap<String, IObjectValue>();
        IObjectCollection sourceBillEntryColl = null;
        IObjectValue sourceBillInfo = null;
        IObjectValue sourceBillEntryInfo = null;
        int isize = sourceBillColl.size();
        for (int i = 0; i < isize; ++i) {
            sourceBillInfo = sourceBillColl.getObject(i);
            if (sourceBillInfo == null || sourceBillInfo.get("id") == null) continue;
            sourceBillEntryColl = (IObjectCollection)sourceBillInfo.get(sourceBillEntryKey);
            int jsize = sourceBillEntryColl.size();
            for (int j = 0; j < jsize; ++j) {
                sourceBillEntryInfo = sourceBillEntryColl.getObject(j);
                if (sourceBillEntryInfo == null || sourceBillEntryInfo.get("id") == null) continue;
                sourceBillEntryMap.put(sourceBillEntryInfo.get("id").toString(), sourceBillEntryInfo);
            }
        }
        return sourceBillEntryMap;
    }

    private static IObjectCollection getSourceBillColl(Context ctx, SCMBillBaseInfo scmBillInfo, IObjectCollection scmBillEntryColl, String entryKey) throws BOSException {
        String sourceBillId;
        HashSet<String> sourceBillIDSet = new HashSet<String>();
        SCMBillEntryBaseInfo scmBillEntryInfo = null;
        int size = scmBillEntryColl.size();
        for (int i = 0; i < size; ++i) {
            scmBillEntryInfo = (SCMBillEntryBaseInfo)scmBillEntryColl.getObject(i);
            sourceBillIDSet.add(scmBillEntryInfo.getSourceBillId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sourceBillIDSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(entryKey + ".unit.id"));
        viewInfo.setSelector(sic);
        BOSObjectType bosObjectType = null;
        Iterator iterator = sourceBillIDSet.iterator();
        while (iterator.hasNext() && (bosObjectType = new ObjectUuidPK(sourceBillId = (String)iterator.next()).getObjectType()) == null) {
        }
        ICoreBase iCoreBase = null;
        iCoreBase = ctx == null ? (ICoreBase)BOSObjectFactory.createRemoteBOSObject(bosObjectType, ICoreBase.class) : (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, bosObjectType);
        return iCoreBase.getCollection(viewInfo);
    }

    public static BigDecimal calQtyByBaseQty(Context ctx, BigDecimal baseQty, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws EASBizException, BOSException {
        String unitID;
        if (baseQty == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        String materialID = scmBillEntryBaseInfo.getMaterial().getId().toString();
        MultiMeasureUnitInfo mulUnit = SCMCommonUtil.getMeasureUnitInfo(ctx, materialID, unitID = scmBillEntryBaseInfo.getUnit().getId().toString());
        BigDecimal coefficient = mulUnit.getBaseConvsRate();
        if (coefficient != null) {
            int precision = mulUnit.getQtyPrecision();
            return baseQty.divide(coefficient, precision, 4);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal reCalQty(Context ctx, BigDecimal qty, SCMBillEntryBaseInfo scmBillEntryBaseInfo, String sourceUnitID) throws EASBizException, BOSException {
        if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        String materialID = scmBillEntryBaseInfo.getMaterial().getId().toString();
        MultiMeasureUnitInfo sourceMulUnit = SCMCommonUtil.getMeasureUnitInfo(ctx, materialID, sourceUnitID);
        BigDecimal coefficient = sourceMulUnit.getBaseConvsRate();
        BigDecimal baseQty = BigDecimal.ZERO;
        if (coefficient != null) {
            baseQty = qty.multiply(coefficient);
        }
        return SCMCommonUtil.calQtyByBaseQty(ctx, baseQty, scmBillEntryBaseInfo);
    }

    public static BigDecimal reCalPrice(Context ctx, BigDecimal price, SCMBillEntryBaseInfo scmBillEntryBaseInfo, String sourceUnitID) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mulUnit;
        if (price == null || price.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        String materialID = scmBillEntryBaseInfo.getMaterial().getId().toString();
        String unitID = scmBillEntryBaseInfo.getUnit().getId().toString();
        MultiMeasureUnitInfo sourceMulUnit = SCMCommonUtil.getMeasureUnitInfo(ctx, materialID, sourceUnitID);
        int pricePrecision = scmBillEntryBaseInfo.getMaterial().getPricePrecision();
        BigDecimal coefficient = sourceMulUnit.getBaseConvsRate();
        if (coefficient != null) {
            price = price.divide(coefficient, pricePrecision + 2, 4);
        }
        if ((coefficient = (mulUnit = SCMCommonUtil.getMeasureUnitInfo(ctx, materialID, unitID)).getBaseConvsRate()) != null) {
            price = price.multiply(coefficient);
        }
        price.setScale(pricePrecision, 4);
        return price;
    }

    private static MultiMeasureUnitInfo getMeasureUnitInfo(Context ctx, String materialID, String unitID) throws EASBizException, BOSException {
        MultiMeasureUnitInfo mmuInfo = measureUnitMap.get(materialID + unitID);
        if (mmuInfo != null) {
            return mmuInfo;
        }
        IMultiMeasureUnit iMutilMeasureUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        mmuInfo = iMutilMeasureUnit.getMultiUnit(materialID, unitID);
        measureUnitMap.put(materialID + unitID, mmuInfo);
        return mmuInfo;
    }

    public static void setUnitInfo(Context ctx, OrgUnitInfo mainOrgUnit, IObjectCollection scmBillEntryColl) throws BOSException {
        SCMBillEntryBaseInfo scmBillEntryBaseInfo = null;
        HashSet<String> materialIDSet = new HashSet<String>();
        int size = scmBillEntryColl.size();
        for (int i = 0; i < size; ++i) {
            scmBillEntryBaseInfo = (SCMBillEntryBaseInfo)scmBillEntryColl.getObject(i);
            if (scmBillEntryBaseInfo.getMaterial() == null || scmBillEntryBaseInfo.getMaterial().getId() == null) continue;
            materialIDSet.add(scmBillEntryBaseInfo.getMaterial().getId().toString());
        }
        if (CollectionUtil.isEmpty(materialIDSet)) {
            return;
        }
        String mainOrgUnitId = mainOrgUnit.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material", materialIDSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)mainOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("unit.id"));
        selector.add(new SelectorItemInfo("unit.number"));
        selector.add(new SelectorItemInfo("unit.name"));
        selector.add(new SelectorItemInfo("unit.qtyPrecision"));
        selector.add(new SelectorItemInfo("unit.coefficient"));
        selector.add(new SelectorItemInfo("unit.isBaseUnit"));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        Map<String, MeasureUnitInfo> materialUnitMap = SCMCommonUtil.getMaterialPropertyBaseMap(ctx, mainOrgUnit, viewInfo);
        String materialId = null;
        int size2 = scmBillEntryColl.size();
        for (int i = 0; i < size2; ++i) {
            scmBillEntryBaseInfo = (SCMBillEntryBaseInfo)scmBillEntryColl.getObject(i);
            materialId = scmBillEntryBaseInfo.getMaterial().getId().toString();
            if (materialUnitMap.get(materialId) == null || scmBillEntryBaseInfo.getReservationBillObjectId() != null) continue;
            scmBillEntryBaseInfo.setUnit(materialUnitMap.get(materialId));
        }
    }

    private static Map<String, MeasureUnitInfo> getMaterialPropertyBaseMap(Context ctx, OrgUnitInfo mainOrgUnit, EntityViewInfo viewInfo) throws BOSException {
        HashMap<String, MeasureUnitInfo> materialUnitMap;
        block4: {
            block5: {
                block3: {
                    materialUnitMap = new HashMap<String, MeasureUnitInfo>();
                    if (!(mainOrgUnit instanceof PurchaseOrgUnitInfo)) break block3;
                    IMaterialPurchasing iFactory = ctx == null ? MaterialPurchasingFactory.getRemoteInstance() : MaterialPurchasingFactory.getLocalInstance((Context)ctx);
                    MaterialPurchasingCollection materialPurchaseColl = iFactory.getMaterialPurchasingCollection(viewInfo);
                    MaterialPurchasingInfo materialPurchasingInfo = null;
                    int size = materialPurchaseColl.size();
                    for (int i = 0; i < size; ++i) {
                        materialPurchasingInfo = materialPurchaseColl.get(i);
                        materialUnitMap.put(materialPurchasingInfo.getMaterial().getId().toString(), materialPurchasingInfo.getUnit());
                    }
                    break block4;
                }
                if (!(mainOrgUnit instanceof StorageOrgUnitInfo)) break block5;
                IMaterialInventory iFactory = ctx == null ? MaterialInventoryFactory.getRemoteInstance() : MaterialInventoryFactory.getLocalInstance((Context)ctx);
                MaterialInventoryCollection materialInventoryColl = iFactory.getMaterialInventoryCollection(viewInfo);
                MaterialInventoryInfo materialInventoryInfo = null;
                int size = materialInventoryColl.size();
                for (int i = 0; i < size; ++i) {
                    materialInventoryInfo = materialInventoryColl.get(i);
                    materialUnitMap.put(materialInventoryInfo.getMaterial().getId().toString(), materialInventoryInfo.getUnit());
                }
                break block4;
            }
            if (!(mainOrgUnit instanceof SaleOrgUnitInfo)) break block4;
            IMaterialSales iFactory = ctx == null ? MaterialSalesFactory.getRemoteInstance() : MaterialSalesFactory.getLocalInstance((Context)ctx);
            MaterialSalesCollection materialSalesColl = iFactory.getMaterialSalesCollection(viewInfo);
            MaterialSalesInfo materialSalesInfo = null;
            int size = materialSalesColl.size();
            for (int i = 0; i < size; ++i) {
                materialSalesInfo = materialSalesColl.get(i);
                materialUnitMap.put(materialSalesInfo.getMaterial().getId().toString(), materialSalesInfo.getUnit());
            }
        }
        return materialUnitMap;
    }

    public static Map<String, MultiMeasureUnitInfo> getMulUnitMap(Context ctx, SCMBillBaseInfo info) throws EASBizException, BOSException {
        IObjectCollection entries = info.getEntries();
        HashSet<String> unitSet = new HashSet<String>();
        HashSet<String> materialSet = new HashSet<String>();
        HashMap<String, MultiMeasureUnitInfo> muMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (entries != null && entries.size() > 0) {
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
                if (entryInfo.getUnit() != null) {
                    unitSet.add(entryInfo.getUnit().getId().toString());
                }
                if (entryInfo.getBaseUnit() != null) {
                    unitSet.add(entryInfo.getBaseUnit().getId().toString());
                }
                if (entryInfo.getAssistUnit() != null) {
                    unitSet.add(entryInfo.getAssistUnit().getId().toString());
                }
                if (entryInfo.getMaterial() == null) continue;
                materialSet.add(entryInfo.getMaterial().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitSet, CompareType.INCLUDE));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            IMultiMeasureUnit iMultiMeasureUnit = null;
            iMultiMeasureUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            MultiMeasureUnitCollection multiMUCol = iMultiMeasureUnit.getMultiMeasureUnitCollection(view);
            int size2 = multiMUCol.size();
            for (int i = 0; i < size2; ++i) {
                muMap.put(multiMUCol.get(i).getMaterial().getId().toString() + multiMUCol.get(i).getMeasureUnit().getId().toString(), multiMUCol.get(i));
            }
        }
        return muMap;
    }

    public static Map<String, MaterialCompanyInfoInfo> getMaterialCompanyMap(Context ctx, CompanyOrgUnitInfo cou, SCMBillEntryBaseCollection entryColl) throws EASBizException, BOSException {
        HashMap<String, MaterialCompanyInfoInfo> materialId2CompanyMap = new HashMap<String, MaterialCompanyInfoInfo>();
        if (null == cou || entryColl.size() == 0) {
            return materialId2CompanyMap;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        SCMBillEntryBaseInfo entry = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            MaterialInfo materialInfo = entry.getMaterial();
            if (materialInfo == null) continue;
            materialIdSet.add(materialInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cou.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        IMaterialCompanyInfo iMatCompany = ctx == null ? MaterialCompanyInfoFactory.getRemoteInstance() : MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection mic = iMatCompany.getMaterialCompanyInfoCollection(entityViewInfo);
        if (null == mic || mic.size() == 0) {
            return materialId2CompanyMap;
        }
        int size = mic.size();
        for (int i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo materialCompany = mic.get(i);
            materialId2CompanyMap.put(materialCompany.getMateial().getId().toString(), materialCompany);
        }
        return materialId2CompanyMap;
    }

    public static boolean isInvBill(String billTypeId) {
        if (SCMBaseCommonUtil.isInvBill((String)billTypeId)) {
            return true;
        }
        return "XlazxwEREADgAAAEwKgSxUY+1VI=".equals(billTypeId) || "MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billTypeId) || "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(billTypeId);
    }

    public static BigDecimal calActualCost(Context ctx, BigDecimal unitActualCost, BigDecimal qty, StorageOrgUnitInfo sou) throws EASBizException, BOSException {
        BigDecimal actualCost = BigDecimal.ZERO;
        if (NumericUtil.isEqualsZero((BigDecimal)unitActualCost) || NumericUtil.isEqualsZero((BigDecimal)qty)) {
            return BigDecimal.ZERO;
        }
        actualCost = unitActualCost.multiply(qty);
        CompanyOrgUnitInfo cou = SCMCommonUtil.getCompanyInfo(ctx, sou);
        int localAmtPrecision = cou.getBaseCurrency().getPrecision();
        return actualCost.setScale(localAmtPrecision, 4);
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        CompanyOrgUnitInfo cou = sou2CouMap.get(sou.getId().toString());
        if (cou == null) {
            IOrgUnitRelation iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            cou = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 1);
            if (cou == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
                cou = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            if (cou != null) {
                String oql = "SELECT *, baseCurrency.precision WHERE id ='" + cou.getId().toString() + "'";
                ICompanyOrgUnit iCou = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                cou = iCou.getCompanyOrgUnitInfo(oql);
            }
            sou2CouMap.put(sou.getId().toString(), cou);
        }
        return cou;
    }
}

