/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataComponentMap;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.scm.common.client.HistoryChangeDisplayUI;
import com.kingdee.eas.scm.framework.UseStatusEnum;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigCollection;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFactory;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFieldCollection;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigFieldInfo;
import com.kingdee.eas.scm.framework.alter.AlterViewConfigInfo;
import com.kingdee.eas.scm.framework.alter.FieldTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.EventListenerList;

public class ViewHistoryVersionHelper {
    private EditUI editUI;
    private ICoreBase icoreBase;
    private IObjectValue editData;
    private DataComponentMap componentMap;
    private Method compareMethod;
    private Class compareClass;
    private IObjectCollection oldBillColl;
    private Map<String, Field> tableField2EntityPropMap;
    private Map<Field, Map<BOSUuid, List<IObjectValue>>> entryFieldMap;
    private HistoryChangeDisplayUI displayUI = null;
    private Map<String, Integer> field2LineMap;
    private int curLineNumber = 0;
    private boolean isShow = false;
    private Map<JComponent, Border> oldBorderMap;
    private Map<JComponent, Color> oldBackGroundColorMap;
    private Map<ICell, Color> oldCellColorMap;
    private Map<IRow, Color> oldRowColorMap;
    private Map<ICell, Object> oldCellFormatMap;
    private Map<JComponent, MouseListener> componentListenerMap;
    private Map<KDTable, KDTSelectListener> tableListenerMap;
    private AlterViewConfigInfo alterViewConfigInfo;
    private Set<String> headFieldSet;
    private Set<String> entryFieldSet;
    private ActionToggleHistory actionToggleHistory = null;
    private KDWorkButton btnShowHisDiff;
    private KDMenuItem menuItemShowHisDiff;
    private Map<String, AlterViewConfigFieldInfo> fieldName2FieldConfigMap = null;

    public ViewHistoryVersionHelper(EditUI editUI, ICoreBase icoreBase) {
        this.editUI = editUI;
        this.icoreBase = icoreBase;
        this.createButton();
        editUI.getUILifeCycleHandler().addRuleListener((IUILifeCycleListener)new AfterShowListener());
    }

    public void defaultShow() {
        int billStatus;
        if (this.editUI.getDataObject().get("baseStatus") != null && (billStatus = ((Integer)this.editUI.getDataObject().get("baseStatus")).intValue()) == -2) {
            try {
                if (!this.isShow) {
                    this.dispalyDiff(false, false);
                }
            }
            catch (BOSException e) {
                this.editUI.handUIException((Throwable)e);
            }
        }
    }

    private void createButton() {
        this.btnShowHisDiff = new KDWorkButton();
        this.btnShowHisDiff.setName("btnShowHisDiff");
        this.btnShowHisDiff.setText(this.getResource("viewAlter", new String[0]));
        this.actionToggleHistory = new ActionToggleHistory((IUIObject)this.displayUI);
        this.actionToggleHistory.setEnabled(true);
        this.actionToggleHistory.setVisible(true);
        this.btnShowHisDiff.setAction((Action)((Object)this.actionToggleHistory));
        Component component = null;
        int size = this.editUI.getUIToolBar().getToolBarComponentCount();
        for (int i = 0; i < size; ++i) {
            if (!"btnWorkFlowG".equals(this.editUI.getUIToolBar().getToolBarComponentAt(i).getName())) continue;
            component = this.editUI.getUIToolBar().getToolBarComponentAt(i);
            break;
        }
        this.editUI.getUIToolBar().addComponentAfterComponent((Component)this.btnShowHisDiff, component);
        this.btnShowHisDiff.setIcon(EASResource.getIcon((String)"imgTable_task"));
        this.menuItemShowHisDiff = new KDMenuItem();
        this.menuItemShowHisDiff.setName("menuItemShowHisDiff");
        this.menuItemShowHisDiff.setAction((Action)((Object)this.actionToggleHistory));
        this.menuItemShowHisDiff.setText(this.getResource("viewAlter", new String[0]));
        this.menuItemShowHisDiff.setEnabled(true);
        this.menuItemShowHisDiff.setVisible(true);
        this.menuItemShowHisDiff.setIcon(EASResource.getIcon((String)"imgTable_task"));
        JMenu menu = null;
        int size2 = this.editUI.getUIMenuBar().getMenuCount();
        for (int i = 0; i < size2; ++i) {
            if (!"menuView".equals(this.editUI.getUIMenuBar().getMenu(i).getName())) continue;
            menu = this.editUI.getUIMenuBar().getMenu(i);
            break;
        }
        if (null == menu) {
            menu = this.editUI.getUIMenuBar().getMenu(2);
        }
        menu.add((JMenuItem)this.menuItemShowHisDiff);
    }

    private void init() throws BOSException {
        this.initFieldSet();
        this.initCompareMethod();
        this.initEntryMap();
        this.initField();
    }

    private void initFieldSet() {
        this.entryFieldSet = new HashSet<String>();
        this.headFieldSet = new HashSet<String>();
        this.fieldName2FieldConfigMap = new HashMap<String, AlterViewConfigFieldInfo>();
        AlterViewConfigFieldCollection entries = this.alterViewConfigInfo.getEntry();
        AlterViewConfigFieldInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            this.fieldName2FieldConfigMap.put(entry.getField(), entry);
            if (entry.getField().contains(".")) {
                this.entryFieldSet.add(entry.getField());
                continue;
            }
            this.headFieldSet.add(entry.getField());
        }
    }

    private void initField() {
        this.tableField2EntityPropMap = new HashMap<String, Field>();
        this.field2LineMap = new HashMap<String, Integer>();
        this.curLineNumber = 0;
        this.oldBorderMap = new HashMap<JComponent, Border>();
        this.oldBackGroundColorMap = new HashMap<JComponent, Color>();
        this.oldCellColorMap = new HashMap<ICell, Color>();
        this.oldRowColorMap = new HashMap<IRow, Color>();
        this.oldCellFormatMap = new HashMap<ICell, Object>();
        this.componentListenerMap = new HashMap<JComponent, MouseListener>();
        this.tableListenerMap = new HashMap<KDTable, KDTSelectListener>();
    }

    private void initEntryMap() throws BOSException {
        this.componentMap = this.editUI.getDataBinder().getDataComponentMap();
        this.entryFieldMap = this.getEntryFieldMap(this.oldBillColl);
    }

    public void toggleDispaly() throws BOSException {
        if (!this.isShow) {
            this.dispalyDiff(false);
        } else {
            this.destoryDiffDisplay();
        }
    }

    public void destoryDiffDisplay() {
        if (!this.isShow) {
            return;
        }
        if (this.displayUI != null) {
            this.editUI.getParent().remove((Component)((Object)this.displayUI));
            this.displayUI.destroyWindow();
            this.editUI.getParent().validate();
        }
        for (Map.Entry<JComponent, Border> entry : this.oldBorderMap.entrySet()) {
            entry.getKey().setBorder(entry.getValue());
        }
        this.oldBorderMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.oldBackGroundColorMap.entrySet()) {
            this.setBackGroundCorlor(entry.getKey(), (Color)entry.getValue());
        }
        this.oldBackGroundColorMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.oldCellColorMap.entrySet()) {
            ((ICell)entry.getKey()).getStyleAttributes().setBackground((Color)entry.getValue());
        }
        this.oldCellColorMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.oldRowColorMap.entrySet()) {
            ((IRow)entry.getKey()).getStyleAttributes().setBackground(null);
        }
        this.oldRowColorMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.oldCellFormatMap.entrySet()) {
            ((ICell)entry.getKey()).getStyleAttributes().setNumberFormat((String)entry.getValue());
        }
        this.oldCellFormatMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.componentListenerMap.entrySet()) {
            entry.getKey().removeMouseListener((MouseListener)entry.getValue());
        }
        this.componentListenerMap.clear();
        for (Map.Entry<JComponent, Object> entry : this.tableListenerMap.entrySet()) {
            ((KDTable)entry.getKey()).removeKDTSelectListener((KDTSelectListener)entry.getValue());
            ((KDTable)entry.getKey()).getSelectManager().removeAll();
        }
        this.tableListenerMap.clear();
        this.isShow = false;
        this.btnShowHisDiff.setText(this.getResource("viewAlter", new String[0]));
        this.menuItemShowHisDiff.setText(this.getResource("viewAlter", new String[0]));
    }

    private void dispalyDiff(boolean isShowAll) throws BOSException {
        this.dispalyDiff(isShowAll, true);
    }

    private void dispalyDiff(boolean isShowAll, boolean isShowMsg) throws BOSException {
        this.editData = this.editUI.getDataObject();
        if (this.editData.get("id") == null) {
            if (isShowMsg) {
                MsgBox.showInfo((String)this.getResource("noAlter", new String[0]));
            }
            return;
        }
        this.oldBillColl = this.getOldVersionCollection(this.editData.getString("id"), isShowAll);
        if (this.oldBillColl == null || this.oldBillColl.size() == 0) {
            if (isShowMsg) {
                MsgBox.showInfo((String)this.getResource("noAlter", new String[0]));
            }
            return;
        }
        AlterViewConfigCollection alterViewConfigCollection = AlterViewConfigFactory.getRemoteInstance().getAlterViewConfigCollection(this.getConfigEntityViewInfo());
        if (alterViewConfigCollection == null || alterViewConfigCollection.size() == 0) {
            if (isShowMsg) {
                MsgBox.showInfo((String)this.getResource("noAlterViewConfig", new String[0]));
            }
            return;
        }
        this.alterViewConfigInfo = alterViewConfigCollection.get(0);
        this.init();
        this.isShow = true;
        this.initHistoryDisplayUI(isShowAll);
        this.displayUI.setDisplayPanelText(this.getHtml());
        this.btnShowHisDiff.setText(this.getResource("hideAlter", new String[0]));
        this.menuItemShowHisDiff.setText(this.getResource("hideAlter", new String[0]));
    }

    private String getHtmlHeader() {
        StringBuilder headSb = new StringBuilder();
        headSb.append("<head>");
        headSb.append("</head>");
        return headSb.toString();
    }

    private String getHtmlBody() throws BOSException {
        StringBuilder bodySb = new StringBuilder();
        bodySb.append("<body>");
        bodySb.append(this.dispalyHead(this.headFieldSet));
        bodySb.append(this.getAllEntryDiffText(this.entryFieldSet));
        bodySb.append("</body>");
        return bodySb.toString();
    }

    private String getHtml() throws BOSException {
        StringBuilder htmlSb = new StringBuilder();
        htmlSb.append("<html>");
        htmlSb.append(this.getHtmlHeader());
        htmlSb.append(this.getHtmlBody());
        htmlSb.append("</html>");
        return htmlSb.toString();
    }

    private String getAlterMsg() {
        StringBuilder alterMsg = new StringBuilder();
        alterMsg.append("<span id =\"header\">");
        for (IObjectValue oldEditdata : this.oldBillColl) {
            alterMsg.append(this.getResource("version", new String[0])).append(":").append(oldEditdata.get("version")).append("<br>");
            alterMsg.append(this.getResource("alterDate", new String[0])).append(":").append(oldEditdata.get(this.getAlterDateColName())).append("<br>");
            alterMsg.append(this.getResource("alterPerson", new String[0])).append(":").append(oldEditdata.get("alterPerson")).append("<br>");
            this.curLineNumber += 3;
        }
        alterMsg.append("</span>");
        alterMsg.append("<hr>");
        return alterMsg.toString();
    }

    private String getAllEntryDiffText(Set<String> entryFieldSet) throws BOSException {
        StringBuilder entryMsg = new StringBuilder();
        Field headerField = new Field("header");
        ArrayList detailList = this.componentMap.getDetailList(headerField);
        if (detailList != null) {
            Field detailField = null;
            int length = detailList.size();
            for (int i = 0; i < length; ++i) {
                detailField = (Field)detailList.get(i);
                if (this.getExcludeEntryNameSet().contains(detailField.getActualName())) continue;
                entryMsg.append(this.dealSingleEntryByField(detailField, entryFieldSet));
            }
        }
        return entryMsg.toString();
    }

    private String dealSingleEntryByField(Field detailField, Set<String> entryFieldSet) throws BOSException {
        StringBuilder entryMsg = new StringBuilder();
        KDTable table = this.componentMap.getTable(detailField);
        table.getSelectManager().removeAll();
        this.removeTablePropertyChangeListener(table, KDTPropertyChangeListener.class);
        AlterCellSelectListener alterCellSelectListener = new AlterCellSelectListener(detailField);
        table.addKDTSelectListener((KDTSelectListener)alterCellSelectListener);
        this.tableListenerMap.put(table, alterCellSelectListener);
        ArrayList fields = this.componentMap.getDetailFields(detailField);
        Map<BOSUuid, List<IObjectValue>> oldID2ValueMap = this.entryFieldMap.get(detailField);
        Color color = new Color(Integer.parseInt(this.alterViewConfigInfo.getColor()));
        boolean isShowAll = this.displayUI.getShowAllCheckBox().isSelected();
        int size = fields.size();
        for (int j = 0; j < size; ++j) {
            Field colField = (Field)fields.get(j);
            if (entryFieldSet != null && !entryFieldSet.contains(colField.getName())) continue;
            IObjectCollection newDetailCollection = (IObjectCollection)BindingUtility.getBeanProperty((Object)this.editData, (String)detailField.getActualName());
            ComponentProperty compProp = this.componentMap.getComponentProperty(colField);
            this.tableField2EntityPropMap.put(table.getName() + compProp.getPropertyName(), colField);
            String columnName = (String)table.getHead().getRow(0).getCell(table.getColumnIndex(compProp.getPropertyName())).getValue();
            int rowCount = table.getRowCount();
            for (int k = 0; k < rowCount; ++k) {
                boolean isNewRow;
                BOSUuid id = (BOSUuid)table.getRow(k).getCell("id").getValue();
                IObjectValue newEntryObject = newDetailCollection.getObject((Object)id);
                List<IObjectValue> oldEntryObjectList = oldID2ValueMap.get(id);
                boolean bl = isNewRow = null == oldEntryObjectList || this.isOldEntryValueNull(oldEntryObjectList.get(0)) || id == null;
                if (isNewRow) {
                    IRow row = table.getRow(k);
                    this.oldRowColorMap.put(row, row.getStyleAttributes().getBackground());
                    row.getStyleAttributes().setBackground(color);
                    continue;
                }
                if (!this.hasEntryFieldAlter(colField, newEntryObject, oldEntryObjectList)) continue;
                this.field2LineMap.put(id + table.getName() + compProp.getPropertyName(), this.curLineNumber);
                entryMsg.append("<span id=\"").append(id + table.getName() + compProp.getPropertyName()).append("\">");
                entryMsg.append(this.getResource("fieldName", new String[0])).append(":").append(this.getResource("entry", new String[0])).append(".").append(columnName).append("<br>");
                ++this.curLineNumber;
                entryMsg.append(this.getEntryDiffMsg(k, colField, newEntryObject, oldEntryObjectList, table));
                entryMsg.append("</span>");
                ICell cell = table.getRow(k).getCell(compProp.getPropertyName());
                this.oldCellColorMap.put(cell, cell.getStyleAttributes().getBackground());
                cell.getStyleAttributes().setBackground(color);
                if (!isShowAll && this.fieldName2FieldConfigMap.get(colField.getName()).getFieldType() == FieldTypeEnum.NUMBER) {
                    this.oldCellFormatMap.put(cell, cell.getStyleAttributes().getNumberFormat());
                    Object oldCellValue = null;
                    Object newCellValue = null;
                    if (cell.getValue() != null) {
                        newCellValue = cell.getValue();
                    }
                    if (!this.isOldEntryValueNull(oldEntryObjectList.get(0)) && BindingUtility.getValue((IObjectValue)oldEntryObjectList.get(0), (Field)colField) != null) {
                        oldCellValue = BindingUtility.getValue((IObjectValue)oldEntryObjectList.get(0), (Field)colField);
                    }
                    if (oldCellValue != null && newCellValue != null && newCellValue instanceof BigDecimal && oldCellValue instanceof BigDecimal) {
                        int scale = ((BigDecimal)oldCellValue).scale();
                        if (null != cell.getEditor() && null != cell.getEditor().getComponent() && cell.getEditor().getComponent() instanceof KDFormattedTextField) {
                            ((KDFormattedTextField)cell.getEditor().getComponent()).setDataType(1);
                            scale = ((KDFormattedTextField)cell.getEditor().getComponent()).getPrecision();
                        } else if (cell.getFormattedValue() != null) {
                            scale = new BigDecimal(cell.getFormattedValue().toString()).scale();
                        }
                        if (((BigDecimal)newCellValue).compareTo((BigDecimal)oldCellValue) > 0) {
                            cell.getStyleAttributes().setNumberFormat(this.getFormatPattern(scale, true));
                        } else {
                            cell.getStyleAttributes().setNumberFormat(this.getFormatPattern(scale, false));
                        }
                    }
                }
                entryMsg.append("<hr>");
            }
        }
        return entryMsg.toString();
    }

    private boolean isOldEntryValueNull(IObjectValue oldValue) {
        return oldValue == null || oldValue.get("id") == null;
    }

    private String getEntryDiffMsg(int k, Field colField, IObjectValue newEntryObject, List<IObjectValue> oldEntryObjectList, KDTable table) {
        StringBuilder entryMsg = new StringBuilder();
        entryMsg.append(this.getResource("ronum", k + 1 + "")).append(":").append("<br>");
        ++this.curLineNumber;
        String nullFieldvalue = this.getResource("nullValue", new String[0]);
        String noValue = this.getResource("noValue", new String[0]);
        String oldCellValue = nullFieldvalue;
        boolean isCheckBoxField = false;
        ComponentProperty compProp = this.componentMap.getComponentProperty(colField);
        ICellEditor entryEditor = table.getColumn(compProp.getPropertyName()).getEditor();
        if (null == entryEditor) {
            entryEditor = table.getCell(k, compProp.getPropertyName()).getEditor();
        }
        if (null == entryEditor) {
            entryEditor = table.getCellEditor(k, table.getColumnIndex(compProp.getPropertyName()));
        }
        if (null != entryEditor && entryEditor.getComponent() instanceof KDCheckBox) {
            isCheckBoxField = true;
        }
        int size = oldEntryObjectList.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue oldEntryObject = oldEntryObjectList.get(i);
            entryMsg.append(this.getResource("version", new String[0])).append(oldEntryObject.get("version")).append(this.getResource("value", new String[0])).append(":");
            if (this.isOldEntryValueNull(oldEntryObject)) {
                oldCellValue = noValue;
            } else if (BindingUtility.getValue((IObjectValue)oldEntryObject, (Field)colField) != null) {
                oldCellValue = BindingUtility.getValue((IObjectValue)oldEntryObject, (Field)colField).toString();
            }
            oldCellValue = this.handleSpecialField(isCheckBoxField, oldCellValue, nullFieldvalue, noValue);
            entryMsg.append(oldCellValue).append("<br>");
            ++this.curLineNumber;
        }
        String newCellValue = nullFieldvalue;
        if (BindingUtility.getValue((IObjectValue)newEntryObject, (Field)colField) != null) {
            newCellValue = BindingUtility.getValue((IObjectValue)newEntryObject, (Field)colField).toString();
        }
        newCellValue = this.handleSpecialField(isCheckBoxField, newCellValue, nullFieldvalue, noValue);
        entryMsg.append(this.getResource("currentVersion", new String[0])).append(":").append(newCellValue).append("<br>");
        ++this.curLineNumber;
        return entryMsg.toString();
    }

    private boolean hasEntryFieldAlter(Field colField, IObjectValue newEntryObject, List<IObjectValue> oldEntryObjectList) throws BOSException {
        Object newCellValue = BindingUtility.getValue((IObjectValue)newEntryObject, (Field)colField);
        boolean hasAlter = false;
        if (oldEntryObjectList == null) {
            return true;
        }
        for (IObjectValue oldEntryObject : oldEntryObjectList) {
            if (this.isOldEntryValueNull(oldEntryObject)) {
                hasAlter = true;
                break;
            }
            Object oldCellValue = BindingUtility.getValue((IObjectValue)oldEntryObject, (Field)colField);
            if (this.compareValue(newCellValue, oldCellValue)) continue;
            hasAlter = true;
            break;
        }
        return hasAlter;
    }

    private String dispalyHead(Set<String> headFieldSet) throws BOSException {
        StringBuilder difMsg = new StringBuilder();
        difMsg.append(this.getAlterMsg());
        Color color = new Color(Integer.parseInt(this.alterViewConfigInfo.getColor()));
        ArrayList headerFields = this.componentMap.getHeaderFields();
        if (headerFields != null) {
            boolean flag;
            Field field = null;
            ComponentProperty compProp = null;
            IObjectValue oldEditdata2 = null;
            StringBuffer toolTipSb = new StringBuffer();
            block0: do {
                flag = true;
                int length = headerFields.size();
                for (int i = 0; i < length; ++i) {
                    field = (Field)headerFields.get(i);
                    if (headFieldSet != null && !headFieldSet.contains(field.getActualName())) continue;
                    compProp = this.componentMap.getComponentProperty(field);
                    toolTipSb.setLength(0);
                    boolean hasDiff = false;
                    Object newFieldValue = BindingUtility.getValue((IObjectValue)this.editData, (Field)field);
                    for (IObjectValue oldEditdata2 : this.oldBillColl) {
                        Object oldFieldvalue = BindingUtility.getValue((IObjectValue)oldEditdata2, (Field)field);
                        if (this.compareValue(newFieldValue, oldFieldvalue)) continue;
                        hasDiff = true;
                        break;
                    }
                    if (hasDiff) {
                        difMsg.append(this.getHeaderDiffMsg(field));
                        JComponent component = (JComponent)compProp.getComponent();
                        this.oldBackGroundColorMap.put(component, this.getBackGroundCorlor(component));
                        this.setBackGroundCorlor(component, color);
                        component.setBackground(color);
                        MouseAdapter musLisener = new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                int lineNum = 1;
                                String fieldName = ((JComponent)e.getSource()).getName();
                                if (e.getSource().getClass().getName().equals("com.kingdee.bos.ctrl.swing.DateTimeEditor$DateTimeTextField")) {
                                    fieldName = ((JComponent)e.getSource()).getParent().getParent().getName();
                                }
                                ViewHistoryVersionHelper.this.displayUI.changeStyle(fieldName);
                                if (ViewHistoryVersionHelper.this.field2LineMap.get(fieldName) != null) {
                                    lineNum = (Integer)ViewHistoryVersionHelper.this.field2LineMap.get(fieldName);
                                }
                                int scrMaxValue = ViewHistoryVersionHelper.this.displayUI.getScrollMaxValue();
                                int value = lineNum * scrMaxValue / ViewHistoryVersionHelper.this.curLineNumber;
                                ViewHistoryVersionHelper.this.displayUI.setScrollValue(value);
                            }
                        };
                        if (component instanceof KDDatePicker) {
                            component = ((KDDatePicker)component).getEditor().getEditorComponent();
                        }
                        if (component instanceof KDPromptBox) {
                            component = ((KDPromptBox)component).getEditor();
                        }
                        component.addMouseListener(musLisener);
                        this.componentListenerMap.put(component, musLisener);
                    }
                    if (headerFields.size() == length) continue;
                    flag = false;
                    continue block0;
                }
            } while (!flag);
        }
        return difMsg.toString();
    }

    private String getHeaderDiffMsg(Field field) {
        StringBuilder toolTipSb = new StringBuilder();
        ComponentProperty componentProp = this.componentMap.getComponentProperty(field);
        this.field2LineMap.put(componentProp.getComponent().getName(), this.curLineNumber);
        toolTipSb.append("<span id=\"").append(componentProp.getComponent().getName()).append("\">").append(this.getResource("fieldName", new String[0])).append(":");
        boolean isCheckBox = componentProp.getComponent() instanceof KDCheckBox;
        if (componentProp.getComponent().getParent() instanceof KDLabelContainer) {
            KDLabelContainer lbC = (KDLabelContainer)componentProp.getComponent().getParent();
            toolTipSb.append(lbC.getBoundLabelText());
        } else if (isCheckBox) {
            toolTipSb.append(((KDCheckBox)componentProp.getComponent()).getText());
        }
        toolTipSb.append("<br>");
        ++this.curLineNumber;
        String nullFieldvalue = this.getResource("nullValue", new String[0]);
        for (IObjectValue oldEditdata : this.oldBillColl) {
            Object oldFieldvalue = BindingUtility.getValue((IObjectValue)oldEditdata, (Field)field);
            oldFieldvalue = this.handleSpecialField(isCheckBox, oldFieldvalue, nullFieldvalue, "");
            toolTipSb.append(this.getResource("version", new String[0])).append(oldEditdata.getString("version"));
            toolTipSb.append(":" + oldFieldvalue).append("<br>");
            ++this.curLineNumber;
        }
        Object newValue = BindingUtility.getValue((IObjectValue)this.editData, (Field)field);
        newValue = this.handleSpecialField(isCheckBox, newValue, nullFieldvalue, "");
        toolTipSb.append(this.getResource("currentVersion", new String[0])).append(":").append(newValue).append("<br>");
        toolTipSb.append("</span>");
        ++this.curLineNumber;
        toolTipSb.append("<hr>");
        return toolTipSb.toString();
    }

    private Object handleFieldValue(Object value, String nullFieldvalue) {
        if (null == value) {
            return nullFieldvalue;
        }
        if (value instanceof DataBaseInfo && null == value.toString()) {
            ((DataBaseInfo)value).setDisplayFormat("$description$");
        }
        return value.toString();
    }

    private String handleSpecialField(boolean isCheckBoxField, Object value, String nullFieldvalue, String noValue) {
        value = this.handleFieldValue(value, nullFieldvalue);
        if (!isCheckBoxField || nullFieldvalue.equals(value) || noValue.equals(value)) {
            return value.toString();
        }
        String yesStr = this.getResource("28_yes", new String[0]);
        String noStr = this.getResource("29_no", new String[0]);
        value = new Boolean(value.toString()) != false ? yesStr : noStr;
        return value.toString();
    }

    private boolean compareValue(Object newValue, Object oldValue) throws BOSException {
        try {
            return (Boolean)this.compareMethod.invoke((Object)this.compareClass, newValue, oldValue);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initCompareMethod() {
        try {
            this.compareClass = Class.forName("com.kingdee.bos.dao.AbstractObjectValue");
            this.compareMethod = this.compareClass.getDeclaredMethod("compareValue", Object.class, Object.class);
            this.compareMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IObjectCollection getOldVersionCollection(String currentID, boolean isShowAll) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(this.getOldModelIdColName(), (Object)currentID, CompareType.EQUALS));
        int version = this.editData.getInt("version");
        if (!isShowAll) {
            filter.getFilterItems().add(new FilterItemInfo("version", (Object)(version - 1), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("version", (Object)version, CompareType.LESS));
        }
        SelectorItemCollection sics = this.editUI.getMergedSelector();
        sics.add(new SelectorItemInfo("alterPerson.name"));
        sics.add(new SelectorItemInfo(this.getAlterDateColName()));
        view.setSelector(sics);
        view.setFilter(filter);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("version"));
        view.setSorter(sorters);
        return this.icoreBase.getCollection(view);
    }

    public String getOldModelIdColName() {
        return "oldID";
    }

    public String getOldEntryIdColName() {
        return "oldID";
    }

    public String getAlterDateColName() {
        return "alterDate";
    }

    public Set<String> getExcludeEntryNameSet() {
        return new HashSet<String>();
    }

    private Map<Field, Map<BOSUuid, List<IObjectValue>>> getEntryFieldMap(IObjectCollection oldColl) {
        HashMap<Field, Map<BOSUuid, List<IObjectValue>>> fieldMap = new HashMap<Field, Map<BOSUuid, List<IObjectValue>>>();
        HashMap oldID2ValueListMap = null;
        ArrayList oldEntryValueList = null;
        Field headerField = new Field("header");
        ArrayList detailList = this.componentMap.getDetailList(headerField);
        String entryKey = null;
        for (Object detailField : detailList) {
            entryKey = ((Field)detailField).getActualName();
            oldID2ValueListMap = new HashMap();
            IObjectCollection newDetailCollection = (IObjectCollection)BindingUtility.getBeanProperty((Object)this.editData, (String)entryKey);
            for (IObjectValue newDetailInfo : newDetailCollection) {
                for (CoreBaseInfo oldInfo : oldColl) {
                    BOSUuid oldId = (BOSUuid)newDetailInfo.get("id");
                    if (null == oldId) continue;
                    if (oldID2ValueListMap.get(oldId) == null) {
                        oldEntryValueList = new ArrayList();
                        oldID2ValueListMap.put(oldId, oldEntryValueList);
                    }
                    ((List)oldID2ValueListMap.get(oldId)).add(this.getEntryInfoByOldId(oldInfo, oldId.toString(), entryKey));
                }
            }
            fieldMap.put((Field)detailField, oldID2ValueListMap);
        }
        return fieldMap;
    }

    private IObjectValue getEntryInfoByOldId(CoreBaseInfo oldInfo, String id, String entryKey) {
        IObjectCollection oldDetailCollection = (IObjectCollection)BindingUtility.getBeanProperty((Object)oldInfo, (String)entryKey);
        for (IObjectValue oldDetailInfo : oldDetailCollection) {
            BOSUuid oldId = (BOSUuid)oldDetailInfo.get(this.getOldEntryIdColName());
            if (oldId == null || !oldId.toString().equals(id)) continue;
            oldDetailInfo.put("version", oldInfo.get("version"));
            return oldDetailInfo;
        }
        CoreBillBaseInfo coreInfo = new CoreBillBaseInfo(){};
        coreInfo.put("version", oldInfo.get("version"));
        return coreInfo;
    }

    private void initHistoryDisplayUI(boolean isShowAll) {
        try {
            this.displayUI = new HistoryChangeDisplayUI();
            this.displayUI.initUIContentLayout();
            this.displayUI.getShowAllCheckBox().setSelected(isShowAll);
            this.displayUI.setPreferredSize(new Dimension(300, 600));
            MatteBorder matteBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray);
            this.displayUI.setBorder(matteBorder);
        }
        catch (Exception e) {
            this.editUI.handUIException((Throwable)e);
        }
        if (this.editUI.getParent() instanceof KDPanel) {
            this.editUI.getParent().add((Component)((Object)this.displayUI), "East");
            this.editUI.getParent().validate();
        } else {
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)new BorderLayout());
            this.editUI.getParent().add((Component)panel);
            panel.add((Component)this.editUI, (Object)"Center");
            panel.add((Component)((Object)this.displayUI), (Object)"East");
            panel.getParent().validate();
        }
        this.displayUI.getShowAllCheckBox().addItemListener((ItemListener)new ShowAllChangeListener());
    }

    private EntityViewInfo getConfigEntityViewInfo() {
        BOSObjectType bosType = this.editData.getBOSType();
        CtrlUnitInfo cu = (CtrlUnitInfo)this.editData.get("CU");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType.toString()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cu.getId()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void actionToggleHistory(ActionEvent e) {
        try {
            this.toggleDispaly();
        }
        catch (BOSException e1) {
            this.editUI.handUIException((Throwable)e1);
        }
    }

    private String getResource(String key, String ... value) {
        return EASResource.getString((String)"com.kingdee.eas.scm.framework.alter.AlterViewConfigResource", (String)key, (Object[])value);
    }

    private void setBackGroundCorlor(JComponent component, Color color) {
        if (component instanceof KDTextField) {
            ((KDTextField)component).setCustomBackgroundColor(color);
        } else if (component instanceof KDPromptBox) {
            ((KDTextField)((KDPromptBox)component).getEditor()).setCustomBackgroundColor(color);
        } else if (component instanceof KDCheckBox) {
            ((KDCheckBox)component).setForeground(color);
        } else if (component instanceof KDDatePicker) {
            ((BasicFormattedTextField)((KDDatePicker)component).getEditor().getEditorComponent()).setCustomBackgroundColor(color);
        } else if (component instanceof BasicFormattedTextField) {
            ((BasicFormattedTextField)component).setCustomBackgroundColor(color);
        } else {
            component.setBackground(color);
        }
    }

    private Color getBackGroundCorlor(JComponent component) {
        if (component instanceof KDTextField) {
            return ((KDTextField)component).getCustomBackgroundColor();
        }
        if (component instanceof KDPromptBox) {
            return ((KDTextField)((KDPromptBox)component).getEditor()).getCustomBackgroundColor();
        }
        if (component instanceof KDCheckBox) {
            return ((KDCheckBox)component).getForeground();
        }
        if (component instanceof KDDatePicker) {
            return ((BasicFormattedTextField)((KDDatePicker)component).getEditor().getEditorComponent()).getBackground();
        }
        if (component instanceof BasicFormattedTextField) {
            return ((BasicFormattedTextField)component).getCustomBackgroundColor();
        }
        return component.getBackground();
    }

    public EventListener[] removeTablePropertyChangeListener(KDTable detail, Class type) {
        if (detail != null) {
            EventListenerList eventList = detail.getListenerList();
            EventListener[] lists = eventList.getListeners(type);
            if (lists != null) {
                for (int i = 0; i < lists.length; ++i) {
                    eventList.remove(type, lists[i]);
                }
            }
            return lists;
        }
        return null;
    }

    private String getFormatPattern(int scale, boolean isUp) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        String foreStr = "\u2193";
        if (isUp) {
            foreStr = "\u2191";
        }
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = foreStr + pattern + ";" + foreStr + "-" + pattern + ";";
        return pattern;
    }

    public void setShow(boolean isShow) {
        this.isShow = isShow;
    }

    class AfterShowListener
    extends UILifeCycleImp {
        AfterShowListener() {
        }

        public void afterOnShow(UILifeCycleEvent event) {
            ViewHistoryVersionHelper.this.defaultShow();
        }

        public void onSetDataObject(UILifeCycleEvent event) {
            if (ViewHistoryVersionHelper.this.isShow) {
                ViewHistoryVersionHelper.this.destoryDiffDisplay();
            }
        }
    }

    class ActionToggleHistory
    extends ItemAction {
        public ActionToggleHistory() {
            this(null);
        }

        public ActionToggleHistory(IUIObject uiObject) {
            super(uiObject);
            this.putValue("ShortDescription", ViewHistoryVersionHelper.this.getResource("viewAlter", new String[0]));
            this.putValue("LongDescription", ViewHistoryVersionHelper.this.getResource("viewAlter", new String[0]));
            this.putValue("Name", ViewHistoryVersionHelper.this.getResource("viewAlter", new String[0]));
        }

        public void actionPerformed(ActionEvent e) {
            ViewHistoryVersionHelper.this.actionToggleHistory(e);
        }
    }

    class ShowAllChangeListener
    implements ItemListener {
        ShowAllChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (ViewHistoryVersionHelper.this.displayUI.getShowAllCheckBox().isSelected()) {
                ViewHistoryVersionHelper.this.destoryDiffDisplay();
                try {
                    ViewHistoryVersionHelper.this.dispalyDiff(true);
                }
                catch (BOSException e1) {
                    ViewHistoryVersionHelper.this.editUI.handUIException((Throwable)e1);
                }
            } else {
                ViewHistoryVersionHelper.this.destoryDiffDisplay();
                try {
                    ViewHistoryVersionHelper.this.dispalyDiff(false);
                }
                catch (BOSException e1) {
                    ViewHistoryVersionHelper.this.editUI.handUIException((Throwable)e1);
                }
            }
        }
    }

    class AlterCellSelectListener
    implements KDTSelectListener {
        private Field detailField;

        public AlterCellSelectListener(Field detailField) {
            this.detailField = detailField;
        }

        public void tableSelectChanged(KDTSelectEvent e) {
            KDTSelectBlock selectBlock = e.getSelectBlock();
            if (selectBlock.size() == 1 && selectBlock.getBeginCol() == selectBlock.getEndCol() && selectBlock.getBeginRow() == selectBlock.getEndRow()) {
                KDTable table = (KDTable)e.getSource();
                int rowIndex = selectBlock.getBeginRow();
                int colIndex = selectBlock.getBeginCol();
                ICell cell = table.getCell(rowIndex, colIndex);
                Object id = table.getRow(rowIndex).getCell("id").getValue();
                if (null == id) {
                    return;
                }
                String entryId = id.toString();
                Color color = new Color(Integer.parseInt(ViewHistoryVersionHelper.this.alterViewConfigInfo.getColor()));
                if (cell.getStyleAttributes().getBackground().equals(color)) {
                    String lineKey = entryId + table.getName() + table.getColumnKey(colIndex);
                    ViewHistoryVersionHelper.this.displayUI.changeStyle(lineKey);
                    int lineNum = 1;
                    if (ViewHistoryVersionHelper.this.field2LineMap.get(lineKey) != null) {
                        lineNum = (Integer)ViewHistoryVersionHelper.this.field2LineMap.get(lineKey);
                    }
                    int scrMaxValue = ViewHistoryVersionHelper.this.displayUI.getScrollMaxValue();
                    int value = (lineNum - 1) * scrMaxValue / ViewHistoryVersionHelper.this.curLineNumber;
                    ViewHistoryVersionHelper.this.displayUI.setScrollValue(value);
                }
            }
        }
    }
}

