/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class WriteBack2CarryBillSQLHelper {
    public static String createCBWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_SaleIssueEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_SaleIssueBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ABS(srcEntry.FQty)-ABS(srcEntry.FOutQtyActual) < 0 ");
            }
        } else if (isWriteCore[1]) {
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_PurInWarehsEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_PurInWarehsBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ABS(srcEntry.FQty)-ABS(srcEntry.FQtyActual) < 0 ");
            }
        } else if (isWriteCore[2]) {
            sql.append("SELECT 3 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_MoveIssueBillEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_MoveIssueBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ABS(srcEntry.FQty)-ABS(srcEntry.FOutQtyActual) < 0 ");
            }
        } else if (isWriteCore[3]) {
            sql.append("SELECT 4 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq, src.FTranportOrgUnitId as tranportOrgUnitId ");
            sql.append("FROM T_DT_CarryBillFeeEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_DT_LogisticsFeeEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_DT_LogisticsFee dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ABS(srcEntry.FFeeQty)-ABS(srcEntry.FBalancedQty) < 0 ");
            }
        } else if (isWriteCore[4]) {
            sql.append("SELECT 5 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_MoveInWarehsBillEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_MoveInWarehsBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND srcEntry.FReceiveAssoBaseQty < 0 ");
            }
        } else if (isWriteCore[5]) {
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillFeeEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_PurInWarehsEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_PurInWarehsBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("");
            }
        } else if (isWriteCore.length > 6 && isWriteCore[6]) {
            sql.append("SELECT 6 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_AR_OtherBillentry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_AR_OtherBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append(" AND srcEntry.FArAssociateQty < 0 ");
            }
        } else if (isWriteCore.length > 7 && isWriteCore[7]) {
            sql.append("SELECT 2 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_PurInWarehsEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_PurInWarehsBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ( ");
                sql.append("(srcEntry.FReceivedQty + srcEntry.FReceivedLostQty) < srcEntry.FReceivedArQty OR ");
                sql.append("(srcEntry.FReceivedQty + srcEntry.FReceivedLostQty) < srcEntry.FQtyActual ) ");
            }
        } else if (isWriteCore.length > 8 && isWriteCore[8]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_SaleIssueEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_SaleIssueBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ( ");
                sql.append("(srcEntry.FOutQtyActual - srcEntry.FQtyLoss) < srcEntry.FReceivedArQty OR ");
                sql.append("(srcEntry.FOutQtyActual - srcEntry.FQtyLoss) < srcEntry.FQtyActual ) ");
            }
        } else if (isWriteCore.length > 9 && isWriteCore[9]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_SaleIssueEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_SaleIssueBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append(" AND srcEntry.FAssociateQty < 0 ");
            }
        } else if (isWriteCore.length > 10 && isWriteCore[10]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_CarryBillEntry srcEntry ");
            sql.append("INNER JOIN T_DT_CarryBill src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_IM_SaleIssueEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_IM_SaleIssueBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (!isBefore) {
                sql.append("AND ( ");
                sql.append("(srcEntry.FReceivedQty + srcEntry.FReceivedLostQty) < srcEntry.FReceivedArQty OR ");
                sql.append("(srcEntry.FReceivedQty + srcEntry.FReceivedLostQty) < srcEntry.FQtyActual ) ");
            }
        }
        return sql.toString();
    }

    public static void verifyCBWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        boolean isError = false;
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.CARRYBILL_WBERROR")).append("\n");
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.QTYFLOWOFF")).append("\n");
        while (rs.next()) {
            isError = true;
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.CARRYBILLNO")).append(":");
            sql.append(rs.getString("srcNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("srcSeq"));
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SALEISSUE"));
                    break;
                }
                case 2: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.PURIN"));
                    break;
                }
                case 3: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.MOVEISSUE"));
                    break;
                }
                case 4: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.LogisticsFee"));
                    break;
                }
                case 5: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.MOVEINWAREHS"));
                    break;
                }
                case 6: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.AROTHERBILL"));
                }
            }
            sql.append(rs.getString("destNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("destSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static void verifyCBWriteBack(Context ctx, IRowSet rs) throws SQLException, SCMBillException {
        boolean isError = false;
        StringBuffer sql = new StringBuffer();
        sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "CARRYBILL_WBERROR", ctx)).append("\n");
        sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "QTYFLOWOFF", ctx)).append("\n");
        while (rs.next()) {
            isError = true;
            sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "CARRYBILLNO", ctx)).append(":");
            sql.append(rs.getString("srcNumber")).append(" ");
            sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WBResource", "SEQNO", ctx)).append(":");
            sql.append(rs.getInt("srcSeq")).append(" ");
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WBResource", "SALEISSUE", ctx)).append(":");
                    break;
                }
                case 2: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "PURIN", ctx)).append(":");
                    break;
                }
                case 3: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "MOVEISSUE", ctx)).append(":");
                    break;
                }
                case 4: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "LogisticsFee", ctx)).append(":");
                    break;
                }
                case 5: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "MOVEINWAREHS", ctx)).append(":");
                    break;
                }
                case 6: {
                    sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WB2CBResource", "AROTHERBILL", ctx)).append(":");
                }
            }
            sql.append(rs.getString("destNumber")).append(" ");
            sql.append(SCMUtils.getResource("com.kingdee.eas.scm.common.WBResource", "SEQNO", ctx)).append(":");
            sql.append(rs.getInt("destSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getSI2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getSI2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_IM_SaleIssueEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createSI2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FOutQtyActual, FAssociateQty,FQtyActual,FArAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FOutQtyActual+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FOutQtyActual+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty-tmp.FBaseQty ,");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FArAssociateQty IS NULL THEN tmp.FBaseQty ELSE srcEntry.FArAssociateQty+tmp.FBaseQty END ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FOutQtyActual-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FOutQtyActual-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty+tmp.FBaseQty ,");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FArAssociateQty-tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append("(select fparentid,fsourcebillentryid,fbaseunitid,fbaseunitid as funitid,sum(fbaseqty) as fbaseqty,sum(fbaseqty) as fqty ");
        sql.append("from ").append(temptable);
        sql.append(" group by fparentid,fsourcebillentryid,fbaseunitid) ");
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String createSI2CBWriteSQL2(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FQtyActual, FReceivedQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReceivedQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReceivedQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty+tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReceivedQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReceivedQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty-tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append("(select fparentid,fsourcebillentryid,fbaseunitid,fbaseunitid as funitid,sum(fbaseqty) as fbaseqty,sum(fbaseqty) as fqty ");
        sql.append("from ").append(temptable);
        sql.append(" group by fparentid,fsourcebillentryid,fbaseunitid) ");
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getPI2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getPI2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_IM_PurInWarehsEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createPI2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FQtyActual, FReceivedQty, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReceivedQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReceivedQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FQtyActual-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FQtyActual-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FReceivedQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FReceivedQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append("srcEntry.FAssociateQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String createPI2CBWriteSQL2(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FReceiveAssoBaseQty, FReceivedQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT srcEntry.FReceiveAssoBaseQty - tmp.FBaseQty,");
            sql.append(" srcEntry.FReceivedQty + (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END) ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT srcEntry.FReceiveAssoBaseQty + tmp.FBaseQty,");
            sql.append(" srcEntry.FReceivedQty - (CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END) ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getMO2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getMO2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_IM_MoveIssueBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createMO2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FOutQtyActual, FAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FOutQtyActual+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FOutQtyActual+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FAssociateQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FOutQtyActual-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FOutQtyActual-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append("srcEntry.FAssociateQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append("(select fparentid,fsourcebillentryid,fbaseunitid,fbaseunitid as funitid,sum(fbaseqty) as fbaseqty,sum(fbaseqty) as fqty ");
        sql.append("from ").append(temptable);
        sql.append(" group by fparentid,fsourcebillentryid,fbaseunitid) ");
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getLF2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBalanceQty DECIMAL(21,8),");
        sql.append("FBalanceAmt DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getLF2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,SUM(FBalanceQty) AS FBalanceQty, SUM(FBalanceAmt) AS FBalanceAmt ");
        sql.append("FROM T_DT_LogisticsFeeEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID");
        return sql.toString();
    }

    public static String createLF2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillFeeEntry AS T1 SET ");
        sql.append("(FUnbalancedQty, FBalancedQty, FBalancedAmount)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FUnbalancedQty-are.FBalanceQty,");
            sql.append(" sre.FBalancedQty+are.FBalanceQty, ");
            sql.append(" sre.FBalancedAmount+are.FBalanceAmt ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FUnbalancedQty+are.FBalanceQty,");
            sql.append(" sre.FBalancedQty-are.FBalanceQty, ");
            sql.append(" sre.FBalancedAmount-are.FBalanceAmt ");
        }
        sql.append("FROM T_DT_CarryBillFeeEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" are ON are.FSourceBillEntryId=sre.FID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String getCB2SOTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FCoreBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getCB2SOInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FCoreBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_DT_CarryBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FCoreBillEntryID,FBaseUnitID,FUnitID ");
        return sql.toString();
    }

    public static String createCB2SOWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SaleOrderEntry AS T1 SET ");
        sql.append("(FPlanDeliveryQty, FTotalUnIssueQty, FTotalUnIssueBaseQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalUnIssueQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalUnIssueQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FTotalUnIssueBaseQty-tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FPlanDeliveryQty-tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FPlanDeliveryQty-tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" CASE WHEN srcEntry.FUnitID=tmp.FUnitID THEN srcEntry.FTotalUnIssueQty+tmp.FQty ");
            sql.append(" ELSE ROUND(srcEntry.FTotalUnIssueQty+tmp.FBaseQty/mmu.FBaseConvsRate,mmu.FQtyPrecision) END,");
            sql.append(" srcEntry.FTotalUnIssueBaseQty+tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FCoreBillEntryId=srcEntry.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=srcEntry.FMaterialID AND mmu.FMeasureUnitID=srcEntry.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }

    public static String getMI2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getMI2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FBaseUnitID,SUM(FBaseQty) AS FBaseQty, FUnitID,SUM(FQty) AS FQty ");
        sql.append("FROM T_IM_MoveInWarehsBillEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FBaseUnitID, FUnitID");
        return sql.toString();
    }

    public static String createMI2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FReceiveAssoBaseQty, FQtyActual, FReceivedQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT sre.FReceiveAssoBaseQty - tmp.FBaseQty,");
            sql.append(" CASE WHEN sre.FQtyActual=sre.FReceivedQty ");
            sql.append(" THEN (sre.FQtyActual + (CASE WHEN sre.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END)) ");
            sql.append(" ELSE sre.FQtyActual END, ");
            sql.append(" sre.FReceivedQty + (CASE WHEN sre.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END) ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT sre.FReceiveAssoBaseQty + tmp.FBaseQty,");
            sql.append(" CASE WHEN sre.FQtyActual=sre.FReceivedQty ");
            sql.append(" THEN (sre.FQtyActual - (CASE WHEN sre.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END)) ");
            sql.append(" ELSE sre.FQtyActual END, ");
            sql.append(" sre.FReceivedQty - (CASE WHEN sre.FUnitID=tmp.FUnitID THEN tmp.FQty ");
            sql.append(" ELSE ROUND(Decimal(tmp.FBaseQty/mmu.FBaseConvsRate,28,16),mmu.FQtyPrecision) END) ");
        }
        sql.append("FROM T_DT_CarryBillEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }

    public static String getAR2CBTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8),");
        sql.append("FRecievePayAmount DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getAR2CBInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID, FSourceBillEntryID, FBaseUnitID, ");
        sql.append(" SUM(FBaseQty) AS FBaseQty, FMeasureUnitID, SUM(FQuantity) AS FQty, SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AR_OtherBillentry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID, FSourceBillEntryID, FBaseUnitID, FMeasureUnitID ");
        return sql.toString();
    }

    public static String createAR2CBWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_CarryBillEntry AS T1 SET ");
        sql.append("(FReceivedArQty, FReceivedArAmount, FArAssociateQty)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN sre.FUnitID = tmp.FUnitID THEN (sre.FReceivedArQty + tmp.FQty) ");
            sql.append(" ELSE ROUND((sre.FReceivedArQty + tmp.FQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append(" sre.FReceivedArAmount + tmp.FRecievePayAmount, ");
            sql.append(" sre.FArAssociateQty - tmp.FBaseQty ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT ");
            sql.append(" CASE WHEN sre.FUnitID = tmp.FUnitID THEN (sre.FReceivedArQty - tmp.FQty) ");
            sql.append(" ELSE ROUND((sre.FReceivedArQty - tmp.FQty)/mmu.FBaseConvsRate,mmu.FQtyPrecision) END, ");
            sql.append(" sre.FReceivedArAmount - tmp.FRecievePayAmount, ");
            sql.append(" sre.FArAssociateQty + tmp.FBaseQty ");
        }
        sql.append("FROM T_DT_CarryBillEntry sre ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=sre.FID ");
        sql.append(" INNER JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=sre.FMaterialID AND mmu.FMeasureUnitID=sre.FUnitID ");
        sql.append("WHERE ");
        sql.append("T1.FID=sre.FID)");
        return sql.toString();
    }
}

