/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.util;

import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class WriteBack2LogisitcsFeeSQLHelper {
    public static String createLFWriteBackVerifySQL(String idList, boolean[] isWriteCore, String temptable, boolean isBefore) {
        StringBuffer sql = new StringBuffer();
        if (isWriteCore[0]) {
            sql.append("SELECT 1 as FErrType, src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq ");
            sql.append("FROM T_DT_LogisticsFeeEntry srcEntry ");
            sql.append("INNER JOIN T_DT_LogisticsFee src ON src.FID=srcEntry.FParentID ");
            sql.append("INNER JOIN T_AP_OtherBillentry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ");
            sql.append("INNER JOIN T_AP_OtherBill dest ON dest.FID=destEntry.FParentID ");
            sql.append("WHERE dest.FID IN (");
            sql.append(idList);
            sql.append(") ");
            if (isBefore) {
                sql.append(" AND ABS(srcEntry.FAssociateQty) < ABS(destEntry.FBaseQty) ");
            } else {
                sql.append(" AND srcEntry.FAssociateQty < 0 ");
            }
        }
        return sql.toString();
    }

    public static void verifyLFWriteBack(IRowSet rs) throws SQLException, SCMBillException {
        boolean isError = false;
        StringBuffer sql = new StringBuffer();
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2LFResource.LOGISTICSFEE_WBERROR")).append("\n");
        sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2CBResource.QTYFLOWOFF")).append("\n");
        while (rs.next()) {
            isError = true;
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2LFResource.LOGISTICSFEENO")).append(":");
            sql.append(rs.getString("srcNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("srcSeq"));
            switch (rs.getInt("FErrType")) {
                case 1: {
                    sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WB2LFResource.AP"));
                }
            }
            sql.append(rs.getString("destNumber"));
            sql.append(EASResource.getString((String)"com.kingdee.eas.scm.common.WBResource.SEQNO")).append(":");
            sql.append(rs.getInt("destSeq")).append("\n");
        }
        if (isError) {
            throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, new Object[]{sql.toString()});
        }
    }

    public static String getAP2LFTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8),");
        sql.append("FRecievePayAmount DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getAP2LFInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,");
        sql.append(" SUM(FBaseQty) AS FBaseQty, SUM(FQuantity) AS FQty, SUM(FRecievePayAmount) AS FRecievePayAmount ");
        sql.append("FROM T_AP_OtherBillentry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FMeasureUnitID ");
        return sql.toString();
    }

    public static String createAP2LFWriteSQL(BizActionEnum bizAction, String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_DT_LogisticsFeeEntry AS T1 SET ");
        sql.append("(FAssociateQty, FTotalApQty, FTotalApAmt)=");
        if (bizAction == BizActionEnum.AUDIT) {
            sql.append("(SELECT srcEntry.FAssociateQty - tmp.FBaseQty,");
            sql.append(" srcEntry.FTotalApQty + tmp.FQty, ");
            sql.append(" srcEntry.FTotalApAmt + tmp.FRecievePayAmount ");
        } else if (bizAction == BizActionEnum.UNAUDIT) {
            sql.append("(SELECT srcEntry.FAssociateQty + tmp.FBaseQty,");
            sql.append(" srcEntry.FTotalApQty - tmp.FQty, ");
            sql.append(" srcEntry.FTotalApAmt - tmp.FRecievePayAmount ");
        }
        sql.append("FROM T_DT_LogisticsFeeEntry srcEntry ");
        sql.append("INNER JOIN ");
        sql.append(temptable);
        sql.append(" tmp ON tmp.FSourceBillEntryId=srcEntry.FID ");
        sql.append("WHERE ");
        sql.append("T1.FID=srcEntry.FID)");
        return sql.toString();
    }
}

