/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.verify;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.scm.common.util.ArrayListMap;
import com.kingdee.eas.scm.common.util.ArrayMap;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.common.verify.BatchVerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MaterialInventoryVerifyItem
extends BatchVerifyItem {
    public MaterialInventoryVerifyItem(Component component, VerifyType verifyType, Object compareValue, String errMsg) {
        super(component, verifyType, compareValue, errMsg);
    }

    public MaterialInventoryVerifyItem(Component component) {
        super(component);
    }

    @Override
    protected boolean doVerify() throws Exception {
        List result = null;
        ArrayMap miMap = this.getMaterialInventoryMap();
        IMaterial imaterial = MaterialFactory.getRemoteInstance();
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getRemoteInstance();
        HashMap map = iMaterialInventory.verifyMaterialInvInfos((HashMap)this.makeParamMap(miMap));
        ArrayList rowList = new ArrayList();
        if (miMap != null && miMap.size() > 0) {
            Object[] storages = miMap.keySet().toArray();
            for (int i = 0; i < storages.length; ++i) {
                result = (List)map.get((String)storages[i]);
                rowList.addAll(this.addRowForShowingError(storages[i], result, miMap));
            }
            if (rowList.size() > 0) {
                Object[] rows = SortUtil.sortArrayByIntValue(rowList.toArray(), true);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < rows.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(rows[i]);
                }
                return !this.isError(sb);
            }
        }
        return true;
    }

    private List addRowForShowingError(Object stID, List result, ArrayMap miMap) {
        List<Object> errorList = new ArrayList();
        Object[] rowIDs = miMap.getArray((String)stID, 1);
        Object[] materials = miMap.getArray((String)stID, 0);
        if (result == null) {
            errorList = Arrays.asList(rowIDs);
            return errorList;
        }
        for (int i = 0; i < rowIDs.length; ++i) {
            if (result.indexOf(materials[i]) != -1) continue;
            errorList.add(rowIDs[i]);
        }
        return errorList;
    }

    private Map makeParamMap(ArrayMap miMap) {
        HashMap<Object, List<String>> paramMap = new HashMap<Object, List<String>>();
        Object[] storages = miMap.keySet().toArray();
        for (int i = 0; i < storages.length; ++i) {
            Object[] materials = miMap.getArray(storages[i], 0);
            String[] materialIds = new String[materials.length];
            System.arraycopy(materials, 0, materialIds, 0, materials.length);
            paramMap.put(storages[i], Arrays.asList(materialIds));
        }
        return paramMap;
    }

    public ArrayMap getMaterialInventoryMap() {
        String colMaterial = (String)this.columns.get("MATERIAL");
        String colStorage = (String)this.columns.get("STORAGEORGUNIT");
        if (this.component instanceof KDTable && colMaterial != null && colStorage != null) {
            ArrayListMap map = new ArrayListMap(2);
            KDTable table = (KDTable)this.component;
            for (int i = 0; i < table.getRowCount(); ++i) {
                IRow arow = table.getRow(i);
                MaterialInfo materialInfo = (MaterialInfo)arow.getCell(colMaterial).getValue();
                StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)arow.getCell(colStorage).getValue();
                if (materialInfo == null || storageInfo == null) continue;
                map.put(storageInfo.getId().toString(), new Object[]{materialInfo.getId().toString(), new Integer(i + 1)});
            }
            return map;
        }
        return null;
    }
}

