/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.dataloader;

import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import java.util.HashMap;
import java.util.Map;

public class DefaultDataCache
implements IDataCache {
    private Map<DataTypeEnum, Map<String, Object>> cacheMap = new HashMap<DataTypeEnum, Map<String, Object>>();
    private Map<String, Map<String, Object>> othersMap = new HashMap<String, Map<String, Object>>();

    @Override
    public Object get(String key, DataTypeEnum dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (dataType != null);
        Map<String, Object> tMap = this.getDataMapByType(dataType);
        return tMap.get(key);
    }

    @Override
    public boolean contain(String key, DataTypeEnum dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (dataType != null);
        Map<String, Object> tMap = this.getDataMapByType(dataType);
        return tMap.containsKey(key);
    }

    @Override
    public void put(String key, Object obj, DataTypeEnum dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (obj != null);
        assert (dataType != null);
        Map<String, Object> tMap = this.getDataMapByType(dataType);
        tMap.put(key, obj);
    }

    @Override
    public void putAll(DataTypeEnum dataType, Map<String, Object> dataMap) {
        assert (dataType != null);
        assert (dataMap != null);
        Map<String, Object> tMap = this.getDataMapByType(dataType);
        tMap.putAll(dataMap);
    }

    @Override
    public Map<String, Object> getDataMapByType(DataTypeEnum dataType) {
        HashMap<String, Object> tMap;
        assert (dataType != null);
        if (this.cacheMap.containsKey((Object)dataType)) {
            tMap = this.cacheMap.get((Object)dataType);
        } else {
            tMap = new HashMap();
            this.cacheMap.put(dataType, tMap);
        }
        return tMap;
    }

    @Override
    public Object getOthers(String key, String dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (dataType != null);
        Map<String, Object> tMap = this.getOtherDataMapByType(dataType);
        return tMap.get(key);
    }

    private Map<String, Object> getOtherDataMapByType(String dataType) {
        HashMap<String, Object> tMap;
        assert (dataType != null);
        if (this.othersMap.containsKey(dataType)) {
            tMap = this.othersMap.get(dataType);
        } else {
            tMap = new HashMap();
            this.othersMap.put(dataType, tMap);
        }
        return tMap;
    }

    @Override
    public boolean containOthers(String key, String dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (dataType != null);
        Map<String, Object> tMap = this.getOtherDataMapByType(dataType);
        return tMap.containsKey(key);
    }

    @Override
    public void putOthers(String key, Object obj, String dataType) {
        assert (key != null && !"".equals(key.trim()));
        assert (obj != null);
        assert (dataType != null);
        Map<String, Object> tMap = this.getOtherDataMapByType(dataType);
        tMap.put(key, obj);
    }
}

