/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.BatchValidationException;
import com.kingdee.eas.scm.framework.validator.ValidationResult;
import com.kingdee.eas.scm.framework.validator.ValidationResultItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultValidationResult
implements ValidationResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValidationResult.class);
    private List<ValidationResultItem> result = new ArrayList<ValidationResultItem>();
    private Map<IObjectPK, EASBizException> resultMap = new HashMap<IObjectPK, EASBizException>();

    @Override
    public void addFailure(IObjectPK pk, EASBizException ex) {
        assert (pk != null);
        assert (ex != null);
        ValidationResultItem item = new ValidationResultItem(pk, ex);
        this.addFailure(item);
    }

    @Override
    public void addFailure(ValidationResultItem item) {
        assert (item != null);
        this.result.add(item);
        this.resultMap.put(item.getPk(), item.getException());
        if (logger.isDebugEnabled() && item.getException() != null) {
            logger.debug("\u4e1a\u52a1\u6821\u9a8c\u5f02\u5e38:", (Throwable)item.getException());
        }
    }

    @Override
    public Iterator<ValidationResultItem> iterator() {
        return this.result.iterator();
    }

    @Override
    public boolean isFailed(IObjectPK pk) {
        assert (pk != null);
        return this.resultMap.containsKey(pk);
    }

    @Override
    public EASBizException getException(IObjectPK pk) {
        assert (pk != null);
        return this.resultMap.get(pk);
    }

    @Override
    public boolean hasFialed() {
        return this.result.size() > 0;
    }

    @Override
    public void throwExceptionIfHasFialed() throws BatchValidationException {
        if (this.hasFialed()) {
            throw new BatchValidationException(this);
        }
    }
}

