/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.beanvalidation;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.validator.beanvalidation.PropertyValidationException;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationError;
import com.kingdee.eas.scm.framework.validator.beanvalidation.PropertyValidationErrors;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DefaultPropertyValidationErrors
implements PropertyValidationErrors {
    private static final String ERROR_RESOURCE = "com.kingdee.eas.scm.common.validator.beanvalidation.ValidationResource";
    private Context ctx;
    private List<PropertyValidationError> errors;
    private boolean isInitErrorMsg = false;
    private String errorMsg;
    private Locale locale;
    private Map<BOSObjectType, EntityObjectInfo> entityObjectMap;

    DefaultPropertyValidationErrors(Context ctx) {
        this.ctx = ctx;
        this.init();
    }

    private void init() {
        this.errors = new ArrayList<PropertyValidationError>();
        this.entityObjectMap = new HashMap<BOSObjectType, EntityObjectInfo>();
        this.locale = this.ctx == null ? SysContext.getSysContext().getLocale() : this.ctx.getLocale();
    }

    DefaultPropertyValidationErrors() {
        this(null);
    }

    @Override
    public void addValidationError(PropertyValidationError error) {
        assert (error != null);
        this.errors.add(error);
        this.isInitErrorMsg = false;
    }

    @Override
    public void clear() {
        this.errors.clear();
        this.isInitErrorMsg = false;
    }

    @Override
    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    @Override
    public String getErrorMsg() {
        if (!this.isInitErrorMsg) {
            this.initErrorMsg();
        }
        return this.errorMsg;
    }

    @Override
    public PropertyValidationException getErrorException() {
        if (!this.isInitErrorMsg) {
            this.initErrorMsg();
        }
        return new PropertyValidationException(PropertyValidationException.VALIDATEFAILD, new Object[]{this.errorMsg});
    }

    private void initErrorMsg() {
        StringBuilder sb = new StringBuilder();
        int size = this.errors.size();
        for (int i = 0; i < size; ++i) {
            String errorStr;
            if (i > 0) {
                if (this.locale != null && !this.locale.equals(this.ctx.getLocale())) {
                    sb.append(ResourceBase.getString((String)ERROR_RESOURCE, (String)"semicolon", (Locale)this.locale));
                }
                sb.append("  ");
            }
            PropertyValidationError error = this.errors.get(i);
            ArrayList<Object> params = new ArrayList<Object>();
            if (!StringUtils.isEmpty((String)error.getErrResource())) {
                errorStr = ResourceBase.getString((String)error.getErrResource(), (Locale)this.locale);
                if (error.getParentSeq() != 0) {
                    params.add(error.getParentSeq());
                }
                params.add(error.getEntrySeq());
            } else {
                PropertyInfo propertyInfo;
                String propertyAlias;
                String propertys;
                String resName = null;
                EntityObjectInfo entityObjectInfo = this.getEntityObjectInfoByBosType(error.getBosType());
                String p = propertys = error.getProperty();
                if (!StringUtils.isEmpty((String)propertys) && propertys.indexOf("#") != -1) {
                    p = propertys.split("#")[1];
                }
                String string = propertyAlias = (propertyInfo = entityObjectInfo.getPropertyByName(p)) != null ? (propertyAlias = propertyInfo.getAlias()) : p;
                if (error.getEntrySeq() > 0) {
                    resName = "Entry_" + error.getErrorType().getErrRes();
                    params.add(error.getEntrySeq());
                    params.add(propertyAlias);
                } else {
                    resName = "Bill_" + error.getErrorType().getErrRes();
                    params.add(propertyAlias);
                }
                errorStr = ResourceBase.getString((String)ERROR_RESOURCE, (String)resName, (Locale)this.locale);
            }
            if (null != error.getReplaceParam() && error.getReplaceParam().length > 0) {
                int len = error.getReplaceParam().length;
                for (int j = 0; j < len; ++j) {
                    params.add(error.getReplaceParam()[j]);
                }
            }
            if (params.size() > 0) {
                errorStr = MessageFormat.format(errorStr, params.toArray());
            }
            sb.append(errorStr);
            if (this.ctx.get((Object)"isWebCtx") == null) continue;
            sb.append("<br>");
        }
        this.errorMsg = sb.toString();
        this.isInitErrorMsg = true;
    }

    private EntityObjectInfo getEntityObjectInfoByBosType(BOSObjectType bosType) {
        EntityObjectInfo entityInfo = this.entityObjectMap.get(bosType);
        if (null == entityInfo) {
            entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getEntity(bosType);
            this.entityObjectMap.put(bosType, entityInfo);
        }
        return entityInfo;
    }
}

