/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class CheckBillStatusVRule
implements IVRule {
    private static final String ERROR_RESOURCE = "com.kingdee.eas.scm.common.validator.beanvalidation.ValidationResource";
    private Context ctx;
    private String actionType;

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public CheckBillStatusVRule(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public void setInjectData(IDataCache dataCache) {
    }

    @Override
    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)bean;
        if ("save".equalsIgnoreCase(this.actionType)) {
            this.check4Save(scmBillInfo);
        } else if ("submit".equalsIgnoreCase(this.actionType)) {
            this.check4Submit(scmBillInfo);
        } else if ("audit".equalsIgnoreCase(this.actionType)) {
            this.check4Audit(scmBillInfo);
        } else if ("unaudit".equalsIgnoreCase(this.actionType)) {
            this.check4UnAudit(scmBillInfo);
        } else {
            throw new BOSException(ResourceUtil.getMessage((String)ERROR_RESOURCE, (String)"CheckBillStatusVRule", (String[])new String[]{this.actionType}));
        }
    }

    protected void check4Audit(SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        if (!BillBaseStatusEnum.SUBMITED.equals((Object)scmBillInfo.getBaseStatus()) && !BillBaseStatusEnum.ALTERING.equals((Object)scmBillInfo.getBaseStatus())) {
            throw new SCMBillException(SCMBillException.BILLSTATUSNOTSUBMIT4AUDIT);
        }
        SCMBillBaseInfo newInfo = this.getDataNewStatus(this.ctx, (IObjectValue)scmBillInfo);
        if (newInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (!BillBaseStatusEnum.SUBMITED.equals((Object)newInfo.getBaseStatus()) && !BillBaseStatusEnum.ALTERING.equals((Object)scmBillInfo.getBaseStatus())) {
            throw new SCMBillException(SCMBillException.BILLSTATUSNOTSUBMIT4AUDIT);
        }
    }

    protected void check4Save(SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        if (null == scmBillInfo.getBaseStatus() || BillBaseStatusEnum.ADD.equals((Object)scmBillInfo.getBaseStatus())) {
            return;
        }
        if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)scmBillInfo.getBaseStatus())) {
            SCMBillBaseInfo newInfo = this.getDataNewStatus(this.ctx, (IObjectValue)scmBillInfo);
            if (newInfo == null) {
                return;
            }
            if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)newInfo.getBaseStatus())) {
                return;
            }
        }
        if (scmBillInfo.getBOSType().toString().equals("25428F2E") && scmBillInfo.getBoolean("isMergeBill")) {
            return;
        }
        throw new SCMBillException(SCMBillException.BILLSTATUSNOTSAVEORADDNEW);
    }

    protected void check4Submit(SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        if (null == scmBillInfo.getBaseStatus() || BillBaseStatusEnum.ADD.equals((Object)scmBillInfo.getBaseStatus())) {
            return;
        }
        if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)scmBillInfo.getBaseStatus()) || BillBaseStatusEnum.SUBMITED.equals((Object)scmBillInfo.getBaseStatus())) {
            SCMBillBaseInfo newInfo = this.getDataNewStatus(this.ctx, (IObjectValue)scmBillInfo);
            if (newInfo == null) {
                return;
            }
            if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)newInfo.getBaseStatus()) || BillBaseStatusEnum.SUBMITED.equals((Object)newInfo.getBaseStatus())) {
                return;
            }
        }
        throw new SCMBillException(SCMBillException.BILLSTATUSNOTSAVEORSUBMIT);
    }

    protected void check4UnAudit(SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        if (scmBillInfo.getBaseStatus() == null || !BillBaseStatusEnum.AUDITED.equals((Object)scmBillInfo.getBaseStatus())) {
            throw new SCMBillException(SCMBillException.CHECKSTATEUNSTATE);
        }
        SCMBillBaseInfo newInfo = this.getDataNewStatus(this.ctx, (IObjectValue)scmBillInfo);
        if (newInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        if (!BillBaseStatusEnum.AUDITED.equals((Object)newInfo.getBaseStatus())) {
            throw new SCMBillException(SCMBillException.CHECKSTATEUNSTATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCMBillBaseInfo getDataNewStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo newInfo = null;
        if (model.get("id") == null) {
            return null;
        }
        SCMBillBaseInfo info = (SCMBillBaseInfo)model;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("name"));
        sc.add(new SelectorItemInfo("number"));
        sc.add(new SelectorItemInfo("baseStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sc);
        IObjectCollection newBillCol = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            newBillCol = this.getDAO(ctx, cn, info.getBOSType()).getCollection(evi);
            if (newBillCol != null) {
                if (newBillCol.size() == 0) {
                } else {
                    newInfo = (SCMBillBaseInfo)newBillCol.getObject(0);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        return newInfo;
    }

    private IORMappingDAO getDAO(Context ctx2, Connection cn, BOSObjectType bosType) {
        return ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)this.ctx, (Connection)cn);
    }

    private Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

