/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.validator.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.validator.beanvalidation.PropertyValidationException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class CheckEntryAssistPropertyVRule
implements IVRule {
    private Context ctx;
    private static final String ERROR_RESOURCE = "com.kingdee.eas.scm.common.validator.beanvalidation.ValidationResource";

    public CheckEntryAssistPropertyVRule(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setInjectData(IDataCache dataCache) {
    }

    @Override
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    @Override
    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SCMBillEntryBaseInfo entryInfo = null;
        String orgId = "";
        String paramNumber = "";
        boolean notCheck = false;
        StringBuilder errorMsg = new StringBuilder();
        int errorCount = 0;
        SCMBillBaseInfo info = (SCMBillBaseInfo)bean;
        if ("C48A423A".equals(info.getBOSType().toString()) && info.get("saleOrgUnit") != null) {
            orgId = ((SaleOrgUnitInfo)info.get("saleOrgUnit")).getId().toString();
            paramNumber = "SALEORDER100";
        }
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)paramNumber)) {
            return;
        }
        String paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(orgId.toString()), paramNumber);
        if (paramValue != null && ("true".equals(paramValue.trim()) || "1".equals(paramValue.trim()))) {
            notCheck = true;
        }
        if (info.getEntries() != null) {
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (SCMBillEntryBaseInfo)info.getEntries().getObject(i);
                if (entryInfo == null || !"C48A423A".equals(info.getBOSType().toString()) || entryInfo.getMaterial() == null || entryInfo.getMaterial().getAssistAttr() == null || entryInfo.getAssistProperty() != null || notCheck) continue;
                errorMsg.append(MessageFormat.format(ResourceBase.getString((String)ERROR_RESOURCE, (String)"Entry_NotNull_AssistProperty", (Locale)this.ctx.getLocale()), i + 1));
                ++errorCount;
            }
        }
        if (errorCount > 0) {
            throw new PropertyValidationException(PropertyValidationException.VALIDATEFAILD, new Object[]{errorMsg});
        }
    }
}

