/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.tools.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.CryptoUtil;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.scm.common.client.SCMClientHelper;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.customize.tools.IIndexCheck;
import com.kingdee.eas.scm.customize.tools.IndexCheckFactory;
import com.kingdee.eas.scm.customize.tools.IndexCheckInfo;
import com.kingdee.eas.scm.customize.tools.IndexCheckTreeFactory;
import com.kingdee.eas.scm.customize.tools.client.AbstractIndexCheckListUI;
import com.kingdee.eas.scm.customize.tools.client.IndexCheckTreeEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class IndexCheckListUI
extends AbstractIndexCheckListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(IndexCheckListUI.class);
    private static String uiQuickInputCls = "com.kingdee.eas.scm.customize.tools.client.IndexCheckEditUI";
    private static String importStdCls = "com.kingdee.eas.scm.customize.tools.client.IndexCheckFilterTableUI";
    private static String checkIndexUICls = "com.kingdee.eas.scm.customize.tools.client.IndexCheckMsgUI";
    private String res = "com.kingdee.eas.scm.customize.tools.ToolsResource";

    public IndexCheckListUI() throws Exception {
        boolean b = this.isLogin();
        if (!b) {
            this.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        TreeBaseInfo treeInfo = null;
        if (!(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            return;
        }
        treeInfo = (TreeBaseInfo)treeNode.getUserObject();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ParentNode", (Object)treeInfo);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiQuickInputCls, (Map)uiContext, null, OprtState.ADDNEW);
        uiWin.show();
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.setLocatePre(false);
        this.refresh(e);
        this.setPreSelecteRow();
        this.setLocatePre(true);
    }

    @Override
    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheck_actionPerformed(e);
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        String treeID = null;
        if (!(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            return;
        }
        treeID = ((TreeBaseInfo)treeNode.getUserObject()).getNumber().toString();
        IIndexCheck iIndexCheck = IndexCheckFactory.getRemoteInstance();
        List returnList = iIndexCheck.checkIndex(treeID);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"RESULTMSG", (Object)returnList);
        this.showUI(e, checkIndexUICls, uiContext);
        this.refreshDetails();
    }

    private void showUI(ActionEvent e, String uiName, UIContext uiContext) throws UIException {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        String treeID = null;
        if (!(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            return;
        }
        treeID = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
        if (uiContext == null) {
            uiContext = new UIContext((Object)this);
        }
        uiContext.put((Object)"ID", (Object)treeID);
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.ADDNEW);
        uiWin.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        String selValue = this.getSelectedKeyValue();
        if (selValue == null || selValue.length() == 0) {
            String info = ResourceUtils.getMessage((String)this.res, (String)"NoSelectedCannotEdit");
            MsgBox.showInfo((String)info);
            this.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiQuickInputCls, (Map)uiContext, null, OprtState.EDIT);
        uiWin.show();
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.setLocatePre(false);
        this.refresh(e);
        this.setPreSelecteRow();
        this.setLocatePre(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        this.getUIContext().putAll(uiContext);
        IUIWindow uiWin = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiQuickInputCls, (Map)uiContext, null, OprtState.VIEW);
        uiWin.show();
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.setLocatePre(false);
        this.refresh(e);
        this.setPreSelecteRow();
        this.setLocatePre(true);
    }

    @Override
    public void actionImportStd_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && !treeNode.isLeaf()) {
            String confirmMsg = ResourceUtils.getMessage((String)this.res, (String)"SubNode");
            MsgBox.showError((String)confirmMsg);
            this.abort();
        }
        super.actionImportStd_actionPerformed(e);
        this.showUI(e, importStdCls, null);
        if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
            this.prepareRefresh(null).callHandler();
        }
        this.setLocatePre(false);
        this.refresh(e);
        this.setPreSelecteRow();
        this.setLocatePre(true);
    }

    private void lockTblBackup() {
        int colCount = this.tblBackup.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            this.tblBackup.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public void onLoad() throws Exception {
        logger.info((Object)"***onLoad start*****");
        super.onLoad();
        this.initCtrl();
    }

    private boolean isLogin() throws EASBizException {
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (Administrator.isSuperCUAdmin((IObjectPK)new ObjectUuidPK(userInfo.getId()))) {
            return true;
        }
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userInfo.getId().toString())) {
            return true;
        }
        try {
            userInfo = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"49_FMIsqlUI"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String logonPassword = new String(pwd.getPassword());
        return IndexCheckListUI.matchPassword(userInfo, logonPassword);
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return IndexCheckListUI.encrypt(userInfo.getId().toString(), password).equals(userInfo.getPassword());
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        try {
            return CryptoUtil.encrypt((String)(userID + password.trim()));
        }
        catch (Exception e) {
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.btnAddNew.isEnabled()) {
            super.tblMain_tableClicked(e);
        }
    }

    private void initCtrl() {
        this.btnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.btnImportStd.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.actionCheck.setDaemonDialog(true);
        this.actionCheck.setDaemonRun(true);
        this.btnPrint.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.btnMoveTree.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
        this.btnLocate.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.MenuService.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuItemImportData.setEnabled(false);
        this.menuHelp.setVisible(false);
        this.btnQuery.setEnabled(false);
        this.btnQuery.setVisible(false);
        SCMClientHelper.addCtrlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        this.addSqlMenu((CoreUIObject)this, this.menuEdit);
        this.lockTblBackup();
        this.tblBackup.getColumn("backupTime").getStyleAttributes().setWeight(550.0f);
        this.tblBackup.getColumn("backupTime").getStyleAttributes().setNumberFormat("yyyy-mm-dd hh:mm:ss");
        this.tblBackup.repaint();
    }

    public void addSqlMenu(CoreUIObject uiObject, KDMenu menu) {
        menu.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift E"){
            private static final long serialVersionUID = 1L;

            public void action_actionPerformed() {
                IndexCheckListUI.this.isCanEdit(false);
            }
        });
    }

    protected void isCanEdit(boolean isOnload) {
        boolean isCanEdit = false;
        isCanEdit = isOnload ? isCanEdit : !this.btnAddNew.isEnabled();
        this.btnAddNew.setEnabled(isCanEdit);
        this.menuItemAddNew.setEnabled(isCanEdit);
        this.btnEdit.setEnabled(isCanEdit);
        this.menuItemEdit.setEnabled(isCanEdit);
        this.btnImportStd.setEnabled(isCanEdit);
        this.btnRemove.setEnabled(isCanEdit);
        this.menuItemRemove.setEnabled(isCanEdit);
        this.btnView.setEnabled(isCanEdit);
        this.menuItemView.setEnabled(isCanEdit);
        this.btnAddNew.setVisible(isCanEdit);
        this.menuItemAddNew.setVisible(isCanEdit);
        this.btnEdit.setVisible(isCanEdit);
        this.menuItemEdit.setVisible(isCanEdit);
        this.btnImportStd.setVisible(isCanEdit);
        this.btnRemove.setVisible(isCanEdit);
        this.menuItemRemove.setVisible(isCanEdit);
        this.btnView.setVisible(isCanEdit);
        this.menuItemView.setVisible(isCanEdit);
        this.btnGroupAddNew.setEnabled(isCanEdit);
        this.menuItemGroupAddNew.setEnabled(isCanEdit);
        this.btnGroupEdit.setEnabled(isCanEdit);
        this.menuItemGroupEdit.setEnabled(isCanEdit);
        this.btnGroupMoveTree.setEnabled(isCanEdit);
        this.menuItemGroupMoveTree.setEnabled(isCanEdit);
        this.btnGroupRemove.setEnabled(isCanEdit);
        this.menuItemGroupRemove.setEnabled(isCanEdit);
        this.btnGroupView.setEnabled(isCanEdit);
        this.menuItemGroupView.setEnabled(isCanEdit);
        this.btnGroupAddNew.setVisible(isCanEdit);
        this.menuItemGroupAddNew.setVisible(isCanEdit);
        this.btnGroupEdit.setVisible(isCanEdit);
        this.menuItemGroupEdit.setVisible(isCanEdit);
        this.btnGroupMoveTree.setVisible(isCanEdit);
        this.menuItemGroupMoveTree.setVisible(isCanEdit);
        this.btnGroupRemove.setVisible(isCanEdit);
        this.menuItemGroupRemove.setVisible(isCanEdit);
        this.btnGroupView.setVisible(isCanEdit);
        this.menuItemGroupView.setVisible(isCanEdit);
        this.menuEdit.setVisible(isCanEdit);
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.isLeaf() && this.tblMain.getRowCount() > 0) {
            String info = ResourceUtils.getMessage((String)this.res, (String)"IsLeaf");
            MsgBox.showError((String)info);
            this.abort();
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return IndexCheckFactory.getRemoteInstance();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return IndexCheckTreeFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return IndexCheckTreeEditUI.class.getName();
    }

    @Override
    protected String getSelectDetailTreeName() {
        return "tree";
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.refreshDetails();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        this.tblBackup.removeRows();
    }

    protected IQueryExecutor getDetailQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        if ("com\\kingdee\\eas\\scm\\customize\\tools\\app\\IndexCheckTreeBackupQuery".equals(queryPK.toString())) {
            this.buildBackupTreeFilter();
            exec.setObjectView(this.indexCheckTreeBackupQuery);
        } else {
            exec.setObjectView(viewInfo);
        }
        return exec;
    }

    @Override
    protected EntityViewInfo[] getDetialViewInfos() {
        EntityViewInfo info = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("indexBackup.id", null, CompareType.ISNOT));
        info.setFilter(filter);
        SorterItemCollection col = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo();
        sortItem.setPropertyName("indexBackup.backupTime");
        sortItem.setSortType(SortType.DESCEND);
        col.add(sortItem);
        info.setSorter(col);
        return new EntityViewInfo[]{info};
    }

    @Override
    protected IMetaDataPK[] getDetailIMetaDataPKs() {
        return new MetaDataPK[]{new MetaDataPK("com.kingdee.eas.scm.customize.tools.app.IndexCheckTreeBackupQuery")};
    }

    @Override
    protected KDTable[] getDetailTables() {
        return new KDTable[]{this.tblBackup};
    }

    @Override
    protected String[] getDetailRelations() {
        return new String[]{"id"};
    }

    protected String getQueryFieldName() {
        return "tree.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getRootName() {
        return "EAS";
    }

    @Override
    protected IObjectValue createNewData() {
        IndexCheckInfo objectValue = new IndexCheckInfo();
        return objectValue;
    }

    protected void buildBackupTreeFilter() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        if (this.indexCheckTreeBackupQuery == null) {
            this.indexCheckTreeBackupQuery = new EntityViewInfo();
        }
        if (this.indexCheckTreeBackupQuery.getFilter() == null) {
            this.indexCheckTreeBackupQuery.setFilter(new FilterInfo());
        }
        FilterItemCollection col = this.removeQueryFilterAndSorter(this.indexCheckTreeBackupQuery);
        if (treeNode.getUserObject() instanceof TreeBaseInfo) {
            this.setFilterIncludChild(col, (TreeBaseInfo)treeNode.getUserObject());
        } else {
            this.setFilterIncludChild(col, null);
        }
        int count = this.indexCheckTreeBackupQuery.getFilter().getFilterItems().size();
        this.indexCheckTreeBackupQuery.getFilter().setMaskString("");
        if (count > 0) {
            StringBuffer master = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    master.append(" OR ");
                }
                master.append("#");
                master.append(i);
            }
            this.indexCheckTreeBackupQuery.getFilter().setMaskString(master.toString());
        }
        try {
            this.getEntityViewInfo(this.indexCheckTreeBackupQuery);
            this.TreeFilterMerge(this.getDetialViewInfos()[0].getFilter());
            this.indexCheckTreeBackupQuery.setSorter(this.getDetialViewInfos()[0].getSorter());
        }
        catch (Exception ex) {
            this.handleException(ex);
            this.abort();
        }
    }

    private void setFilterIncludChild(FilterItemCollection cols, TreeBaseInfo tree) {
        block10: {
            if (this.isIsIncludeChild()) {
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(this.getDefaultFilterForTree());
                ev.getSelector().add(new SelectorItemInfo("id"));
                try {
                    TreeBaseCollection treeCols = null;
                    treeCols = this.getTreeInterface().getAllChildren(tree, ev);
                    if (tree == null) {
                        cols.add(new FilterItemInfo("id", (Object)"null", CompareType.EQUALS));
                    } else {
                        cols.add(new FilterItemInfo("id", (Object)tree.getId().toString(), CompareType.EQUALS));
                    }
                    if (treeCols == null) break block10;
                    ArrayList<String> filterList = new ArrayList<String>();
                    for (int i = 0; i < treeCols.size(); ++i) {
                        filterList.add(treeCols.get(i).getId().toString());
                    }
                    if (filterList.size() > 0) {
                        String strIdLists = StringUtils.arrayToString((Object[])filterList.toArray(), (String)",");
                        cols.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                    }
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            } else if (tree == null) {
                cols.add(new FilterItemInfo("id", (Object)"null"));
            } else {
                cols.add(new FilterItemInfo("id", (Object)tree.getId().toString()));
            }
        }
    }

    private void TreeFilterMerge(FilterInfo filter) {
        if (filter != null && filter.getFilterItems().size() > 0) {
            try {
                if (this.indexCheckTreeBackupQuery.getFilter() != null && this.indexCheckTreeBackupQuery.getFilter().getFilterItems() != null && this.indexCheckTreeBackupQuery.getFilter().getFilterItems().size() > 0) {
                    this.indexCheckTreeBackupQuery.getFilter().mergeFilter(filter, "AND");
                } else {
                    this.indexCheckTreeBackupQuery.setFilter(filter);
                }
            }
            catch (BOSException ex) {
                MsgBox.showError((Component)((Object)this), (String)ex.getMessage());
                super.abort();
            }
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.isLeaf() && this.tblMain.getRowCount() > 0) {
            String confirmMsg = ResourceUtils.getMessage((String)this.res, (String)"CanNotDelete");
            MsgBox.showError((String)confirmMsg);
            this.abort();
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }
}

