/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.framework.balance.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataQueryInfo;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DateFilterTypeEnum;
import com.kingdee.eas.scm.framework.balance.client.AbstractBalanceDataModelEditUI;
import com.kingdee.eas.scm.framework.balance.client.CommonDataQueryFilterPanel;
import com.kingdee.eas.scm.framework.balance.client.DataQueryFieldSelector;
import com.kingdee.eas.scm.framework.balance.client.SelectQueryFieldSelector;
import com.kingdee.eas.scm.framework.balance.model.PropertyMeta;
import com.kingdee.eas.scm.framework.balance.model.PropertyMetaUtil;
import com.kingdee.eas.scm.framework.model.RuleSegementInfo;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;

public class BalanceDataModelEditUI
extends AbstractBalanceDataModelEditUI {
    private static final long serialVersionUID = 1L;
    private static final String COL_ID = "id";
    private static final String COL_BALANCEFIELD = "balanceField";
    private static final String COL_VALUEEXPRESSION = "valueExpression";
    private CommonDataQueryFilterPanel commonFilterPanel;
    private BalanceModelInfo balanceModelInfo;
    private SelectorListener fieldSelectorListener = new SelectorListener(){

        public void willShow(SelectorEvent e) {
            BalanceDataModelEditUI.this.initFieldF7(e);
        }
    };
    private DataChangeListener dataChangeListener = new DataChangeListener(){

        public void dataChanged(DataChangeEvent e) {
            BalanceDataModelEditUI.this.dataQueryChanged(e);
        }
    };
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            BalanceDataModelEditUI.this.setComponentEnable((DateFilterTypeEnum)((Object)e.getItem()));
        }
    };
    private ItemListener initializeChangeListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            BalanceDataModelEditUI.this.initializeChanged(e);
        }
    };

    private void initFieldF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof SelectQueryFieldSelector)) {
            BalanceFieldModelInfo fieldModel = this.getFieldModel(f7Box);
            SelectQueryFieldSelector selector = new SelectQueryFieldSelector((DataQueryInfo)this.prmtDataQuery.getData(), fieldModel);
            f7Box.setSelector((KDPromptSelector)selector);
        } else {
            ((SelectQueryFieldSelector)f7Box.getSelector()).setDataQuery((DataQueryInfo)this.prmtDataQuery.getData());
        }
    }

    private BalanceFieldModelInfo getFieldModel(KDPromptBox f7Box) {
        BalanceFieldModelInfo result = null;
        String ctrlName = f7Box.getName();
        if (ctrlName.equals("prmtOrgField")) {
            result = this.balanceModelInfo.getMainOrgUnitField();
        } else if (ctrlName.equals("prmtYearField")) {
            result = this.balanceModelInfo.getPeriodYearField();
        } else if (ctrlName.equals("prmtMonthField")) {
            result = this.balanceModelInfo.getPeriodMonthField();
        } else if (ctrlName.equals("prmtBizDateField")) {
            result = new BalanceFieldModelInfo();
            result.setDataType(DataTypeEnum.Date);
        } else if (ctrlName.equals("prmtPeriodIDField")) {
            result = this.balanceModelInfo.getPeriodField();
        }
        return result;
    }

    private void dataQueryChanged(DataChangeEvent e) {
        if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        if (BalanceTypeEnum.RealTime.equals((Object)this.balanceModelInfo.getBalanceType())) {
            DataQueryInfo query = (DataQueryInfo)e.getNewValue();
            this.prmtBillIDField.setData((Object)PropertyMetaUtil.getPropertyMeta(query.getMainTable(), "FID"));
        } else {
            this.prmtBillIDField.setData(null);
        }
        this.prmtOrgField.setData(null);
        this.prmtYearField.setData(null);
        this.prmtMonthField.setData(null);
        this.prmtBizDateField.setData(null);
        this.prmtPeriodIDField.setData(null);
        this.commonFilterPanel.setDataQuery((DataQueryInfo)e.getNewValue());
        try {
            this.commonFilterPanel.reInitCondition();
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        this.clearFieldTable();
    }

    private void clearFieldTable() {
        IRow row = null;
        int count = this.tblFieldConfig.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblFieldConfig.getRow(i);
            row.setUserObject(null);
            row.getCell(COL_VALUEEXPRESSION).setValue(null);
        }
    }

    public void onLoad() throws Exception {
        this.balanceModelInfo = (BalanceModelInfo)this.getUIContext().get("ParentNode");
        super.onLoad();
        this.initDataQueryF7();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.setComponentEnable(this.editData.getDateFilterType());
        this.setFieldComponentEnable();
        this.transferFieldShow();
        this.initFieldTable();
        this.initFilterPanel();
        this.addListener();
    }

    private void initFilterPanel() {
        try {
            if (this.commonFilterPanel != null) {
                this.commonFilterPanel.setDataQuery(this.editData.getDataQuery());
                this.commonFilterPanel.setFilterInfo(this.editData.getFilterInfo());
                this.commonFilterPanel.reInitTable();
                return;
            }
            int wight = 665;
            int height = 440;
            this.commonFilterPanel = new CommonDataQueryFilterPanel(this.editData.getDataQuery(), this.editData.getFilterInfo(), wight, height, 10);
            this.panelFilter.add((Component)((Object)this.commonFilterPanel));
            this.commonFilterPanel.setBounds(0, 0, wight, height);
            if ("EDIT".equals(this.getOprtState()) || "ADDNEW".equals(this.getOprtState())) {
                this.commonFilterPanel.setEnabled(true);
            } else {
                this.commonFilterPanel.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initDataQueryF7() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("balanceModel.id", (Object)this.balanceModelInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("isMainTable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)Boolean.TRUE));
        view.setFilter(filterInfo);
        this.prmtDataQuery.setEntityViewInfo(view);
        this.prmtDataQuery.setHasCUDefaultFilter(false);
    }

    private void transferFieldShow() {
        DataQueryInfo dataQuery = (DataQueryInfo)this.prmtDataQuery.getData();
        this.prmtOrgField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getOrgField()));
        this.prmtBillIDField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getBillIdField()));
        this.prmtYearField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getPeriodYear()));
        this.prmtMonthField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getPeriodMonth()));
        this.prmtBizDateField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getBizDateField()));
        this.prmtPeriodIDField.setData((Object)PropertyMetaUtil.getPropertyMeta(dataQuery, this.editData.getPeriodIdField()));
    }

    private void setFieldComponentEnable() {
        if (this.balanceModelInfo != null && BalanceTypeEnum.RealTime.equals((Object)this.balanceModelInfo.getBalanceType())) {
            this.panelOrg.setVisible(false);
            this.panelBillID.setVisible(true);
            this.panelUpdateType.setVisible(true);
            this.prmtOrgField.setEnabled(false);
            this.prmtYearField.setEnabled(false);
            this.prmtMonthField.setEnabled(false);
            this.prmtBizDateField.setEnabled(false);
            this.prmtPeriodIDField.setEnabled(false);
            this.comboDateFilterType.setEnabled(false);
            this.prmtBillIDField.setEnabled(true);
            this.prmtBillIDField.setRequired(true);
            this.cmbUpdateType.setEnabled(true);
            this.cmbUpdateType.setRequired(true);
            this.chkIsInitialize.setVisible(false);
            this.panelDateFilter.setVisible(false);
        } else {
            this.panelOrg.setVisible(true);
            this.panelBillID.setVisible(false);
            this.panelUpdateType.setVisible(false);
            this.prmtOrgField.setEnabled(true);
            this.prmtOrgField.setRequired(true);
            this.comboDateFilterType.setEnabled(true);
            this.comboDateFilterType.setRequired(true);
            this.prmtBillIDField.setEnabled(false);
            this.cmbUpdateType.setEnabled(false);
            this.chkIsInitialize.setVisible(true);
            this.panelDateFilter.setVisible(true);
        }
        this.prmtOrgField.setEditable(false);
        this.prmtBillIDField.setEditable(false);
        this.prmtYearField.setEditable(false);
        this.prmtMonthField.setEditable(false);
        this.prmtBizDateField.setEditable(false);
        this.prmtPeriodIDField.setEditable(false);
        this.prmtDataQuery.setEditable(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.setFieldComponentEnable();
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
    }

    private void initFieldTable() {
        if (this.balanceModelInfo == null) {
            return;
        }
        this.tblFieldConfig.removeRows();
        this.tblFieldConfig.checkParsed();
        this.tblFieldConfig.getColumn(COL_BALANCEFIELD).getStyleAttributes().setLocked(true);
        this.tblFieldConfig.getColumn(COL_VALUEEXPRESSION).getStyleAttributes().setLocked(false);
        BalanceFieldModelInfo field = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            field = coll.get(i);
            this.addRow(field);
        }
    }

    private void addRow(BalanceFieldModelInfo field) {
        if (field == null) {
            return;
        }
        if (field.getName().equals("ID")) {
            return;
        }
        if (BizDataTypeEnum.EndData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Year.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Month.equals((Object)field.getBizDataType()) || BizDataTypeEnum.Period.equals((Object)field.getBizDataType())) {
            return;
        }
        if (this.editData.isIsInitialize() && (BizDataTypeEnum.InData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.OutData.equals((Object)field.getBizDataType()))) {
            return;
        }
        if (!this.editData.isIsInitialize() && (BizDataTypeEnum.BeginData.equals((Object)field.getBizDataType()) || BizDataTypeEnum.YearTotalData.equals((Object)field.getBizDataType()))) {
            return;
        }
        IRow row = this.tblFieldConfig.addRow();
        row.getCell(COL_ID).setValue((Object)field.getId());
        row.getCell(COL_BALANCEFIELD).setValue((Object)field.getAlias());
        row.getCell(COL_BALANCEFIELD).setUserObject((Object)field);
        BalanceFieldDataModelInfo fieldDataModel = this.editData.getFieldDataModelByFieldID(field.getId().toString());
        if (fieldDataModel != null) {
            if (StringUtil.isEmpty((String)fieldDataModel.getExpressionAlias())) {
                row.getCell(COL_VALUEEXPRESSION).setValue((Object)fieldDataModel.getValueExpression());
            } else {
                row.getCell(COL_VALUEEXPRESSION).setValue((Object)fieldDataModel.getExpressionAlias());
            }
        } else {
            row.getCell(COL_VALUEEXPRESSION).setValue(null);
        }
        row.getCell(COL_VALUEEXPRESSION).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.getValueExpressionF7(this.tblFieldConfig)));
        row.setUserObject((Object)fieldDataModel);
        if (!field.isIsNullable() && StringUtil.isEmpty((String)field.getDefaultValue())) {
            row.getStyleAttributes().setBackground(new Color(255, 255, 153));
        }
    }

    private KDBizPromptBox getValueExpressionF7(final KDTable table) {
        KDBizPromptBox valueF7 = new KDBizPromptBox();
        valueF7.setEditable(false);
        valueF7.setRefresh(false);
        valueF7.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                int rowIndex = table.getEditManager().getEditRowIndex();
                IRow row = BalanceDataModelEditUI.this.tblFieldConfig.getRow(rowIndex);
                BalanceFieldModelInfo fieldModel = (BalanceFieldModelInfo)row.getCell(BalanceDataModelEditUI.COL_BALANCEFIELD).getUserObject();
                RuleSegementInfo ruleSegInfo = (RuleSegementInfo)f7Box.getUserObject();
                if (ruleSegInfo == null) {
                    ruleSegInfo = new RuleSegementInfo();
                    Object obj = row.getUserObject();
                    if (obj != null) {
                        BalanceFieldDataModelInfo fieldDataModel = (BalanceFieldDataModelInfo)obj;
                        ruleSegInfo.setExpression(fieldDataModel.getValueExpression());
                        ruleSegInfo.setExpressionAlias(fieldDataModel.getExpressionAlias());
                    }
                }
                DataQueryFieldSelector selector = new DataQueryFieldSelector((DataQueryInfo)BalanceDataModelEditUI.this.prmtDataQuery.getData(), fieldModel, ruleSegInfo);
                f7Box.setSelector((KDPromptSelector)selector);
            }
        });
        valueF7.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                KDPromptBox f7Box = (KDPromptBox)e.getSource();
                int rowIndex = table.getEditManager().getEditRowIndex();
                IRow row = BalanceDataModelEditUI.this.tblFieldConfig.getRow(rowIndex);
                if (e.getData() != null) {
                    RuleSegementInfo ruleSegInfo = (RuleSegementInfo)e.getData();
                    BalanceFieldDataModelInfo fieldDataModel = (BalanceFieldDataModelInfo)row.getUserObject();
                    if (fieldDataModel == null) {
                        BalanceFieldModelInfo fieldModel = (BalanceFieldModelInfo)row.getCell(BalanceDataModelEditUI.COL_BALANCEFIELD).getUserObject();
                        fieldDataModel = BalanceDataModelEditUI.this.createDetailData(fieldModel);
                    }
                    fieldDataModel.setValueExpression(ruleSegInfo.getExpression());
                    fieldDataModel.setExpressionAlias(ruleSegInfo.getExpressionAlias());
                    row.setUserObject((Object)fieldDataModel);
                    e.setData((Object)ruleSegInfo.getExpressionAlias());
                    f7Box.setUserObject((Object)ruleSegInfo);
                } else {
                    row.setUserObject(null);
                    e.setData(null);
                    f7Box.setUserObject(null);
                }
                e.setResult(1);
            }
        });
        return valueF7;
    }

    private void setComponentEnable(DateFilterTypeEnum type) {
        if (DateFilterTypeEnum.YearAndMonth.equals((Object)type)) {
            this.contBizDateField.setVisible(false);
            this.contPeriodIdField.setVisible(false);
            this.contPeriodYear.setVisible(true);
            this.prmtYearField.setRequired(true);
            this.contPeriodMonth.setVisible(true);
            this.prmtMonthField.setRequired(true);
        } else if (DateFilterTypeEnum.BizDate.equals((Object)type)) {
            this.contBizDateField.setVisible(true);
            this.prmtBizDateField.setRequired(true);
            this.contPeriodIdField.setVisible(false);
            this.contPeriodYear.setVisible(false);
            this.contPeriodMonth.setVisible(false);
        } else if (DateFilterTypeEnum.PeriodID.equals((Object)type)) {
            this.contBizDateField.setVisible(false);
            this.contPeriodIdField.setVisible(true);
            this.prmtPeriodIDField.setRequired(true);
            this.contPeriodYear.setVisible(false);
            this.contPeriodMonth.setVisible(false);
        }
    }

    private void initializeChanged(ItemEvent e) {
        this.storeFieldConfig();
        this.editData.setIsInitialize(this.chkIsInitialize.isSelected());
        this.initFieldTable();
    }

    private void removeListener() {
        this.comboDateFilterType.removeItemListener(this.itemListener);
        this.prmtOrgField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtBillIDField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtYearField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtMonthField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtBizDateField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtPeriodIDField.removeSelectorListener(this.fieldSelectorListener);
        this.prmtDataQuery.removeDataChangeListener(this.dataChangeListener);
        this.chkIsInitialize.removeItemListener(this.initializeChangeListener);
    }

    private void addListener() {
        this.comboDateFilterType.addItemListener(this.itemListener);
        this.prmtOrgField.addSelectorListener(this.fieldSelectorListener);
        this.prmtBillIDField.addSelectorListener(this.fieldSelectorListener);
        this.prmtYearField.addSelectorListener(this.fieldSelectorListener);
        this.prmtMonthField.addSelectorListener(this.fieldSelectorListener);
        this.prmtBizDateField.addSelectorListener(this.fieldSelectorListener);
        this.prmtPeriodIDField.addSelectorListener(this.fieldSelectorListener);
        this.prmtDataQuery.addDataChangeListener(this.dataChangeListener);
        this.chkIsInitialize.addItemListener(this.initializeChangeListener);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        String message = null;
        if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtDataQuery.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"66_BalanceDataModelEditUI"));
            this.prmtDataQuery.requestFocus();
            SysUtil.abort();
        }
        this.editData.setNumber(this.txtNumber.getText().trim());
        this.editData.setDataQuery((DataQueryInfo)this.prmtDataQuery.getData());
        this.txtNumber.requestFocus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.prmtOrgField.getData() != null) {
            this.editData.setOrgField(((PropertyMeta)this.prmtOrgField.getData()).getFullSQLFieldName());
        }
        if (this.prmtBillIDField.getData() != null) {
            this.editData.setBillIdField(((PropertyMeta)this.prmtBillIDField.getData()).getFullSQLFieldName());
        }
        if (this.prmtYearField.getData() != null) {
            this.editData.setPeriodYear(((PropertyMeta)this.prmtYearField.getData()).getFullSQLFieldName());
        }
        if (this.prmtMonthField.getData() != null) {
            this.editData.setPeriodMonth(((PropertyMeta)this.prmtMonthField.getData()).getFullSQLFieldName());
        }
        if (this.prmtBizDateField.getData() != null) {
            this.editData.setBizDateField(((PropertyMeta)this.prmtBizDateField.getData()).getFullSQLFieldName());
        }
        if (this.prmtPeriodIDField.getData() != null) {
            this.editData.setPeriodIdField(((PropertyMeta)this.prmtPeriodIDField.getData()).getFullSQLFieldName());
        }
        if (!this.commonFilterPanel.verify()) {
            SysUtil.abort();
        }
        this.editData.setDataFilter(this.commonFilterPanel.getFilterInfo().toString());
        this.storeFieldConfig();
    }

    private void storeFieldConfig() {
        IRow row = null;
        this.editData.getEntry().clear();
        int count = this.tblFieldConfig.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblFieldConfig.getRow(i);
            if (row.getUserObject() == null) continue;
            this.editData.getEntry().add((BalanceFieldDataModelInfo)row.getUserObject());
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("dataFilter"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.balanceField"));
        sic.add(new SelectorItemInfo("entry.valueExpression"));
        sic.add(new SelectorItemInfo("entry.expressionAlias"));
        sic.add(new SelectorItemInfo("dataQuery.entry.name"));
        sic.add(new SelectorItemInfo("dataQuery.entry.bosType"));
        sic.add(new SelectorItemInfo("dataQuery.entry.tableName"));
        sic.add(new SelectorItemInfo("dataQuery.entry.tableAlias"));
        sic.add(new SelectorItemInfo("dataQuery.entry.seq"));
        sic.add(new SelectorItemInfo("dataQuery.entry.joinType"));
        sic.add(new SelectorItemInfo("dataQuery.entry.joinCondition"));
        sic.add(new SelectorItemInfo("dataQuery.entry.isMainTable"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.id"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.bosType"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.name"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.tableName"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.tableAlias"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.joinType"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.joinCondition"));
        sic.add(new SelectorItemInfo("dataQuery.entry.parentTable.isMainTable"));
        return sic;
    }

    protected IObjectValue createNewData() {
        BalanceDataModelInfo info = new BalanceDataModelInfo();
        info.setDateFilterType(DateFilterTypeEnum.YearAndMonth);
        info.setBalanceModel(this.balanceModelInfo);
        return info;
    }

    private BalanceFieldDataModelInfo createDetailData(BalanceFieldModelInfo fieldModel) {
        BalanceFieldDataModelInfo fieldData = new BalanceFieldDataModelInfo();
        fieldData.setId(BOSUuid.create((BOSObjectType)fieldData.getBOSType()));
        fieldData.setBalanceField(fieldModel);
        fieldData.setParent(this.editData);
        return fieldData;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setOprtState("EDIT");
        this.unLockUI();
        this.initDataStatus();
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.beforeEnableCheck();
        try {
            super.actionCancelCancel_actionPerformed(e);
        }
        catch (Exception err) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"67_BalanceDataModelEditUI"), (String)err.getMessage(), (int)1);
        }
        this.setOprtState("VIEW");
        this.initDataStatus();
    }

    private void beforeEnableCheck() {
        if (BalanceTypeEnum.RealTime.equals((Object)this.balanceModelInfo.getBalanceType())) {
            if (this.prmtBillIDField.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"68_BalanceDataModelEditUI"));
                this.prmtBillIDField.requestFocus();
                SysUtil.abort();
            }
        } else {
            DateFilterTypeEnum type;
            if (this.prmtOrgField.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"69_BalanceDataModelEditUI"));
                this.prmtOrgField.requestFocus();
                SysUtil.abort();
            }
            if (DateFilterTypeEnum.YearAndMonth.equals((Object)(type = (DateFilterTypeEnum)((Object)this.comboDateFilterType.getSelectedItem())))) {
                if (this.prmtYearField.getData() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"70_BalanceDataModelEditUI"));
                    this.prmtYearField.requestFocus();
                    SysUtil.abort();
                }
                if (this.prmtMonthField.getData() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"71_BalanceDataModelEditUI"));
                    this.prmtMonthField.requestFocus();
                    SysUtil.abort();
                }
            } else if (DateFilterTypeEnum.BizDate.equals((Object)type)) {
                if (this.prmtBizDateField.getData() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"72_BalanceDataModelEditUI"));
                    this.prmtBizDateField.requestFocus();
                    SysUtil.abort();
                }
            } else if (DateFilterTypeEnum.PeriodID.equals((Object)type) && this.prmtPeriodIDField.getData() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"73_BalanceDataModelEditUI"));
                this.prmtPeriodIDField.requestFocus();
                SysUtil.abort();
            }
        }
        IRow row = null;
        Object valueExpression = null;
        BalanceFieldModelInfo field = null;
        int count = this.tblFieldConfig.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblFieldConfig.getRow(i);
            field = (BalanceFieldModelInfo)row.getCell(COL_BALANCEFIELD).getUserObject();
            valueExpression = row.getCell(COL_VALUEEXPRESSION).getValue();
            if (field.isIsNullable() || !StringUtil.isEmpty((String)field.getDefaultValue()) || valueExpression != null) continue;
            MsgBox.showInfo((String)ResourceUtil.getMessage((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"74_BalanceDataModelEditUI", (String[])new String[]{field.getAlias()}));
            this.tblFieldConfig.getEditManager().editCellAt(row.getRowIndex(), 2);
            SysUtil.abort();
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"75_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getState().getValue() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"76_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
        if (this.editData.isIsScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"77_BalanceDataModelEditUI"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionShowSQL_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"savefirst"));
            SysUtil.abort();
        }
        String sSQL = BalanceDataModelFactory.getRemoteInstance().getSQL((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        UIContext uiContext = new UIContext();
        uiContext.put("InitDataObject", sSQL);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.framework.balance.client.BalanceDataModelShowSQLUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BalanceDataModelFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        BalanceDataModelInfo info = (BalanceDataModelInfo)newData;
        info.setNumber(null);
        info.setName(null);
        info.setState(UseStatusEnum.SAVED);
    }

    public boolean isModify() {
        if ("VIEW".equals(this.getOprtState())) {
            return false;
        }
        if (!"ADDNEW".equals(this.getOprtState()) && this.editData.compareNewToOld()) {
            return false;
        }
        return super.isModify();
    }
}

